/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.File;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.LongIterator;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongProgression;
import kotlin.ranges.RangesKt;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.CC;
import org.mapdb.DBException;
import org.mapdb.DataIO;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;
import org.mapdb.StoreBinary;
import org.mapdb.StoreBinaryGetLong;
import org.mapdb.StoreDirect;
import org.mapdb.StoreDirectAbstract;
import org.mapdb.StoreDirectJava;
import org.mapdb.Utils;
import org.mapdb.volume.Volume;
import org.mapdb.volume.VolumeFactory;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 d2\u00020\u00012\u00020\u0002:\u0001dBy\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\n\u0012\u0006\u0010\u000f\u001a\u00020\n\u0012\u0006\u0010\u0010\u001a\u00020\b\u0012\u0006\u0010\u0011\u001a\u00020\b\u0012\u0006\u0010\u0012\u001a\u00020\b\u0012\u0006\u0010\u0013\u001a\u00020\b\u0012\u0006\u0010\u0014\u001a\u00020\b\u0012\b\b\u0002\u0010\u0015\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0016J\b\u0010\"\u001a\u00020\nH\u0014J\b\u0010#\u001a\u00020\nH\u0014J\b\u0010$\u001a\u00020\nH\u0004J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020&H\u0016J\b\u0010(\u001a\u00020&H\u0016J=\u0010)\u001a\u00020\b\"\u0004\b\u0000\u0010*2\u0006\u0010+\u001a\u00020\n2\b\u0010,\u001a\u0004\u0018\u0001H*2\b\u0010-\u001a\u0004\u0018\u0001H*2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H*0/H\u0016\u00a2\u0006\u0002\u00100J$\u00101\u001a\u00020&\"\u0004\b\u0000\u0010*2\u0006\u0010+\u001a\u00020\n2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H*0/H\u0016J\b\u00102\u001a\u00020\bH\u0016J\u0010\u00103\u001a\u00020&2\u0006\u00104\u001a\u00020\nH\u0014J+\u00105\u001a\u0004\u0018\u0001H*\"\u0004\b\u0000\u0010*2\u0006\u0010+\u001a\u00020\n2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H*0/H\u0016\u00a2\u0006\u0002\u00106J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020\u000408H\u0016J\b\u00109\u001a\u00020:H\u0016J\u0018\u0010;\u001a\u00020\n2\u0006\u0010+\u001a\u00020\n2\u0006\u0010<\u001a\u00020=H\u0016J\u0006\u0010\u0019\u001a\u00020\nJ\u0010\u0010>\u001a\u00020\n2\u0006\u0010+\u001a\u00020\nH\u0014J\u0006\u0010?\u001a\u00020\nJ\u0010\u0010@\u001a\u00020&2\u0006\u0010A\u001a\u00020\nH\u0004J\u0010\u0010B\u001a\u00020C2\u0006\u0010A\u001a\u00020\nH\u0004J\u0018\u0010D\u001a\u00020\n2\u0006\u0010E\u001a\u00020C2\u0006\u0010F\u001a\u00020\rH\u0004J\u0018\u0010G\u001a\u00020\n2\u0006\u0010H\u001a\u00020\n2\u0006\u0010I\u001a\u00020\nH\u0004J3\u0010J\u001a\u00020&2\u0006\u0010K\u001a\u00020\n2!\u0010L\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\bN\u0012\b\bO\u0012\u0004\b\b(P\u0012\u0004\u0012\u00020&0MH\u0004J0\u0010Q\u001a\u00020&2\u0006\u0010K\u001a\u00020\n2\u0006\u0010R\u001a\u00020\n2\u0006\u0010P\u001a\u00020\n2\u0006\u0010S\u001a\u00020\n2\u0006\u0010T\u001a\u00020\bH\u0004J \u0010U\u001a\u00020&2\u0006\u0010K\u001a\u00020\n2\u0006\u0010P\u001a\u00020\n2\u0006\u0010T\u001a\u00020\bH\u0014J\u0018\u0010V\u001a\u00020\n2\u0006\u0010K\u001a\u00020\n2\u0006\u0010T\u001a\u00020\bH\u0014J\b\u0010W\u001a\u00020\nH\u0016J+\u0010X\u001a\u00020\n\"\u0004\b\u0000\u0010*2\b\u0010Y\u001a\u0004\u0018\u0001H*2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H*0/H\u0016\u00a2\u0006\u0002\u0010ZJ\u001a\u0010[\u001a\u00020&2\u0006\u0010+\u001a\u00020\n2\b\u0010\\\u001a\u0004\u0018\u00010CH\u0002J\u0018\u0010]\u001a\u00020&2\u0006\u0010+\u001a\u00020\n2\u0006\u0010P\u001a\u00020\nH\u0014J3\u0010^\u001a\u00020&\"\u0004\b\u0000\u0010*2\u0006\u0010+\u001a\u00020\n2\b\u0010Y\u001a\u0004\u0018\u0001H*2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H*0/H\u0016\u00a2\u0006\u0002\u0010_J\u001a\u0010`\u001a\u00020&2\u0006\u0010+\u001a\u00020\n2\b\u0010a\u001a\u0004\u0018\u00010bH\u0002J\b\u0010c\u001a\u00020&H\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u001fR\u0014\u0010 \u001a\u00020\u001cX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001e\u00a8\u0006e"}, d2={"Lorg/mapdb/StoreDirect;", "Lorg/mapdb/StoreDirectAbstract;", "Lorg/mapdb/StoreBinary;", "file", "", "volumeFactory", "Lorg/mapdb/volume/VolumeFactory;", "isReadOnly", "", "fileLockWait", "", "isThreadSafe", "concShift", "", "allocateIncrement", "allocateStartSize", "fileDeleteAfterClose", "fileDeleteAfterOpen", "checksum", "checksumHeader", "checksumHeaderBypass", "fileSyncDisable", "(Ljava/lang/String;Lorg/mapdb/volume/VolumeFactory;ZJZIJJZZZZZZ)V", "freeSize", "Ljava/util/concurrent/atomic/AtomicLong;", "getFreeSize", "()Ljava/util/concurrent/atomic/AtomicLong;", "headVol", "Lorg/mapdb/volume/Volume;", "getHeadVol", "()Lorg/mapdb/volume/Volume;", "()Z", "volume", "getVolume", "allocateNewIndexPage", "allocateNewPage", "calculateFreeSize", "close", "", "commit", "compact", "compareAndSwap", "R", "recid", "expectedOldRecord", "newRecord", "serializer", "Lorg/mapdb/Serializer;", "(JLjava/lang/Object;Ljava/lang/Object;Lorg/mapdb/Serializer;)Z", "delete", "fileLoad", "freeSizeIncrement", "increment", "get", "(JLorg/mapdb/Serializer;)Ljava/lang/Object;", "getAllFiles", "", "getAllRecids", "Lkotlin/collections/LongIterator;", "getBinaryLong", "f", "Lorg/mapdb/StoreBinaryGetLong;", "getIndexVal", "getTotalSize", "linkedRecordDelete", "indexValue", "linkedRecordGet", "", "linkedRecordPut", "output", "size", "longStackFindEnd", "pageOffset", "pos", "longStackForEach", "masterLinkOffset", "body", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "value", "longStackNewChunk", "prevPageOffset", "valueSize", "recursive", "longStackPut", "longStackTake", "preallocate", "put", "record", "(Ljava/lang/Object;Lorg/mapdb/Serializer;)J", "putCompact", "data", "setIndexVal", "update", "(JLjava/lang/Object;Lorg/mapdb/Serializer;)V", "updateProtected", "di", "Lorg/mapdb/DataOutput2;", "verify", "Companion", "mapdb"})
@SourceDebugExtension(value={"SMAP\nStoreDirect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StoreDirect.kt\norg/mapdb/StoreDirect\n+ 2 Utils.kt\norg/mapdb/Utils\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1121:1\n124#2,5:1122\n124#2,5:1127\n124#2,5:1132\n124#2,5:1137\n88#2,7:1142\n99#2,7:1149\n99#2,7:1156\n99#2,4:1163\n124#2,5:1167\n88#2,7:1172\n104#2,2:1179\n124#2,5:1181\n88#2,7:1186\n124#2,5:1193\n124#2,5:1198\n88#2,7:1203\n88#2,4:1210\n124#2,5:1214\n93#2,2:1219\n88#2,4:1221\n124#2,5:1225\n93#2,2:1230\n124#2,5:1236\n13309#3,2:1232\n13309#3,2:1234\n*S KotlinDebug\n*F\n+ 1 StoreDirect.kt\norg/mapdb/StoreDirect\n*L\n91#1:1122,5\n243#1:1127,5\n257#1:1132,5\n503#1:1137,5\n507#1:1142,7\n523#1:1149,7\n556#1:1156,7\n592#1:1163,4\n593#1:1167,5\n597#1:1172,7\n592#1:1179,2\n618#1:1181,5\n634#1:1186,7\n656#1:1193,5\n691#1:1198,5\n703#1:1203,7\n725#1:1210,4\n732#1:1214,5\n725#1:1219,2\n752#1:1221,4\n755#1:1225,5\n752#1:1230,2\n1074#1:1236,5\n914#1:1232,2\n1053#1:1234,2\n*E\n"})
public final class StoreDirect
extends StoreDirectAbstract
implements StoreBinary {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isReadOnly;
    @NotNull
    private final AtomicLong freeSize;
    @NotNull
    private final Volume volume;
    @NotNull
    private final Volume headVol;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreDirect(@Nullable String file, @NotNull VolumeFactory volumeFactory, boolean isReadOnly, long fileLockWait, boolean isThreadSafe, int concShift, long allocateIncrement, long allocateStartSize, boolean fileDeleteAfterClose, boolean fileDeleteAfterOpen, boolean checksum, boolean checksumHeader, boolean checksumHeaderBypass, boolean fileSyncDisable) {
        Intrinsics.checkNotNullParameter((Object)volumeFactory, (String)"volumeFactory");
        super(file, volumeFactory, isThreadSafe, concShift, fileDeleteAfterClose, checksum, checksumHeader, checksumHeaderBypass);
        this.isReadOnly = isReadOnly;
        this.freeSize = new AtomicLong(-1L);
        Object object = volumeFactory.makeVolume(file, this.isReadOnly(), fileLockWait, Math.max(20, DataIO.shift((int)allocateIncrement)), DataIO.roundUp(allocateStartSize, 0x100000L), false);
        Intrinsics.checkNotNull((Object)object);
        this.volume = object;
        this.headVol = this.getVolume();
        object = Utils.INSTANCE;
        Lock lock$iv = this.getStructuralLock();
        boolean $i$f$lock = false;
        Lock lock = lock$iv;
        if (lock != null) {
            lock.lock();
        }
        try {
            boolean bl = false;
            if (!this.getVolumeExistsAtStart()) {
                this.getVolume().ensureAvailable(0x100000L);
                this.getVolume().putLong(0L, this.fileHeaderCompose());
                this.getVolume().putLong(8L, 1L);
                this.setDataTail(0L);
                this.setMaxRecid(0L);
                this.setFileTail$mapdb(0x100000L);
                this.getVolume().putInt(16L, this.storeHeaderCompose());
                LongProgression longProgression = RangesKt.step((LongProgression)((LongProgression)RangesKt.until((long)64L, (long)32864L)), (long)8L);
                long offset = longProgression.getFirst();
                long l = longProgression.getLast();
                long l2 = longProgression.getStep();
                if (l2 > 0L && offset <= l || l2 < 0L && l <= offset) {
                    while (true) {
                        this.getVolume().putLong(offset, DataIO.parity4Set(0L));
                        if (offset == l) break;
                        offset += l2;
                    }
                }
                this.getVolume().putLong(32864L, DataIO.parity16Set(0L));
                this.commit();
            } else {
                if (this.getVolume().length() <= 0L) {
                    throw new DBException.DataCorruption("File is empty");
                }
                this.fileHeaderCheck();
                MutableLongList mutableLongList = this.getIndexPages();
                Intrinsics.checkNotNullExpressionValue((Object)mutableLongList, (String)"<get-indexPages>(...)");
                this.loadIndexPages(mutableLongList);
            }
            if (file != null && fileDeleteAfterOpen) {
                new File(file).delete();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            Lock lock2 = lock$iv;
            if (lock2 != null) {
                lock2.unlock();
            }
        }
    }

    public /* synthetic */ StoreDirect(String string, VolumeFactory volumeFactory, boolean bl, long l, boolean bl2, int n, long l2, long l3, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x2000) != 0) {
            bl8 = false;
        }
        this(string, volumeFactory, bl, l, bl2, n, l2, l3, bl3, bl4, bl5, bl6, bl7, bl8);
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @NotNull
    protected final AtomicLong getFreeSize() {
        return this.freeSize;
    }

    @Override
    @NotNull
    protected Volume getVolume() {
        return this.volume;
    }

    @Override
    @NotNull
    protected Volume getHeadVol() {
        return this.headVol;
    }

    @Override
    protected long getIndexVal(long recid2) {
        try {
            long offset = this.recidToOffset(recid2);
            long indexVal = this.getVolume().getLong(offset);
            if (indexVal == 0L) {
                throw new DBException.GetVoid(recid2);
            }
            return DataIO.parity1Get(indexVal);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DBException.GetVoid(recid2);
        }
    }

    @Override
    protected void setIndexVal(long recid2, long value) {
        Utils.INSTANCE.assertWriteLock(this.getLocks()[this.recidToSegment(recid2)]);
        long offset = this.recidToOffset(recid2);
        this.getVolume().putLong(offset, DataIO.parity1Set(value));
    }

    @Override
    protected long allocateNewPage() {
        Utils.INSTANCE.assertLocked(this.getStructuralLock());
        long eof = this.getFileTail$mapdb();
        long newEof = eof + 0x100000L;
        this.getVolume().ensureAvailable(newEof);
        this.setFileTail$mapdb(newEof);
        return eof;
    }

    @Override
    protected long allocateNewIndexPage() {
        long pagePointerOffset;
        Utils.INSTANCE.assertLocked(this.getStructuralLock());
        long indexPage = this.allocateNewPage();
        long l = pagePointerOffset = this.getIndexPages().isEmpty() ? 32864L : this.getIndexPages().get(this.getIndexPages().size() - 1) + (long)8;
        if (DataIO.parity16Get(this.getVolume().getLong(pagePointerOffset)) != 0L) {
            throw new DBException.DataCorruption("index pointer not empty");
        }
        this.getVolume().putLong(pagePointerOffset, DataIO.parity16Set(indexPage));
        this.getIndexPages().add(indexPage);
        this.getVolume().putLong(indexPage + (long)8, DataIO.parity16Set(0L));
        return indexPage;
    }

    @NotNull
    protected final byte[] linkedRecordGet(long indexValue) {
        if (!this.indexValFlagLinked(indexValue)) {
            throw new AssertionError((Object)"not linked record");
        }
        byte[] b = new byte[131072];
        int bpos = 0;
        long pointer = indexValue;
        while (true) {
            boolean isLinked;
            int nextPointerSize = (isLinked = this.indexValFlagLinked(pointer)) ? 8 : 0;
            int size = (int)StoreDirectJava.indexValToSize(pointer) - nextPointerSize;
            long offset = StoreDirectJava.indexValToOffset(pointer);
            if (bpos + size >= b.length) {
                Intrinsics.checkNotNullExpressionValue((Object)Arrays.copyOf(b, b.length * 2), (String)"copyOf(...)");
            }
            this.getVolume().getData(offset + (long)nextPointerSize, b, bpos, size);
            bpos += size;
            if (!isLinked) break;
            pointer = DataIO.parity3Get(this.getVolume().getLong(offset));
        }
        byte[] byArray = Arrays.copyOf(b, bpos);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        return byArray;
    }

    protected final void linkedRecordDelete(long indexValue) {
        if (!this.indexValFlagLinked(indexValue)) {
            throw new AssertionError((Object)"not linked record");
        }
        long pointer = indexValue;
        while (pointer != 0L) {
            boolean isLinked = this.indexValFlagLinked(pointer);
            long size = StoreDirectJava.indexValToSize(pointer);
            long offset = StoreDirectJava.indexValToOffset(pointer);
            pointer = isLinked ? DataIO.parity3Get(this.getVolume().getLong(offset)) : 0L;
            long sizeUp = DataIO.roundUp(size, 16L);
            this.releaseData(sizeUp, offset, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final long linkedRecordPut(@NotNull byte[] output, int size) {
        long l;
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        long remSize = size;
        long chunkSize = 0L;
        chunkSize = Math.min(65520L, remSize);
        Utils utils = Utils.INSTANCE;
        Lock lock$iv = this.getStructuralLock();
        boolean $i$f$lock = false;
        Lock lock = lock$iv;
        if (lock != null) {
            lock.lock();
        }
        try {
            boolean bl = false;
            l = this.allocateData(DataIO.roundUp((int)chunkSize, 16), false);
        }
        finally {
            Lock lock2 = lock$iv;
            if (lock2 != null) {
                lock2.unlock();
            }
        }
        long chunkOffset = l;
        this.getVolume().putData(chunkOffset, output, (int)(remSize - chunkSize), (int)chunkSize);
        remSize -= chunkSize;
        long isLinked = 0L;
        while (remSize > 0L) {
            long l2;
            long prevLink = DataIO.parity3Set((chunkSize + isLinked << 48) + chunkOffset + isLinked);
            isLinked = 8L;
            chunkSize = Math.min(65512L, remSize);
            Utils utils2 = Utils.INSTANCE;
            Lock lock$iv2 = this.getStructuralLock();
            boolean $i$f$lock2 = false;
            Lock lock3 = lock$iv2;
            if (lock3 != null) {
                lock3.lock();
            }
            try {
                boolean bl = false;
                l2 = this.allocateData((int)DataIO.roundUp(chunkSize + (long)8, 16L), false);
            }
            finally {
                Lock lock4 = lock$iv2;
                if (lock4 != null) {
                    lock4.unlock();
                }
            }
            chunkOffset = l2;
            this.getVolume().putLong(chunkOffset, prevLink);
            this.getVolume().putData(chunkOffset + (long)8, output, (int)(remSize -= chunkSize), (int)chunkSize);
        }
        if (remSize != 0L) {
            throw new AssertionError();
        }
        return (chunkSize + (long)8 << 48) + chunkOffset + isLinked + 2L;
    }

    @Override
    protected void longStackPut(long masterLinkOffset, long value, boolean recursive) {
        Utils.INSTANCE.assertLocked(this.getStructuralLock());
        if (masterLinkOffset <= 0L || masterLinkOffset > 0x100000L || masterLinkOffset % (long)8 != 0L) {
            throw new DBException.DataCorruption("wrong master link");
        }
        if (value >> 48 != 0L) {
            throw new AssertionError();
        }
        DataIO.parity1Get(value);
        long valueSize = DataIO.packLongSize(value);
        long masterLinkVal = DataIO.parity4Get(this.getVolume().getLong(masterLinkOffset));
        if (masterLinkVal == 0L) {
            this.longStackNewChunk(masterLinkOffset, 0L, value, valueSize, true);
            return;
        }
        long chunkOffset = masterLinkVal & 0xFFFFFFFFFFF0L;
        long currSize = masterLinkVal >>> 48;
        long prevLinkVal = DataIO.parity4Get(this.getVolume().getLong(chunkOffset));
        long pageSize = prevLinkVal >>> 48;
        if (currSize + valueSize > pageSize) {
            this.longStackNewChunk(masterLinkOffset, chunkOffset, value, valueSize, true);
            return;
        }
        this.getVolume().putPackedLong(chunkOffset + currSize, value);
        long newMasterLinkValue = (currSize + valueSize << 48) + chunkOffset;
        this.getVolume().putLong(masterLinkOffset, DataIO.parity4Set(newMasterLinkValue));
    }

    protected final void longStackNewChunk(long masterLinkOffset, long prevPageOffset, long value, long valueSize, boolean recursive) {
        Utils.INSTANCE.assertLocked(this.getStructuralLock());
        if (masterLinkOffset <= 0L || masterLinkOffset > 0x100000L || masterLinkOffset % (long)8 != 0L) {
            throw new DBException.DataCorruption("wrong master link");
        }
        long newChunkSize = -1L;
        if (!recursive) {
            long size = 256L;
            long l = ProgressionUtilKt.getProgressionLastElement((long)256L, (long)16L, (long)-16L);
            if (l <= size) {
                while (true) {
                    long indexVal;
                    long masterLinkOffset2;
                    if (masterLinkOffset != (masterLinkOffset2 = this.longStackMasterLinkOffset(size)) && (indexVal = DataIO.parity4Get(this.getVolume().getLong(masterLinkOffset2))) != 0L) {
                        newChunkSize = size;
                        break;
                    }
                    if (size == l) break;
                    size += -16L;
                }
            }
        }
        long dataTail = this.getDataTail();
        long remainderSize = DataIO.roundUp(dataTail, 0x100000L) - dataTail;
        if (newChunkSize == -1L) {
            long dataTail2 = dataTail;
            if (dataTail2 == 0L) {
                newChunkSize = 160L;
            } else {
                long l = newChunkSize = remainderSize > 256L || remainderSize < 16L ? 160L : remainderSize;
            }
        }
        if (newChunkSize % (long)16 != 0L) {
            throw new AssertionError();
        }
        long newChunkOffset = this.allocateData((int)newChunkSize, true);
        this.getVolume().clear(newChunkOffset, newChunkOffset + newChunkSize);
        this.getVolume().putLong(newChunkOffset, DataIO.parity4Set((newChunkSize << 48) + prevPageOffset));
        this.getVolume().putPackedLong(newChunkOffset + (long)8, value);
        long newSize = (long)8 + valueSize;
        long newMasterLinkValue = (newSize << 48) + newChunkOffset;
        this.getVolume().putLong(masterLinkOffset, DataIO.parity4Set(newMasterLinkValue));
    }

    @Override
    protected long longStackTake(long masterLinkOffset, boolean recursive) {
        long l;
        Utils.INSTANCE.assertLocked(this.getStructuralLock());
        if (masterLinkOffset <= 0L || masterLinkOffset > 0x100000L || masterLinkOffset % (long)8 != 0L) {
            throw new DBException.DataCorruption("wrong master link");
        }
        long masterLinkVal = DataIO.parity4Get(this.getVolume().getLong(masterLinkOffset));
        if (masterLinkVal == 0L) {
            return 0L;
        }
        long offset = masterLinkVal & 0xFFFFFFFFFFF0L;
        long pos = Math.max((masterLinkVal >>> 48) - 1L, 8L);
        while (pos > 8L && (this.getVolume().getUnsignedByte(offset + pos - 1L) & 0x80) == 0) {
            long l2 = pos;
            pos = l2 + -1L;
        }
        if (pos < 8L) {
            throw new DBException.DataCorruption("position too small");
        }
        if (this.getVolume().getLong(offset) >>> 48 <= pos) {
            throw new DBException.DataCorruption("position beyond chunk " + masterLinkOffset);
        }
        long ret = this.getVolume().getPackedLong(offset + pos) & 0xFFFFFFFFFFFFFFFL;
        this.getVolume().clear(offset + pos, offset + pos + (long)DataIO.packLongSize(ret));
        if (pos > 8L) {
            this.getVolume().putLong(masterLinkOffset, DataIO.parity4Set((pos << 48) + offset));
            if (ret >> 48 != 0L) {
                throw new AssertionError();
            }
            DataIO.parity1Get(ret);
            return ret;
        }
        long prevChunkValue = DataIO.parity4Get(this.getVolume().getLong(offset));
        this.getVolume().putLong(offset, 0L);
        long currentSize = prevChunkValue >>> 48;
        long prevChunkOffset = prevChunkValue & 0xFFFFFFFFFFF0L;
        if (prevChunkOffset != 0L) {
            long pos2 = DataIO.parity4Get(this.getVolume().getLong(prevChunkOffset)) >>> 48;
            l = this.longStackFindEnd(prevChunkOffset, pos2);
        } else {
            l = 0L;
        }
        long masterLinkPos = l;
        this.getVolume().putLong(masterLinkOffset, DataIO.parity4Set((masterLinkPos << 48) + prevChunkOffset));
        this.releaseData(currentSize, offset, true);
        if (ret >> 48 != 0L) {
            throw new AssertionError();
        }
        if (ret != 0L) {
            DataIO.parity1Get(ret);
        }
        return ret;
    }

    protected final long longStackFindEnd(long pageOffset, long pos) {
        long pos2 = pos;
        while (pos2 > 8L && this.getVolume().getUnsignedByte(pageOffset + pos2 - 1L) == 0) {
            long l = pos2;
            pos2 = l + -1L;
        }
        return pos2;
    }

    protected final void longStackForEach(long masterLinkOffset, @NotNull Function1<? super Long, Unit> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        long linkVal = DataIO.parity4Get(this.getVolume().getLong(masterLinkOffset));
        long endSize = StoreDirectJava.indexValToSize(linkVal);
        long offset = StoreDirectJava.indexValToOffset(linkVal);
        endSize = this.longStackFindEnd(offset, endSize);
        while (offset != 0L) {
            long stackVal;
            long currHead = DataIO.parity4Get(this.getVolume().getLong(offset));
            for (long pos = 8L; pos < endSize; pos += stackVal >>> 60) {
                stackVal = this.getVolume().getPackedLong(offset + pos);
                if ((stackVal &= 0xFFFFFFFFFFFFFFFL) >>> 48 != 0L) {
                    throw new AssertionError();
                }
                DataIO.parity1Get(stackVal);
                body.invoke((Object)stackVal);
            }
            offset = StoreDirectJava.indexValToOffset(currHead);
            if (offset == 0L) continue;
            endSize = StoreDirectJava.indexValToSize(DataIO.parity4Get(this.getVolume().getLong(offset)));
            endSize = this.longStackFindEnd(offset, endSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long preallocate() {
        long l;
        this.assertNotClosed();
        Utils utils = Utils.INSTANCE;
        Object lock$iv = this.getStructuralLock();
        boolean $i$f$lock = false;
        Lock lock = lock$iv;
        if (lock != null) {
            lock.lock();
        }
        try {
            boolean bl = false;
            l = this.allocateRecid();
        }
        finally {
            Lock lock2 = lock$iv;
            if (lock2 != null) {
                lock2.unlock();
            }
        }
        long recid2 = l;
        Utils this_$iv = Utils.INSTANCE;
        lock$iv = this.getLocks()[this.recidToSegment(recid2)];
        boolean $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            boolean bl = false;
            long oldVal = this.getVolume().getLong(this.recidToOffset(recid2));
            if (oldVal != 0L && StoreDirectJava.indexValToSize(oldVal) != 65534L) {
                throw new DBException.DataCorruption("old recid is not empty");
            }
            this.setIndexVal(recid2, this.indexValCompose(65535L, 0L, 0, 1, 1));
            long l2 = recid2;
            return l2;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <R> R get(long recid2, @NotNull Serializer<R> serializer) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        this.assertNotClosed();
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.getLocks()[this.recidToSegment(recid2)];
        boolean $i$f$lockRead = false;
        if (lock$iv != null) {
            lock$iv.readLock().lock();
        }
        try {
            boolean bl = false;
            long indexVal = this.getIndexVal(recid2);
            if (this.indexValFlagLinked(indexVal)) {
                byte[] di = this.linkedRecordGet(indexVal);
                R r = this.deserialize(serializer, new DataInput2.ByteArray(di), di.length);
                return r;
            }
            long size = StoreDirectJava.indexValToSize(indexVal);
            if (size == 65534L) {
                throw new DBException.GetVoid(recid2);
            }
            if (size == 65535L) {
                R r = null;
                return r;
            }
            long offset = StoreDirectJava.indexValToOffset(indexVal);
            if (size < 6L) {
                if (size > 5L) {
                    throw new DBException.DataCorruption("wrong size record header");
                }
                R r = serializer.deserializeFromLong(offset >>> 8, (int)size);
                return r;
            }
            DataInput2 di = this.getVolume().getDataInput(offset, (int)size);
            Intrinsics.checkNotNull((Object)di);
            R r = this.deserialize(serializer, di, size);
            return r;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getBinaryLong(long recid2, @NotNull StoreBinaryGetLong f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        this.assertNotClosed();
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.getLocks()[this.recidToSegment(recid2)];
        boolean $i$f$lockRead = false;
        if (lock$iv != null) {
            lock$iv.readLock().lock();
        }
        try {
            DataInput2 dataInput2;
            boolean bl = false;
            long indexVal = this.getIndexVal(recid2);
            if (this.indexValFlagLinked(indexVal)) {
                byte[] di = this.linkedRecordGet(indexVal);
                long l = f.get(new DataInput2.ByteArray(di), di.length);
                return l;
            }
            long size = StoreDirectJava.indexValToSize(indexVal);
            if (size == 65534L) {
                throw new DBException.GetVoid(recid2);
            }
            if (size == 65535L) {
                long l = Long.MIN_VALUE;
                return l;
            }
            long offset = StoreDirectJava.indexValToOffset(indexVal);
            int sizeInt = (int)size;
            if (size >= 6L) {
                dataInput2 = this.getVolume().getDataInput(offset, sizeInt);
            } else {
                byte[] buf = new byte[sizeInt];
                DataIO.putLong(buf, 0, offset >>> 8, sizeInt);
                dataInput2 = new DataInput2.ByteArray(buf);
            }
            DataInput2 di = dataInput2;
            long l = f.get(di, sizeInt);
            return l;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> long put(@Nullable R record, @NotNull Serializer<R> serializer) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        this.assertNotClosed();
        DataOutput2 di = this.serialize(record, serializer);
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.getCompactionLock();
        boolean $i$f$lockRead = false;
        if (lock$iv != null) {
            lock$iv.readLock().lock();
        }
        try {
            long recid2;
            Object lock$iv2;
            block33: {
                block32: {
                    long l;
                    boolean bl = false;
                    Utils utils2 = Utils.INSTANCE;
                    lock$iv2 = this.getStructuralLock();
                    boolean $i$f$lock = false;
                    Lock lock = lock$iv2;
                    if (lock != null) {
                        lock.lock();
                    }
                    try {
                        boolean bl2 = false;
                        l = this.allocateRecid();
                    }
                    finally {
                        Lock lock2 = lock$iv2;
                        if (lock2 != null) {
                            lock2.unlock();
                        }
                    }
                    recid2 = l;
                    Utils this_$iv = Utils.INSTANCE;
                    lock$iv2 = this.getLocks()[this.recidToSegment(recid2)];
                    boolean $i$f$lockWrite = false;
                    if (lock$iv2 != null) {
                        lock$iv2.writeLock().lock();
                    }
                    try {
                        boolean bl3 = false;
                        if (di != null) break block32;
                        this.setIndexVal(recid2, this.indexValCompose(65535L, 0L, 0, 0, 1));
                        long l2 = recid2;
                        if (lock$iv2 != null) {
                            lock$iv2.writeLock().unlock();
                        }
                        long l3 = l2;
                        return l3;
                    }
                    catch (Throwable throwable) {
                        if (lock$iv2 != null) {
                            lock$iv2.writeLock().unlock();
                        }
                        throw throwable;
                    }
                }
                if ((long)di.pos <= 65520L) break block33;
                Intrinsics.checkNotNullExpressionValue((Object)di.buf, (String)"buf");
                long indexVal = this.linkedRecordPut(di.buf, di.pos);
                this.setIndexVal(recid2, indexVal);
                long l = recid2;
                if (lock$iv2 != null) {
                    lock$iv2.writeLock().unlock();
                }
                long l4 = l;
                return l4;
            }
            long size = di.pos;
            long offset = 0L;
            if (di.pos == 0) {
                offset = 0L;
            } else if (di.pos < 6) {
                offset = DataIO.getLong(di.buf, 0) >>> (7 - di.pos) * 8;
            } else {
                long l;
                Utils utils3 = Utils.INSTANCE;
                Lock lock$iv3 = this.getStructuralLock();
                boolean $i$f$lock = false;
                Lock lock = lock$iv3;
                if (lock != null) {
                    lock.lock();
                }
                try {
                    boolean bl = false;
                    l = this.allocateData(DataIO.roundUp(di.pos, 16), false);
                }
                finally {
                    Lock lock3 = lock$iv3;
                    if (lock3 != null) {
                        lock3.unlock();
                    }
                }
                offset = l;
                this.getVolume().putData(offset, di.buf, 0, di.pos);
            }
            this.setIndexVal(recid2, this.indexValCompose(size, offset, 0, 0, 1));
            long l = recid2;
            if (lock$iv2 != null) {
                lock$iv2.writeLock().unlock();
            }
            long l5 = l;
            return l5;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> void update(long recid2, @Nullable R record, @NotNull Serializer<R> serializer) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        this.assertNotClosed();
        DataOutput2 di = this.serialize(record, serializer);
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.getLocks()[this.recidToSegment(recid2)];
        boolean $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            boolean bl = false;
            this.updateProtected(recid2, di);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateProtected(long recid2, DataOutput2 di) {
        long l;
        long newUpSize;
        Utils.INSTANCE.assertWriteLock(this.getLocks()[this.recidToSegment(recid2)]);
        long oldIndexVal = this.getIndexVal(recid2);
        boolean oldLinked = this.indexValFlagLinked(oldIndexVal);
        long oldSize = StoreDirectJava.indexValToSize(oldIndexVal);
        if (oldSize == 65534L) {
            throw new DBException.GetVoid(recid2);
        }
        long l2 = newUpSize = di == null ? -16L : DataIO.roundUp(StoreDirect.updateProtected$roundSixDown(di.pos), 16L);
        if (oldLinked || newUpSize != DataIO.roundUp(StoreDirect.updateProtected$roundSixDown(oldSize), 16L) && oldSize != 65535L && oldSize > 5L) {
            Utils utils = Utils.INSTANCE;
            Lock lock$iv = this.getStructuralLock();
            boolean $i$f$lock = false;
            Lock lock = lock$iv;
            if (lock != null) {
                lock.lock();
            }
            try {
                boolean bl = false;
                if (oldLinked) {
                    this.linkedRecordDelete(oldIndexVal);
                } else {
                    long oldOffset = StoreDirectJava.indexValToOffset(oldIndexVal);
                    long sizeUp = DataIO.roundUp(oldSize, 16L);
                    this.releaseData(sizeUp, oldOffset, false);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                Lock lock2 = lock$iv;
                if (lock2 != null) {
                    lock2.unlock();
                }
            }
        }
        if (di == null) {
            this.setIndexVal(recid2, this.indexValCompose(65535L, 0L, 0, 0, 1));
            return;
        }
        if ((long)di.pos > 65520L) {
            Intrinsics.checkNotNullExpressionValue((Object)di.buf, (String)"buf");
            long newIndexVal = this.linkedRecordPut(di.buf, di.pos);
            this.setIndexVal(recid2, newIndexVal);
            return;
        }
        int size = di.pos;
        if (size != 0 && size < 6) {
            l = DataIO.getLong(di.buf, 0) >>> (7 - size) * 8;
        } else if (!oldLinked && newUpSize == DataIO.roundUp(oldSize, 16L) && oldSize >= 6L) {
            l = StoreDirectJava.indexValToOffset(oldIndexVal);
        } else if (size == 0) {
            l = 0L;
        } else {
            Utils bl = Utils.INSTANCE;
            Lock lock$iv = this.getStructuralLock();
            boolean $i$f$lock = false;
            Lock lock = lock$iv;
            if (lock != null) {
                lock.lock();
            }
            try {
                boolean bl2 = false;
                long l3 = this.allocateData(DataIO.roundUp(size, 16), false);
                l = l3;
            }
            finally {
                Lock lock3 = lock$iv;
                if (lock3 != null) {
                    lock3.unlock();
                }
            }
        }
        long offset = l;
        if (size > 5) {
            this.getVolume().putData(offset, di.buf, 0, size);
        }
        this.setIndexVal(recid2, this.indexValCompose(size, offset, 0, 0, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> boolean compareAndSwap(long recid2, @Nullable R expectedOldRecord, @Nullable R newRecord, @NotNull Serializer<R> serializer) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        this.assertNotClosed();
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.getLocks()[this.recidToSegment(recid2)];
        boolean $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            boolean bl = false;
            R old = this.get(recid2, serializer);
            if (old == null && expectedOldRecord != null) {
                boolean bl2 = false;
                return bl2;
            }
            if (old != null && expectedOldRecord == null) {
                boolean bl3 = false;
                return bl3;
            }
            if (old != expectedOldRecord) {
                R r = old;
                Intrinsics.checkNotNull(r);
                R r2 = expectedOldRecord;
                Intrinsics.checkNotNull(r2);
                if (!serializer.equals(r, r2)) {
                    boolean bl4 = false;
                    return bl4;
                }
            }
            DataOutput2 di = this.serialize(newRecord, serializer);
            this.updateProtected(recid2, di);
            boolean bl5 = true;
            return bl5;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> void delete(long recid2, @NotNull Serializer<R> serializer) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        this.assertNotClosed();
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.getLocks()[this.recidToSegment(recid2)];
        boolean $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            boolean bl = false;
            long oldIndexVal = this.getIndexVal(recid2);
            long oldSize = StoreDirectJava.indexValToSize(oldIndexVal);
            if (oldSize == 65534L) {
                throw new DBException.GetVoid(recid2);
            }
            if (oldSize != 65535L) {
                Utils utils2 = Utils.INSTANCE;
                Lock lock$iv2 = this.getStructuralLock();
                boolean $i$f$lock = false;
                Lock lock = lock$iv2;
                if (lock != null) {
                    lock.lock();
                }
                try {
                    boolean bl2 = false;
                    if (this.indexValFlagLinked(oldIndexVal)) {
                        this.linkedRecordDelete(oldIndexVal);
                    } else if (oldSize > 5L) {
                        long oldOffset = StoreDirectJava.indexValToOffset(oldIndexVal);
                        long sizeUp = DataIO.roundUp(oldSize, 16L);
                        this.releaseData(sizeUp, oldOffset, false);
                    }
                    this.releaseRecid(recid2);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    Lock lock2 = lock$iv2;
                    if (lock2 != null) {
                        lock2.unlock();
                    }
                }
            }
            this.setIndexVal(recid2, this.indexValCompose(65534L, 0L, 0, 0, 1));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compact() {
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.getCompactionLock();
        boolean $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            boolean bl = false;
            Utils.INSTANCE.lockWriteAll(this.getLocks());
            try {
                Utils utils2 = Utils.INSTANCE;
                Lock lock$iv2 = this.getStructuralLock();
                boolean $i$f$lock = false;
                Lock lock = lock$iv2;
                if (lock != null) {
                    lock.lock();
                }
                try {
                    boolean bl2 = false;
                    StoreDirect store2 = org.mapdb.StoreDirect$Companion.make$default(Companion, null, null, 0L, false, false, 0, 0L, 0L, false, false, false, false, false, 8143, null);
                    int n = this.getIndexPages().size();
                    for (int i = 0; i < n; ++i) {
                        store2.allocateNewIndexPage();
                    }
                    if (store2.getIndexPages().size() != this.getIndexPages().size()) {
                        throw new AssertionError();
                    }
                    long recid2 = 1L;
                    long maxRecid = this.getMaxRecid();
                    if (recid2 <= maxRecid) {
                        while (true) {
                            byte[] data = null;
                            boolean exist = true;
                            try {
                                Serializer<byte[]> serializer = Serializer.BYTE_ARRAY_NOSIZE;
                                Intrinsics.checkNotNullExpressionValue(serializer, (String)"BYTE_ARRAY_NOSIZE");
                                data = this.get(recid2, serializer);
                                exist = true;
                            }
                            catch (Exception e) {
                                exist = false;
                            }
                            if (!exist) {
                                store2.releaseRecid(recid2);
                                store2.setIndexVal(recid2, store2.indexValCompose(65534L, 0L, 0, 0, 1));
                            } else {
                                store2.putCompact(recid2, data);
                            }
                            if (recid2 == maxRecid) break;
                            ++recid2;
                        }
                    }
                    store2.setMaxRecid(maxRecid);
                    long fileTail = store2.getFileTail$mapdb();
                    this.getVolume().truncate(fileTail);
                    LongProgression longProgression = RangesKt.step((LongProgression)((LongProgression)RangesKt.until((int)0, (long)fileTail)), (long)0x100000L);
                    long page = longProgression.getFirst();
                    long l = longProgression.getLast();
                    long l2 = longProgression.getStep();
                    if (l2 > 0L && page <= l || l2 < 0L && l <= page) {
                        while (true) {
                            store2.getVolume().copyTo(page, this.getVolume(), page, 0x100000L);
                            if (page == l) break;
                            page += l2;
                        }
                    }
                    this.getIndexPages().clear();
                    this.getIndexPages().addAll((LongIterable)store2.getIndexPages());
                    this.freeSize.set(store2.freeSize.get());
                    store2.close();
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    Lock lock2 = lock$iv2;
                    if (lock2 != null) {
                        lock2.unlock();
                    }
                }
            }
            finally {
                Utils.INSTANCE.unlockWriteAll(this.getLocks());
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    private final void putCompact(long recid2, byte[] data) {
        long l;
        if (this.isThreadSafe()) {
            throw new AssertionError();
        }
        if (data == null) {
            this.setIndexVal(recid2, this.indexValCompose(65535L, 0L, 0, 0, 1));
            return;
        }
        if ((long)data.length > 65520L) {
            long indexVal = this.linkedRecordPut(data, data.length);
            this.setIndexVal(recid2, indexVal);
            return;
        }
        if (data.length == 0) {
            l = 0L;
        } else if (data.length < 6) {
            byte[] data2 = Arrays.copyOf(data, 8);
            l = DataIO.getLong(data2, 0) >>> (7 - data.length) * 8;
        } else {
            long offset = this.allocateData(DataIO.roundUp(data.length, 16), false);
            this.getVolume().putData(offset, data, 0, data.length);
            l = offset;
        }
        long offset = l;
        this.setIndexVal(recid2, this.indexValCompose(data.length, offset, 0, 0, 1));
    }

    @Override
    public void commit() {
        this.assertNotClosed();
        if (this.isReadOnly()) {
            return;
        }
        this.getVolume().putInt(20L, this.calculateHeaderChecksum());
        if (this.getChecksum()) {
            this.getVolume().putLong(8L, this.calculateChecksum());
        }
        if (!this.getFileSyncDisable$mapdb()) {
            this.getVolume().sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Utils.INSTANCE.lockWriteAll(this.getLocks());
        try {
            if (!this.getClosed().compareAndSet(false, true)) {
                return;
            }
            if (!this.isReadOnly()) {
                this.getVolume().putInt(20L, this.calculateHeaderChecksum());
                if (this.getChecksum()) {
                    this.getVolume().putLong(8L, this.calculateChecksum());
                }
            }
            this.getVolume().close();
            if (this.getFileDeleteAfterClose() && this.getFile() != null) {
                new File(this.getFile()).delete();
            }
        }
        finally {
            Utils.INSTANCE.unlockWriteAll(this.getLocks());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public LongIterator getAllRecids() {
        LongArrayList ret;
        block8: {
            ret = new LongArrayList();
            Utils.INSTANCE.lockReadAll(this.getLocks());
            try {
                long maxRecid = this.getMaxRecid();
                long recid2 = 1L;
                if (recid2 > maxRecid) break block8;
                while (true) {
                    long offset = this.recidToOffset(recid2);
                    try {
                        long indexVal = DataIO.parity1Get(this.getVolume().getLong(offset));
                        if (!this.indexValFlagUnused(indexVal)) {
                            ret.add(recid2);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (recid2 != maxRecid) {
                        ++recid2;
                        continue;
                    }
                    break;
                }
            }
            finally {
                Utils.INSTANCE.unlockReadAll(this.getLocks());
            }
        }
        return ArrayIteratorsKt.iterator((long[])ret.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void verify() {
        Object[] $this$forEach$iv = this.getLocks();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Object element$iv = $this$forEach$iv[i];
            ReadWriteLock it = element$iv;
            boolean bl = false;
            Object object = it;
            if (object == null || (object = object.readLock()) == null) continue;
            object.lock();
        }
        Lock lock = this.getStructuralLock();
        if (lock != null) {
            lock.lock();
        }
        try {
            BitSet bit = new BitSet();
            long max = this.getFileTail$mapdb();
            StoreDirect.verify$set(max, this, bit, 0L, 32864L, false);
            if (this.getDataTail() % 0x100000L != 0L) {
                StoreDirect.verify$set(max, this, bit, this.getDataTail(), DataIO.roundUp(this.getDataTail(), 0x100000L), true);
            }
            long zeroIndexPageEnd = Math.min(0x100000L, this.recidToOffset(this.getMaxRecid()) + (long)8);
            StoreDirect.verify$set(max, this, bit, 32864L, 32880L, false);
            StoreDirect.verify$iterateOverIndexValues(this, max, bit, 32864L, zeroIndexPageEnd);
            if (zeroIndexPageEnd < 0x100000L) {
                StoreDirect.verify$set(max, this, bit, zeroIndexPageEnd, 0x100000L, true);
            }
            this.getIndexPages().forEach(arg_0 -> StoreDirect.verify$lambda$22(this, max, bit, arg_0));
            StoreDirect.verify$longStackForEach(this, max, bit, 64L, (Function1<? super Long, Unit>)((Function1)verify.3.INSTANCE));
            long size = 16L;
            long l = ProgressionUtilKt.getProgressionLastElement((long)16L, (long)65520L, (long)16L);
            if (size <= l) {
                while (true) {
                    long masterLinkOffset = this.longStackMasterLinkOffset(size);
                    StoreDirect.verify$longStackForEach(this, max, bit, masterLinkOffset, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>(size, max, this, bit){
                        final /* synthetic */ long $size;
                        final /* synthetic */ long $max;
                        final /* synthetic */ StoreDirect this$0;
                        final /* synthetic */ BitSet $bit;
                        {
                            this.$size = $size;
                            this.$max = $max;
                            this.this$0 = $receiver;
                            this.$bit = $bit;
                            super(1);
                        }

                        public final void invoke(long freeOffset) {
                            long freeOffset2 = DataIO.parity1Get(freeOffset) << 3;
                            StoreDirect.access$verify$set(this.$max, this.this$0, this.$bit, freeOffset2, freeOffset2 + this.$size, true);
                        }
                    }));
                    if (size == l) break;
                    size += 16L;
                }
            }
            for (long index = 0L; index < max; ++index) {
                if (bit.get((int)index)) continue;
                int len = 0;
                while (!bit.get((int)index + len)) {
                    ++len;
                }
                throw new AssertionError((Object)("not set at " + index + ", for length " + len + " - " + index % 0x100000L + " - " + this.getDataTail() + " - " + this.getFileTail$mapdb()));
            }
        }
        catch (Throwable throwable) {
            Lock lock2 = this.getStructuralLock();
            if (lock2 != null) {
                lock2.unlock();
            }
            Object[] $this$forEach$iv2 = ArraysKt.reversedArray((Object[])this.getLocks());
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                ReadWriteLock it = (ReadWriteLock)element$iv;
                boolean bl = false;
                Object object = it;
                if (object == null || (object = object.readLock()) == null) continue;
                object.unlock();
            }
            throw throwable;
        }
        Lock lock3 = this.getStructuralLock();
        if (lock3 != null) {
            lock3.unlock();
        }
        $this$forEach$iv = ArraysKt.reversedArray((Object[])this.getLocks());
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ReadWriteLock it = (ReadWriteLock)element$iv;
            boolean bl = false;
            Object object = it;
            if (object == null || (object = object.readLock()) == null) continue;
            object.unlock();
        }
    }

    @Override
    protected void freeSizeIncrement(long increment) {
        long v;
        if (increment % (long)16 != 0L) {
            throw new AssertionError();
        }
        while ((v = this.freeSize.get()) != -1L && !this.freeSize.compareAndSet(v, v + increment)) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getFreeSize() {
        long ret = 0L;
        ret = this.freeSize.get();
        if (ret != -1L) {
            return ret;
        }
        Utils utils = Utils.INSTANCE;
        Lock lock$iv = this.getStructuralLock();
        boolean $i$f$lock = false;
        Lock lock = lock$iv;
        if (lock != null) {
            lock.lock();
        }
        try {
            boolean bl = false;
            ret = this.freeSize.get();
            if (ret != -1L) {
                long l = ret;
                return l;
            }
            ret = this.calculateFreeSize();
            this.freeSize.set(ret);
            long l = ret;
            return l;
        }
        finally {
            block7: {
                Lock lock2 = lock$iv;
                if (lock2 == null) break block7;
                lock2.unlock();
            }
        }
    }

    protected final long calculateFreeSize() {
        Utils.INSTANCE.assertLocked(this.getStructuralLock());
        Ref.LongRef ret1 = new Ref.LongRef();
        long size = 16L;
        long l = ProgressionUtilKt.getProgressionLastElement((long)16L, (long)65520L, (long)16L);
        if (size <= l) {
            while (true) {
                long masterLinkOffset = this.longStackMasterLinkOffset(size);
                this.longStackForEach(masterLinkOffset, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>(ret1, size){
                    final /* synthetic */ Ref.LongRef $ret1;
                    final /* synthetic */ long $size;
                    {
                        this.$ret1 = $ret1;
                        this.$size = $size;
                        super(1);
                    }

                    public final void invoke(long v) {
                        long v2 = DataIO.parity1Get(v) << 3;
                        if (v2 == 0L) {
                            throw new AssertionError();
                        }
                        this.$ret1.element += this.$size;
                    }
                }));
                if (size == l) break;
                size += 16L;
            }
        }
        return ret1.element;
    }

    public final long getTotalSize() {
        return this.getFileTail$mapdb();
    }

    @Override
    public boolean fileLoad() {
        return this.getVolume().fileLoad();
    }

    @Override
    @NotNull
    public Iterable<String> getAllFiles() {
        if (this.getFile() == null) {
            List<String> list = Arrays.asList(new String[0]);
            Intrinsics.checkNotNullExpressionValue(list, (String)"asList(...)");
            return list;
        }
        String[] stringArray = new String[]{this.getFile()};
        List<String> list = Arrays.asList(stringArray);
        Intrinsics.checkNotNullExpressionValue(list, (String)"asList(...)");
        return list;
    }

    private static final long updateProtected$roundSixDown(long size) {
        return size < 6L ? 0L : size;
    }

    private static final void verify$set(long max, StoreDirect this$0, BitSet bit, long start, long end, boolean expectZeros) {
        if (start > max) {
            throw new AssertionError((Object)"start too high");
        }
        if (end > max) {
            throw new AssertionError((Object)"end too high");
        }
        int start0 = (int)start;
        int end0 = (int)end;
        for (int index = start0; index < end0; ++index) {
            if (bit.get(index)) {
                throw new AssertionError((Object)("already set " + index + " - " + (long)index % 0x100000L));
            }
        }
        bit.set(start0, end0);
    }

    private static final void verify$iterateOverIndexValues(StoreDirect this$0, long max, BitSet bit, long indexPage, long end) {
        LongProgression longProgression = RangesKt.step((LongProgression)((LongProgression)RangesKt.until((long)(indexPage + (long)16), (long)end)), (long)8L);
        long indexOffset = longProgression.getFirst();
        long l = longProgression.getLast();
        long l2 = longProgression.getStep();
        if (l2 > 0L && indexOffset <= l || l2 < 0L && l <= indexOffset) {
            while (true) {
                StoreDirect.verify$set(max, this$0, bit, indexOffset, indexOffset + (long)8, false);
                long indexVal = DataIO.parity1Get(this$0.getVolume().getLong(indexOffset));
                if ((indexVal & 8L) != 0L || StoreDirectJava.indexValToSize(indexVal) >= 6L) {
                    long size;
                    long offset;
                    while ((indexVal & 8L) != 0L) {
                        offset = StoreDirectJava.indexValToOffset(indexVal);
                        size = DataIO.roundUp(StoreDirectJava.indexValToSize(indexVal), 16L);
                        StoreDirect.verify$set(max, this$0, bit, offset, offset + size, false);
                        indexVal = DataIO.parity3Get(this$0.getVolume().getLong(offset));
                    }
                    offset = StoreDirectJava.indexValToOffset(indexVal);
                    size = DataIO.roundUp(StoreDirectJava.indexValToSize(indexVal), 16L);
                    if (size <= 65520L) {
                        StoreDirect.verify$set(max, this$0, bit, offset, offset + size, false);
                    }
                }
                if (indexOffset == l) break;
                indexOffset += l2;
            }
        }
    }

    private static final void verify$lambda$22(StoreDirect this$0, long $max, BitSet $bit, long indexPage) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$bit, (String)"$bit");
        StoreDirect.verify$set($max, this$0, $bit, indexPage, indexPage + (long)16, false);
        long end = Math.min(indexPage + 0x100000L, this$0.recidToOffset(this$0.getMaxRecid()) + (long)8);
        StoreDirect.verify$iterateOverIndexValues(this$0, $max, $bit, indexPage, end);
        if (end < indexPage + 0x100000L) {
            StoreDirect.verify$set($max, this$0, $bit, end, indexPage + 0x100000L, true);
        }
    }

    private static final void verify$longStackForEach(StoreDirect this$0, long max, BitSet bit, long masterLinkOffset, Function1<? super Long, Unit> body) {
        long linkVal = DataIO.parity4Get(this$0.getVolume().getLong(masterLinkOffset));
        long offset = StoreDirectJava.indexValToOffset(linkVal);
        long endSize = StoreDirectJava.indexValToSize(linkVal);
        while (offset != 0L) {
            long stackVal;
            long currHead = DataIO.parity4Get(this$0.getVolume().getLong(offset));
            long currSize = StoreDirectJava.indexValToSize(currHead);
            StoreDirect.verify$set(max, this$0, bit, offset, offset + currSize, false);
            this$0.getVolume().assertZeroes(offset + endSize, offset + currSize);
            for (long pos = 8L; pos < endSize; pos += stackVal >>> 60) {
                stackVal = this$0.getVolume().getPackedLong(offset + pos);
                if ((stackVal &= 0xFFFFFFFFFFFFFFFL) >>> 48 != 0L) {
                    throw new AssertionError();
                }
                DataIO.parity1Get(stackVal);
                body.invoke((Object)stackVal);
            }
            offset = StoreDirectJava.indexValToOffset(currHead);
            if (offset == 0L) continue;
            endSize = StoreDirectJava.indexValToSize(DataIO.parity4Get(this$0.getVolume().getLong(offset)));
            endSize = this$0.longStackFindEnd(offset, endSize);
        }
    }

    public static final /* synthetic */ void access$verify$set(long max, StoreDirect this$0, BitSet bit, long start, long end, boolean expectZeros) {
        StoreDirect.verify$set(max, this$0, bit, start, end, expectZeros);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u008a\u0001\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\n2\b\b\u0002\u0010\u0011\u001a\u00020\n2\b\b\u0002\u0010\u0012\u001a\u00020\f2\b\b\u0002\u0010\u0013\u001a\u00020\f2\b\b\u0002\u0010\u0014\u001a\u00020\f2\b\b\u0002\u0010\u0015\u001a\u00020\f2\b\b\u0002\u0010\u0016\u001a\u00020\f\u00a8\u0006\u0017"}, d2={"Lorg/mapdb/StoreDirect$Companion;", "", "()V", "make", "Lorg/mapdb/StoreDirect;", "file", "", "volumeFactory", "Lorg/mapdb/volume/VolumeFactory;", "fileLockWait", "", "isReadOnly", "", "isThreadSafe", "concShift", "", "allocateIncrement", "allocateStartSize", "fileDeleteAfterClose", "fileDeleteAfterOpen", "checksum", "checksumHeader", "checksumHeaderBypass", "mapdb"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StoreDirect make(@Nullable String file, @NotNull VolumeFactory volumeFactory, long fileLockWait, boolean isReadOnly, boolean isThreadSafe, int concShift, long allocateIncrement, long allocateStartSize, boolean fileDeleteAfterClose, boolean fileDeleteAfterOpen, boolean checksum, boolean checksumHeader, boolean checksumHeaderBypass) {
            Intrinsics.checkNotNullParameter((Object)volumeFactory, (String)"volumeFactory");
            return new StoreDirect(file, volumeFactory, isReadOnly, fileLockWait, isThreadSafe, concShift, allocateIncrement, allocateStartSize, fileDeleteAfterClose, fileDeleteAfterOpen, checksum, checksumHeader, checksumHeaderBypass, false, 8192, null);
        }

        public static /* synthetic */ StoreDirect make$default(Companion companion, String string, VolumeFactory volumeFactory, long l, boolean bl, boolean bl2, int n, long l2, long l3, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = null;
            }
            if ((n2 & 2) != 0) {
                VolumeFactory volumeFactory2;
                if (string == null) {
                    VolumeFactory volumeFactory3 = CC.DEFAULT_MEMORY_VOLUME_FACTORY;
                    volumeFactory2 = volumeFactory3;
                    Intrinsics.checkNotNullExpressionValue((Object)volumeFactory3, (String)"DEFAULT_MEMORY_VOLUME_FACTORY");
                } else {
                    VolumeFactory volumeFactory4 = CC.DEFAULT_FILE_VOLUME_FACTORY;
                    volumeFactory2 = volumeFactory4;
                    Intrinsics.checkNotNullExpressionValue((Object)volumeFactory4, (String)"DEFAULT_FILE_VOLUME_FACTORY");
                }
                volumeFactory = volumeFactory2;
            }
            if ((n2 & 4) != 0) {
                l = 0L;
            }
            if ((n2 & 8) != 0) {
                bl = false;
            }
            if ((n2 & 0x10) != 0) {
                bl2 = true;
            }
            if ((n2 & 0x20) != 0) {
                n = 3;
            }
            if ((n2 & 0x40) != 0) {
                l2 = 0x100000L;
            }
            if ((n2 & 0x80) != 0) {
                l3 = 0L;
            }
            if ((n2 & 0x100) != 0) {
                bl3 = false;
            }
            if ((n2 & 0x200) != 0) {
                bl4 = false;
            }
            if ((n2 & 0x400) != 0) {
                bl5 = false;
            }
            if ((n2 & 0x800) != 0) {
                bl6 = true;
            }
            if ((n2 & 0x1000) != 0) {
                bl7 = false;
            }
            return companion.make(string, volumeFactory, l, bl, bl2, n, l2, l3, bl3, bl4, bl5, bl6, bl7);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

