/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sparql.federation;

import java.util.Iterator;
import java.util.List;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.repository.sparql.query.SPARQLQueryBindingSet;

public class SPARQLCrossProductIteration
extends LookAheadIteration<BindingSet> {
    protected final List<BindingSet> inputBindings;
    protected final CloseableIteration<BindingSet> resultIteration;
    protected Iterator<BindingSet> inputBindingsIterator = null;
    protected BindingSet currentInputBinding = null;

    public SPARQLCrossProductIteration(CloseableIteration<BindingSet> resultIteration, List<BindingSet> inputBindings) {
        this.resultIteration = resultIteration;
        this.inputBindings = inputBindings;
    }

    @Override
    protected BindingSet getNextElement() throws QueryEvaluationException {
        if (this.currentInputBinding == null) {
            this.inputBindingsIterator = this.inputBindings.iterator();
            if (this.resultIteration.hasNext()) {
                this.currentInputBinding = (BindingSet)this.resultIteration.next();
            } else {
                return null;
            }
        }
        if (this.inputBindingsIterator.hasNext()) {
            BindingSet next = this.inputBindingsIterator.next();
            SPARQLQueryBindingSet res = new SPARQLQueryBindingSet(next.size() + this.currentInputBinding.size());
            res.addAll(next);
            res.addAll(this.currentInputBinding);
            if (!this.inputBindingsIterator.hasNext()) {
                this.currentInputBinding = null;
            }
            return res;
        }
        return null;
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        this.resultIteration.close();
    }
}

