/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.Cache;
import org.eclipse.rdf4j.sail.shacl.ast.NodeShape;
import org.eclipse.rdf4j.sail.shacl.ast.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclAstLists;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclProperties;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetChain;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;

public class XoneConstraintComponent
extends AbstractConstraintComponent {
    List<Shape> xone;

    public XoneConstraintComponent(Resource id, ShapeSource shapeSource, Shape.ParseSettings parseSettings, Cache cache) {
        super(id);
        this.xone = ShaclAstLists.toList(shapeSource, id, Resource.class).stream().map(r -> new ShaclProperties((Resource)r, shapeSource)).map(p -> {
            if (p.getType() == SHACL.NODE_SHAPE) {
                return NodeShape.getInstance(p, shapeSource, parseSettings, cache);
            }
            if (p.getType() == SHACL.PROPERTY_SHAPE) {
                return PropertyShape.getInstance(p, shapeSource, parseSettings, cache);
            }
            throw new IllegalStateException("Unknown shape type for " + p.getId());
        }).collect(Collectors.toList());
    }

    public XoneConstraintComponent(XoneConstraintComponent xoneConstraintComponent) {
        super(xoneConstraintComponent.getId());
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.XONE, this.getId(), new Resource[0]);
        if (!cycleDetection.contains(this.getId())) {
            cycleDetection.add(this.getId());
            this.xone.forEach(o -> o.toModel(null, null, model, cycleDetection));
        }
        if (!model.contains(this.getId(), null, null, new Resource[0])) {
            ShaclAstLists.listToRdf(this.xone.stream().map(Shape::getId).collect(Collectors.toList()), this.getId(), model);
        }
    }

    @Override
    public void setTargetChain(TargetChain targetChain) {
        super.setTargetChain(targetChain);
        for (Shape shape : this.xone) {
            shape.setTargetChain(targetChain.setOptimizable(false));
        }
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.XoneConstraintComponent;
    }

    @Override
    public ConstraintComponent deepClone() {
        XoneConstraintComponent constraintComponent = new XoneConstraintComponent(this);
        constraintComponent.xone = this.xone.stream().map(ConstraintComponent::deepClone).map(a -> (Shape)a).collect(Collectors.toList());
        return constraintComponent;
    }

    @Override
    public List<Literal> getDefaultMessage() {
        return List.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XoneConstraintComponent that = (XoneConstraintComponent)o;
        return this.xone.equals(that.xone);
    }

    public int hashCode() {
        return this.xone.hashCode() + "XoneConstraintComponent".hashCode();
    }
}

