/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.contextaware.config;

import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryFactory;
import org.eclipse.rdf4j.repository.config.RepositoryImplConfig;
import org.eclipse.rdf4j.repository.contextaware.ContextAwareRepository;
import org.eclipse.rdf4j.repository.contextaware.config.ContextAwareConfig;

public class ContextAwareFactory
implements RepositoryFactory {
    public static final String REPOSITORY_TYPE = "openrdf:ContextAwareRepository";

    public String getRepositoryType() {
        return REPOSITORY_TYPE;
    }

    public RepositoryImplConfig getConfig() {
        return new ContextAwareConfig();
    }

    public Repository getRepository(RepositoryImplConfig configuration) throws RepositoryConfigException {
        if (configuration instanceof ContextAwareConfig) {
            ContextAwareConfig config = (ContextAwareConfig)configuration;
            ContextAwareRepository repo = new ContextAwareRepository();
            repo.setIncludeInferred(config.isIncludeInferred());
            repo.setMaxQueryTime(config.getMaxQueryTime());
            repo.setQueryLanguage(config.getQueryLanguage());
            repo.setBaseURI(config.getBaseURI());
            repo.setReadContexts(config.getReadContexts());
            repo.setAddContexts(config.getAddContexts());
            repo.setRemoveContexts(config.getRemoveContexts());
            repo.setArchiveContexts(config.getArchiveContexts());
            repo.setInsertContext(config.getInsertContext());
            return repo;
        }
        throw new RepositoryConfigException("Invalid configuration class: " + configuration.getClass());
    }
}

