/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.mapdb.DBException;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;

public final class DataIO {
    public static final long PACK_LONG_RESULT_MASK = 0xFFFFFFFFFFFFFFFL;

    private DataIO() {
    }

    public static int unpackInt(DataInput is) throws IOException {
        byte v;
        int ret = 0;
        do {
            v = is.readByte();
            ret = ret << 7 | v & 0x7F;
        } while ((v & 0x80) == 0);
        return ret;
    }

    public static long unpackLong(DataInput in) throws IOException {
        byte v;
        long ret = 0L;
        do {
            v = in.readByte();
            ret = ret << 7 | (long)(v & 0x7F);
        } while ((v & 0x80) == 0);
        return ret;
    }

    public static int unpackInt(InputStream in) throws IOException {
        int v;
        int ret = 0;
        do {
            if ((v = in.read()) == -1) {
                throw new EOFException();
            }
            ret = ret << 7 | v & 0x7F;
        } while ((v & 0x80) == 0);
        return ret;
    }

    public static long unpackLong(InputStream in) throws IOException {
        int v;
        long ret = 0L;
        do {
            if ((v = in.read()) == -1) {
                throw new EOFException();
            }
            ret = ret << 7 | (long)(v & 0x7F);
        } while ((v & 0x80) == 0);
        return ret;
    }

    public static void packLong(DataOutput out, long value) throws IOException {
        int shift = 63 - Long.numberOfLeadingZeros(value);
        shift -= shift % 7;
        while (shift != 0) {
            out.writeByte((byte)(value >>> shift & 0x7FL));
            shift -= 7;
        }
        out.writeByte((byte)(value & 0x7FL | 0x80L));
    }

    public static void packLong(OutputStream out, long value) throws IOException {
        int shift = 63 - Long.numberOfLeadingZeros(value);
        shift -= shift % 7;
        while (shift != 0) {
            out.write((int)(value >>> shift & 0x7FL));
            shift -= 7;
        }
        out.write((int)(value & 0x7FL | 0x80L));
    }

    public static int packLongSize(long value) {
        int shift = 63 - Long.numberOfLeadingZeros(value);
        shift -= shift % 7;
        int ret = 1;
        while (shift != 0) {
            shift -= 7;
            ++ret;
        }
        return ret;
    }

    public static long unpackRecid(DataInput2 in) throws IOException {
        long val = in.unpackLong();
        val = DataIO.parity1Get(val);
        return val >>> 1;
    }

    public static void packRecid(DataOutput2 out, long value) throws IOException {
        value = DataIO.parity1Set(value << 1);
        out.packLong(value);
    }

    public static void packInt(DataOutput out, int value) throws IOException {
        int shift = value & 0xFFFFFF80;
        if (shift != 0) {
            shift = 31 - Integer.numberOfLeadingZeros(value);
            shift -= shift % 7;
            while (shift != 0) {
                out.writeByte((byte)(value >>> shift & 0x7F));
                shift -= 7;
            }
        }
        out.writeByte((byte)(value & 0x7F | 0x80));
    }

    public static void packIntBigger(DataOutput out, int value) throws IOException {
        int shift = 31 - Integer.numberOfLeadingZeros(value);
        shift -= shift % 7;
        while (shift != 0) {
            out.writeByte((byte)(value >>> shift & 0x7F));
            shift -= 7;
        }
        out.writeByte((byte)(value & 0x7F | 0x80));
    }

    public static int longHash(long h) {
        h *= -7046029254386353131L;
        h ^= h >> 32;
        return (int)(h ^ h >> 16);
    }

    public static int intHash(int h) {
        return (h *= -1640531527) ^ h >> 16;
    }

    public static int getInt(byte[] buf, int pos) {
        return buf[pos++] << 24 | (buf[pos++] & 0xFF) << 16 | (buf[pos++] & 0xFF) << 8 | buf[pos] & 0xFF;
    }

    public static void putInt(byte[] buf, int pos, int v) {
        buf[pos++] = (byte)(0xFF & v >> 24);
        buf[pos++] = (byte)(0xFF & v >> 16);
        buf[pos++] = (byte)(0xFF & v >> 8);
        buf[pos] = (byte)(0xFF & v);
    }

    public static long getLong(byte[] buf, int pos) {
        return (long)buf[pos++] << 56 | ((long)buf[pos++] & 0xFFL) << 48 | ((long)buf[pos++] & 0xFFL) << 40 | ((long)buf[pos++] & 0xFFL) << 32 | ((long)buf[pos++] & 0xFFL) << 24 | ((long)buf[pos++] & 0xFFL) << 16 | ((long)buf[pos++] & 0xFFL) << 8 | (long)buf[pos] & 0xFFL;
    }

    public static void putLong(byte[] buf, int pos, long v) {
        buf[pos++] = (byte)(0xFFL & v >> 56);
        buf[pos++] = (byte)(0xFFL & v >> 48);
        buf[pos++] = (byte)(0xFFL & v >> 40);
        buf[pos++] = (byte)(0xFFL & v >> 32);
        buf[pos++] = (byte)(0xFFL & v >> 24);
        buf[pos++] = (byte)(0xFFL & v >> 16);
        buf[pos++] = (byte)(0xFFL & v >> 8);
        buf[pos] = (byte)(0xFFL & v);
    }

    public static void putLong(byte[] buf, int pos, long v, int vSize) {
        for (int i = vSize - 1; i >= 0; --i) {
            buf[i + pos] = (byte)(0xFFL & v);
            v >>>= 8;
        }
    }

    public static int packInt(byte[] buf, int pos, int value) {
        int pos2 = pos;
        int shift = 31 - Integer.numberOfLeadingZeros(value);
        shift -= shift % 7;
        while (shift != 0) {
            buf[pos++] = (byte)(value >>> shift & 0x7F);
            shift -= 7;
        }
        buf[pos++] = (byte)(value & 0x7F | 0x80);
        return pos - pos2;
    }

    public static int packLong(byte[] buf, int pos, long value) {
        int pos2 = pos;
        int shift = 63 - Long.numberOfLeadingZeros(value);
        shift -= shift % 7;
        while (shift != 0) {
            buf[pos++] = (byte)(value >>> shift & 0x7FL);
            shift -= 7;
        }
        buf[pos++] = (byte)(value & 0x7FL | 0x80L);
        return pos - pos2;
    }

    public static int unpackInt(byte[] buf, int pos) {
        byte v;
        int ret = 0;
        do {
            v = buf[pos++];
            ret = ret << 7 | v & 0x7F;
        } while ((v & 0x80) == 0);
        return ret;
    }

    public static long unpackLong(byte[] buf, int pos) {
        byte v;
        long ret = 0L;
        do {
            v = buf[pos++];
            ret = ret << 7 | (long)(v & 0x7F);
        } while ((v & 0x80) == 0);
        return ret;
    }

    public static long getSixLong(byte[] buf, int pos) {
        return (long)(buf[pos++] & 0xFF) << 40 | (long)(buf[pos++] & 0xFF) << 32 | (long)(buf[pos++] & 0xFF) << 24 | (long)(buf[pos++] & 0xFF) << 16 | (long)(buf[pos++] & 0xFF) << 8 | (long)(buf[pos] & 0xFF);
    }

    public static void putSixLong(byte[] buf, int pos, long value) {
        if (value >>> 48 != 0L) {
            throw new AssertionError();
        }
        buf[pos++] = (byte)(0xFFL & value >> 40);
        buf[pos++] = (byte)(0xFFL & value >> 32);
        buf[pos++] = (byte)(0xFFL & value >> 24);
        buf[pos++] = (byte)(0xFFL & value >> 16);
        buf[pos++] = (byte)(0xFFL & value >> 8);
        buf[pos] = (byte)(0xFFL & value);
    }

    public static long nextPowTwo(long a) {
        return 1L << 64 - Long.numberOfLeadingZeros(a - 1L);
    }

    public static int nextPowTwo(int a) {
        return 1 << 32 - Integer.numberOfLeadingZeros(a - 1);
    }

    public static void readFully(InputStream in, byte[] data, int offset, int len) throws IOException {
        len += offset;
        while (offset < len) {
            int c = in.read(data, offset, len - offset);
            if (c < 0) {
                throw new EOFException();
            }
            offset += c;
        }
    }

    public static void readFully(InputStream in, byte[] data) throws IOException {
        DataIO.readFully(in, data, 0, data.length);
    }

    public static void writeFully(FileChannel f, ByteBuffer buf) throws IOException {
        for (int rem = buf.remaining(); rem > 0; rem -= f.write(buf)) {
        }
    }

    public static void skipFully(InputStream in, long length) throws IOException {
        while ((length -= in.skip(length)) > 0L) {
        }
    }

    public static long fillLowBits(int bitCount) {
        long ret = 0L;
        while (bitCount > 0) {
            ret = ret << 1 | 1L;
            --bitCount;
        }
        return ret;
    }

    public static long parity1Set(long i) {
        if ((i & 1L) != 0L) {
            throw new DBException.PointerChecksumBroken();
        }
        return i | (long)((Long.bitCount(i) + 1) % 2);
    }

    public static int parity1Set(int i) {
        if ((i & 1) != 0) {
            throw new DBException.PointerChecksumBroken();
        }
        return i | (Integer.bitCount(i) + 1) % 2;
    }

    public static long parity1Get(long i) {
        if (Long.bitCount(i) % 2 != 1) {
            throw new DBException.PointerChecksumBroken();
        }
        return i & 0xFFFFFFFFFFFFFFFEL;
    }

    public static int parity1Get(int i) {
        if (Integer.bitCount(i) % 2 != 1) {
            throw new DBException.PointerChecksumBroken();
        }
        return i & 0xFFFFFFFE;
    }

    public static long parity3Set(long i) {
        if ((i & 7L) != 0L) {
            throw new DBException.PointerChecksumBroken();
        }
        return i | (long)((Long.bitCount(i) + 1) % 8);
    }

    public static long parity3Get(long i) {
        long ret = i & 0xFFFFFFFFFFFFFFF8L;
        if ((long)((Long.bitCount(ret) + 1) % 8) != (i & 7L)) {
            throw new DBException.PointerChecksumBroken();
        }
        return ret;
    }

    public static long parity4Set(long i) {
        if ((i & 0xFL) != 0L) {
            throw new DBException.PointerChecksumBroken();
        }
        return i | (long)((Long.bitCount(i) + 1) % 16);
    }

    public static long parity4Get(long i) {
        long ret = i & 0xFFFFFFFFFFFFFFF0L;
        if ((long)((Long.bitCount(ret) + 1) % 16) != (i & 0xFL)) {
            throw new DBException.PointerChecksumBroken();
        }
        return ret;
    }

    public static long parity16Set(long i) {
        if ((i & 0xFFFFL) != 0L) {
            throw new DBException.PointerChecksumBroken();
        }
        return i | (long)DataIO.longHash(i + 1L) & 0xFFFFL;
    }

    public static long parity16Get(long i) {
        long ret = i & 0xFFFFFFFFFFFF0000L;
        if (((long)DataIO.longHash(ret + 1L) & 0xFFFFL) != (i & 0xFFFFL)) {
            throw new DBException.PointerChecksumBroken();
        }
        return ret;
    }

    public static String toHexa(byte[] bb) {
        char[] HEXA_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] ret = new char[bb.length * 2];
        for (int i = 0; i < bb.length; ++i) {
            ret[i * 2] = HEXA_CHARS[(bb[i] & 0xF0) >> 4];
            ret[i * 2 + 1] = HEXA_CHARS[bb[i] & 0xF];
        }
        return new String(ret);
    }

    public static byte[] fromHexa(String s) {
        byte[] ret = new byte[s.length() / 2];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (byte)Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16);
        }
        return ret;
    }

    public static Object[] arrayPut(Object[] array, int pos, Object value) {
        Object[] ret = Arrays.copyOf(array, array.length + 1);
        if (pos < array.length) {
            System.arraycopy(array, pos, ret, pos + 1, array.length - pos);
        }
        ret[pos] = value;
        return ret;
    }

    public static Object[] arrayDelete(Object[] vals, int pos, int len) {
        Object[] vals2 = new Object[vals.length - len];
        System.arraycopy(vals, 0, vals2, 0, pos - len);
        System.arraycopy(vals, pos, vals2, pos - len, vals2.length - (pos - len));
        return vals2;
    }

    public static long[] arrayDelete(long[] vals, int pos, int len) {
        long[] vals2 = new long[vals.length - len];
        System.arraycopy(vals, 0, vals2, 0, pos - len);
        System.arraycopy(vals, pos, vals2, pos - len, vals2.length - (pos - len));
        return vals2;
    }

    public static long intToLong(int i) {
        return (long)i & 0xFFFFFFFFL;
    }

    public static long roundUp(long number, long roundUpToMultipleOf) {
        return (number + roundUpToMultipleOf - 1L) / roundUpToMultipleOf * roundUpToMultipleOf;
    }

    public static long roundDown(long number, long roundDownToMultipleOf) {
        return number - number % roundDownToMultipleOf;
    }

    public static int roundUp(int number, int roundUpToMultipleOf) {
        return (number + roundUpToMultipleOf - 1) / roundUpToMultipleOf * roundUpToMultipleOf;
    }

    public static int roundDown(int number, int roundDownToMultipleOf) {
        return number - number % roundDownToMultipleOf;
    }

    public static int shift(int value) {
        return 31 - Integer.numberOfLeadingZeros(value);
    }

    static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().startsWith("windows");
    }

    static boolean JVMSupportsLargeMappedFiles() {
        String arch = System.getProperty("os.arch");
        if (arch == null || !arch.contains("64")) {
            return false;
        }
        return !DataIO.isWindows();
    }
}

