/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.optimizer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.And;
import org.eclipse.rdf4j.query.algebra.BinaryValueOperator;
import org.eclipse.rdf4j.query.algebra.Bound;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.FunctionCall;
import org.eclipse.rdf4j.query.algebra.If;
import org.eclipse.rdf4j.query.algebra.Or;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElemList;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.Regex;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.UnaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.UnaryValueOperator;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.function.FunctionRegistry;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractSimpleQueryModelVisitor;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstantOptimizer
implements QueryOptimizer {
    private static final Logger logger = LoggerFactory.getLogger(ConstantOptimizer.class);
    private final EvaluationStrategy strategy;

    public ConstantOptimizer(EvaluationStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        ConstantVisitor visitor = new ConstantVisitor(this.strategy, new QueryEvaluationContext.Minimal((Dataset)new SimpleDataset()));
        tupleExpr.visit((QueryModelVisitor)visitor);
        Set varsBefore = visitor.varNames;
        VarNameCollector varCollector = new VarNameCollector();
        tupleExpr.visit((QueryModelVisitor)varCollector);
        Set<String> varsAfter = varCollector.varNames;
        if (varsAfter.size() < varsBefore.size()) {
            varsBefore.removeAll(varsAfter);
            for (ProjectionElemList projElems : visitor.projElemLists) {
                for (ProjectionElem projElem : projElems.getElements()) {
                    String name = projElem.getName();
                    if (!varsBefore.contains(name)) continue;
                    UnaryTupleOperator proj = (UnaryTupleOperator)projElems.getParentNode();
                    Extension ext = new Extension(proj.getArg());
                    proj.setArg((TupleExpr)ext);
                    Value value = bindings.getValue(name);
                    Var lostVar = value == null ? new Var(name) : new Var(name, value);
                    ext.addElement(new ExtensionElem((ValueExpr)lostVar, name));
                }
            }
        }
    }

    private static class VarNameCollector
    extends AbstractSimpleQueryModelVisitor<RuntimeException> {
        final Set<String> varNames = new HashSet<String>();

        protected VarNameCollector() {
            super(true);
        }

        public void meet(Var var) {
            if (!var.isAnonymous()) {
                this.varNames.add(var.getName());
            }
        }
    }

    private static class ConstantVisitor
    extends VarNameCollector {
        private final EvaluationStrategy strategy;
        private final QueryEvaluationContext context;
        List<ProjectionElemList> projElemLists = Collections.emptyList();

        public ConstantVisitor(EvaluationStrategy strategy, QueryEvaluationContext context) {
            this.strategy = strategy;
            this.context = context;
        }

        public void meet(ProjectionElemList projElems) {
            super.meet(projElems);
            if (this.projElemLists.isEmpty()) {
                this.projElemLists = Collections.singletonList(projElems);
            } else {
                if (this.projElemLists.size() == 1) {
                    this.projElemLists = new ArrayList<ProjectionElemList>(this.projElemLists);
                }
                this.projElemLists.add(projElems);
            }
        }

        public void meet(Or or) {
            or.visitChildren((QueryModelVisitor)this);
            try {
                if (this.isConstant(or.getLeftArg()) && this.isConstant(or.getRightArg())) {
                    boolean value = this.strategy.isTrue((ValueExpr)or, EmptyBindingSet.getInstance());
                    or.replaceWith((QueryModelNode)new ValueConstant((Value)BooleanLiteral.valueOf((boolean)value)));
                } else if (this.isConstant(or.getLeftArg())) {
                    boolean leftIsTrue = this.strategy.isTrue(or.getLeftArg(), EmptyBindingSet.getInstance());
                    if (leftIsTrue) {
                        or.replaceWith((QueryModelNode)new ValueConstant((Value)BooleanLiteral.TRUE));
                    } else {
                        or.replaceWith((QueryModelNode)or.getRightArg().clone());
                    }
                } else if (this.isConstant(or.getRightArg())) {
                    boolean rightIsTrue = this.strategy.isTrue(or.getRightArg(), EmptyBindingSet.getInstance());
                    if (rightIsTrue) {
                        or.replaceWith((QueryModelNode)new ValueConstant((Value)BooleanLiteral.TRUE));
                    } else {
                        or.replaceWith((QueryModelNode)or.getLeftArg().clone());
                    }
                }
            }
            catch (ValueExprEvaluationException e) {
                logger.debug("Failed to evaluate BinaryValueOperator with two constant arguments", (Throwable)((Object)e));
            }
            catch (QueryEvaluationException e) {
                logger.error("Query evaluation exception caught", (Throwable)e);
            }
        }

        public void meet(And and) {
            and.visitChildren((QueryModelVisitor)this);
            try {
                if (this.isConstant(and.getLeftArg()) && this.isConstant(and.getRightArg())) {
                    boolean value = this.strategy.isTrue((ValueExpr)and, EmptyBindingSet.getInstance());
                    and.replaceWith((QueryModelNode)new ValueConstant((Value)BooleanLiteral.valueOf((boolean)value)));
                } else if (this.isConstant(and.getLeftArg())) {
                    boolean leftIsTrue = this.strategy.isTrue(and.getLeftArg(), EmptyBindingSet.getInstance());
                    if (leftIsTrue) {
                        and.replaceWith((QueryModelNode)and.getRightArg().clone());
                    } else {
                        and.replaceWith((QueryModelNode)new ValueConstant((Value)BooleanLiteral.FALSE));
                    }
                } else if (this.isConstant(and.getRightArg())) {
                    boolean rightIsTrue = this.strategy.isTrue(and.getRightArg(), EmptyBindingSet.getInstance());
                    if (rightIsTrue) {
                        and.replaceWith((QueryModelNode)and.getLeftArg().clone());
                    } else {
                        and.replaceWith((QueryModelNode)new ValueConstant((Value)BooleanLiteral.FALSE));
                    }
                }
            }
            catch (ValueExprEvaluationException e) {
                logger.debug("Failed to evaluate BinaryValueOperator with two constant arguments", (Throwable)((Object)e));
            }
            catch (QueryEvaluationException e) {
                logger.error("Query evaluation exception caught", (Throwable)e);
            }
        }

        protected void meetBinaryValueOperator(BinaryValueOperator binaryValueOp) {
            super.meetBinaryValueOperator(binaryValueOp);
            if (this.isConstant(binaryValueOp.getLeftArg()) && this.isConstant(binaryValueOp.getRightArg())) {
                try {
                    Value value = this.strategy.precompile((ValueExpr)binaryValueOp, this.context).evaluate(EmptyBindingSet.getInstance());
                    binaryValueOp.replaceWith((QueryModelNode)new ValueConstant(value));
                }
                catch (ValueExprEvaluationException e) {
                    logger.debug("Failed to evaluate BinaryValueOperator with two constant arguments", (Throwable)((Object)e));
                }
                catch (QueryEvaluationException e) {
                    logger.error("Query evaluation exception caught", (Throwable)e);
                }
            }
        }

        protected void meetUnaryValueOperator(UnaryValueOperator unaryValueOp) {
            super.meetUnaryValueOperator(unaryValueOp);
            if (this.isConstant(unaryValueOp.getArg())) {
                try {
                    Value value = this.strategy.precompile((ValueExpr)unaryValueOp, this.context).evaluate(EmptyBindingSet.getInstance());
                    unaryValueOp.replaceWith((QueryModelNode)new ValueConstant(value));
                }
                catch (ValueExprEvaluationException e) {
                    logger.debug("Failed to evaluate UnaryValueOperator with a constant argument", (Throwable)((Object)e));
                }
                catch (QueryEvaluationException e) {
                    logger.error("Query evaluation exception caught", (Throwable)e);
                }
            }
        }

        public void meet(FunctionCall functionCall) {
            super.meet(functionCall);
            List args = functionCall.getArgs();
            if (args.isEmpty()) {
                if (!this.isConstantZeroArgFunction(functionCall)) {
                    return;
                }
            } else {
                for (ValueExpr arg : args) {
                    if (this.isConstant(arg)) continue;
                    return;
                }
            }
            try {
                Value value = this.strategy.precompile((ValueExpr)functionCall, this.context).evaluate(EmptyBindingSet.getInstance());
                functionCall.replaceWith((QueryModelNode)new ValueConstant(value));
            }
            catch (ValueExprEvaluationException e) {
                logger.debug("Failed to evaluate BinaryValueOperator with two constant arguments", (Throwable)((Object)e));
            }
            catch (QueryEvaluationException e) {
                logger.error("Query evaluation exception caught", (Throwable)e);
            }
        }

        private boolean isConstantZeroArgFunction(FunctionCall functionCall) {
            Function function = (Function)FunctionRegistry.getInstance().get(functionCall.getURI()).orElseThrow(() -> new QueryEvaluationException("Unable to find function with the URI: " + functionCall.getURI()));
            return !function.mustReturnDifferentResult();
        }

        public void meet(Bound bound) {
            super.meet(bound);
            if (bound.getArg().hasValue()) {
                bound.replaceWith((QueryModelNode)new ValueConstant((Value)BooleanLiteral.TRUE));
            }
        }

        public void meet(If node) {
            super.meet(node);
            if (this.isConstant(node.getCondition())) {
                try {
                    if (this.strategy.isTrue(node.getCondition(), EmptyBindingSet.getInstance())) {
                        node.replaceWith((QueryModelNode)node.getResult());
                    } else {
                        node.replaceWith((QueryModelNode)node.getAlternative().clone());
                    }
                }
                catch (ValueExprEvaluationException e) {
                    logger.debug("Failed to evaluate UnaryValueOperator with a constant argument", (Throwable)((Object)e));
                }
                catch (QueryEvaluationException e) {
                    logger.error("Query evaluation exception caught", (Throwable)e);
                }
            }
        }

        public void meet(Regex node) {
            super.meet(node);
            if (this.isConstant(node.getArg()) && this.isConstant(node.getPatternArg()) && this.isConstant(node.getFlagsArg())) {
                try {
                    Value value = this.strategy.precompile((ValueExpr)node, this.context).evaluate(EmptyBindingSet.getInstance());
                    node.replaceWith((QueryModelNode)new ValueConstant(value));
                }
                catch (ValueExprEvaluationException e) {
                    logger.debug("Failed to evaluate BinaryValueOperator with two constant arguments", (Throwable)((Object)e));
                }
                catch (QueryEvaluationException e) {
                    logger.error("Query evaluation exception caught", (Throwable)e);
                }
            }
        }

        private boolean isConstant(ValueExpr expr) {
            return expr instanceof ValueConstant || expr instanceof Var && ((Var)expr).hasValue();
        }
    }
}

