/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.webapp.system;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.common.app.AppConfiguration;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class SystemInfoController
implements Controller {
    private String view;
    private AppConfiguration config;
    private final ServerInfo server = new ServerInfo();

    public String getView() {
        return this.view;
    }

    public void setView(String view) {
        this.view = view;
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView result = new ModelAndView();
        result.setViewName(this.view);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("appConfig", this.config);
        model.put("server", this.server);
        model.put("memory", new MemoryInfo());
        model.put("javaProps", this.getJavaPropStrings());
        model.put("envVars", this.getEnvVarStrings());
        result.addAllObjects(model);
        return result;
    }

    public AppConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(AppConfiguration config) {
        this.config = config;
    }

    private Map getJavaPropStrings() {
        Properties sysProps = System.getProperties();
        ArrayList<Object> keyList = new ArrayList<Object>(sysProps.keySet());
        Collections.sort(keyList);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(keyList.size());
        for (String string : keyList) {
            if (string.startsWith("aduna")) continue;
            result.put(string, sysProps.get(string));
        }
        return result;
    }

    private Map getEnvVarStrings() {
        Map<String, String> envProps = System.getenv();
        ArrayList<String> keyList = new ArrayList<String>(envProps.keySet());
        Collections.sort(keyList);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(keyList.size());
        for (String name : keyList) {
            result.put(name, envProps.get(name));
        }
        return result;
    }

    public static class MemoryInfo {
        private final int maximum;
        private final int used;
        private final float percentageInUse;

        public MemoryInfo() {
            Runtime runtime = Runtime.getRuntime();
            long usedMemory = runtime.totalMemory() - runtime.freeMemory();
            long maxMemory = runtime.maxMemory();
            this.percentageInUse = (float)usedMemory / (float)maxMemory;
            this.used = (int)(usedMemory / 1024L / 1024L);
            this.maximum = (int)(maxMemory / 1024L / 1024L);
        }

        public int getMaximum() {
            return this.maximum;
        }

        public int getUsed() {
            return this.used;
        }

        public float getPercentageInUse() {
            return this.percentageInUse;
        }
    }

    public static class ServerInfo {
        private final String os = System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")";
        private final String java = System.getProperty("java.vendor") + " " + System.getProperty("java.vm.name") + " " + System.getProperty("java.version");
        private final String user = System.getProperty("user.name");

        public String getOs() {
            return this.os;
        }

        public String getJava() {
            return this.java;
        }

        public String getUser() {
            return this.user;
        }
    }
}

