/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.util.Objects;
import java.util.function.Function;

public interface Cache<K, V> {
    public V put(K var1, V var2);

    public V get(K var1);

    public V remove(K var1);

    public void clear();

    default public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        V newValue;
        Objects.requireNonNull(mappingFunction);
        V v = this.get(key);
        if (v == null && (newValue = mappingFunction.apply(key)) != null) {
            this.put(key, newValue);
            return newValue;
        }
        return v;
    }
}

