/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.sparql;

import java.net.URISyntaxException;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.common.net.ParsedIRI;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.parser.sparql.AbstractASTVisitor;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTBaseDecl;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTDeleteData;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTIRI;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTIRIFunc;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTInsertData;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTOperationContainer;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTServiceGraphPattern;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTUnparsedQuadDataBlock;
import org.eclipse.rdf4j.query.parser.sparql.ast.VisitorException;

@InternalUseOnly
public class BaseDeclProcessor {
    public static void process(ASTOperationContainer qc, String externalBaseURI) throws MalformedQueryException {
        ParsedIRI parsedBaseURI = null;
        ASTBaseDecl baseDecl = qc.getBaseDecl();
        if (baseDecl != null) {
            try {
                parsedBaseURI = new ParsedIRI(baseDecl.getIRI());
            }
            catch (URISyntaxException e) {
                throw new MalformedQueryException(e);
            }
            if (!parsedBaseURI.isAbsolute()) {
                throw new MalformedQueryException("BASE IRI is not an absolute IRI: " + externalBaseURI);
            }
        } else if (externalBaseURI != null) {
            try {
                parsedBaseURI = new ParsedIRI(externalBaseURI);
            }
            catch (URISyntaxException e) {
                throw new MalformedQueryException(e);
            }
            if (!parsedBaseURI.isAbsolute()) {
                throw new IllegalArgumentException("Supplied base URI is not an absolute IRI: " + externalBaseURI);
            }
        }
        if (parsedBaseURI != null) {
            ASTUnparsedQuadDataBlock dataBlock = null;
            if (qc.getOperation() instanceof ASTInsertData) {
                ASTInsertData insertData = (ASTInsertData)qc.getOperation();
                dataBlock = insertData.jjtGetChild(ASTUnparsedQuadDataBlock.class);
            } else if (qc.getOperation() instanceof ASTDeleteData) {
                ASTDeleteData deleteData = (ASTDeleteData)qc.getOperation();
                dataBlock = deleteData.jjtGetChild(ASTUnparsedQuadDataBlock.class);
            }
            if (dataBlock != null) {
                String baseURIDeclaration = "BASE <" + parsedBaseURI + "> \n";
                dataBlock.setDataBlock(baseURIDeclaration + dataBlock.getDataBlock());
            } else {
                RelativeIRIResolver visitor = new RelativeIRIResolver(parsedBaseURI);
                try {
                    qc.jjtAccept(visitor, null);
                }
                catch (VisitorException e) {
                    throw new MalformedQueryException(e);
                }
            }
        }
    }

    private static class RelativeIRIResolver
    extends AbstractASTVisitor {
        private final ParsedIRI parsedBaseURI;

        public RelativeIRIResolver(ParsedIRI parsedBaseURI) {
            this.parsedBaseURI = parsedBaseURI;
        }

        @Override
        public Object visit(ASTIRI node, Object data) throws VisitorException {
            node.setValue(this.parsedBaseURI.resolve(node.getValue()));
            return super.visit(node, data);
        }

        @Override
        public Object visit(ASTIRIFunc node, Object data) throws VisitorException {
            node.setBaseURI(this.parsedBaseURI.toString());
            return super.visit(node, data);
        }

        @Override
        public Object visit(ASTServiceGraphPattern node, Object data) throws VisitorException {
            node.setBaseURI(this.parsedBaseURI.toString());
            return super.visit(node, data);
        }
    }
}

