/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import java.lang.ref.SoftReference;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.memory.model.MemResource;
import org.eclipse.rdf4j.sail.memory.model.MemStatement;
import org.eclipse.rdf4j.sail.memory.model.MemStatementList;

public class MemIRI
extends MemResource
implements IRI {
    private static final long serialVersionUID = 9118488004995852467L;
    private final String namespace;
    private final String localName;
    private final transient Object creator;
    private volatile int hashCode = 0;
    private final transient MemStatementList predicateStatements = new MemStatementList();
    private final transient MemStatementList objectStatements = new MemStatementList();
    transient SoftReference<String> toStringCache = null;

    public MemIRI(Object creator, String namespace, String localName) {
        this.creator = creator;
        this.namespace = namespace;
        this.localName = localName;
    }

    public String toString() {
        Object result;
        if (this.toStringCache == null) {
            result = this.namespace + this.localName;
            this.toStringCache = new SoftReference<Object>(result);
        } else {
            result = this.toStringCache.get();
            if (result == null) {
                result = this.namespace + this.localName;
                this.toStringCache = new SoftReference<Object>(result);
            }
        }
        return result;
    }

    public String stringValue() {
        return this.toString();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getLocalName() {
        return this.localName;
    }

    public boolean equals(Object o) {
        Value oValue;
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() == MemIRI.class) {
            MemIRI oMemIRI = (MemIRI)o;
            if (oMemIRI.creator == this.creator) {
                return false;
            }
            return this.namespace.length() == oMemIRI.namespace.length() && this.localName.length() == oMemIRI.localName.length() && this.namespace.equals(oMemIRI.namespace) && this.localName.equals(oMemIRI.localName);
        }
        if (o instanceof Value && (oValue = (Value)o).isIRI()) {
            String stringValue;
            String oStr = oValue.stringValue();
            if (this.toStringCache != null && (stringValue = this.toStringCache.get()) != null) {
                return stringValue.equals(oStr);
            }
            return this.namespace.length() + this.localName.length() == oStr.length() && oStr.endsWith(this.localName) && oStr.startsWith(this.namespace);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.stringValue().hashCode();
        }
        return this.hashCode;
    }

    @Override
    public Object getCreator() {
        return this.creator;
    }

    @Override
    public boolean hasStatements() {
        return !this.subjectStatements.isEmpty() || !this.predicateStatements.isEmpty() || !this.objectStatements.isEmpty() || !this.contextStatements.isEmpty();
    }

    public MemStatementList getPredicateStatementList() {
        return this.predicateStatements;
    }

    public int getPredicateStatementCount() {
        return this.predicateStatements.size();
    }

    public void addPredicateStatement(MemStatement st) throws InterruptedException {
        this.predicateStatements.add(st);
    }

    public void cleanSnapshotsFromPredicateStatements(int currentSnapshot) throws InterruptedException {
        this.predicateStatements.cleanSnapshots(currentSnapshot);
    }

    @Override
    public MemStatementList getObjectStatementList() {
        return this.objectStatements;
    }

    @Override
    public int getObjectStatementCount() {
        return this.objectStatements.size();
    }

    @Override
    public void addObjectStatement(MemStatement st) throws InterruptedException {
        this.objectStatements.add(st);
    }

    @Override
    public void cleanSnapshotsFromObjectStatements(int currentSnapshot) throws InterruptedException {
        this.objectStatements.cleanSnapshots(currentSnapshot);
    }

    @Override
    public boolean hasPredicateStatements() {
        return !this.predicateStatements.isEmpty();
    }

    @Override
    public boolean hasObjectStatements() {
        return !this.objectStatements.isEmpty();
    }
}

