/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.processor;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.net.URI;
import no.hasmac.jsonld.JsonLdError;
import no.hasmac.jsonld.JsonLdErrorCode;
import no.hasmac.jsonld.JsonLdOptions;
import no.hasmac.jsonld.compaction.Compaction;
import no.hasmac.jsonld.context.ActiveContext;
import no.hasmac.jsonld.document.Document;
import no.hasmac.jsonld.json.JsonProvider;
import no.hasmac.jsonld.json.JsonUtils;
import no.hasmac.jsonld.loader.DocumentLoaderOptions;
import no.hasmac.jsonld.processor.ExpansionProcessor;

public final class CompactionProcessor {
    private CompactionProcessor() {
    }

    public static JsonObject compact(URI input, URI context, JsonLdOptions options) throws JsonLdError {
        if (options.getDocumentLoader() == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Document loader is null. Cannot fetch [" + String.valueOf(context) + "].");
        }
        Document contextDocument = options.getDocumentLoader().loadDocument(context, new DocumentLoaderOptions());
        if (contextDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.INVALID_REMOTE_CONTEXT, "Context[" + String.valueOf(context) + "] is null.");
        }
        return CompactionProcessor.compact(input, contextDocument, options);
    }

    public static JsonObject compact(URI input, Document context, JsonLdOptions options) throws JsonLdError {
        if (options.getDocumentLoader() == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Document loader is null. Cannot fetch [" + String.valueOf(input) + "].");
        }
        DocumentLoaderOptions loaderOptions = new DocumentLoaderOptions();
        loaderOptions.setExtractAllScripts(options.isExtractAllScripts());
        Document remoteDocument = options.getDocumentLoader().loadDocument(input, loaderOptions);
        if (remoteDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Returned document is null [" + String.valueOf(input) + "].");
        }
        return CompactionProcessor.compact(remoteDocument, context, options);
    }

    public static JsonObject compact(Document input, URI context, JsonLdOptions options) throws JsonLdError {
        if (options.getDocumentLoader() == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Document loader is null. Cannot fetch [" + String.valueOf(context) + "].");
        }
        Document contextDocument = options.getDocumentLoader().loadDocument(context, new DocumentLoaderOptions());
        if (contextDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.INVALID_REMOTE_CONTEXT, "Returned context is null [" + String.valueOf(context) + "] is null.");
        }
        return CompactionProcessor.compact(input, contextDocument, options);
    }

    public static JsonObject compact(Document input, Document context, JsonLdOptions options) throws JsonLdError {
        JsonValue compactedOutput;
        JsonLdOptions expansionOptions = new JsonLdOptions(options);
        expansionOptions.setOrdered(false);
        expansionOptions.setExtractAllScripts(false);
        JsonArray expandedInput = ExpansionProcessor.expand(input, expansionOptions, false);
        URI contextBase = input.getDocumentUrl();
        if (contextBase == null) {
            contextBase = options.getBase();
        }
        JsonValue contextValue = context.getJsonContent().map(ctx -> JsonUtils.flatten((JsonValue)ctx, "@context")).orElse((JsonValue)JsonValue.EMPTY_JSON_OBJECT);
        ActiveContext activeContext = new ActiveContext(options).newContext().create(contextValue, contextBase);
        if (activeContext.getBaseUri() == null) {
            if (options.getBase() != null) {
                activeContext.setBaseUri(options.getBase());
            } else if (options.isCompactToRelative()) {
                activeContext.setBaseUri(input.getDocumentUrl());
            }
        }
        if (JsonUtils.isEmptyArray(compactedOutput = Compaction.with(activeContext).compactArrays(options.isCompactArrays()).ordered(options.isOrdered()).compact((JsonValue)expandedInput))) {
            compactedOutput = JsonValue.EMPTY_JSON_OBJECT;
        } else if (JsonUtils.isArray(compactedOutput)) {
            compactedOutput = JsonProvider.instance().createObjectBuilder().add(activeContext.uriCompaction().vocab(true).compact("@graph"), compactedOutput).build();
        }
        if (JsonUtils.isNull(compactedOutput) || compactedOutput.asJsonObject().isEmpty()) {
            return JsonValue.EMPTY_JSON_OBJECT;
        }
        if (JsonUtils.isNotNull(contextValue) && !JsonUtils.isEmptyArray(contextValue) && !JsonUtils.isEmptyObject(contextValue)) {
            compactedOutput = JsonProvider.instance().createObjectBuilder(compactedOutput.asJsonObject()).add("@context", contextValue).build();
        }
        return compactedOutput.asJsonObject();
    }
}

