/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.StampedLock;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.lmdb.LmdbUtil;
import org.eclipse.rdf4j.sail.lmdb.Pool;
import org.eclipse.rdf4j.sail.lmdb.RecordIterator;
import org.eclipse.rdf4j.sail.lmdb.TripleStore;
import org.eclipse.rdf4j.sail.lmdb.TxnManager;
import org.eclipse.rdf4j.sail.lmdb.Varint;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.lmdb.LMDB;
import org.lwjgl.util.lmdb.MDBVal;

class LmdbRecordIterator
implements RecordIterator {
    private final Pool pool;
    private final TripleStore.TripleIndex index;
    private final long cursor;
    private final MDBVal maxKey;
    private final Varint.GroupMatcher groupMatcher;
    private final TxnManager.Txn txnRef;
    private long txnRefVersion;
    private final long txn;
    private final int dbi;
    private volatile boolean closed = false;
    private final MDBVal keyData;
    private final MDBVal valueData;
    private ByteBuffer minKeyBuf;
    private ByteBuffer maxKeyBuf;
    private int lastResult;
    private final long[] quad = new long[4];
    private boolean fetchNext = false;
    private final StampedLock txnLock;
    private final Thread ownerThread = Thread.currentThread();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LmdbRecordIterator(Pool pool, TripleStore.TripleIndex index, boolean rangeSearch, long subj, long pred, long obj, long context, boolean explicit, TxnManager.Txn txnRef) throws IOException {
        this.pool = pool;
        this.keyData = pool.getVal();
        this.valueData = pool.getVal();
        this.index = index;
        if (rangeSearch) {
            this.minKeyBuf = pool.getKeyBuffer();
            index.getMinKey(this.minKeyBuf, subj, pred, obj, context);
            this.minKeyBuf.flip();
            this.maxKey = pool.getVal();
            this.maxKeyBuf = pool.getKeyBuffer();
            index.getMaxKey(this.maxKeyBuf, subj, pred, obj, context);
            this.maxKeyBuf.flip();
            this.maxKey.mv_data(this.maxKeyBuf);
        } else {
            this.minKeyBuf = null;
            this.maxKey = null;
        }
        boolean matchValues = subj > 0L || pred > 0L || obj > 0L || context >= 0L;
        this.groupMatcher = matchValues ? index.createMatcher(subj, pred, obj, context) : null;
        this.dbi = index.getDB(explicit);
        this.txnRef = txnRef;
        this.txnLock = txnRef.lock();
        long stamp = this.txnLock.readLock();
        try {
            this.txnRefVersion = txnRef.version();
            this.txn = txnRef.get();
            try (MemoryStack stack = MemoryStack.stackPush();){
                PointerBuffer pp = stack.mallocPointer(1);
                LmdbUtil.E(LMDB.mdb_cursor_open((long)this.txn, (int)this.dbi, (PointerBuffer)pp));
                this.cursor = pp.get(0);
            }
        }
        finally {
            this.txnLock.unlockRead(stamp);
        }
    }

    @Override
    public long[] next() {
        long stamp = this.txnLock.readLock();
        try {
            if (this.txnRefVersion != this.txnRef.version()) {
                LMDB.mdb_cursor_renew((long)this.txn, (long)this.cursor);
                if (this.fetchNext) {
                    if (this.minKeyBuf == null) {
                        this.minKeyBuf = this.pool.getKeyBuffer();
                    }
                    this.minKeyBuf.clear();
                    this.index.toKey(this.minKeyBuf, this.quad[0], this.quad[1], this.quad[2], this.quad[3]);
                    this.minKeyBuf.flip();
                    this.keyData.mv_data(this.minKeyBuf);
                    this.lastResult = LmdbUtil.E(LMDB.mdb_cursor_get((long)this.cursor, (MDBVal)this.keyData, (MDBVal)this.valueData, (int)15));
                    if (this.lastResult != 0) {
                        this.lastResult = LmdbUtil.E(LMDB.mdb_cursor_get((long)this.cursor, (MDBVal)this.keyData, (MDBVal)this.valueData, (int)17));
                    }
                    if (this.lastResult != 0) {
                        this.closeInternal(false);
                        long[] lArray = null;
                        return lArray;
                    }
                }
                this.txnRefVersion = this.txnRef.version();
            }
            if (this.fetchNext) {
                this.lastResult = LmdbUtil.E(LMDB.mdb_cursor_get((long)this.cursor, (MDBVal)this.keyData, (MDBVal)this.valueData, (int)8));
                this.fetchNext = false;
            } else if (this.minKeyBuf != null) {
                this.keyData.mv_data(this.minKeyBuf);
                this.lastResult = LmdbUtil.E(LMDB.mdb_cursor_get((long)this.cursor, (MDBVal)this.keyData, (MDBVal)this.valueData, (int)17));
            } else {
                this.lastResult = LmdbUtil.E(LMDB.mdb_cursor_get((long)this.cursor, (MDBVal)this.keyData, (MDBVal)this.valueData, (int)8));
            }
            while (this.lastResult == 0) {
                if (this.maxKey != null && LMDB.mdb_cmp((long)this.txn, (int)this.dbi, (MDBVal)this.keyData, (MDBVal)this.maxKey) > 0) {
                    this.lastResult = -30798;
                    continue;
                }
                if (this.groupMatcher != null && !this.groupMatcher.matches(this.keyData.mv_data())) {
                    this.lastResult = LmdbUtil.E(LMDB.mdb_cursor_get((long)this.cursor, (MDBVal)this.keyData, (MDBVal)this.valueData, (int)8));
                    continue;
                }
                this.index.keyToQuad(this.keyData.mv_data(), this.quad);
                this.fetchNext = true;
                long[] lArray = this.quad;
                return lArray;
            }
            this.closeInternal(false);
            long[] lArray = null;
            return lArray;
        }
        catch (IOException e) {
            throw new SailException((Throwable)e);
        }
        finally {
            this.txnLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInternal(boolean maybeCalledAsync) {
        if (!this.closed) {
            long stamp = maybeCalledAsync && this.ownerThread != Thread.currentThread() ? this.txnLock.writeLock() : 0L;
            try {
                if (!this.closed) {
                    LMDB.mdb_cursor_close((long)this.cursor);
                    this.pool.free(this.keyData);
                    this.pool.free(this.valueData);
                    if (this.minKeyBuf != null) {
                        this.pool.free(this.minKeyBuf);
                    }
                    if (this.maxKey != null) {
                        this.pool.free(this.maxKeyBuf);
                        this.pool.free(this.maxKey);
                    }
                }
            }
            finally {
                this.closed = true;
                if (stamp != 0L) {
                    this.txnLock.unlockWrite(stamp);
                }
            }
        }
    }

    @Override
    public void close() {
        this.closeInternal(true);
    }
}

