/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mapdb.DB;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Engine;
import org.mapdb.Fun;
import org.mapdb.Serializer;
import org.mapdb.SerializerBase;

public class SerializerPojo
extends SerializerBase
implements Serializable {
    protected static final Serializer<CopyOnWriteArrayList<ClassInfo>> serializer = new Serializer<CopyOnWriteArrayList<ClassInfo>>(){

        @Override
        public void serialize(DataOutput out, CopyOnWriteArrayList<ClassInfo> obj) throws IOException {
            DataOutput2.packInt(out, obj.size());
            for (ClassInfo ci : obj) {
                out.writeUTF(ci.name);
                out.writeBoolean(ci.isEnum);
                out.writeBoolean(ci.useObjectStream);
                if (ci.useObjectStream) continue;
                DataOutput2.packInt(out, ci.fields.size());
                for (FieldInfo fi : ci.fields) {
                    out.writeUTF(fi.name);
                    out.writeBoolean(fi.primitive);
                    out.writeUTF(fi.type);
                }
            }
        }

        @Override
        public CopyOnWriteArrayList<ClassInfo> deserialize(DataInput in, int available) throws IOException {
            if (available == 0) {
                return new CopyOnWriteArrayList<ClassInfo>();
            }
            int size = DataInput2.unpackInt(in);
            ArrayList<ClassInfo> ret = new ArrayList<ClassInfo>(size);
            for (int i = 0; i < size; ++i) {
                String className = in.readUTF();
                boolean isEnum = in.readBoolean();
                boolean isExternalizable = in.readBoolean();
                int fieldsNum = isExternalizable ? 0 : DataInput2.unpackInt(in);
                FieldInfo[] fields = new FieldInfo[fieldsNum];
                for (int j = 0; j < fieldsNum; ++j) {
                    fields[j] = new FieldInfo(in.readUTF(), in.readBoolean(), in.readUTF(), SerializerPojo.classForName(className));
                }
                ret.add(new ClassInfo(className, fields, isEnum, isExternalizable));
            }
            return new CopyOnWriteArrayList<ClassInfo>(ret);
        }

        @Override
        public int fixedSize() {
            return -1;
        }
    };
    private static final long serialVersionUID = 3181417366609199703L;
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(false);
    protected DB db;
    protected CopyOnWriteArrayList<ClassInfo> registered;
    protected Map<Class<?>, Integer> class2classId = new HashMap();
    protected Map<Integer, Class<?>> classId2class = new HashMap();
    protected static Method sunConstructor = null;
    protected static Object sunReflFac = null;
    protected static Method androidConstructor = null;
    private static Method androidConstructorGinger = null;
    private static Object constructorId;
    protected static Map<Class<?>, Constructor<?>> class2constuctor;
    protected int oldSize;
    protected CopyOnWriteArrayList<Fun.Function1> serializationTransformsSerialize;
    protected CopyOnWriteArrayList<Fun.Function1> serializationTransformsDeserialize;

    protected static Class<?> classForName(String className) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return Class.forName(className, true, loader);
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(className, true, SerializerPojo.class.getClassLoader());
            }
            catch (ClassNotFoundException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    public SerializerPojo(CopyOnWriteArrayList<ClassInfo> registered) {
        if (registered == null) {
            registered = new CopyOnWriteArrayList();
        }
        this.registered = registered;
        this.oldSize = registered.size();
        for (int i = 0; i < registered.size(); ++i) {
            ClassInfo ci = registered.get(i);
            Class<?> clazz = SerializerPojo.classForName(ci.name);
            this.class2classId.put(clazz, i);
            this.classId2class.put(i, clazz);
        }
    }

    protected void setDb(DB db) {
        this.db = db;
    }

    public void registerClass(Class<?> clazz) throws IOException {
        if (this.containsClass(clazz)) {
            return;
        }
        assert (this.lock.isWriteLockedByCurrentThread());
        boolean advancedSer = this.usesAdvancedSerialization(clazz);
        ObjectStreamField[] streamFields = advancedSer ? new ObjectStreamField[]{} : this.getFields(clazz);
        FieldInfo[] fields = new FieldInfo[streamFields.length];
        for (int i = 0; i < fields.length; ++i) {
            ObjectStreamField sf = streamFields[i];
            fields[i] = new FieldInfo(sf, clazz);
        }
        ClassInfo i = new ClassInfo(clazz.getName(), fields, clazz.isEnum(), advancedSer);
        this.class2classId.put(clazz, this.registered.size());
        this.classId2class.put(this.registered.size(), clazz);
        this.registered.add(i);
        this.saveClassInfo();
    }

    protected boolean usesAdvancedSerialization(Class<?> clazz) {
        if (Externalizable.class.isAssignableFrom(clazz)) {
            return true;
        }
        try {
            if (clazz.getDeclaredMethod("readObject", ObjectInputStream.class) != null) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            if (clazz.getDeclaredMethod("writeObject", ObjectOutputStream.class) != null) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            if (clazz.getDeclaredMethod("writeReplace", new Class[0]) != null) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    protected void saveClassInfo() {
    }

    protected ObjectStreamField[] getFields(Class<?> clazz) {
        ObjectStreamField[] fields = null;
        ClassInfo classInfo = null;
        Integer classId = this.class2classId.get(clazz);
        if (classId != null) {
            classInfo = this.registered.get(classId);
            fields = classInfo.getObjectStreamFields();
        }
        if (fields == null) {
            ObjectStreamClass streamClass = ObjectStreamClass.lookup(clazz);
            SerializerBase.FastArrayList<ObjectStreamField> fieldsList = new SerializerBase.FastArrayList<ObjectStreamField>();
            while (streamClass != null) {
                for (ObjectStreamField f : streamClass.getFields()) {
                    fieldsList.add(f);
                }
                streamClass = (clazz = clazz.getSuperclass()) != null ? ObjectStreamClass.lookup(clazz) : null;
            }
            fields = new ObjectStreamField[fieldsList.size];
            System.arraycopy(fieldsList.data, 0, fields, 0, fields.length);
            if (classInfo != null) {
                classInfo.setObjectStreamFields(fields);
            }
        }
        return fields;
    }

    protected void assertClassSerializable(Class<?> clazz) throws NotSerializableException, InvalidClassException {
        if (this.containsClass(clazz)) {
            return;
        }
        if (!Serializable.class.isAssignableFrom(clazz)) {
            throw new NotSerializableException(clazz.getName());
        }
    }

    public Object getFieldValue(FieldInfo fieldInfo, Object object) {
        if (fieldInfo.field == null) {
            throw new NoSuchFieldError(object.getClass() + "." + fieldInfo.name);
        }
        try {
            return fieldInfo.field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not get value from field", e);
        }
    }

    public void setFieldValue(FieldInfo fieldInfo, Object object, Object value) {
        if (fieldInfo.field == null) {
            throw new NoSuchFieldError(object.getClass() + "." + fieldInfo.name);
        }
        try {
            fieldInfo.field.set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not set field value: ", e);
        }
    }

    public boolean containsClass(Class<?> clazz) {
        return this.class2classId.get(clazz) != null;
    }

    public int getClassId(Class<?> clazz) {
        Integer classId = this.class2classId.get(clazz);
        if (classId != null) {
            return classId;
        }
        throw new AssertionError((Object)("Class is not registered: " + clazz));
    }

    @Override
    protected Engine getEngine() {
        return this.db.getEngine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void serializeUnknownObject(DataOutput out, Object obj, SerializerBase.FastArrayList<Object> objectStack) throws IOException {
        String name;
        if (this.db != null && (name = this.db.getNameForObject(obj)) != null) {
            out.write(175);
            out.writeUTF(name);
            return;
        }
        out.write(173);
        this.lock.writeLock().lock();
        try {
            Class<?> clazz = obj.getClass();
            if (!clazz.isEnum() && clazz.getSuperclass() != null && clazz.getSuperclass().isEnum()) {
                clazz = clazz.getSuperclass();
            }
            if (clazz != Object.class) {
                this.assertClassSerializable(clazz);
            }
            this.registerClass(clazz);
            int classId = this.getClassId(clazz);
            DataOutput2.packInt(out, classId);
            ClassInfo classInfo = this.registered.get(classId);
            if (classInfo.useObjectStream) {
                ObjectOutputStream2 out2 = new ObjectOutputStream2((OutputStream)((Object)out));
                out2.writeObject(obj);
                return;
            }
            if (classInfo.isEnum) {
                int ordinal = ((Enum)obj).ordinal();
                DataOutput2.packInt(out, ordinal);
            }
            ObjectStreamField[] fields = this.getFields(clazz);
            DataOutput2.packInt(out, fields.length);
            for (ObjectStreamField f : fields) {
                int fieldId = classInfo.getFieldId(f.getName());
                if (fieldId == -1) {
                    fieldId = classInfo.addFieldInfo(new FieldInfo(f, clazz));
                    this.saveClassInfo();
                }
                DataOutput2.packInt(out, fieldId);
                Object fieldValue = this.getFieldValue(classInfo.fields.get(fieldId), obj);
                this.serialize(out, fieldValue, objectStack);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    protected Object deserializeUnknownHeader(DataInput in, int head, SerializerBase.FastArrayList<Object> objectStack) throws IOException {
        if (head == 175) {
            String name = in.readUTF();
            Object o = this.db.get(name);
            if (o == null) {
                throw new AssertionError((Object)("Named object was not found: " + name));
            }
            objectStack.add(o);
            return o;
        }
        if (head != 173) {
            throw new AssertionError();
        }
        this.lock.readLock().lock();
        try {
            Object o;
            int classId = DataInput2.unpackInt(in);
            ClassInfo classInfo = this.registered.get(classId);
            Class<?> clazz = this.classId2class.get(classId);
            if (clazz == null) {
                clazz = SerializerPojo.classForName(classInfo.name);
            }
            this.assertClassSerializable(clazz);
            if (classInfo.useObjectStream) {
                ObjectInputStream2 in2 = new ObjectInputStream2((InputStream)((Object)in));
                o = in2.readObject();
            } else if (classInfo.isEnum) {
                int ordinal = DataInput2.unpackInt(in);
                o = clazz.getEnumConstants()[ordinal];
            } else {
                o = this.createInstanceSkippinkConstructor(clazz);
            }
            objectStack.add(o);
            if (!classInfo.useObjectStream) {
                int fieldCount = DataInput2.unpackInt(in);
                for (int i = 0; i < fieldCount; ++i) {
                    int fieldId = DataInput2.unpackInt(in);
                    FieldInfo f = classInfo.fields.get(fieldId);
                    Object fieldValue = this.deserialize(in, objectStack);
                    this.setFieldValue(f, o, fieldValue);
                }
            }
            Object object = o;
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate class", e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected <T> T createInstanceSkippinkConstructor(Class<T> clazz) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        if (sunConstructor != null) {
            Constructor intConstr = class2constuctor.get(clazz);
            if (intConstr == null) {
                Constructor objDef = Object.class.getDeclaredConstructor(new Class[0]);
                intConstr = (Constructor)sunConstructor.invoke(sunReflFac, clazz, objDef);
                class2constuctor.put(clazz, intConstr);
            }
            return (T)intConstr.newInstance(new Object[0]);
        }
        if (androidConstructor != null) {
            return (T)androidConstructor.invoke(null, clazz, Object.class);
        }
        if (androidConstructorGinger != null) {
            return (T)androidConstructorGinger.invoke(null, clazz, constructorId);
        }
        Constructor<Object> c = class2constuctor.get(clazz);
        if (c == null) {
            c = clazz.getConstructor(new Class[0]);
            if (!c.isAccessible()) {
                c.setAccessible(true);
            }
            class2constuctor.put(clazz, c);
        }
        return (T)c.newInstance(new Object[0]);
    }

    public boolean hasUnsavedChanges() {
        return this.oldSize != this.registered.size();
    }

    public void save(Engine e) {
        e.update(2L, this.registered, serializer);
        this.oldSize = this.registered.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A, R> void serializerTransformAdd(Fun.Function1<A, R> beforeSerialization, Fun.Function1<R, A> afterDeserialization) {
        this.lock.writeLock().lock();
        try {
            if (this.serializationTransformsSerialize == null) {
                this.serializationTransformsSerialize = new CopyOnWriteArrayList();
                this.serializationTransformsDeserialize = new CopyOnWriteArrayList();
            }
            this.serializationTransformsSerialize.add(beforeSerialization);
            this.serializationTransformsDeserialize.add(afterDeserialization);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A, R> void serializerTransformRemove(Fun.Function1<A, R> beforeSerialization, Fun.Function1<R, A> afterDeserialization) {
        this.lock.writeLock().lock();
        try {
            if (this.serializationTransformsSerialize == null) {
                return;
            }
            this.serializationTransformsSerialize.remove(beforeSerialization);
            this.serializationTransformsDeserialize.remove(afterDeserialization);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void serialize(DataOutput out, Object obj) throws IOException {
        if (this.serializationTransformsSerialize != null) {
            for (Fun.Function1 f : this.serializationTransformsSerialize) {
                obj = f.run(obj);
            }
        }
        super.serialize(out, obj);
    }

    @Override
    public Object deserialize(DataInput is, int capacity) throws IOException {
        Object obj = super.deserialize(is, capacity);
        if (this.serializationTransformsDeserialize != null) {
            for (Fun.Function1 f : this.serializationTransformsDeserialize) {
                obj = f.run(obj);
            }
        }
        return obj;
    }

    static {
        try {
            Class<?> clazz = SerializerPojo.classForName("sun.reflect.ReflectionFactory");
            if (clazz != null) {
                Method getReflectionFactory = clazz.getMethod("getReflectionFactory", new Class[0]);
                sunReflFac = getReflectionFactory.invoke(null, new Object[0]);
                sunConstructor = clazz.getMethod("newConstructorForSerialization", Class.class, Constructor.class);
            }
        }
        catch (Exception clazz) {
            // empty catch block
        }
        if (sunConstructor == null) {
            try {
                Method newInstance = ObjectInputStream.class.getDeclaredMethod("newInstance", Class.class, Class.class);
                newInstance.setAccessible(true);
                androidConstructor = newInstance;
            }
            catch (Exception newInstance) {
                // empty catch block
            }
        }
        if (sunConstructor == null && androidConstructor == null) {
            try {
                Method getConstructorId = ObjectStreamClass.class.getDeclaredMethod("getConstructorId", Class.class);
                getConstructorId.setAccessible(true);
                constructorId = getConstructorId.invoke(null, Object.class);
                Method newInstance = ObjectStreamClass.class.getDeclaredMethod("newInstance", Class.class, getConstructorId.getReturnType());
                newInstance.setAccessible(true);
                androidConstructorGinger = newInstance;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        class2constuctor = new ConcurrentHashMap();
    }

    protected final class ObjectInputStream2
    extends ObjectInputStream {
        protected ObjectInputStream2(InputStream in) throws IOException, SecurityException {
            super(in);
        }

        @Override
        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            Integer classId = DataInput2.unpackInt(this);
            Class<?> clazz = SerializerPojo.this.classId2class.get(classId);
            return ObjectStreamClass.lookup(clazz);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = Class.forName(desc.getName(), false, loader);
            if (clazz != null) {
                return clazz;
            }
            return super.resolveClass(desc);
        }
    }

    protected final class ObjectOutputStream2
    extends ObjectOutputStream {
        protected ObjectOutputStream2(OutputStream out) throws IOException, SecurityException {
            super(out);
        }

        @Override
        protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
            Integer classId = SerializerPojo.this.class2classId.get(desc.forClass());
            if (classId == null) {
                SerializerPojo.this.registerClass(desc.forClass());
                classId = SerializerPojo.this.class2classId.get(desc.forClass());
            }
            DataOutput2.packInt(this, classId);
        }
    }

    protected static class FieldInfo {
        protected final String name;
        protected final boolean primitive;
        protected final String type;
        protected Class<?> typeClass;
        protected final Class<?> clazz;
        protected Field field;

        public FieldInfo(String name, boolean primitive, String type, Class<?> clazz) {
            this.name = name;
            this.primitive = primitive;
            this.type = type;
            this.clazz = clazz;
            this.typeClass = primitive ? null : SerializerPojo.classForName(type);
            Class<?> aClazz = clazz;
            while (true) {
                if (aClazz == Object.class) {
                    throw new RuntimeException("Could not set field value: " + name + " - " + clazz.toString());
                }
                try {
                    Field f = aClazz.getDeclaredField(name);
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    this.field = f;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    aClazz = aClazz.getSuperclass();
                    continue;
                }
                break;
            }
        }

        public FieldInfo(ObjectStreamField sf, Class<?> clazz) {
            this(sf.getName(), sf.isPrimitive(), sf.getType().getName(), clazz);
        }
    }

    protected static final class ClassInfo {
        protected final String name;
        protected final List<FieldInfo> fields = new ArrayList<FieldInfo>();
        protected final Map<String, FieldInfo> name2fieldInfo = new HashMap<String, FieldInfo>();
        protected final Map<String, Integer> name2fieldId = new HashMap<String, Integer>();
        protected ObjectStreamField[] objectStreamFields;
        protected final boolean isEnum;
        protected final boolean useObjectStream;

        public ClassInfo(String name, FieldInfo[] fields, boolean isEnum, boolean isExternalizable) {
            this.name = name;
            this.isEnum = isEnum;
            this.useObjectStream = isExternalizable;
            for (FieldInfo f : fields) {
                this.name2fieldId.put(f.name, this.fields.size());
                this.fields.add(f);
                this.name2fieldInfo.put(f.name, f);
            }
        }

        public int getFieldId(String name) {
            Integer fieldId = this.name2fieldId.get(name);
            if (fieldId != null) {
                return fieldId;
            }
            return -1;
        }

        public int addFieldInfo(FieldInfo field) {
            this.name2fieldId.put(field.name, this.fields.size());
            this.name2fieldInfo.put(field.name, field);
            this.fields.add(field);
            return this.fields.size() - 1;
        }

        public ObjectStreamField[] getObjectStreamFields() {
            return this.objectStreamFields;
        }

        public void setObjectStreamFields(ObjectStreamField[] objectStreamFields) {
            this.objectStreamFields = objectStreamFields;
        }

        public String toString() {
            return super.toString() + "[" + this.name + "]";
        }
    }
}

