/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.iterator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.federated.algebra.FedXZeroLengthPath;
import org.eclipse.rdf4j.federated.algebra.StatementSource;
import org.eclipse.rdf4j.federated.algebra.StatementTupleExpr;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MutableBindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class FedXPathIteration
extends LookAheadIteration<BindingSet, QueryEvaluationException> {
    private final EvaluationStrategy strategy;
    private long currentLength;
    private CloseableIteration<BindingSet, QueryEvaluationException> currentIter;
    private final BindingSet bindings;
    private final StatementPattern.Scope scope;
    private final Var startVar;
    private final Var endVar;
    private final boolean startVarFixed;
    private final boolean endVarFixed;
    private final Queue<ValuePair> valueQueue;
    private final Set<ValuePair> reportedValues;
    private final Set<ValuePair> unreportedValues;
    private final TupleExpr pathExpression;
    private final Var contextVar;
    private ValuePair currentVp;
    private static final String JOINVAR_PREFIX = "intermediate_join_";
    private final Set<String> namedIntermediateJoins = new HashSet<String>();
    private final QueryInfo queryInfo;

    public FedXPathIteration(EvaluationStrategy strategy, StatementPattern.Scope scope, Var startVar, TupleExpr pathExpression, Var endVar, Var contextVar, long minLength, BindingSet bindings, QueryInfo queryInfo) throws QueryEvaluationException {
        this.strategy = strategy;
        this.scope = scope;
        this.startVar = startVar;
        this.endVar = endVar;
        this.startVarFixed = startVar.hasValue() || bindings.hasBinding(startVar.getName());
        this.endVarFixed = endVar.hasValue() || bindings.hasBinding(endVar.getName());
        this.pathExpression = pathExpression;
        this.contextVar = contextVar;
        this.currentLength = minLength;
        this.bindings = bindings;
        this.reportedValues = strategy.makeSet();
        this.unreportedValues = strategy.makeSet();
        this.valueQueue = strategy.makeQueue();
        this.queryInfo = queryInfo;
        this.createIteration();
    }

    /*
     * Exception decompiling
     */
    @Override
    protected BindingSet getNextElement() throws QueryEvaluationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[UNCONDITIONALDOLOOP]], but top level block is 1[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private BindingSet removeIntermediateJoinVars(QueryBindingSet nextElement) {
        nextElement.removeAll(this.namedIntermediateJoins);
        return nextElement;
    }

    private ValuePair valuePairFromStartAndEnd(MutableBindingSet nextElement) {
        Value v2;
        Value v1;
        if (this.startVarFixed && this.endVarFixed && this.currentLength > 2L) {
            v1 = this.getVarValue(this.startVar, this.startVarFixed, nextElement);
            v2 = nextElement.getValue("END_intermediate_join_" + this.hashCode());
        } else if (this.startVarFixed && this.endVarFixed && this.currentLength == 2L) {
            v1 = this.getVarValue(this.startVar, this.startVarFixed, nextElement);
            v2 = nextElement.getValue(JOINVAR_PREFIX + (this.currentLength - 1L) + "_" + this.hashCode());
        } else {
            v1 = this.getVarValue(this.startVar, this.startVarFixed, nextElement);
            v2 = this.getVarValue(this.endVar, this.endVarFixed, nextElement);
        }
        return new ValuePair(v1, v2);
    }

    private void addBinding(MutableBindingSet bs, String name, Value value) {
        bs.addBinding(name, value);
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        try {
            super.handleClose();
        }
        finally {
            Iterations.closeCloseable(this.currentIter);
        }
    }

    protected boolean addToQueue(Queue<ValuePair> valueQueue2, ValuePair vp) throws QueryEvaluationException {
        return valueQueue2.add(vp);
    }

    protected boolean add(Set<ValuePair> valueSet, ValuePair vp) throws QueryEvaluationException {
        return valueSet.add(vp);
    }

    private Value getVarValue(Var var, boolean fixedValue, BindingSet bindingSet) {
        Value v;
        if (fixedValue) {
            v = var.getValue();
            if (v == null) {
                v = this.bindings.getValue(var.getName());
            }
        } else {
            v = bindingSet.getValue(var.getName());
        }
        return v;
    }

    private boolean isCyclicPath(ValuePair vp) {
        if (this.currentLength <= 2L) {
            return false;
        }
        return this.reportedValues.contains(vp);
    }

    private void createIteration() throws QueryEvaluationException {
        if (this.isUnbound(this.startVar, this.bindings) || this.isUnbound(this.endVar, this.bindings)) {
            this.currentIter = null;
        } else if (this.currentLength == 0L) {
            ArrayList<StatementSource> statementSources = new ArrayList<StatementSource>();
            if (this.pathExpression instanceof StatementTupleExpr) {
                statementSources.addAll(((StatementTupleExpr)this.pathExpression).getStatementSources());
            }
            FedXZeroLengthPath zlp = new FedXZeroLengthPath(this.scope, this.startVar.clone(), this.endVar.clone(), this.contextVar != null ? this.contextVar.clone() : null, this.queryInfo, statementSources);
            this.currentIter = this.strategy.evaluate(zlp, this.bindings);
            ++this.currentLength;
        } else if (this.currentLength == 1L) {
            TupleExpr pathExprClone = this.pathExpression.clone();
            if (this.startVarFixed && this.endVarFixed) {
                Var replacement = this.createAnonVar(JOINVAR_PREFIX + this.currentLength + "_" + this.hashCode());
                VarReplacer replacer = new VarReplacer(this.endVar, replacement, 0L, false);
                pathExprClone.visit(replacer);
            }
            this.currentIter = this.strategy.evaluate(pathExprClone, this.bindings);
            ++this.currentLength;
        } else {
            this.currentVp = this.valueQueue.poll();
            if (this.currentVp != null) {
                TupleExpr pathExprClone = this.pathExpression.clone();
                if (this.startVarFixed && this.endVarFixed) {
                    Var startReplacement = this.createAnonVar(JOINVAR_PREFIX + this.currentLength + "_" + this.hashCode());
                    Var endReplacement = this.createAnonVar("END_intermediate_join_" + this.hashCode());
                    startReplacement.setAnonymous(false);
                    endReplacement.setAnonymous(false);
                    Value v = this.currentVp.getEndValue();
                    startReplacement.setValue(v);
                    VarReplacer replacer = new VarReplacer(this.startVar, startReplacement, 0L, false);
                    pathExprClone.visit(replacer);
                    replacer = new VarReplacer(this.endVar, endReplacement, 0L, false);
                    pathExprClone.visit(replacer);
                } else {
                    Value v;
                    Var toBeReplaced;
                    if (!this.endVarFixed) {
                        toBeReplaced = this.startVar;
                        v = this.currentVp.getEndValue();
                    } else {
                        toBeReplaced = this.endVar;
                        v = this.currentVp.getStartValue();
                    }
                    Var replacement = this.createAnonVar(JOINVAR_PREFIX + this.currentLength + "-" + this.hashCode());
                    replacement.setValue(v);
                    VarReplacer replacer = new VarReplacer(toBeReplaced, replacement, 0L, false);
                    pathExprClone.visit(replacer);
                }
                this.currentIter = this.strategy.evaluate(pathExprClone, this.bindings);
            } else {
                this.currentIter = null;
            }
            ++this.currentLength;
        }
    }

    protected boolean isUnbound(Var var, BindingSet bindings) {
        if (var == null) {
            return false;
        }
        return bindings.hasBinding(var.getName()) && bindings.getValue(var.getName()) == null;
    }

    private Var createAnonVar(String varName, Value v, boolean anonymous) {
        this.namedIntermediateJoins.add(varName);
        return new Var(varName, null, anonymous, false);
    }

    public Var createAnonVar(String varName) {
        return this.createAnonVar(varName, null, true);
    }

    class VarReplacer
    extends AbstractQueryModelVisitor<QueryEvaluationException> {
        private final Var toBeReplaced;
        private final Var replacement;
        private final long index;
        private final boolean replaceAnons;

        public VarReplacer(Var toBeReplaced, Var replacement, long index, boolean replaceAnons) {
            this.toBeReplaced = toBeReplaced;
            this.replacement = replacement;
            this.index = index;
            this.replaceAnons = replaceAnons;
        }

        @Override
        public void meet(Var var) {
            if (this.toBeReplaced.equals(var) || this.toBeReplaced.isAnonymous() && var.isAnonymous() && this.toBeReplaced.hasValue() && this.toBeReplaced.getValue().equals(var.getValue())) {
                QueryModelNode parent = var.getParentNode();
                parent.replaceChildNode(var, this.replacement.clone());
            } else if (this.replaceAnons && var.isAnonymous() && !var.hasValue()) {
                Var replacementVar = FedXPathIteration.this.createAnonVar("anon-replace-" + var.getName() + this.index);
                QueryModelNode parent = var.getParentNode();
                parent.replaceChildNode(var, replacementVar);
            }
        }
    }

    protected static class ValuePair {
        private final Value startValue;
        private final Value endValue;

        public ValuePair(Value startValue, Value endValue) {
            this.startValue = startValue;
            this.endValue = endValue;
        }

        public Value getStartValue() {
            return this.startValue;
        }

        public Value getEndValue() {
            return this.endValue;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.endValue == null ? 0 : this.endValue.hashCode());
            result = 31 * result + (this.startValue == null ? 0 : this.startValue.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ValuePair)) {
                return false;
            }
            ValuePair other = (ValuePair)obj;
            if (this.endValue == null ? other.endValue != null : !this.endValue.equals(other.endValue)) {
                return false;
            }
            return !(this.startValue == null ? other.startValue != null : !this.startValue.equals(other.startValue));
        }
    }
}

