/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.setting;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.rdf4j.console.setting.ConsoleSetting;

public class WorkDir
extends ConsoleSetting<Path> {
    public static final String NAME = "workdir";

    @Override
    public String getHelpLong() {
        return "set workDir=<dir>              Set the working directory\n";
    }

    public WorkDir() {
        super(Paths.get(System.getProperty("user.dir"), new String[0]));
    }

    public WorkDir(Path initValue) {
        super(initValue);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void set(Path value) throws IllegalArgumentException {
        if (value == null || !value.toFile().isDirectory() || !value.toFile().canWrite()) {
            throw new IllegalArgumentException("Path is not a writable directory");
        }
        super.set(value);
    }

    @Override
    public void setFromString(String value) throws IllegalArgumentException {
        this.set(Paths.get(value, new String[0]));
    }
}

