/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.common.text.ASCIIUtil;

public class URIUtil {
    private static final Set<Character> reserved = new HashSet<Character>(Arrays.asList(Character.valueOf(';'), Character.valueOf('/'), Character.valueOf('?'), Character.valueOf(':'), Character.valueOf('@'), Character.valueOf('&'), Character.valueOf('='), Character.valueOf('+'), Character.valueOf('$'), Character.valueOf(',')));
    private static final Set<Character> mark = new HashSet<Character>(Arrays.asList(Character.valueOf('-'), Character.valueOf('_'), Character.valueOf('.'), Character.valueOf('!'), Character.valueOf('~'), Character.valueOf('*'), Character.valueOf('\''), Character.valueOf('('), Character.valueOf(')')));
    private static final Pattern unicodeControlCharPattern = Pattern.compile(".*[\u0000-\u001f\u007f-\u009f].*");
    private static final char[] LOCAL_ESCAPED_CHARS = new char[]{'_', '~', '.', '-', '!', '$', '&', '\'', '(', ')', '*', '+', ',', ';', '=', '/', '?', '#', '@', '%'};

    public static int getLocalNameIndex(String uri) {
        int separatorIdx = uri.indexOf(35);
        if (separatorIdx < 0) {
            separatorIdx = uri.lastIndexOf(47);
        }
        if (separatorIdx < 0) {
            separatorIdx = uri.lastIndexOf(58);
        }
        if (separatorIdx < 0) {
            throw new IllegalArgumentException("No separator character founds in URI: " + uri);
        }
        return separatorIdx + 1;
    }

    public static boolean isCorrectURISplit(String namespace, String localName) {
        assert (namespace != null) : "namespace must not be null";
        assert (localName != null) : "localName must not be null";
        if (namespace.length() == 0) {
            return false;
        }
        int nsLength = namespace.length();
        char lastNsChar = namespace.charAt(nsLength - 1);
        if (lastNsChar == '#') {
            return namespace.lastIndexOf(35, nsLength - 2) == -1 && localName.indexOf(35) == -1;
        }
        if (lastNsChar == '/') {
            return localName.indexOf(47) == -1 && localName.indexOf(35) == -1 && namespace.indexOf(35) == -1;
        }
        if (lastNsChar == ':') {
            return localName.indexOf(58) == -1 && localName.indexOf(35) == -1 && localName.indexOf(47) == -1 && namespace.indexOf(35) == -1 && namespace.indexOf(47) == -1;
        }
        return false;
    }

    public static boolean isValidURIReference(String uriRef) {
        boolean valid;
        boolean bl = valid = !unicodeControlCharPattern.matcher(uriRef).matches();
        if (valid) {
            String escaped = URIUtil.escapeExcludedChars(uriRef);
            try {
                URI uri = new URI(escaped);
                valid = uri.isAbsolute();
            }
            catch (URISyntaxException e) {
                valid = false;
            }
        }
        return valid;
    }

    private static String escapeExcludedChars(String unescaped) {
        StringBuilder escaped = new StringBuilder();
        for (int i = 0; i < unescaped.length(); ++i) {
            char c = unescaped.charAt(i);
            if (!URIUtil.isUnreserved(c) && !reserved.contains(Character.valueOf(c))) {
                escaped.append("%" + Integer.toHexString(c));
                continue;
            }
            escaped.append(c);
        }
        return escaped.toString();
    }

    private static boolean isUnreserved(char c) {
        boolean unreserved;
        char n = c;
        boolean bl = unreserved = '/' < n && n < ':' || '`' < n && n < '{' || '@' < n && n < '[';
        if (!unreserved) {
            unreserved = mark.contains(Character.valueOf(c));
        }
        return unreserved;
    }

    public static boolean isValidLocalName(String name) {
        if (name.length() == 0) {
            return true;
        }
        if (!(URIUtil.isPN_CHARS_U(name.charAt(0)) || name.charAt(0) == ':' || ASCIIUtil.isNumber((int)name.charAt(0)) || URIUtil.isPLX_START(name))) {
            return false;
        }
        if (!URIUtil.isNameStartChar(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (!URIUtil.isNameChar(name.charAt(i))) {
                return false;
            }
            if (name.charAt(i) != '%' || name.length() - i >= 3) continue;
            return false;
        }
        return true;
    }

    private static boolean isPN_CHARS_U(int codePoint) {
        return URIUtil.isPN_CHARS_BASE(codePoint) || codePoint == 95;
    }

    private static boolean isPLX_START(String name) {
        if (name.length() >= 3 && URIUtil.isPERCENT(name.substring(0, 3))) {
            return true;
        }
        return name.length() >= 2 && URIUtil.isPN_LOCAL_ESC(name.substring(0, 2));
    }

    private static boolean isPERCENT(String name) {
        if (name.length() != 3) {
            return false;
        }
        if (name.charAt(0) != '%') {
            return false;
        }
        return ASCIIUtil.isHex((int)name.charAt(1)) && ASCIIUtil.isHex((int)name.charAt(2));
    }

    private static boolean isPN_LOCAL_ESC(String name) {
        if (name.length() != 2) {
            return false;
        }
        if (!name.startsWith("\\")) {
            return false;
        }
        return Arrays.binarySearch(LOCAL_ESCAPED_CHARS, name.charAt(1)) > -1;
    }

    private static boolean isPN_CHARS_BASE(int codePoint) {
        return ASCIIUtil.isLetter((int)codePoint) || codePoint >= 192 && codePoint <= 214 || codePoint >= 216 && codePoint <= 246 || codePoint >= 248 && codePoint <= 767 || codePoint >= 880 && codePoint <= 893 || codePoint >= 895 && codePoint <= 8191 || codePoint >= 8204 && codePoint <= 8205 || codePoint >= 8304 && codePoint <= 8591 || codePoint >= 11264 && codePoint <= 12271 || codePoint >= 12289 && codePoint <= 55295 || codePoint >= 63744 && codePoint <= 64975 || codePoint >= 65008 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 983039;
    }

    private static boolean isNameStartChar(int codePoint) {
        return URIUtil.isPN_CHARS_U(codePoint) || codePoint == 58 || ASCIIUtil.isNumber((int)codePoint) || codePoint == 92 || codePoint == 37;
    }

    private static boolean isNameChar(int codePoint) {
        return URIUtil.isPN_CHARS(codePoint) || codePoint == 46 || codePoint == 58 | codePoint == 92 || codePoint == 37;
    }

    private static boolean isPN_CHARS(int codePoint) {
        return URIUtil.isPN_CHARS_U(codePoint) || ASCIIUtil.isNumber((int)codePoint) || codePoint == 45 || codePoint == 183 || codePoint >= 768 && codePoint <= 879 || codePoint >= 8255 && codePoint <= 8256;
    }
}

