/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclPrefixParser;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;

public class SparqlFragment {
    private static final boolean USE_UNION_PRESERVING_JOIN = false;
    private final Set<Namespace> namespaces = new HashSet<Namespace>();
    private final String fragment;
    private final List<String> unionFragments = new ArrayList<String>();
    private final List<StatementMatcher> statementMatchers = new ArrayList<StatementMatcher>();
    private final TraceBack traceBackFunction;
    private boolean filterCondition;
    private boolean bgp;
    private boolean union;
    private final boolean supportsIncrementalEvaluation;

    private SparqlFragment(Collection<Namespace> namespaces, String fragment, boolean filterCondition, boolean bgp, List<StatementMatcher> statementMatchers, TraceBack traceBackFunction, boolean supportsIncrementalEvaluation) {
        this.namespaces.addAll(namespaces);
        this.fragment = fragment;
        this.filterCondition = filterCondition;
        this.bgp = bgp;
        this.statementMatchers.addAll(statementMatchers);
        this.traceBackFunction = traceBackFunction;
        this.supportsIncrementalEvaluation = supportsIncrementalEvaluation;
        assert (filterCondition != bgp);
    }

    private SparqlFragment(Collection<Namespace> namespaces, List<String> unionFragments, List<StatementMatcher> statementMatchers, TraceBack traceBackFunction, boolean supportsIncrementalEvaluation) {
        this.namespaces.addAll(namespaces);
        this.fragment = null;
        this.unionFragments.addAll(unionFragments);
        this.union = true;
        this.statementMatchers.addAll(statementMatchers);
        this.traceBackFunction = traceBackFunction;
        this.supportsIncrementalEvaluation = supportsIncrementalEvaluation;
    }

    public static SparqlFragment filterCondition(Collection<Namespace> namespaces, String fragment, List<StatementMatcher> statementMatchers) {
        return new SparqlFragment(namespaces, fragment, true, false, statementMatchers, null, true);
    }

    public static SparqlFragment filterCondition(Collection<Namespace> namespaces, String fragment, List<StatementMatcher> statementMatchers, boolean supportsIncrementalEvaluation) {
        return new SparqlFragment(namespaces, fragment, true, false, statementMatchers, null, supportsIncrementalEvaluation);
    }

    public static SparqlFragment bgp(Collection<Namespace> namespaces, String query, boolean supportsIncrementalEvaluation) {
        return new SparqlFragment(namespaces, query, false, true, List.of(), null, supportsIncrementalEvaluation);
    }

    public static SparqlFragment bgp(Collection<Namespace> namespaces, String fragment, List<StatementMatcher> statementMatchers) {
        return new SparqlFragment(namespaces, fragment, false, true, statementMatchers, null, true);
    }

    public static SparqlFragment bgp(Collection<Namespace> namespaces, String fragment, List<StatementMatcher> statementMatchers, TraceBack traceBackFunction) {
        return new SparqlFragment(namespaces, fragment, false, true, statementMatchers, traceBackFunction, true);
    }

    public static SparqlFragment bgp(Collection<Namespace> namespaces, String fragment, List<StatementMatcher> statementMatchers, TraceBack traceBackFunction, boolean supportsIncrementalEvaluation) {
        return new SparqlFragment(namespaces, fragment, false, true, statementMatchers, traceBackFunction, supportsIncrementalEvaluation);
    }

    public static SparqlFragment bgp(Collection<Namespace> namespaces, String fragment, StatementMatcher statementMatcher) {
        return new SparqlFragment(namespaces, fragment, false, true, List.of(statementMatcher), null, true);
    }

    public static SparqlFragment bgp(Collection<Namespace> namespaces, String fragment, StatementMatcher statementMatcher, TraceBack traceBackFunction) {
        return new SparqlFragment(namespaces, fragment, false, true, List.of(statementMatcher), traceBackFunction, true);
    }

    public static SparqlFragment bgp(Collection<Namespace> namespaces, String fragment) {
        return new SparqlFragment(namespaces, fragment, false, true, List.of(), null, true);
    }

    public static SparqlFragment and(List<SparqlFragment> sparqlFragments) {
        String collect = sparqlFragments.stream().peek(s -> {
            assert (s.filterCondition);
        }).map(SparqlFragment::getFragment).collect(Collectors.joining(" ) && ( ", "( ", " )"));
        boolean supportsIncrementalEvaluation = sparqlFragments.stream().allMatch(SparqlFragment::supportsIncrementalEvaluation);
        Set<Namespace> namespaces = sparqlFragments.stream().flatMap(s -> s.namespaces.stream()).collect(Collectors.toSet());
        return SparqlFragment.filterCondition(namespaces, collect, SparqlFragment.getStatementMatchers(sparqlFragments), supportsIncrementalEvaluation);
    }

    public static SparqlFragment or(List<SparqlFragment> sparqlFragments) {
        String collect = sparqlFragments.stream().peek(s -> {
            assert (s.filterCondition);
        }).map(SparqlFragment::getFragment).collect(Collectors.joining(" ) || ( ", "( ", " )"));
        boolean supportsIncrementalEvaluation = sparqlFragments.stream().allMatch(SparqlFragment::supportsIncrementalEvaluation);
        Set<Namespace> namespaces = sparqlFragments.stream().flatMap(s -> s.namespaces.stream()).collect(Collectors.toSet());
        return SparqlFragment.filterCondition(namespaces, collect, SparqlFragment.getStatementMatchers(sparqlFragments), supportsIncrementalEvaluation);
    }

    public static SparqlFragment join(List<SparqlFragment> sparqlFragments) {
        return SparqlFragment.join(sparqlFragments, null);
    }

    public static SparqlFragment join(List<SparqlFragment> sparqlFragments, TraceBack traceBackFunction) {
        String queryFragment = sparqlFragments.stream().peek(s -> {
            assert (!s.filterCondition);
        }).map(SparqlFragment::getFragment).reduce((a, b) -> a + "\n" + b).orElse("");
        boolean supportsIncrementalEvaluation = sparqlFragments.stream().allMatch(SparqlFragment::supportsIncrementalEvaluation);
        Set<Namespace> namespaces = sparqlFragments.stream().flatMap(s -> s.namespaces.stream()).collect(Collectors.toSet());
        return SparqlFragment.bgp(namespaces, queryFragment, SparqlFragment.getStatementMatchers(sparqlFragments), traceBackFunction, supportsIncrementalEvaluation);
    }

    private static SparqlFragment unionPreservingJoin(List<SparqlFragment> sparqlFragments, TraceBack traceBackFunction) {
        List<String> workingSet = new ArrayList<String>();
        SparqlFragment firstSparqlFragment = sparqlFragments.get(0);
        if (firstSparqlFragment.union) {
            workingSet.addAll(firstSparqlFragment.unionFragments);
        } else {
            assert (firstSparqlFragment.bgp);
            workingSet.add(firstSparqlFragment.fragment);
        }
        for (int i = 1; i < sparqlFragments.size(); ++i) {
            SparqlFragment sparqlFragment = sparqlFragments.get(i);
            if (sparqlFragment.union) {
                ArrayList<CallSite> newWorkingSet = new ArrayList<CallSite>();
                for (String unionFragment : sparqlFragment.unionFragments) {
                    for (String workingSetFragment : workingSet) {
                        newWorkingSet.add((CallSite)((Object)(workingSetFragment + "\n" + unionFragment)));
                    }
                }
                workingSet = newWorkingSet;
                continue;
            }
            assert (sparqlFragment.bgp);
            workingSet = workingSet.stream().map(s -> sparqlFragment.fragment + "\n" + s).collect(Collectors.toList());
        }
        boolean supportsIncrementalEvaluation = sparqlFragments.stream().allMatch(SparqlFragment::supportsIncrementalEvaluation);
        Set<Namespace> namespaces = sparqlFragments.stream().flatMap(s -> s.namespaces.stream()).collect(Collectors.toSet());
        SparqlFragment union = SparqlFragment.unionQueryStrings(namespaces, workingSet, traceBackFunction, supportsIncrementalEvaluation);
        union.addStatementMatchers(SparqlFragment.getStatementMatchers(sparqlFragments));
        return union;
    }

    public static boolean isFilterCondition(List<SparqlFragment> sparqlFragments) {
        for (SparqlFragment sparqlFragment : sparqlFragments) {
            if (!sparqlFragment.isFilterCondition()) continue;
            return true;
        }
        return false;
    }

    public static List<StatementMatcher> getStatementMatchers(List<SparqlFragment> sparqlFragments) {
        return sparqlFragments.stream().flatMap(s -> s.statementMatchers.stream()).collect(Collectors.toList());
    }

    public static SparqlFragment unionQueryStrings(Set<Namespace> namespaces, List<String> query, TraceBack traceBackFunction, boolean supportsIncrementalEvaluation) {
        return new SparqlFragment(namespaces, query, Collections.emptyList(), traceBackFunction, supportsIncrementalEvaluation);
    }

    public static SparqlFragment union(List<SparqlFragment> sparqlFragments) {
        List<String> sparqlFragmentString = sparqlFragments.stream().map(SparqlFragment::getFragment).collect(Collectors.toList());
        boolean supportsIncrementalEvaluation = sparqlFragments.stream().allMatch(SparqlFragment::supportsIncrementalEvaluation);
        Set<Namespace> namespaces = sparqlFragments.stream().flatMap(s -> s.namespaces.stream()).collect(Collectors.toSet());
        return new SparqlFragment(namespaces, sparqlFragmentString, SparqlFragment.getStatementMatchers(sparqlFragments), null, supportsIncrementalEvaluation);
    }

    public static SparqlFragment union(List<SparqlFragment> sparqlFragments, TraceBack traceBackFunction) {
        List<String> sparqlFragmentString = sparqlFragments.stream().map(SparqlFragment::getFragment).collect(Collectors.toList());
        boolean supportsIncrementalEvaluation = sparqlFragments.stream().allMatch(SparqlFragment::supportsIncrementalEvaluation);
        Set<Namespace> namespaces = sparqlFragments.stream().flatMap(s -> s.namespaces.stream()).collect(Collectors.toSet());
        return new SparqlFragment(namespaces, sparqlFragmentString, SparqlFragment.getStatementMatchers(sparqlFragments), traceBackFunction, supportsIncrementalEvaluation);
    }

    public static SparqlFragment unionQueryStrings(Set<Namespace> namespaces, String query1, String query2, String query3, boolean supportsIncrementalEvaluation) {
        return new SparqlFragment(namespaces, List.of(query1, query2, query3), Collections.emptyList(), null, supportsIncrementalEvaluation);
    }

    public String getFragment() {
        if (this.union) {
            return this.unionFragments.stream().collect(Collectors.joining("\n} UNION {\n#VALUES_INJECTION_POINT#\n", "{\n#VALUES_INJECTION_POINT#\n", "\n}"));
        }
        return this.fragment;
    }

    public boolean isFilterCondition() {
        return this.filterCondition;
    }

    public List<StatementMatcher> getStatementMatchers() {
        return this.statementMatchers;
    }

    public void addStatementMatchers(List<StatementMatcher> statementMatchers) {
        this.statementMatchers.addAll(statementMatchers);
    }

    public boolean supportsIncrementalEvaluation() {
        return this.supportsIncrementalEvaluation;
    }

    public String getNamespacesForSparql() {
        return ShaclPrefixParser.toSparqlPrefixes(this.namespaces);
    }

    public Stream<EffectiveTarget.StatementsAndMatcher> getRoot(ConnectionsGroup connectionsGroup, Resource[] dataGraph, Path path, StatementMatcher currentStatementMatcher, List<Statement> currentStatements) {
        assert (this.traceBackFunction != null);
        return this.traceBackFunction.getRoot(connectionsGroup, dataGraph, path, currentStatementMatcher, currentStatements);
    }

    public String toString() {
        return "SparqlFragment{fragment='" + this.fragment + "', unionFragments=" + this.unionFragments + ", statementMatchers=" + this.statementMatchers + ", traceBackFunction=" + this.traceBackFunction + ", filterCondition=" + this.filterCondition + ", bgp=" + this.bgp + ", union=" + this.union + ", supportsIncrementalEvaluation=" + this.supportsIncrementalEvaluation + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SparqlFragment that = (SparqlFragment)o;
        if (this.filterCondition != that.filterCondition) {
            return false;
        }
        if (this.bgp != that.bgp) {
            return false;
        }
        if (this.union != that.union) {
            return false;
        }
        if (this.supportsIncrementalEvaluation != that.supportsIncrementalEvaluation) {
            return false;
        }
        if (!this.namespaces.equals(that.namespaces)) {
            return false;
        }
        if (!Objects.equals(this.fragment, that.fragment)) {
            return false;
        }
        if (!this.unionFragments.equals(that.unionFragments)) {
            return false;
        }
        if (!this.statementMatchers.equals(that.statementMatchers)) {
            return false;
        }
        return Objects.equals(this.traceBackFunction, that.traceBackFunction);
    }

    public int hashCode() {
        int result = this.namespaces.hashCode();
        result = 31 * result + (this.fragment != null ? this.fragment.hashCode() : 0);
        result = 31 * result + this.unionFragments.hashCode();
        result = 31 * result + this.statementMatchers.hashCode();
        result = 31 * result + (this.traceBackFunction != null ? this.traceBackFunction.hashCode() : 0);
        result = 31 * result + (this.filterCondition ? 1 : 0);
        result = 31 * result + (this.bgp ? 1 : 0);
        result = 31 * result + (this.union ? 1 : 0);
        result = 31 * result + (this.supportsIncrementalEvaluation ? 1 : 0);
        return result;
    }

    private static /* synthetic */ boolean lambda$join$4(SparqlFragment s1) {
        return s1.union;
    }

    public static interface TraceBack {
        public Stream<EffectiveTarget.StatementsAndMatcher> getRoot(ConnectionsGroup var1, Resource[] var2, Path var3, StatementMatcher var4, List<Statement> var5);
    }
}

