/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.io.Serializable;
import java.util.Arrays;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;

public class BindingSetHashKey
implements Serializable {
    private static final long serialVersionUID = 6407405580643353289L;
    public static final BindingSetHashKey EMPTY = new BindingSetHashKey(new Value[0]);
    private final Value[] values;
    private transient int hashcode;

    public static BindingSetHashKey create(String[] varNames, BindingSet bindings) {
        BindingSetHashKey key;
        int varNameSize = varNames.length;
        if (varNameSize > 0) {
            Value[] keyValues = new Value[varNameSize];
            for (int i = 0; i < varNameSize; ++i) {
                Value value;
                keyValues[i] = value = bindings.getValue(varNames[i]);
            }
            key = new BindingSetHashKey(keyValues);
        } else {
            key = EMPTY;
        }
        return key;
    }

    private BindingSetHashKey(Value[] values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BindingSetHashKey)) {
            return false;
        }
        BindingSetHashKey jk = (BindingSetHashKey)o;
        if (this.values.length != jk.values.length) {
            return false;
        }
        for (int i = this.values.length - 1; i >= 0; --i) {
            Value v1 = this.values[i];
            Value v2 = jk.values[i];
            if (!(v1 == null ? v2 != null : !v1.equals(v2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            this.hashcode = Arrays.hashCode(this.values);
        }
        return this.hashcode;
    }
}

