/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.Stats;
import org.eclipse.rdf4j.sail.shacl.ValidationSettings;
import org.eclipse.rdf4j.sail.shacl.ast.ContextWithShapes;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.SingleCloseablePlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.results.ValidationReport;
import org.eclipse.rdf4j.sail.shacl.results.lazy.LazyValidationReport;
import org.eclipse.rdf4j.sail.shacl.results.lazy.ValidationResultIterator;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.VerySimpleRdfsBackwardsChainingConnection;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.CombinedShapeSource;

@Experimental
public class ShaclValidator {
    private static final Resource[] ALL_CONTEXTS = new Resource[0];
    protected static Resource[] CONTEXTS = new Resource[0];

    public static ValidationReport validate(Sail dataRepo, Sail shapesRepo) {
        List<ContextWithShapes> shapes;
        try (SailConnection shapesConnection = shapesRepo.getConnection();){
            shapesConnection.begin((IsolationLevel)IsolationLevels.NONE);
            try (CombinedShapeSource shapeSource = new CombinedShapeSource(shapesConnection, shapesConnection);){
                shapes = Shape.Factory.getShapes(shapeSource.withContext(CONTEXTS), new Shape.ParseSettings(true, true));
            }
            shapesConnection.commit();
        }
        try (SailConnection dataRepoConnection = dataRepo.getConnection();){
            RdfsSubClassOfReasoner reasoner;
            try (SailConnection shapesConnection = shapesRepo.getConnection();){
                reasoner = RdfsSubClassOfReasoner.createReasoner(dataRepoConnection, shapesConnection, new ValidationSettings(ALL_CONTEXTS, false, true, false));
            }
            VerySimpleRdfsBackwardsChainingConnection verySimpleRdfsBackwardsChainingConnection = new VerySimpleRdfsBackwardsChainingConnection(dataRepoConnection, reasoner);
            ValidationReport validationReport = ShaclValidator.performValidation(shapes, new ConnectionsGroup((SailConnection)verySimpleRdfsBackwardsChainingConnection, null, null, null, new Stats(), () -> reasoner, new ShaclSailConnection.Settings(true, true, true, (IsolationLevel)IsolationLevels.NONE), true));
            return validationReport;
        }
    }

    private static ValidationReport performValidation(List<ContextWithShapes> shapes, ConnectionsGroup connectionsGroup) {
        List<ValidationResultIterator> collect = shapes.stream().flatMap(contextWithShapes -> contextWithShapes.getShapes().stream().map(shape -> shape.generatePlans(connectionsGroup, new ValidationSettings(contextWithShapes.getDataGraph(), false, true, false)))).map(planNode -> {
            assert (planNode instanceof SingleCloseablePlanNode);
            planNode.receiveLogger(ValidationExecutionLogger.getInstance(false));
            return (SingleCloseablePlanNode)planNode;
        }).map(planNode -> {
            try (CloseableIteration<? extends ValidationTuple, SailException> iterator = planNode.iterator();){
                ValidationResultIterator validationResultIterator = new ValidationResultIterator(iterator, 1000L, planNode.getShape().getSeverity());
                return validationResultIterator;
            }
        }).collect(Collectors.toList());
        return new LazyValidationReport(collect, 10000L);
    }
}

