/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlQueryParserCache;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Formatter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Select
implements PlanNode {
    private static final Logger logger = LoggerFactory.getLogger(Select.class);
    private final SailConnection connection;
    private final Function<BindingSet, ValidationTuple> mapper;
    private final String query;
    private final boolean sorted;
    private final Dataset dataset;
    private StackTraceElement[] stackTrace;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public Select(SailConnection connection, SparqlFragment queryFragment, String orderBy, Function<BindingSet, ValidationTuple> mapper, Resource[] dataGraph) {
        this.connection = connection;
        assert (this.connection != null);
        this.mapper = mapper;
        String fragment = queryFragment.getFragment();
        if (fragment.trim().equals("")) {
            logger.error("Query is empty", new Throwable("This throwable is just to log the stack trace"));
            fragment = "?a <http://fjiewojfiwejfioewhgurh8924y.com/f289h8fhn> ?c.\nFILTER (NOT EXISTS {?a <http://fjiewojfiwejfioewhgurh8924y.com/f289h8fhn> ?c})";
        }
        boolean bl = this.sorted = orderBy != null;
        this.query = !this.sorted && fragment.trim().startsWith("select ") ? queryFragment.getNamespacesForSparql() + "\n" + StatementMatcher.StableRandomVariableProvider.normalize(fragment) : queryFragment.getNamespacesForSparql() + "\n" + StatementMatcher.StableRandomVariableProvider.normalize("select * where {\n" + fragment + "\n}" + (String)(this.sorted ? " order by " + orderBy : ""));
        this.dataset = PlanNodeHelper.asDefaultGraphDataset(dataGraph);
    }

    public Select(SailConnection connection, String query, Function<BindingSet, ValidationTuple> mapper, Resource[] dataGraph) {
        assert (!query.toLowerCase().contains("order by")) : "Queries with order by are not supported.";
        assert (query.trim().toLowerCase().contains("select ")) : "Expected query to contain select.";
        this.connection = connection;
        assert (this.connection != null);
        this.mapper = mapper;
        this.query = StatementMatcher.StableRandomVariableProvider.normalize(query);
        this.dataset = PlanNodeHelper.asDefaultGraphDataset(dataGraph);
        this.sorted = false;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            CloseableIteration<? extends BindingSet, QueryEvaluationException> bindingSet;

            @Override
            protected void init() {
                if (this.bindingSet != null) {
                    return;
                }
                try {
                    TupleExpr tupleExpr = SparqlQueryParserCache.get(Select.this.query);
                    this.bindingSet = Select.this.connection.evaluate(tupleExpr, Select.this.dataset, EmptyBindingSet.getInstance(), true);
                    if (logger.isTraceEnabled()) {
                        boolean hasNext = this.bindingSet.hasNext();
                        logger.trace("SPARQL query (hasNext={}) \n{}", (Object)hasNext, (Object)Formatter.formatSparqlQuery(Select.this.query));
                    }
                }
                catch (MalformedQueryException e) {
                    logger.error("Malformed query:\n{}", (Object)Select.this.query);
                    throw e;
                }
            }

            @Override
            public void localClose() {
                if (this.bindingSet != null) {
                    this.bindingSet.close();
                }
            }

            @Override
            protected boolean localHasNext() {
                return this.bindingSet.hasNext();
            }

            @Override
            protected ValidationTuple loggingNext() {
                return Select.this.mapper.apply((BindingSet)this.bindingSet.next());
            }
        };
    }

    @Override
    public int depth() {
        return 0;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        if (this.connection instanceof MemoryStoreConnection) {
            stringBuilder.append(System.identityHashCode(((MemoryStoreConnection)this.connection).getSail()) + " -> " + this.getId()).append("\n");
        } else {
            stringBuilder.append(System.identityHashCode(this.connection) + " -> " + this.getId()).append("\n");
        }
    }

    @Override
    public String getId() {
        return "" + System.identityHashCode(this);
    }

    public String toString() {
        return "Select{query='" + this.query.replace("\n", "  ") + "'}";
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
    }

    @Override
    public boolean producesSorted() {
        return this.sorted;
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Select that = (Select)o;
        if (this.connection instanceof MemoryStoreConnection && that.connection instanceof MemoryStoreConnection) {
            return this.sorted == that.sorted && ((MemoryStoreConnection)this.connection).getSail().equals(((MemoryStoreConnection)that.connection).getSail()) && this.mapper.equals(that.mapper) && this.dataset.equals(that.dataset) && this.query.equals(that.query);
        }
        return this.sorted == that.sorted && Objects.equals(this.connection, that.connection) && this.mapper.equals(that.mapper) && this.dataset.equals(that.dataset) && this.query.equals(that.query);
    }

    public int hashCode() {
        if (this.connection instanceof MemoryStoreConnection) {
            return Objects.hash(((MemoryStoreConnection)this.connection).getSail(), this.mapper, this.query, this.sorted, this.dataset);
        }
        return Objects.hash(this.connection, this.mapper, this.query, this.sorted, this.dataset);
    }
}

