/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.jsonld;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jsonldjava.core.DocumentLoader;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.core.JsonLdTripleCallback;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFParser;
import org.eclipse.rdf4j.rio.helpers.JSONSettings;
import org.eclipse.rdf4j.rio.jsonld.JSONLDInternalTripleCallback;
import org.eclipse.rdf4j.rio.jsonld.JSONLDSettings;

public class JSONLDParser
extends AbstractRDFParser {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    public JSONLDParser() {
    }

    public JSONLDParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.JSONLD;
    }

    public Collection<RioSetting<?>> getSupportedSettings() {
        Collection result = super.getSupportedSettings();
        result.add(JSONSettings.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER);
        result.add(JSONSettings.ALLOW_COMMENTS);
        result.add(JSONSettings.ALLOW_NON_NUMERIC_NUMBERS);
        result.add(JSONSettings.ALLOW_NUMERIC_LEADING_ZEROS);
        result.add(JSONSettings.ALLOW_SINGLE_QUOTES);
        result.add(JSONSettings.ALLOW_UNQUOTED_CONTROL_CHARS);
        result.add(JSONSettings.ALLOW_UNQUOTED_FIELD_NAMES);
        result.add(JSONSettings.ALLOW_YAML_COMMENTS);
        result.add(JSONSettings.ALLOW_TRAILING_COMMA);
        result.add(JSONSettings.INCLUDE_SOURCE_IN_LOCATION);
        result.add(JSONSettings.STRICT_DUPLICATE_DETECTION);
        result.add(JSONLDSettings.DOCUMENT_LOADER);
        return result;
    }

    public void parse(InputStream in, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        this.parse(in, null, baseURI);
    }

    public void parse(Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        this.parse(null, reader, baseURI);
    }

    private void parse(InputStream in, Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        this.clear();
        try {
            JSONLDInternalTripleCallback callback = new JSONLDInternalTripleCallback(this.getRDFHandler(), this.valueFactory, this.getParserConfig(), this.getParseErrorListener(), nodeID -> this.createNode((String)nodeID), () -> this.createNode());
            JsonLdOptions options = baseURI != null ? new JsonLdOptions(baseURI) : new JsonLdOptions();
            options.useNamespaces = true;
            DocumentLoader loader = (DocumentLoader)this.getParserConfig().get(JSONLDSettings.DOCUMENT_LOADER);
            if (loader != null) {
                options.setDocumentLoader(loader);
            }
            JsonFactory factory = this.configureNewJsonFactory();
            Object parsedJson = this.getJSONObject(in, reader, factory);
            JsonLdProcessor.toRDF((Object)parsedJson, (JsonLdTripleCallback)callback, (JsonLdOptions)options);
        }
        catch (JsonLdError e) {
            throw new RDFParseException("Could not parse JSONLD", (Throwable)e);
        }
        catch (JsonProcessingException e) {
            throw new RDFParseException("Could not parse JSONLD", (Throwable)e, (long)e.getLocation().getLineNr(), (long)e.getLocation().getColumnNr());
        }
        catch (RuntimeException e) {
            if (e.getCause() != null && e.getCause() instanceof RDFParseException) {
                throw (RDFParseException)e.getCause();
            }
            throw e;
        }
        finally {
            this.clear();
        }
    }

    protected Object getJSONObject(InputStream in, Reader reader, JsonFactory factory) throws IOException {
        JsonParser nextParser = in != null ? factory.createParser(in) : factory.createParser(reader);
        return JsonUtils.fromJsonParser((JsonParser)nextParser);
    }

    private JsonFactory configureNewJsonFactory() {
        JsonFactoryBuilder builder = new JsonFactoryBuilder();
        ParserConfig parserConfig = this.getParserConfig();
        if (parserConfig.isSet(JSONSettings.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER)) {
            builder.configure(JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, ((Boolean)parserConfig.get(JSONSettings.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER)).booleanValue());
        }
        if (parserConfig.isSet(JSONSettings.ALLOW_COMMENTS)) {
            builder.configure(JsonReadFeature.ALLOW_JAVA_COMMENTS, ((Boolean)parserConfig.get(JSONSettings.ALLOW_COMMENTS)).booleanValue());
        }
        if (parserConfig.isSet(JSONSettings.ALLOW_NON_NUMERIC_NUMBERS)) {
            builder.configure(JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS, ((Boolean)parserConfig.get(JSONSettings.ALLOW_NON_NUMERIC_NUMBERS)).booleanValue());
        }
        if (parserConfig.isSet(JSONSettings.ALLOW_NUMERIC_LEADING_ZEROS)) {
            builder.configure(JsonReadFeature.ALLOW_LEADING_ZEROS_FOR_NUMBERS, ((Boolean)parserConfig.get(JSONSettings.ALLOW_NUMERIC_LEADING_ZEROS)).booleanValue());
        }
        if (parserConfig.isSet(JSONSettings.ALLOW_SINGLE_QUOTES)) {
            builder.configure(JsonReadFeature.ALLOW_SINGLE_QUOTES, ((Boolean)parserConfig.get(JSONSettings.ALLOW_SINGLE_QUOTES)).booleanValue());
        }
        if (parserConfig.isSet(JSONSettings.ALLOW_UNQUOTED_CONTROL_CHARS)) {
            builder.configure(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS, ((Boolean)parserConfig.get(JSONSettings.ALLOW_UNQUOTED_CONTROL_CHARS)).booleanValue());
        }
        if (parserConfig.isSet(JSONSettings.ALLOW_UNQUOTED_FIELD_NAMES)) {
            builder.configure(JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES, ((Boolean)parserConfig.get(JSONSettings.ALLOW_UNQUOTED_FIELD_NAMES)).booleanValue());
        }
        if (parserConfig.isSet(JSONSettings.ALLOW_YAML_COMMENTS)) {
            builder.configure(JsonReadFeature.ALLOW_YAML_COMMENTS, ((Boolean)parserConfig.get(JSONSettings.ALLOW_YAML_COMMENTS)).booleanValue());
        }
        if (parserConfig.isSet(JSONSettings.ALLOW_TRAILING_COMMA)) {
            builder.configure(JsonReadFeature.ALLOW_TRAILING_COMMA, ((Boolean)parserConfig.get(JSONSettings.ALLOW_TRAILING_COMMA)).booleanValue());
        }
        if (parserConfig.isSet(JSONSettings.INCLUDE_SOURCE_IN_LOCATION)) {
            builder.configure(StreamReadFeature.INCLUDE_SOURCE_IN_LOCATION, ((Boolean)parserConfig.get(JSONSettings.INCLUDE_SOURCE_IN_LOCATION)).booleanValue());
        }
        if (parserConfig.isSet(JSONSettings.STRICT_DUPLICATE_DETECTION)) {
            builder.configure(StreamReadFeature.STRICT_DUPLICATE_DETECTION, ((Boolean)parserConfig.get(JSONSettings.STRICT_DUPLICATE_DETECTION)).booleanValue());
        }
        return builder.build().setCodec((ObjectCodec)JSON_MAPPER);
    }
}

