/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl;

import com.google.common.base.Stopwatch;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.DistinctIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.IterationWrapper;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.common.iteration.ReducedIteration;
import org.eclipse.rdf4j.common.iteration.SingletonIteration;
import org.eclipse.rdf4j.common.net.ParsedIRI;
import org.eclipse.rdf4j.common.transaction.QueryEvaluationMode;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MutableBindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.And;
import org.eclipse.rdf4j.query.algebra.ArbitraryLengthPath;
import org.eclipse.rdf4j.query.algebra.BNodeGenerator;
import org.eclipse.rdf4j.query.algebra.BinaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.BinaryValueOperator;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.Bound;
import org.eclipse.rdf4j.query.algebra.Coalesce;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.CompareAll;
import org.eclipse.rdf4j.query.algebra.CompareAny;
import org.eclipse.rdf4j.query.algebra.Datatype;
import org.eclipse.rdf4j.query.algebra.DescribeOperator;
import org.eclipse.rdf4j.query.algebra.Difference;
import org.eclipse.rdf4j.query.algebra.Distinct;
import org.eclipse.rdf4j.query.algebra.EmptySet;
import org.eclipse.rdf4j.query.algebra.Exists;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.FunctionCall;
import org.eclipse.rdf4j.query.algebra.Group;
import org.eclipse.rdf4j.query.algebra.IRIFunction;
import org.eclipse.rdf4j.query.algebra.If;
import org.eclipse.rdf4j.query.algebra.In;
import org.eclipse.rdf4j.query.algebra.Intersection;
import org.eclipse.rdf4j.query.algebra.IsBNode;
import org.eclipse.rdf4j.query.algebra.IsLiteral;
import org.eclipse.rdf4j.query.algebra.IsNumeric;
import org.eclipse.rdf4j.query.algebra.IsResource;
import org.eclipse.rdf4j.query.algebra.IsURI;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.Label;
import org.eclipse.rdf4j.query.algebra.Lang;
import org.eclipse.rdf4j.query.algebra.LangMatches;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.Like;
import org.eclipse.rdf4j.query.algebra.ListMemberOperator;
import org.eclipse.rdf4j.query.algebra.LocalName;
import org.eclipse.rdf4j.query.algebra.MathExpr;
import org.eclipse.rdf4j.query.algebra.MultiProjection;
import org.eclipse.rdf4j.query.algebra.Namespace;
import org.eclipse.rdf4j.query.algebra.Not;
import org.eclipse.rdf4j.query.algebra.Or;
import org.eclipse.rdf4j.query.algebra.Order;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryRoot;
import org.eclipse.rdf4j.query.algebra.Reduced;
import org.eclipse.rdf4j.query.algebra.Regex;
import org.eclipse.rdf4j.query.algebra.SameTerm;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.SingletonSet;
import org.eclipse.rdf4j.query.algebra.Slice;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Str;
import org.eclipse.rdf4j.query.algebra.TripleRef;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.TupleFunctionCall;
import org.eclipse.rdf4j.query.algebra.UnaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.UnaryValueOperator;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.ValueExprTripleRef;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.ZeroLengthPath;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizerPipeline;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.RDFStarTripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedService;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolverClient;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.function.FunctionRegistry;
import org.eclipse.rdf4j.query.algebra.evaluation.function.TupleFunction;
import org.eclipse.rdf4j.query.algebra.evaluation.function.TupleFunctionRegistry;
import org.eclipse.rdf4j.query.algebra.evaluation.function.datetime.Now;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ArrayBindingBasedQueryEvaluationContext;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ExtensionQueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.BindingSetAssignmentQueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.IntersectionQueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.JoinQueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.LeftJoinQueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.MinusQueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.OrderQueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.ProjectionQueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.RdfStarQueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.RegexValueEvaluationStepSupplier;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.ReificationRdfStarQueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.ServiceQueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.SliceQueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.StatementPatternQueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.UnionQueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.ZeroLengthPathEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.DescribeIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.ExtensionIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.FilterIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.GroupIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.MultiProjectionIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.PathIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.StandardQueryOptimizerPipeline;
import org.eclipse.rdf4j.query.algebra.evaluation.util.MathUtil;
import org.eclipse.rdf4j.query.algebra.evaluation.util.OrderComparator;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtil;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtility;
import org.eclipse.rdf4j.query.algebra.evaluation.util.ValueComparator;
import org.eclipse.rdf4j.query.algebra.evaluation.util.XMLDatatypeMathUtil;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.util.UUIDable;

public class DefaultEvaluationStrategy
implements EvaluationStrategy,
FederatedServiceResolverClient,
UUIDable {
    protected final TripleSource tripleSource;
    protected final Dataset dataset;
    protected FederatedServiceResolver serviceResolver;
    private Literal sharedValueOfNow;
    private final long iterationCacheSyncThreshold;
    private boolean trackResultSize;
    private boolean trackTime;
    private UUID uuid;
    private QueryOptimizerPipeline pipeline;
    private final TupleFunctionRegistry tupleFuncRegistry;
    private QueryEvaluationMode queryEvaluationMode;

    static CloseableIteration<BindingSet, QueryEvaluationException> evaluate(TupleFunction func, final List<Var> resultVars, final BindingSet bindings, ValueFactory valueFactory, Value ... argValues) throws QueryEvaluationException {
        final CloseableIteration<? extends List<? extends Value>, QueryEvaluationException> iter = func.evaluate(valueFactory, argValues);
        return new LookAheadIteration<BindingSet, QueryEvaluationException>(){

            @Override
            public BindingSet getNextElement() throws QueryEvaluationException {
                QueryBindingSet resultBindings = null;
                block0: while (resultBindings == null && iter.hasNext()) {
                    resultBindings = new QueryBindingSet(bindings);
                    List values = (List)iter.next();
                    if (resultVars.size() != values.size()) {
                        throw new QueryEvaluationException("Incorrect number of result vars: require " + values.size());
                    }
                    for (int i = 0; i < values.size(); ++i) {
                        Value result = (Value)values.get(i);
                        Var resultVar = (Var)resultVars.get(i);
                        Value varValue = resultVar.getValue();
                        String varName = resultVar.getName();
                        Value boundValue = bindings.getValue(varName);
                        if ((varValue == null || result.equals(varValue)) && (boundValue == null || result.equals(boundValue))) {
                            if (boundValue != null) continue;
                            resultBindings.addBinding(varName, result);
                            continue;
                        }
                        resultBindings = null;
                        continue block0;
                    }
                }
                return resultBindings;
            }

            @Override
            protected void handleClose() throws QueryEvaluationException {
                try {
                    super.handleClose();
                }
                finally {
                    iter.close();
                }
            }
        };
    }

    public DefaultEvaluationStrategy(TripleSource tripleSource, FederatedServiceResolver serviceResolver) {
        this(tripleSource, null, serviceResolver);
    }

    public DefaultEvaluationStrategy(TripleSource tripleSource, Dataset dataset, FederatedServiceResolver serviceResolver) {
        this(tripleSource, dataset, serviceResolver, 0L, new EvaluationStatistics());
    }

    public DefaultEvaluationStrategy(TripleSource tripleSource, Dataset dataset, FederatedServiceResolver serviceResolver, long iterationCacheSyncTreshold, EvaluationStatistics evaluationStatistics) {
        this(tripleSource, dataset, serviceResolver, iterationCacheSyncTreshold, evaluationStatistics, false);
    }

    public DefaultEvaluationStrategy(TripleSource tripleSource, Dataset dataset, FederatedServiceResolver serviceResolver, long iterationCacheSyncTreshold, EvaluationStatistics evaluationStatistics, boolean trackResultSize) {
        this(tripleSource, dataset, serviceResolver, iterationCacheSyncTreshold, evaluationStatistics, trackResultSize, TupleFunctionRegistry.getInstance());
    }

    public DefaultEvaluationStrategy(TripleSource tripleSource, Dataset dataset, FederatedServiceResolver serviceResolver, long iterationCacheSyncTreshold, EvaluationStatistics evaluationStatistics, boolean trackResultSize, TupleFunctionRegistry tupleFunctionRegistry) {
        this.tripleSource = tripleSource;
        this.dataset = dataset;
        this.serviceResolver = serviceResolver;
        this.iterationCacheSyncThreshold = iterationCacheSyncTreshold;
        this.pipeline = new StandardQueryOptimizerPipeline(this, tripleSource, evaluationStatistics);
        this.trackResultSize = trackResultSize;
        this.tupleFuncRegistry = tupleFunctionRegistry;
        this.setQueryEvaluationMode(QueryEvaluationMode.STANDARD);
    }

    @Override
    @Deprecated(forRemoval=true, since="4.0.0")
    public synchronized UUID getUUID() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
        }
        return this.uuid;
    }

    @Override
    public void setFederatedServiceResolver(FederatedServiceResolver resolver) {
        this.serviceResolver = resolver;
    }

    @Override
    public FederatedServiceResolver getFederatedServiceResolver() {
        return this.serviceResolver;
    }

    @Override
    public FederatedService getService(String serviceUrl) throws QueryEvaluationException {
        return this.serviceResolver.getService(serviceUrl);
    }

    @Override
    public void setOptimizerPipeline(QueryOptimizerPipeline pipeline) {
        Objects.requireNonNull(pipeline);
        this.pipeline = pipeline;
    }

    @Override
    public TupleExpr optimize(TupleExpr expr, EvaluationStatistics evaluationStatistics, BindingSet bindings) {
        for (QueryOptimizer optimizer : this.pipeline.getOptimizers()) {
            optimizer.optimize(expr, this.dataset, bindings);
        }
        return expr;
    }

    @Override
    @Deprecated(forRemoval=true)
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(TupleExpr expr, BindingSet bindings) throws QueryEvaluationException {
        CloseableIteration<BindingSet, QueryEvaluationException> ret;
        if (expr instanceof StatementPattern) {
            ret = this.evaluate((StatementPattern)expr, bindings);
        } else if (expr instanceof UnaryTupleOperator) {
            ret = this.evaluate((UnaryTupleOperator)expr, bindings);
        } else if (expr instanceof BinaryTupleOperator) {
            ret = this.evaluate((BinaryTupleOperator)expr, bindings);
        } else if (expr instanceof SingletonSet) {
            ret = this.evaluate((SingletonSet)expr, bindings);
        } else if (expr instanceof EmptySet) {
            ret = this.evaluate((EmptySet)expr, bindings);
        } else if (expr instanceof ZeroLengthPath) {
            ret = this.evaluate((ZeroLengthPath)expr, bindings);
        } else if (expr instanceof ArbitraryLengthPath) {
            ret = this.evaluate((ArbitraryLengthPath)expr, bindings);
        } else if (expr instanceof BindingSetAssignment) {
            ret = this.evaluate((BindingSetAssignment)expr, bindings);
        } else if (expr instanceof TripleRef) {
            ret = this.evaluate((TripleRef)expr, bindings);
        } else {
            if (expr instanceof TupleFunctionCall) {
                if (this.getQueryEvaluationMode().compareTo(QueryEvaluationMode.STANDARD) < 0) {
                    throw new QueryEvaluationException("Tuple function call not supported in query evaluation mode " + this.getQueryEvaluationMode());
                }
                return this.evaluate((TupleFunctionCall)expr, bindings);
            }
            if (expr == null) {
                throw new IllegalArgumentException("expr must not be null");
            }
            throw new QueryEvaluationException("Unsupported tuple expr type: " + expr.getClass());
        }
        if (this.trackTime) {
            expr.setTotalTimeNanosActual(Math.max(0L, expr.getTotalTimeNanosActual()));
            ret = new TimedIterator(ret, expr);
        }
        if (this.trackResultSize) {
            expr.setResultSizeActual(Math.max(0L, expr.getResultSizeActual()));
            ret = new ResultSizeCountingIterator(ret, expr);
        }
        return ret;
    }

    @Override
    public QueryEvaluationStep precompile(TupleExpr expr) {
        QueryEvaluationContext context = new QueryEvaluationContext.Minimal(this.dataset, this.tripleSource.getValueFactory());
        if (expr instanceof QueryRoot) {
            String[] allVariables = ArrayBindingBasedQueryEvaluationContext.findAllVariablesUsedInQuery((QueryRoot)expr);
            context = new ArrayBindingBasedQueryEvaluationContext(context, allVariables);
        }
        return this.precompile(expr, context);
    }

    @Override
    public QueryEvaluationStep precompile(TupleExpr expr, QueryEvaluationContext context) {
        QueryEvaluationStep ret;
        if (expr instanceof StatementPattern) {
            ret = this.prepare((StatementPattern)expr, context);
        } else if (expr instanceof UnaryTupleOperator) {
            ret = this.prepare((UnaryTupleOperator)expr, context);
        } else if (expr instanceof BinaryTupleOperator) {
            ret = this.prepare((BinaryTupleOperator)expr, context);
        } else if (expr instanceof SingletonSet) {
            ret = this.prepare((SingletonSet)expr, context);
        } else if (expr instanceof EmptySet) {
            ret = this.prepare((EmptySet)expr, context);
        } else if (expr instanceof ZeroLengthPath) {
            ret = this.prepare((ZeroLengthPath)expr, context);
        } else if (expr instanceof ArbitraryLengthPath) {
            ret = this.prepare((ArbitraryLengthPath)expr, context);
        } else if (expr instanceof BindingSetAssignment) {
            ret = this.prepare((BindingSetAssignment)expr, context);
        } else if (expr instanceof TripleRef) {
            ret = this.prepare((TripleRef)expr, context);
        } else if (expr instanceof TupleFunctionCall) {
            ret = this.prepare((TupleFunctionCall)expr, context);
        } else {
            if (expr == null) {
                throw new IllegalArgumentException("expr must not be null");
            }
            throw new QueryEvaluationException("Unsupported tuple expr type: " + expr.getClass());
        }
        if (ret != null) {
            if (this.trackTime) {
                ret = this.trackTime(expr, ret);
            }
            if (this.trackResultSize) {
                ret = this.trackResultSize(expr, ret);
            }
            return ret;
        }
        return EvaluationStrategy.super.precompile(expr, context);
    }

    private QueryEvaluationStep trackResultSize(TupleExpr expr, QueryEvaluationStep qes) {
        return QueryEvaluationStep.wrap(qes, iter -> {
            expr.setResultSizeActual(Math.max(0L, expr.getResultSizeActual()));
            return new ResultSizeCountingIterator((CloseableIteration<BindingSet, QueryEvaluationException>)iter, expr);
        });
    }

    private QueryEvaluationStep trackTime(TupleExpr expr, QueryEvaluationStep qes) {
        return QueryEvaluationStep.wrap(qes, iter -> {
            expr.setTotalTimeNanosActual(Math.max(0L, expr.getTotalTimeNanosActual()));
            return new TimedIterator((CloseableIteration<BindingSet, QueryEvaluationException>)iter, expr);
        });
    }

    @Deprecated(forRemoval=true)
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(ArbitraryLengthPath alp, BindingSet bindings) throws QueryEvaluationException {
        return this.precompile(alp).evaluate(bindings);
    }

    protected QueryEvaluationStep prepare(ArbitraryLengthPath alp, QueryEvaluationContext context) throws QueryEvaluationException {
        final StatementPattern.Scope scope = alp.getScope();
        final Var subjectVar = alp.getSubjectVar();
        final TupleExpr pathExpression = alp.getPathExpression();
        final Var objVar = alp.getObjectVar();
        final Var contextVar = alp.getContextVar();
        final long minLength = alp.getMinLength();
        return new QueryEvaluationStep(){

            @Override
            public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindings) {
                return new PathIteration(DefaultEvaluationStrategy.this, scope, subjectVar, pathExpression, objVar, contextVar, minLength, bindings);
            }
        };
    }

    @Deprecated(forRemoval=true)
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(ZeroLengthPath zlp, BindingSet bindings) throws QueryEvaluationException {
        return this.precompile(zlp).evaluate(bindings);
    }

    protected QueryEvaluationStep prepare(ZeroLengthPath zlp, QueryEvaluationContext context) throws QueryEvaluationException {
        Var subjectVar = zlp.getSubjectVar();
        Var objVar = zlp.getObjectVar();
        Var contextVar = zlp.getContextVar();
        QueryValueEvaluationStep subPrep = this.precompile(subjectVar, context);
        QueryValueEvaluationStep objPrep = this.precompile(objVar, context);
        return new ZeroLengthPathEvaluationStep(subjectVar, objVar, contextVar, subPrep, objPrep, this, context);
    }

    @Override
    @Deprecated(forRemoval=true)
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Service service, String serviceUri, CloseableIteration<BindingSet, QueryEvaluationException> bindings) throws QueryEvaluationException {
        try {
            FederatedService fs = this.serviceResolver.getService(serviceUri);
            return fs.evaluate(service, bindings, service.getBaseURI());
        }
        catch (QueryEvaluationException e) {
            if (service.isSilent()) {
                return bindings;
            }
            throw new QueryEvaluationException(e);
        }
    }

    @Deprecated(forRemoval=true)
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Service service, BindingSet bindings) throws QueryEvaluationException {
        return this.precompile(service).evaluate(bindings);
    }

    protected QueryEvaluationStep prepare(Difference node, QueryEvaluationContext context) throws QueryEvaluationException {
        return new MinusQueryEvaluationStep(this.precompile(node.getLeftArg(), context), this.precompile(node.getRightArg(), context));
    }

    protected QueryEvaluationStep prepare(final Group node, final QueryEvaluationContext context) throws QueryEvaluationException {
        return new QueryEvaluationStep(){

            @Override
            public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindings) {
                return new GroupIterator(DefaultEvaluationStrategy.this, node, bindings, DefaultEvaluationStrategy.this.iterationCacheSyncThreshold, context);
            }
        };
    }

    protected QueryEvaluationStep prepare(Intersection node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryEvaluationStep leftArg = this.precompile(node.getLeftArg(), context);
        QueryEvaluationStep rightArg = this.precompile(node.getRightArg(), context);
        return new IntersectionQueryEvaluationStep(leftArg, rightArg, this::makeSet);
    }

    protected QueryEvaluationStep prepare(Join node, QueryEvaluationContext context) throws QueryEvaluationException {
        return new JoinQueryEvaluationStep(this, node, context);
    }

    protected QueryEvaluationStep prepare(LeftJoin node, QueryEvaluationContext context) throws QueryEvaluationException {
        return LeftJoinQueryEvaluationStep.supply(this, node, context);
    }

    protected QueryEvaluationStep prepare(final MultiProjection node, QueryEvaluationContext context) throws QueryEvaluationException {
        final QueryEvaluationStep arg = this.precompile(node.getArg(), context);
        return new QueryEvaluationStep(){

            @Override
            public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindings) {
                return new MultiProjectionIterator(node, arg.evaluate(bindings), bindings);
            }
        };
    }

    protected QueryEvaluationStep prepare(Projection node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryEvaluationStep temp = this.precompile(node.getArg(), context);
        return new ProjectionQueryEvaluationStep(node, temp, context);
    }

    protected QueryEvaluationStep prepare(QueryRoot node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryEvaluationStep arg = this.precompile(node.getArg(), context);
        return new QueryRootQueryEvaluationStep(arg);
    }

    protected QueryEvaluationStep prepare(StatementPattern node, QueryEvaluationContext context) throws QueryEvaluationException {
        return new StatementPatternQueryEvaluationStep(node, context, this.tripleSource);
    }

    protected QueryEvaluationStep prepare(Union node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryEvaluationStep leftQes = this.precompile(node.getLeftArg(), context);
        QueryEvaluationStep rightQes = this.precompile(node.getRightArg(), context);
        return new UnionQueryEvaluationStep(leftQes, rightQes);
    }

    protected QueryEvaluationStep prepare(Slice node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryEvaluationStep arg = this.precompile(node.getArg(), context);
        return SliceQueryEvaluationStep.supply(node, arg);
    }

    protected QueryEvaluationStep prepare(Extension node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryEvaluationStep arg = this.precompile(node.getArg(), context);
        Consumer<MutableBindingSet> consumer = ExtensionIterator.buildLambdaToEvaluateTheExpressions(node, this, context);
        return new ExtensionQueryEvaluationStep(arg, consumer, context);
    }

    protected QueryEvaluationStep prepare(Service service, QueryEvaluationContext context) throws QueryEvaluationException {
        Var serviceRef = service.getServiceRef();
        return new ServiceQueryEvaluationStep(service, serviceRef, this.serviceResolver);
    }

    protected QueryEvaluationStep prepare(final Filter node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryValueEvaluationStep ves;
        final QueryEvaluationStep arg = this.precompile(node.getArg(), context);
        try {
            ves = this.precompile(node.getCondition(), context);
        }
        catch (QueryEvaluationException e) {
            return new QueryEvaluationStep(){

                @Override
                public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bs) {
                    return new EmptyIteration<BindingSet, QueryEvaluationException>();
                }
            };
        }
        return new QueryEvaluationStep(){

            @Override
            public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bs) {
                return new FilterIterator(node, arg.evaluate(bs), ves, DefaultEvaluationStrategy.this);
            }
        };
    }

    protected QueryEvaluationStep prepare(Order node, QueryEvaluationContext context) throws QueryEvaluationException {
        ValueComparator vcmp = new ValueComparator();
        OrderComparator cmp = new OrderComparator(this, node, vcmp, context);
        boolean reduced = this.isReducedOrDistinct(node);
        long limit = this.getLimit(node);
        QueryEvaluationStep preparedArg = this.precompile(node.getArg(), context);
        return new OrderQueryEvaluationStep(cmp, limit, reduced, preparedArg, this.iterationCacheSyncThreshold);
    }

    protected QueryEvaluationStep prepare(BindingSetAssignment node, QueryEvaluationContext context) throws QueryEvaluationException {
        return new BindingSetAssignmentQueryEvaluationStep(node, context);
    }

    protected QueryEvaluationStep prepare(final DescribeOperator node, QueryEvaluationContext context) throws QueryEvaluationException {
        final QueryEvaluationStep child = this.precompile(node.getArg(), context);
        return new QueryEvaluationStep(){

            @Override
            public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bs) {
                return new DescribeIteration(child.evaluate(bs), DefaultEvaluationStrategy.this, node.getBindingNames(), bs);
            }
        };
    }

    protected QueryEvaluationStep prepare(Distinct node, QueryEvaluationContext context) throws QueryEvaluationException {
        final QueryEvaluationStep child = this.precompile(node.getArg(), context);
        return new QueryEvaluationStep(){

            @Override
            public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindings) {
                CloseableIteration<BindingSet, QueryEvaluationException> evaluate = child.evaluate(bindings);
                return new DistinctIteration<BindingSet, QueryEvaluationException>(evaluate, DefaultEvaluationStrategy.this::makeSet);
            }
        };
    }

    protected QueryEvaluationStep prepare(Reduced node, QueryEvaluationContext context) throws QueryEvaluationException {
        final QueryEvaluationStep arg = this.precompile(node.getArg(), context);
        return new QueryEvaluationStep(){

            @Override
            public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindings) {
                return new ReducedIteration<BindingSet, QueryEvaluationException>(arg.evaluate(bindings));
            }
        };
    }

    protected QueryEvaluationStep prepare(final TupleFunctionCall expr, QueryEvaluationContext context) throws QueryEvaluationException {
        final TupleFunction func = (TupleFunction)this.tupleFuncRegistry.get(expr.getURI()).orElseThrow(() -> new QueryEvaluationException("Unknown tuple function '" + expr.getURI() + "'"));
        final List<ValueExpr> args = expr.getArgs();
        final QueryValueEvaluationStep[] argEpresions = new QueryValueEvaluationStep[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            argEpresions[i] = this.precompile(args.get(i), context);
        }
        return new QueryEvaluationStep(){

            @Override
            public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindings) {
                Value[] argValues = new Value[args.size()];
                for (int i = 0; i < args.size(); ++i) {
                    argValues[i] = argEpresions[i].evaluate(bindings);
                }
                return DefaultEvaluationStrategy.evaluate(func, expr.getResultVars(), bindings, DefaultEvaluationStrategy.this.tripleSource.getValueFactory(), argValues);
            }
        };
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(DescribeOperator operator, BindingSet bindings) throws QueryEvaluationException {
        return this.precompile(operator).evaluate(bindings);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(StatementPattern statementPattern, BindingSet bindings) throws QueryEvaluationException {
        return this.precompile(statementPattern).evaluate(bindings);
    }

    public static Value getVarValue(Var var, BindingSet bindings) {
        if (var == null) {
            return null;
        }
        if (var.hasValue()) {
            return var.getValue();
        }
        return bindings.getValue(var.getName());
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(UnaryTupleOperator expr, BindingSet bindings) throws QueryEvaluationException {
        if (expr instanceof Projection) {
            return this.evaluate((Projection)expr, bindings);
        }
        if (expr instanceof MultiProjection) {
            return this.evaluate((MultiProjection)expr, bindings);
        }
        if (expr instanceof Filter) {
            return this.evaluate((Filter)expr, bindings);
        }
        if (expr instanceof Service) {
            return this.evaluate((Service)expr, bindings);
        }
        if (expr instanceof Slice) {
            return this.evaluate((Slice)expr, bindings);
        }
        if (expr instanceof Extension) {
            return this.evaluate((Extension)expr, bindings);
        }
        if (expr instanceof Distinct) {
            return this.evaluate((Distinct)expr, bindings);
        }
        if (expr instanceof Reduced) {
            return this.evaluate((Reduced)expr, bindings);
        }
        if (expr instanceof Group) {
            return this.evaluate((Group)expr, bindings);
        }
        if (expr instanceof Order) {
            return this.evaluate((Order)expr, bindings);
        }
        if (expr instanceof QueryRoot) {
            this.sharedValueOfNow = null;
            return this.evaluate(expr.getArg(), bindings);
        }
        if (expr instanceof DescribeOperator) {
            return this.evaluate((DescribeOperator)expr, bindings);
        }
        if (expr == null) {
            throw new IllegalArgumentException("expr must not be null");
        }
        throw new QueryEvaluationException("Unknown unary tuple operator type: " + expr.getClass());
    }

    protected QueryEvaluationStep prepare(UnaryTupleOperator expr, QueryEvaluationContext context) throws QueryEvaluationException {
        if (expr instanceof Projection) {
            return this.prepare((Projection)expr, context);
        }
        if (expr instanceof MultiProjection) {
            return this.prepare((MultiProjection)expr, context);
        }
        if (expr instanceof Filter) {
            return this.prepare((Filter)expr, context);
        }
        if (expr instanceof Service) {
            return this.prepare((Service)expr, context);
        }
        if (expr instanceof Slice) {
            return this.prepare((Slice)expr, context);
        }
        if (expr instanceof Extension) {
            return this.prepare((Extension)expr, context);
        }
        if (expr instanceof Distinct) {
            return this.prepare((Distinct)expr, context);
        }
        if (expr instanceof Reduced) {
            return this.prepare((Reduced)expr, context);
        }
        if (expr instanceof Group) {
            return this.prepare((Group)expr, context);
        }
        if (expr instanceof Order) {
            return this.prepare((Order)expr, context);
        }
        if (expr instanceof QueryRoot) {
            this.sharedValueOfNow = null;
            return this.precompile(expr.getArg(), context);
        }
        if (expr instanceof DescribeOperator) {
            return this.prepare((DescribeOperator)expr, context);
        }
        if (expr == null) {
            throw new IllegalArgumentException("expr must not be null");
        }
        throw new QueryEvaluationException("Unknown unary tuple operator type: " + expr.getClass());
    }

    @Deprecated(forRemoval=true)
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSetAssignment bsa, BindingSet bindings) throws QueryEvaluationException {
        return this.precompile(bsa).evaluate(bindings);
    }

    @Deprecated(forRemoval=true)
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Projection projection, BindingSet bindings) throws QueryEvaluationException {
        return this.precompile(projection).evaluate(bindings);
    }

    @Deprecated(forRemoval=true)
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(MultiProjection multiProjection, BindingSet bindings) throws QueryEvaluationException {
        return this.precompile(multiProjection).evaluate(bindings);
    }

    @Deprecated(forRemoval=true)
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Filter filter, BindingSet bindings) throws QueryEvaluationException {
        return this.precompile(filter).evaluate(bindings);
    }

    @Deprecated(forRemoval=true)
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Slice slice, BindingSet bindings) throws QueryEvaluationException {
        return this.precompile(slice).evaluate(bindings);
    }

    @Deprecated(forRemoval=true)
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Extension extension, BindingSet bindings) throws QueryEvaluationException {
        return this.precompile(extension).evaluate(bindings);
    }

    @Deprecated(forRemoval=true)
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Distinct distinct, BindingSet bindings) throws QueryEvaluationException {
        return this.precompile(distinct).evaluate(bindings);
    }

    @Deprecated(forRemoval=true)
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Reduced reduced, BindingSet bindings) throws QueryEvaluationException {
        return new ReducedIteration<BindingSet, QueryEvaluationException>(this.evaluate(reduced.getArg(), bindings));
    }

    @Deprecated(forRemoval=true)
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Group node, BindingSet bindings) throws QueryEvaluationException {
        return this.precompile(node).evaluate(bindings);
    }

    @Deprecated(forRemoval=true)
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Order node, BindingSet bindings) throws QueryEvaluationException {
        return this.precompile(node).evaluate(bindings);
    }

    @Deprecated(forRemoval=true)
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BinaryTupleOperator expr, BindingSet bindings) throws QueryEvaluationException {
        if (expr instanceof Join) {
            return this.evaluate((Join)expr, bindings);
        }
        if (expr instanceof LeftJoin) {
            return this.evaluate((LeftJoin)expr, bindings);
        }
        if (expr instanceof Union) {
            return this.evaluate((Union)expr, bindings);
        }
        if (expr instanceof Intersection) {
            return this.evaluate((Intersection)expr, bindings);
        }
        if (expr instanceof Difference) {
            return this.evaluate((Difference)expr, bindings);
        }
        if (expr == null) {
            throw new IllegalArgumentException("expr must not be null");
        }
        throw new QueryEvaluationException("Unsupported binary tuple operator type: " + expr.getClass());
    }

    protected QueryEvaluationStep prepare(BinaryTupleOperator expr, QueryEvaluationContext context) throws QueryEvaluationException {
        if (expr instanceof Join) {
            return this.prepare((Join)expr, context);
        }
        if (expr instanceof LeftJoin) {
            return this.prepare((LeftJoin)expr, context);
        }
        if (expr instanceof Union) {
            return this.prepare((Union)expr, context);
        }
        if (expr instanceof Intersection) {
            return this.prepare((Intersection)expr, context);
        }
        if (expr instanceof Difference) {
            return this.prepare((Difference)expr, context);
        }
        if (expr == null) {
            throw new IllegalArgumentException("expr must not be null");
        }
        throw new QueryEvaluationException("Unsupported binary tuple operator type: " + expr.getClass());
    }

    @Deprecated(forRemoval=true)
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Join join, BindingSet bindings) throws QueryEvaluationException {
        return this.precompile(join).evaluate(bindings);
    }

    @Deprecated(forRemoval=true)
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(LeftJoin leftJoin, BindingSet bindings) throws QueryEvaluationException {
        return this.precompile(leftJoin).evaluate(bindings);
    }

    @Deprecated(forRemoval=true)
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Union union, BindingSet bindings) throws QueryEvaluationException {
        return this.precompile(union).evaluate(bindings);
    }

    @Deprecated(forRemoval=true)
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Intersection intersection, BindingSet bindings) throws QueryEvaluationException {
        return this.precompile(intersection).evaluate(bindings);
    }

    @Deprecated(forRemoval=true)
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Difference difference, BindingSet bindings) throws QueryEvaluationException {
        return this.precompile(difference).evaluate(bindings);
    }

    @Deprecated(forRemoval=true)
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(SingletonSet singletonSet, BindingSet bindings) throws QueryEvaluationException {
        return new SingletonIteration<BindingSet, QueryEvaluationException>(bindings);
    }

    protected QueryEvaluationStep prepare(SingletonSet singletonSet, QueryEvaluationContext context) throws QueryEvaluationException {
        return new QueryEvaluationStep(){

            @Override
            public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindings) {
                return new SingletonIteration<BindingSet, QueryEvaluationException>(bindings);
            }
        };
    }

    @Deprecated(forRemoval=true)
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(EmptySet emptySet, BindingSet bindings) throws QueryEvaluationException {
        return new EmptyIteration<BindingSet, QueryEvaluationException>();
    }

    protected QueryEvaluationStep prepare(EmptySet emptySet, QueryEvaluationContext context) throws QueryEvaluationException {
        return new QueryEvaluationStep(){

            @Override
            public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindings) {
                return new EmptyIteration<BindingSet, QueryEvaluationException>();
            }
        };
    }

    @Override
    public QueryValueEvaluationStep precompile(ValueExpr expr, QueryEvaluationContext context) throws QueryEvaluationException {
        if (expr instanceof Var) {
            return this.prepare((Var)expr, context);
        }
        if (expr instanceof ValueConstant) {
            return this.prepare((ValueConstant)expr, context);
        }
        if (expr instanceof BNodeGenerator) {
            return new QueryValueEvaluationStep.Minimal(this, expr);
        }
        if (expr instanceof Bound) {
            return this.prepare((Bound)expr, context);
        }
        if (expr instanceof Str) {
            return new QueryValueEvaluationStep.Minimal(this, expr);
        }
        if (expr instanceof Label) {
            return new QueryValueEvaluationStep.Minimal(this, expr);
        }
        if (expr instanceof Lang) {
            return new QueryValueEvaluationStep.Minimal(this, expr);
        }
        if (expr instanceof LangMatches) {
            return this.prepare((LangMatches)expr, context);
        }
        if (expr instanceof Datatype) {
            return new QueryValueEvaluationStep.Minimal(this, expr);
        }
        if (expr instanceof Namespace) {
            return new QueryValueEvaluationStep.Minimal(this, expr);
        }
        if (expr instanceof LocalName) {
            return new QueryValueEvaluationStep.Minimal(this, expr);
        }
        if (expr instanceof IsResource) {
            return new QueryValueEvaluationStep.Minimal(this, expr);
        }
        if (expr instanceof IsURI) {
            return new QueryValueEvaluationStep.Minimal(this, expr);
        }
        if (expr instanceof IsBNode) {
            return new QueryValueEvaluationStep.Minimal(this, expr);
        }
        if (expr instanceof IsLiteral) {
            return new QueryValueEvaluationStep.Minimal(this, expr);
        }
        if (expr instanceof IsNumeric) {
            return new QueryValueEvaluationStep.Minimal(this, expr);
        }
        if (expr instanceof IRIFunction) {
            return new QueryValueEvaluationStep.Minimal(this, expr);
        }
        if (expr instanceof Regex) {
            return this.prepare((Regex)expr, context);
        }
        if (expr instanceof Coalesce) {
            return new QueryValueEvaluationStep.Minimal(this, expr);
        }
        if (expr instanceof Like) {
            return new QueryValueEvaluationStep.Minimal(this, expr);
        }
        if (expr instanceof FunctionCall) {
            return new QueryValueEvaluationStep.Minimal(this, expr);
        }
        if (expr instanceof And) {
            return new QueryValueEvaluationStep.Minimal(this, expr);
        }
        if (expr instanceof Or) {
            return new QueryValueEvaluationStep.Minimal(this, expr);
        }
        if (expr instanceof Not) {
            return this.prepare((Not)expr, context);
        }
        if (expr instanceof SameTerm) {
            return this.prepare((SameTerm)expr, context);
        }
        if (expr instanceof Compare) {
            return this.prepare((Compare)expr, context);
        }
        if (expr instanceof MathExpr) {
            return this.prepare((MathExpr)expr, context);
        }
        if (expr instanceof In) {
            return new QueryValueEvaluationStep.Minimal(this, expr);
        }
        if (expr instanceof CompareAny) {
            return new QueryValueEvaluationStep.Minimal(this, expr);
        }
        if (expr instanceof CompareAll) {
            return new QueryValueEvaluationStep.Minimal(this, expr);
        }
        if (expr instanceof Exists) {
            return new QueryValueEvaluationStep.Minimal(this, expr);
        }
        if (expr instanceof If) {
            return new QueryValueEvaluationStep.Minimal(this, expr);
        }
        if (expr instanceof ListMemberOperator) {
            return new QueryValueEvaluationStep.Minimal(this, expr);
        }
        if (expr instanceof ValueExprTripleRef) {
            return new QueryValueEvaluationStep.Minimal(this, expr);
        }
        if (expr == null) {
            throw new IllegalArgumentException("expr must not be null");
        }
        throw new QueryEvaluationException("Unsupported value expr type: " + expr.getClass());
    }

    @Override
    @Deprecated(forRemoval=true)
    public Value evaluate(ValueExpr expr, BindingSet bindings) throws QueryEvaluationException {
        if (expr instanceof Var) {
            return this.evaluate((Var)expr, bindings);
        }
        if (expr instanceof ValueConstant) {
            return this.evaluate((ValueConstant)expr, bindings);
        }
        if (expr instanceof BNodeGenerator) {
            return this.evaluate((BNodeGenerator)expr, bindings);
        }
        if (expr instanceof Bound) {
            return this.evaluate((Bound)expr, bindings);
        }
        if (expr instanceof Str) {
            return this.evaluate((Str)expr, bindings);
        }
        if (expr instanceof Label) {
            return this.evaluate((Label)expr, bindings);
        }
        if (expr instanceof Lang) {
            return this.evaluate((Lang)expr, bindings);
        }
        if (expr instanceof LangMatches) {
            return this.evaluate((LangMatches)expr, bindings);
        }
        if (expr instanceof Datatype) {
            return this.evaluate((Datatype)expr, bindings);
        }
        if (expr instanceof Namespace) {
            return this.evaluate((Namespace)expr, bindings);
        }
        if (expr instanceof LocalName) {
            return this.evaluate((LocalName)expr, bindings);
        }
        if (expr instanceof IsResource) {
            return this.evaluate((IsResource)expr, bindings);
        }
        if (expr instanceof IsURI) {
            return this.evaluate((IsURI)expr, bindings);
        }
        if (expr instanceof IsBNode) {
            return this.evaluate((IsBNode)expr, bindings);
        }
        if (expr instanceof IsLiteral) {
            return this.evaluate((IsLiteral)expr, bindings);
        }
        if (expr instanceof IsNumeric) {
            return this.evaluate((IsNumeric)expr, bindings);
        }
        if (expr instanceof IRIFunction) {
            return this.evaluate((IRIFunction)expr, bindings);
        }
        if (expr instanceof Regex) {
            return this.evaluate((Regex)expr, bindings);
        }
        if (expr instanceof Coalesce) {
            return this.evaluate((Coalesce)expr, bindings);
        }
        if (expr instanceof Like) {
            return this.evaluate((Like)expr, bindings);
        }
        if (expr instanceof FunctionCall) {
            return this.evaluate((FunctionCall)expr, bindings);
        }
        if (expr instanceof And) {
            return this.evaluate((And)expr, bindings);
        }
        if (expr instanceof Or) {
            return this.evaluate((Or)expr, bindings);
        }
        if (expr instanceof Not) {
            return this.evaluate((Not)expr, bindings);
        }
        if (expr instanceof SameTerm) {
            return this.evaluate((SameTerm)expr, bindings);
        }
        if (expr instanceof Compare) {
            return this.evaluate((Compare)expr, bindings);
        }
        if (expr instanceof MathExpr) {
            return this.evaluate((MathExpr)expr, bindings);
        }
        if (expr instanceof In) {
            return this.evaluate((In)expr, bindings);
        }
        if (expr instanceof CompareAny) {
            return this.evaluate((CompareAny)expr, bindings);
        }
        if (expr instanceof CompareAll) {
            return this.evaluate((CompareAll)expr, bindings);
        }
        if (expr instanceof Exists) {
            return this.evaluate((Exists)expr, bindings);
        }
        if (expr instanceof If) {
            return this.evaluate((If)expr, bindings);
        }
        if (expr instanceof ListMemberOperator) {
            return this.evaluate((ListMemberOperator)expr, bindings);
        }
        if (expr instanceof ValueExprTripleRef) {
            return this.evaluate((ValueExprTripleRef)expr, bindings);
        }
        if (expr == null) {
            throw new IllegalArgumentException("expr must not be null");
        }
        throw new QueryEvaluationException("Unsupported value expr type: " + expr.getClass());
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(Var var, BindingSet bindings) throws QueryEvaluationException {
        Value value = var.getValue();
        if (value == null) {
            value = bindings.getValue(var.getName());
        }
        if (value == null) {
            throw new ValueExprEvaluationException();
        }
        return value;
    }

    protected QueryValueEvaluationStep prepare(Var var, QueryEvaluationContext context) throws QueryEvaluationException {
        Value value = var.getValue();
        if (value != null) {
            return new QueryValueEvaluationStep.ConstantQueryValueEvaluationStep(value);
        }
        final java.util.function.Function<BindingSet, Value> getValue = context.getValue(var.getName());
        return new QueryValueEvaluationStep(){

            @Override
            public Value evaluate(BindingSet bindings) throws QueryEvaluationException {
                Value value = (Value)getValue.apply(bindings);
                if (value == null) {
                    throw new ValueExprEvaluationException();
                }
                return value;
            }
        };
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(ValueConstant valueConstant, BindingSet bindings) throws QueryEvaluationException {
        return valueConstant.getValue();
    }

    protected QueryValueEvaluationStep prepare(ValueConstant valueConstant, QueryEvaluationContext context) throws QueryEvaluationException {
        return new QueryValueEvaluationStep.ConstantQueryValueEvaluationStep(valueConstant);
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(BNodeGenerator node, BindingSet bindings) throws QueryEvaluationException {
        ValueExpr nodeIdExpr = node.getNodeIdExpr();
        if (nodeIdExpr != null) {
            Value nodeId = this.evaluate(nodeIdExpr, bindings);
            if (nodeId instanceof Literal) {
                String nodeLabel = ((Literal)nodeId).getLabel() + bindings.toString().hashCode();
                return this.tripleSource.getValueFactory().createBNode(nodeLabel);
            }
            throw new ValueExprEvaluationException("BNODE function argument must be a literal");
        }
        return this.tripleSource.getValueFactory().createBNode();
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(Bound node, BindingSet bindings) throws QueryEvaluationException {
        try {
            Value argValue = this.evaluate(node.getArg(), bindings);
            return BooleanLiteral.valueOf(argValue != null);
        }
        catch (ValueExprEvaluationException e) {
            return BooleanLiteral.FALSE;
        }
    }

    private QueryValueEvaluationStep prepare(Bound node, QueryEvaluationContext context) throws QueryEvaluationException {
        try {
            final QueryValueEvaluationStep arg = this.precompile(node.getArg(), context);
            return new QueryValueEvaluationStep(){

                @Override
                public Value evaluate(BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
                    try {
                        Value argValue = arg.evaluate(bindings);
                        return BooleanLiteral.valueOf(argValue != null);
                    }
                    catch (ValueExprEvaluationException e) {
                        return BooleanLiteral.FALSE;
                    }
                }
            };
        }
        catch (QueryEvaluationException e) {
            return new QueryValueEvaluationStep.ConstantQueryValueEvaluationStep(BooleanLiteral.FALSE);
        }
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(Str node, BindingSet bindings) throws QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof IRI) {
            return this.tripleSource.getValueFactory().createLiteral(argValue.toString());
        }
        if (argValue instanceof Literal) {
            Literal literal = (Literal)argValue;
            if (QueryEvaluationUtility.isSimpleLiteral(literal)) {
                return literal;
            }
            return this.tripleSource.getValueFactory().createLiteral(literal.getLabel());
        }
        if (argValue instanceof Triple) {
            return this.tripleSource.getValueFactory().createLiteral(argValue.toString());
        }
        throw new ValueExprEvaluationException();
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(Label node, BindingSet bindings) throws QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof Literal) {
            Literal literal = (Literal)argValue;
            if (QueryEvaluationUtility.isSimpleLiteral(literal)) {
                return literal;
            }
            return this.tripleSource.getValueFactory().createLiteral(literal.getLabel());
        }
        throw new ValueExprEvaluationException();
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(Lang node, BindingSet bindings) throws QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof Literal) {
            Literal literal = (Literal)argValue;
            return this.tripleSource.getValueFactory().createLiteral(literal.getLanguage().orElse(""));
        }
        throw new ValueExprEvaluationException();
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(Datatype node, BindingSet bindings) throws QueryEvaluationException {
        Value v = this.evaluate(node.getArg(), bindings);
        if (v instanceof Literal) {
            Literal literal = (Literal)v;
            if (literal.getDatatype() != null) {
                return literal.getDatatype();
            }
            if (literal.getLanguage().isPresent()) {
                return CoreDatatype.RDF.LANGSTRING.getIri();
            }
            return CoreDatatype.XSD.STRING.getIri();
        }
        throw new ValueExprEvaluationException();
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(Namespace node, BindingSet bindings) throws QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof IRI) {
            IRI uri = (IRI)argValue;
            return this.tripleSource.getValueFactory().createIRI(uri.getNamespace());
        }
        throw new ValueExprEvaluationException();
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(LocalName node, BindingSet bindings) throws QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof IRI) {
            IRI uri = (IRI)argValue;
            return this.tripleSource.getValueFactory().createLiteral(uri.getLocalName());
        }
        throw new ValueExprEvaluationException();
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(IsResource node, BindingSet bindings) throws QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        return BooleanLiteral.valueOf(argValue instanceof Resource);
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(IsURI node, BindingSet bindings) throws QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        return BooleanLiteral.valueOf(argValue instanceof IRI);
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(IsBNode node, BindingSet bindings) throws QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        return BooleanLiteral.valueOf(argValue instanceof BNode);
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(IsLiteral node, BindingSet bindings) throws QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        return BooleanLiteral.valueOf(argValue instanceof Literal);
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(IsNumeric node, BindingSet bindings) throws QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof Literal) {
            Literal lit = (Literal)argValue;
            IRI datatype = lit.getDatatype();
            return BooleanLiteral.valueOf(XMLDatatypeUtil.isNumericDatatype(datatype));
        }
        return BooleanLiteral.FALSE;
    }

    @Deprecated(forRemoval=true)
    public IRI evaluate(IRIFunction node, BindingSet bindings) throws QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof Literal) {
            IRI result;
            Literal lit = (Literal)argValue;
            String uriString = lit.getLabel();
            String baseURI = node.getBaseURI();
            try {
                ParsedIRI iri = ParsedIRI.create(uriString);
                if (!iri.isAbsolute() && baseURI != null) {
                    uriString = ParsedIRI.create(baseURI).resolve(iri).toString();
                } else if (!iri.isAbsolute()) {
                    throw new ValueExprEvaluationException("not an absolute IRI reference: " + uriString);
                }
            }
            catch (IllegalArgumentException e) {
                throw new ValueExprEvaluationException("not a valid IRI reference: " + uriString);
            }
            try {
                result = this.tripleSource.getValueFactory().createIRI(uriString);
            }
            catch (IllegalArgumentException e) {
                throw new ValueExprEvaluationException(e.getMessage());
            }
            return result;
        }
        if (argValue instanceof IRI) {
            return (IRI)argValue;
        }
        throw new ValueExprEvaluationException();
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(Regex node, BindingSet bindings) throws QueryEvaluationException {
        return this.prepare(node, (QueryEvaluationContext)new QueryEvaluationContext.Minimal(this.sharedValueOfNow, this.dataset)).evaluate(bindings);
    }

    protected QueryValueEvaluationStep prepare(Regex node, QueryEvaluationContext context) throws QueryEvaluationException {
        return RegexValueEvaluationStepSupplier.make(this, node, context);
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(LangMatches node, BindingSet bindings) throws QueryEvaluationException {
        Value langTagValue = this.evaluate(node.getLeftArg(), bindings);
        Value langRangeValue = this.evaluate(node.getRightArg(), bindings);
        return this.evaluateLangMatch(langTagValue, langRangeValue);
    }

    protected QueryValueEvaluationStep prepare(LangMatches node, QueryEvaluationContext context) {
        return this.supplyBinaryValueEvaluation(node, (leftVal, rightVal) -> this.evaluateLangMatch((Value)leftVal, (Value)rightVal), context);
    }

    private Value evaluateLangMatch(Value langTagValue, Value langRangeValue) {
        if (QueryEvaluationUtility.isSimpleLiteral(langTagValue) && QueryEvaluationUtility.isSimpleLiteral(langRangeValue)) {
            String langTag = ((Literal)langTagValue).getLabel();
            String langRange = ((Literal)langRangeValue).getLabel();
            boolean result = Literals.langMatches(langTag, langRange);
            return BooleanLiteral.valueOf(result);
        }
        throw new ValueExprEvaluationException();
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(Like node, BindingSet bindings) throws QueryEvaluationException {
        String snippet;
        Value val = this.evaluate(node.getArg(), bindings);
        String strVal = null;
        if (val instanceof IRI) {
            strVal = val.toString();
        } else if (val instanceof Literal) {
            strVal = ((Literal)val).getLabel();
        }
        if (strVal == null) {
            throw new ValueExprEvaluationException();
        }
        if (!node.isCaseSensitive()) {
            strVal = strVal.toLowerCase();
        }
        int valIndex = 0;
        int prevPatternIndex = -1;
        int patternIndex = node.getOpPattern().indexOf(42);
        if (patternIndex == -1) {
            return BooleanLiteral.valueOf(node.getOpPattern().equals(strVal));
        }
        if (patternIndex > 0) {
            snippet = node.getOpPattern().substring(0, patternIndex);
            if (!strVal.startsWith(snippet)) {
                return BooleanLiteral.FALSE;
            }
            valIndex += snippet.length();
            prevPatternIndex = patternIndex;
            patternIndex = node.getOpPattern().indexOf(42, patternIndex + 1);
        }
        while (patternIndex != -1) {
            snippet = node.getOpPattern().substring(prevPatternIndex + 1, patternIndex);
            valIndex = strVal.indexOf(snippet, valIndex);
            if (valIndex == -1) {
                return BooleanLiteral.FALSE;
            }
            valIndex += snippet.length();
            prevPatternIndex = patternIndex;
            patternIndex = node.getOpPattern().indexOf(42, patternIndex + 1);
        }
        snippet = node.getOpPattern().substring(prevPatternIndex + 1);
        if (snippet.length() > 0) {
            int i;
            valIndex = strVal.indexOf(snippet, valIndex);
            while ((i = strVal.indexOf(snippet, valIndex + 1)) != -1) {
                valIndex = i;
            }
            if (valIndex == -1) {
                return BooleanLiteral.FALSE;
            }
            if ((valIndex += snippet.length()) < strVal.length()) {
                return BooleanLiteral.FALSE;
            }
        }
        return BooleanLiteral.TRUE;
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(FunctionCall node, BindingSet bindings) throws QueryEvaluationException {
        Function function = (Function)FunctionRegistry.getInstance().get(node.getURI()).orElseThrow(() -> new QueryEvaluationException("Unknown function '" + node.getURI() + "'"));
        if (function instanceof Now) {
            return this.evaluate((Now)function, bindings);
        }
        List<ValueExpr> args = node.getArgs();
        Value[] argValues = new Value[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            argValues[i] = this.evaluate(args.get(i), bindings);
        }
        return function.evaluate(this.tripleSource, argValues);
    }

    public QueryValueEvaluationStep prepare(FunctionCall node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryValueEvaluationStep[] argSteps;
        final Function function = (Function)FunctionRegistry.getInstance().get(node.getURI()).orElseThrow(() -> new QueryEvaluationException("Unknown function '" + node.getURI() + "'"));
        if (function instanceof Now) {
            return this.prepare((Now)function, context);
        }
        final List<ValueExpr> args = node.getArgs();
        boolean allConstant = this.determineIfFunctionCallWillBeAConstant(context, function, args, argSteps = new QueryValueEvaluationStep[args.size()]);
        if (allConstant) {
            Value[] argValues = this.evaluateAllArguments(args, argSteps, EmptyBindingSet.getInstance());
            Value res = function.evaluate(this.tripleSource, argValues);
            return new QueryValueEvaluationStep.ConstantQueryValueEvaluationStep(res);
        }
        return new QueryValueEvaluationStep(){

            @Override
            public Value evaluate(BindingSet bindings) throws QueryEvaluationException {
                Value[] argValues = DefaultEvaluationStrategy.this.evaluateAllArguments(args, argSteps, bindings);
                return function.evaluate(DefaultEvaluationStrategy.this.tripleSource, argValues);
            }
        };
    }

    private boolean determineIfFunctionCallWillBeAConstant(QueryEvaluationContext context, Function function, List<ValueExpr> args, QueryValueEvaluationStep[] argSteps) {
        boolean allConstant = true;
        if (function.mustReturnDifferentResult()) {
            allConstant = false;
            for (int i = 0; i < args.size(); ++i) {
                argSteps[i] = this.precompile(args.get(i), context);
            }
        } else {
            for (int i = 0; i < args.size(); ++i) {
                argSteps[i] = this.precompile(args.get(i), context);
                if (argSteps[i].isConstant()) continue;
                allConstant = false;
            }
        }
        return allConstant;
    }

    private Value[] evaluateAllArguments(List<ValueExpr> args, QueryValueEvaluationStep[] argSteps, BindingSet bindings) {
        Value[] argValues = new Value[argSteps.length];
        for (int i = 0; i < args.size(); ++i) {
            argValues[i] = argSteps[i].evaluate(bindings);
        }
        return argValues;
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(And node, BindingSet bindings) throws QueryEvaluationException {
        try {
            Value leftValue = this.evaluate(node.getLeftArg(), bindings);
            if (QueryEvaluationUtility.getEffectiveBooleanValue(leftValue) == QueryEvaluationUtility.Result._false) {
                return BooleanLiteral.FALSE;
            }
        }
        catch (ValueExprEvaluationException e) {
            Value rightValue = this.evaluate(node.getRightArg(), bindings);
            if (QueryEvaluationUtility.getEffectiveBooleanValue(rightValue) == QueryEvaluationUtility.Result._false) {
                return BooleanLiteral.FALSE;
            }
            throw new ValueExprEvaluationException();
        }
        Value rightValue = this.evaluate(node.getRightArg(), bindings);
        return BooleanLiteral.valueOf(QueryEvaluationUtil.getEffectiveBooleanValue(rightValue));
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(Or node, BindingSet bindings) throws QueryEvaluationException {
        try {
            Value leftValue = this.evaluate(node.getLeftArg(), bindings);
            if (QueryEvaluationUtil.getEffectiveBooleanValue(leftValue)) {
                return BooleanLiteral.TRUE;
            }
        }
        catch (ValueExprEvaluationException e) {
            Value rightValue = this.evaluate(node.getRightArg(), bindings);
            if (QueryEvaluationUtil.getEffectiveBooleanValue(rightValue)) {
                return BooleanLiteral.TRUE;
            }
            throw new ValueExprEvaluationException();
        }
        Value rightValue = this.evaluate(node.getRightArg(), bindings);
        return BooleanLiteral.valueOf(QueryEvaluationUtil.getEffectiveBooleanValue(rightValue));
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(Not node, BindingSet bindings) throws QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        boolean argBoolean = QueryEvaluationUtil.getEffectiveBooleanValue(argValue);
        return BooleanLiteral.valueOf(!argBoolean);
    }

    protected QueryValueEvaluationStep prepare(Not node, QueryEvaluationContext context) {
        return this.supplyUnaryValueEvaluation(node, v -> BooleanLiteral.valueOf(!QueryEvaluationUtil.getEffectiveBooleanValue(v)), context);
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(Now node, BindingSet bindings) throws QueryEvaluationException {
        if (this.sharedValueOfNow == null) {
            this.sharedValueOfNow = node.evaluate(this.tripleSource.getValueFactory(), new Value[0]);
        }
        return this.sharedValueOfNow;
    }

    protected QueryValueEvaluationStep prepare(Now node, QueryEvaluationContext context) {
        return new QueryValueEvaluationStep.ConstantQueryValueEvaluationStep(context.getNow());
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(SameTerm node, BindingSet bindings) throws QueryEvaluationException {
        Value leftVal = this.evaluate(node.getLeftArg(), bindings);
        Value rightVal = this.evaluate(node.getRightArg(), bindings);
        return BooleanLiteral.valueOf(leftVal != null && leftVal.equals(rightVal));
    }

    protected QueryValueEvaluationStep prepare(SameTerm node, QueryEvaluationContext context) {
        return this.supplyBinaryValueEvaluation(node, (leftVal, rightVal) -> BooleanLiteral.valueOf(leftVal != null && leftVal.equals(rightVal)), context);
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(Coalesce node, BindingSet bindings) throws ValueExprEvaluationException {
        Value result = null;
        for (ValueExpr expr : node.getArguments()) {
            try {
                result = this.evaluate(expr, bindings);
                break;
            }
            catch (QueryEvaluationException queryEvaluationException) {
            }
        }
        if (result == null) {
            throw new ValueExprEvaluationException("COALESCE arguments do not evaluate to a value: " + node.getSignature());
        }
        return result;
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(Compare node, BindingSet bindings) throws QueryEvaluationException {
        Value leftVal = this.evaluate(node.getLeftArg(), bindings);
        Value rightVal = this.evaluate(node.getRightArg(), bindings);
        boolean strict = QueryEvaluationMode.STRICT == this.getQueryEvaluationMode();
        return BooleanLiteral.valueOf(QueryEvaluationUtil.compare(leftVal, rightVal, node.getOperator(), strict));
    }

    protected QueryValueEvaluationStep prepare(Compare node, QueryEvaluationContext context) {
        boolean strict = QueryEvaluationMode.STRICT == this.getQueryEvaluationMode();
        return this.supplyBinaryValueEvaluation(node, (leftVal, rightVal) -> BooleanLiteral.valueOf(QueryEvaluationUtil.compare(leftVal, rightVal, node.getOperator(), strict)), context);
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(MathExpr node, BindingSet bindings) throws QueryEvaluationException {
        Value leftVal = this.evaluate(node.getLeftArg(), bindings);
        Value rightVal = this.evaluate(node.getRightArg(), bindings);
        return this.mathOperationApplier(node, leftVal, rightVal, this.getQueryEvaluationMode());
    }

    private Value mathOperationApplier(MathExpr node, Value leftVal, Value rightVal, QueryEvaluationMode queryEvaluationMode) {
        if (leftVal instanceof Literal && rightVal instanceof Literal) {
            switch (queryEvaluationMode) {
                case STRICT: {
                    return MathUtil.compute((Literal)leftVal, (Literal)rightVal, node.getOperator());
                }
            }
            return XMLDatatypeMathUtil.compute((Literal)leftVal, (Literal)rightVal, node.getOperator());
        }
        throw new ValueExprEvaluationException("Both arguments must be literals");
    }

    protected QueryValueEvaluationStep prepare(MathExpr node, QueryEvaluationContext context) {
        return this.supplyBinaryValueEvaluation(node, (leftVal, rightVal) -> this.mathOperationApplier(node, (Value)leftVal, (Value)rightVal, this.getQueryEvaluationMode()), context);
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(If node, BindingSet bindings) throws QueryEvaluationException {
        boolean conditionIsTrue;
        try {
            Value value = this.evaluate(node.getCondition(), bindings);
            conditionIsTrue = QueryEvaluationUtil.getEffectiveBooleanValue(value);
        }
        catch (ValueExprEvaluationException e) {
            return null;
        }
        Value result = conditionIsTrue ? this.evaluate(node.getResult(), bindings) : this.evaluate(node.getAlternative(), bindings);
        return result;
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(In node, BindingSet bindings) throws QueryEvaluationException {
        Value leftValue = this.evaluate(node.getArg(), bindings);
        boolean result = false;
        String bindingName = node.getSubQuery().getBindingNames().iterator().next();
        try (CloseableIteration<BindingSet, QueryEvaluationException> iter = this.evaluate(node.getSubQuery(), bindings);){
            while (!result && iter.hasNext()) {
                BindingSet bindingSet = (BindingSet)iter.next();
                Value rightValue = bindingSet.getValue(bindingName);
                result = leftValue == null && rightValue == null || leftValue != null && leftValue.equals(rightValue);
            }
        }
        return BooleanLiteral.valueOf(result);
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(ListMemberOperator node, BindingSet bindings) throws QueryEvaluationException {
        List<ValueExpr> args = node.getArguments();
        Value leftValue = this.evaluate(args.get(0), bindings);
        boolean result = false;
        ValueExprEvaluationException typeError = null;
        for (int i = 1; i < args.size(); ++i) {
            ValueExpr arg = args.get(i);
            try {
                Value rightValue = this.evaluate(arg, bindings);
                boolean bl = result = leftValue == null && rightValue == null;
                if (!result) {
                    result = QueryEvaluationUtil.compare(leftValue, rightValue, Compare.CompareOp.EQ);
                }
                if (!result) continue;
                break;
            }
            catch (ValueExprEvaluationException caught) {
                typeError = caught;
            }
        }
        if (typeError != null && !result) {
            throw typeError;
        }
        return BooleanLiteral.valueOf(result);
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(CompareAny node, BindingSet bindings) throws QueryEvaluationException {
        boolean result;
        block10: {
            Value leftValue = this.evaluate(node.getArg(), bindings);
            result = false;
            String bindingName = node.getSubQuery().getBindingNames().iterator().next();
            CloseableIteration<BindingSet, QueryEvaluationException> iter = this.evaluate(node.getSubQuery(), bindings);
            block7: while (true) {
                while (!result && iter.hasNext()) {
                    BindingSet bindingSet = (BindingSet)iter.next();
                    Value rightValue = bindingSet.getValue(bindingName);
                    try {
                        result = QueryEvaluationUtil.compare(leftValue, rightValue, node.getOperator());
                        continue block7;
                    }
                    catch (ValueExprEvaluationException valueExprEvaluationException) {
                    }
                }
                break block10;
                {
                    continue block7;
                    break;
                }
                break;
            }
            finally {
                if (iter != null) {
                    iter.close();
                }
            }
        }
        return BooleanLiteral.valueOf(result);
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(CompareAll node, BindingSet bindings) throws QueryEvaluationException {
        boolean result;
        block10: {
            Value leftValue = this.evaluate(node.getArg(), bindings);
            result = true;
            String bindingName = node.getSubQuery().getBindingNames().iterator().next();
            CloseableIteration<BindingSet, QueryEvaluationException> iter = this.evaluate(node.getSubQuery(), bindings);
            block7: while (true) {
                while (result && iter.hasNext()) {
                    BindingSet bindingSet = (BindingSet)iter.next();
                    Value rightValue = bindingSet.getValue(bindingName);
                    try {
                        result = QueryEvaluationUtil.compare(leftValue, rightValue, node.getOperator());
                        continue block7;
                    }
                    catch (ValueExprEvaluationException e) {
                        result = false;
                    }
                }
                break block10;
                {
                    continue block7;
                    break;
                }
                break;
            }
            finally {
                if (iter != null) {
                    iter.close();
                }
            }
        }
        return BooleanLiteral.valueOf(result);
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(Exists node, BindingSet bindings) throws QueryEvaluationException {
        try (CloseableIteration<BindingSet, QueryEvaluationException> iter = this.evaluate(node.getSubQuery(), bindings);){
            BooleanLiteral booleanLiteral = BooleanLiteral.valueOf(iter.hasNext());
            return booleanLiteral;
        }
    }

    @Override
    public boolean isTrue(ValueExpr expr, BindingSet bindings) throws QueryEvaluationException {
        Value value = this.evaluate(expr, bindings);
        return QueryEvaluationUtility.getEffectiveBooleanValue(value).orElse(false);
    }

    @Override
    public boolean isTrue(QueryValueEvaluationStep expr, BindingSet bindings) throws QueryEvaluationException {
        Value value = expr.evaluate(bindings);
        return QueryEvaluationUtility.getEffectiveBooleanValue(value).orElse(false);
    }

    protected boolean isReducedOrDistinct(QueryModelNode node) {
        QueryModelNode parent = node.getParentNode();
        if (parent instanceof Slice) {
            return this.isReducedOrDistinct(parent);
        }
        return parent instanceof Distinct || parent instanceof Reduced;
    }

    protected long getLimit(QueryModelNode node) {
        QueryModelNode parent;
        long offset = 0L;
        if (node instanceof Slice) {
            Slice slice = (Slice)node;
            if (slice.hasOffset() && slice.hasLimit()) {
                return slice.getOffset() + slice.getLimit();
            }
            if (slice.hasLimit()) {
                return slice.getLimit();
            }
            if (slice.hasOffset()) {
                offset = slice.getOffset();
            }
        }
        if ((parent = node.getParentNode()) instanceof Distinct || parent instanceof Reduced || parent instanceof Slice) {
            long limit = this.getLimit(parent);
            if (offset > 0L && limit < Long.MAX_VALUE) {
                return offset + limit;
            }
            return limit;
        }
        return Long.MAX_VALUE;
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(ValueExprTripleRef node, BindingSet bindings) throws QueryEvaluationException {
        Value subj = this.evaluate(node.getSubjectVar(), bindings);
        if (!(subj instanceof Resource)) {
            throw new ValueExprEvaluationException("no subject value");
        }
        Value pred = this.evaluate(node.getPredicateVar(), bindings);
        if (!(pred instanceof IRI)) {
            throw new ValueExprEvaluationException("no predicate value");
        }
        Value obj = this.evaluate(node.getObjectVar(), bindings);
        if (obj == null) {
            throw new ValueExprEvaluationException("no object value");
        }
        return this.tripleSource.getValueFactory().createTriple((Resource)subj, (IRI)pred, obj);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(TripleRef ref, BindingSet bindings) {
        return this.precompile(ref).evaluate(bindings);
    }

    protected QueryEvaluationStep prepare(TripleRef ref, QueryEvaluationContext context) {
        Var subjVar = ref.getSubjectVar();
        Var predVar = ref.getPredicateVar();
        Var objVar = ref.getObjectVar();
        Var extVar = ref.getExprVar();
        boolean sourceSupportsRdfStar = this.tripleSource instanceof RDFStarTripleSource;
        if (sourceSupportsRdfStar) {
            return new RdfStarQueryEvaluationStep(subjVar, predVar, objVar, extVar, (RDFStarTripleSource)this.tripleSource, context);
        }
        return new ReificationRdfStarQueryEvaluationStep(subjVar, predVar, objVar, extVar, this.tripleSource, context);
    }

    @Override
    public void setTrackResultSize(boolean trackResultSize) {
        this.trackResultSize = trackResultSize;
    }

    @Override
    public void setTrackTime(boolean trackTime) {
        this.trackTime = trackTime;
    }

    protected QueryValueEvaluationStep supplyBinaryValueEvaluation(BinaryValueOperator node, final BiFunction<Value, Value, Value> operation, QueryEvaluationContext context) {
        final QueryValueEvaluationStep leftStep = this.precompile(node.getLeftArg(), context);
        final QueryValueEvaluationStep rightStep = this.precompile(node.getRightArg(), context);
        if (leftStep.isConstant() && rightStep.isConstant()) {
            Value leftVal = leftStep.evaluate(EmptyBindingSet.getInstance());
            Value rightVal = rightStep.evaluate(EmptyBindingSet.getInstance());
            Value value = operation.apply(leftVal, rightVal);
            return new QueryValueEvaluationStep.ConstantQueryValueEvaluationStep(value);
        }
        if (leftStep.isConstant()) {
            final Value leftVal = leftStep.evaluate(EmptyBindingSet.getInstance());
            return new QueryValueEvaluationStep(){

                @Override
                public Value evaluate(BindingSet bindings) throws QueryEvaluationException {
                    Value rightVal = rightStep.evaluate(bindings);
                    return (Value)operation.apply(leftVal, rightVal);
                }
            };
        }
        if (rightStep.isConstant()) {
            final Value rightVal = rightStep.evaluate(EmptyBindingSet.getInstance());
            return new QueryValueEvaluationStep(){

                @Override
                public Value evaluate(BindingSet bindings) throws QueryEvaluationException {
                    Value leftVal = leftStep.evaluate(bindings);
                    Value result = (Value)operation.apply(leftVal, rightVal);
                    return result;
                }
            };
        }
        return new QueryValueEvaluationStep(){

            @Override
            public Value evaluate(BindingSet bindings) throws QueryEvaluationException {
                Value leftVal = leftStep.evaluate(bindings);
                Value rightVal = rightStep.evaluate(bindings);
                return (Value)operation.apply(leftVal, rightVal);
            }
        };
    }

    protected QueryValueEvaluationStep supplyUnaryValueEvaluation(UnaryValueOperator node, final java.util.function.Function<Value, Value> operation, QueryEvaluationContext context) {
        final QueryValueEvaluationStep argStep = this.precompile(node.getArg(), context);
        if (argStep.isConstant()) {
            Value argValue = argStep.evaluate(EmptyBindingSet.getInstance());
            return new QueryValueEvaluationStep.ConstantQueryValueEvaluationStep(operation.apply(argValue));
        }
        return new QueryValueEvaluationStep(){

            @Override
            public Value evaluate(BindingSet bindings) throws QueryEvaluationException {
                Value argValue = argStep.evaluate(bindings);
                return (Value)operation.apply(argValue);
            }
        };
    }

    @Override
    public QueryEvaluationMode getQueryEvaluationMode() {
        return this.queryEvaluationMode;
    }

    @Override
    public void setQueryEvaluationMode(QueryEvaluationMode queryEvaluationMode) {
        this.queryEvaluationMode = Objects.requireNonNull(queryEvaluationMode);
    }

    private static class TimedIterator
    extends IterationWrapper<BindingSet, QueryEvaluationException> {
        CloseableIteration<BindingSet, QueryEvaluationException> iterator;
        QueryModelNode queryModelNode;
        Stopwatch stopwatch = Stopwatch.createUnstarted();

        public TimedIterator(CloseableIteration<BindingSet, QueryEvaluationException> iterator, QueryModelNode queryModelNode) {
            super(iterator);
            this.iterator = iterator;
            this.queryModelNode = queryModelNode;
        }

        @Override
        public BindingSet next() throws QueryEvaluationException {
            this.stopwatch.start();
            BindingSet next = (BindingSet)this.iterator.next();
            this.stopwatch.stop();
            return next;
        }

        @Override
        public boolean hasNext() throws QueryEvaluationException {
            this.stopwatch.start();
            boolean hasNext = super.hasNext();
            this.stopwatch.stop();
            return hasNext;
        }

        @Override
        protected void handleClose() throws QueryEvaluationException {
            try {
                this.queryModelNode.setTotalTimeNanosActual(this.queryModelNode.getTotalTimeNanosActual() + this.stopwatch.elapsed(TimeUnit.NANOSECONDS));
            }
            finally {
                super.handleClose();
            }
        }
    }

    private static class ResultSizeCountingIterator
    extends IterationWrapper<BindingSet, QueryEvaluationException> {
        CloseableIteration<BindingSet, QueryEvaluationException> iterator;
        QueryModelNode queryModelNode;

        public ResultSizeCountingIterator(CloseableIteration<BindingSet, QueryEvaluationException> iterator, QueryModelNode queryModelNode) {
            super(iterator);
            this.iterator = iterator;
            this.queryModelNode = queryModelNode;
        }

        @Override
        public boolean hasNext() throws QueryEvaluationException {
            return this.iterator.hasNext();
        }

        @Override
        public BindingSet next() throws QueryEvaluationException {
            this.queryModelNode.setResultSizeActual(this.queryModelNode.getResultSizeActual() + 1L);
            return (BindingSet)this.iterator.next();
        }
    }

    private final class QueryRootQueryEvaluationStep
    implements QueryEvaluationStep {
        private final QueryEvaluationStep arg;

        private QueryRootQueryEvaluationStep(QueryEvaluationStep arg) {
            this.arg = arg;
        }

        @Override
        public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bs) {
            DefaultEvaluationStrategy.this.sharedValueOfNow = null;
            return this.arg.evaluate(bs);
        }
    }
}

