/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.targets;

import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.DASH;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterTargetIsSubject;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnorderedSelect;
import org.eclipse.rdf4j.sail.shacl.ast.targets.Target;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;

public class DashAllSubjects
extends Target {
    private final Resource id;

    public DashAllSubjects(Resource id) {
        this.id = id;
    }

    @Override
    public IRI getPredicate() {
        return DASH.AllSubjectsTarget;
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.TARGET_PROP, this.id, new Resource[0]);
        model.add(this.id, RDF.TYPE, this.getPredicate(), new Resource[0]);
    }

    @Override
    public PlanNode getAdded(ConnectionsGroup connectionsGroup, Resource[] dataGraph, ConstraintComponent.Scope scope) {
        return this.getAddedRemovedInner(connectionsGroup.getAddedStatements(), dataGraph, scope);
    }

    private PlanNode getAddedRemovedInner(SailConnection connection, Resource[] dataGraph, ConstraintComponent.Scope scope) {
        return Unique.getInstance(new UnorderedSelect(connection, null, null, null, dataGraph, UnorderedSelect.Mapper.SubjectScopedMapper.getFunction(scope)), false);
    }

    @Override
    public String getQueryFragment(String subjectVariable, String objectVariable, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        throw new UnsupportedOperationException("Not sure what calls this code!");
    }

    @Override
    public PlanNode getTargetFilter(ConnectionsGroup connectionsGroup, Resource[] dataGraph, PlanNode parent) {
        return new FilterTargetIsSubject(connectionsGroup.getBaseConnection(), dataGraph, parent).getTrueNode(UnBufferedPlanNode.class);
    }

    @Override
    public Stream<StatementMatcher> getStatementMatcher(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner) {
        assert (subject == null);
        return Stream.of(new StatementMatcher(object, null, null));
    }

    @Override
    public String getTargetQueryFragment(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        assert (subject == null);
        String tempVar1 = stableRandomVariableProvider.next().asSparqlVariable();
        String tempVar2 = stableRandomVariableProvider.next().asSparqlVariable();
        return "?" + object.getName() + " " + tempVar1 + " " + tempVar2 + " .";
    }
}

