/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.helpers;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailConnectionListener;
import org.eclipse.rdf4j.sail.helpers.AbstractSail;
import org.eclipse.rdf4j.sail.helpers.AbstractSailConnection;

public abstract class AbstractNotifyingSailConnection
extends AbstractSailConnection
implements NotifyingSailConnection {
    private final List<SailConnectionListener> listeners = new CopyOnWriteArrayList<SailConnectionListener>();

    public AbstractNotifyingSailConnection(AbstractSail sailBase) {
        super(sailBase);
    }

    @Override
    public void addConnectionListener(SailConnectionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeConnectionListener(SailConnectionListener listener) {
        this.listeners.remove(listener);
    }

    protected boolean hasConnectionListeners() {
        return !this.listeners.isEmpty();
    }

    protected void notifyStatementAdded(Statement st) {
        for (SailConnectionListener listener : this.listeners) {
            listener.statementAdded(st);
        }
    }

    protected void notifyStatementRemoved(Statement st) {
        for (SailConnectionListener listener : this.listeners) {
            listener.statementRemoved(st);
        }
    }
}

