/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.results.lazy;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.impl.DynamicModelFactory;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDF4J;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.results.ValidationReport;
import org.eclipse.rdf4j.sail.shacl.results.ValidationResult;
import org.eclipse.rdf4j.sail.shacl.results.lazy.ValidationResultIterator;

@InternalUseOnly
public class LazyValidationReport
extends ValidationReport {
    private List<ValidationResultIterator> validationResultIterators;
    private final long limit;

    public LazyValidationReport(List<ValidationResultIterator> validationResultIterators, long limit) {
        this.validationResultIterators = validationResultIterators;
        this.limit = limit;
    }

    private void evaluateLazyAspect() {
        if (this.validationResultIterators != null) {
            long counter = 0L;
            for (ValidationResultIterator validationResultIterator : this.validationResultIterators) {
                while (validationResultIterator.hasNext()) {
                    if (this.limit >= 0L && counter >= this.limit) {
                        this.truncated = true;
                        break;
                    }
                    ++counter;
                    this.validationResult.add(validationResultIterator.next());
                }
                this.conforms = this.conforms && validationResultIterator.conforms();
                this.truncated = this.truncated || validationResultIterator.isTruncated();
            }
            this.validationResultIterators = null;
        }
    }

    @Override
    public Model asModel(Model model) {
        this.evaluateLazyAspect();
        model.add(this.getId(), SHACL.CONFORMS, (Value)Values.literal((boolean)this.conforms), new Resource[0]);
        model.add(this.getId(), RDF.TYPE, (Value)SHACL.VALIDATION_REPORT, new Resource[0]);
        model.add(this.getId(), RDF4J.TRUNCATED, (Value)BooleanLiteral.valueOf((boolean)this.truncated), new Resource[0]);
        HashSet<Resource> rdfListDedupe = new HashSet<Resource>();
        for (ValidationResult result : this.validationResult) {
            model.add(this.getId(), SHACL.RESULT, (Value)result.getId(), new Resource[0]);
            result.asModel(model, rdfListDedupe);
        }
        return model;
    }

    @Override
    public Model asModel() {
        return this.asModel((Model)new DynamicModelFactory().createEmptyModel());
    }

    @Override
    public Resource getId() {
        return this.id;
    }

    @Override
    public boolean conforms() {
        this.evaluateLazyAspect();
        return this.conforms;
    }

    @Override
    public List<ValidationResult> getValidationResult() {
        this.evaluateLazyAspect();
        return this.validationResult;
    }

    @Override
    public String toString() {
        return "LazyValidationReport{conforms=" + this.conforms + ", validationResult=" + Arrays.toString(this.validationResult.toArray()) + "}";
    }

    @Override
    public boolean isTruncated() {
        this.evaluateLazyAspect();
        return this.truncated;
    }
}

