/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.Cache;
import org.eclipse.rdf4j.sail.shacl.ast.NodeShape;
import org.eclipse.rdf4j.sail.shacl.ast.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclAstLists;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclProperties;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclUnsupportedException;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationQuery;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.LogicalOperatorConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BufferedSplitter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EqualsJoinValue;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ShiftToPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetChain;

public class OrConstraintComponent
extends LogicalOperatorConstraintComponent {
    List<Shape> or;

    public OrConstraintComponent(Resource id, RepositoryConnection connection, Cache cache, ShaclSail shaclSail) {
        super(id);
        this.or = ShaclAstLists.toList(connection, id, Resource.class).stream().map(r -> new ShaclProperties((Resource)r, connection)).map(p -> {
            if (p.getType() == SHACL.NODE_SHAPE) {
                return NodeShape.getInstance(p, connection, cache, false, shaclSail);
            }
            if (p.getType() == SHACL.PROPERTY_SHAPE) {
                return PropertyShape.getInstance(p, connection, cache, shaclSail);
            }
            throw new IllegalStateException("Unknown shape type for " + p.getId());
        }).collect(Collectors.toList());
    }

    public OrConstraintComponent(OrConstraintComponent orConstraintComponent) {
        super(orConstraintComponent.getId());
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.OR, (Value)this.getId(), new Resource[0]);
        if (!cycleDetection.contains(this.getId())) {
            cycleDetection.add(this.getId());
            this.or.forEach(o -> o.toModel(null, null, model, cycleDetection));
        }
        if (!model.contains(this.getId(), null, null, new Resource[0])) {
            ShaclAstLists.listToRdf(this.or.stream().map(Shape::getId).collect(Collectors.toList()), this.getId(), model);
        }
    }

    @Override
    public void setTargetChain(TargetChain targetChain) {
        super.setTargetChain(targetChain);
        for (Shape shape : this.or) {
            shape.setTargetChain(targetChain.setOptimizable(false));
        }
    }

    public List<Shape> getOr() {
        return Collections.unmodifiableList(this.or);
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.OrConstraintComponent;
    }

    @Override
    public ValidationQuery generateSparqlValidationQuery(ConnectionsGroup connectionsGroup, boolean logValidationPlans, boolean negatePlan, boolean negateChildren, ConstraintComponent.Scope scope) {
        throw new ShaclUnsupportedException();
    }

    @Override
    public PlanNode generateTransactionalValidationPlan(ConnectionsGroup connectionsGroup, boolean logValidationPlans, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        PlanNodeProvider planNodeProvider = overrideTargetNode != null ? overrideTargetNode : new BufferedSplitter(this.getAllTargetsPlan(connectionsGroup, scope));
        PlanNode orPlanNodes = this.or.stream().map(or -> or.generateTransactionalValidationPlan(connectionsGroup, logValidationPlans, planNodeProvider, scope)).reduce((a, b) -> new EqualsJoinValue((PlanNode)a, (PlanNode)b, false)).orElse(EmptyNode.getInstance());
        Unique invalid = new Unique(orPlanNodes, false);
        return invalid;
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope) {
        PlanNode allTargets;
        if (scope == ConstraintComponent.Scope.propertyShape) {
            PlanNode allTargetsPlan = this.getTargetChain().getEffectiveTarget("target_", ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner()).getPlanNode(connectionsGroup, ConstraintComponent.Scope.nodeShape, true, null);
            allTargets = new Unique(new ShiftToPropertyShape(allTargetsPlan), true);
        } else {
            allTargets = this.getTargetChain().getEffectiveTarget("target_", scope, connectionsGroup.getRdfsSubClassOfReasoner()).getPlanNode(connectionsGroup, scope, true, null);
        }
        PlanNode planNode = this.or.stream().map(or -> or.getAllTargetsPlan(connectionsGroup, scope)).distinct().reduce((xva$0, xva$1) -> new UnionNode((PlanNode)xva$0, (PlanNode)xva$1)).orElse(EmptyNode.getInstance());
        Unique unique = new Unique(new UnionNode(allTargets, planNode), false);
        return unique;
    }

    @Override
    public ConstraintComponent deepClone() {
        OrConstraintComponent constraintComponent = new OrConstraintComponent(this);
        constraintComponent.or = this.or.stream().map(ConstraintComponent::deepClone).map(a -> (Shape)a).collect(Collectors.toList());
        return constraintComponent;
    }

    @Override
    public boolean requiresEvaluation(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope) {
        return this.or.stream().anyMatch(c -> c.requiresEvaluation(connectionsGroup, scope));
    }

    @Override
    public SparqlFragment buildSparqlValidNodes_rsx_targetShape(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, ConstraintComponent.Scope scope, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        return OrConstraintComponent.buildSparqlValidNodes_rsx_targetShape_inner(subject, object, rdfsSubClassOfReasoner, scope, stableRandomVariableProvider, this.or, this.getTargetChain(), SparqlFragment::union, SparqlFragment::or);
    }
}

