/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.QueryParserFactory;
import org.eclipse.rdf4j.query.parser.QueryParserRegistry;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalFilterByQuery
extends FilterPlanNode {
    private static final Logger logger = LoggerFactory.getLogger(ExternalFilterByQuery.class);
    private final SailConnection connection;
    private final int index;
    private final ParsedQuery query;
    private final String queryVariable;
    private final String bindingVariable;
    private final String queryString;

    public ExternalFilterByQuery(SailConnection connection, PlanNode parent, int index, String queryFragment, String queryVariable) {
        super(parent);
        this.connection = connection;
        this.index = index;
        this.queryVariable = queryVariable;
        this.bindingVariable = queryVariable.substring(1);
        assert (queryVariable.startsWith("?"));
        assert (!this.bindingVariable.startsWith("?"));
        QueryParserFactory queryParserFactory = (QueryParserFactory)QueryParserRegistry.getInstance().get((Object)QueryLanguage.SPARQL).get();
        this.queryString = "SELECT " + queryVariable + " WHERE {\n" + queryFragment + "\n}";
        try {
            this.query = queryParserFactory.getParser().parseQuery(this.queryString, null);
        }
        catch (MalformedQueryException e) {
            logger.error("Malformed query: \n{}", (Object)queryFragment);
            throw e;
        }
    }

    @Override
    boolean checkTuple(Tuple t) {
        Value value = t.getLine().get(this.index);
        MapBindingSet bindings = new MapBindingSet();
        bindings.addBinding(this.bindingVariable, value);
        try (CloseableIteration bindingSet = this.connection.evaluate(this.query.getTupleExpr(), this.query.getDataset(), (BindingSet)bindings, false);){
            boolean bl = bindingSet.hasNext();
            return bl;
        }
    }

    @Override
    public String toString() {
        return "ExternalFilterByQuery{index=" + this.index + ", queryString=" + this.queryString.replace("\n", "\t") + ", queryVariable='" + this.queryVariable + '\'' + '}';
    }
}

