/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.helpers;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.Date;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.rio.helpers.RDFStarUtil;

class RDFStarDecodingValueFactory
implements ValueFactory {
    private ValueFactory delegate;

    RDFStarDecodingValueFactory(ValueFactory delegate) {
        this.delegate = delegate;
    }

    public IRI createIRI(String iri) {
        return this.delegate.createIRI(iri);
    }

    public IRI createIRI(String namespace, String localName) {
        return this.delegate.createIRI(namespace, localName);
    }

    public BNode createBNode() {
        return this.delegate.createBNode();
    }

    public BNode createBNode(String nodeID) {
        return this.delegate.createBNode(nodeID);
    }

    public Literal createLiteral(String label) {
        return this.delegate.createLiteral(label);
    }

    public Literal createLiteral(String label, String language) {
        return this.delegate.createLiteral(label, language);
    }

    public Literal createLiteral(String label, IRI datatype) {
        return this.delegate.createLiteral(label, datatype);
    }

    public Literal createLiteral(boolean value) {
        return this.delegate.createLiteral(value);
    }

    public Literal createLiteral(byte value) {
        return this.delegate.createLiteral(value);
    }

    public Literal createLiteral(short value) {
        return this.delegate.createLiteral(value);
    }

    public Literal createLiteral(int value) {
        return this.delegate.createLiteral(value);
    }

    public Literal createLiteral(long value) {
        return this.delegate.createLiteral(value);
    }

    public Literal createLiteral(float value) {
        return this.delegate.createLiteral(value);
    }

    public Literal createLiteral(double value) {
        return this.delegate.createLiteral(value);
    }

    public Literal createLiteral(BigDecimal bigDecimal) {
        return this.delegate.createLiteral(bigDecimal);
    }

    public Literal createLiteral(BigInteger bigInteger) {
        return this.delegate.createLiteral(bigInteger);
    }

    public Literal createLiteral(TemporalAccessor value) {
        return this.delegate.createLiteral(value);
    }

    public Literal createLiteral(TemporalAmount value) {
        return this.delegate.createLiteral(value);
    }

    public Literal createLiteral(XMLGregorianCalendar calendar) {
        return this.delegate.createLiteral(calendar);
    }

    public Literal createLiteral(Date date) {
        return this.delegate.createLiteral(date);
    }

    public Statement createStatement(Resource subject, IRI predicate, Value object) {
        return this.delegate.createStatement(RDFStarUtil.fromRDFEncodedValue(subject), predicate, RDFStarUtil.fromRDFEncodedValue(object));
    }

    public Statement createStatement(Resource subject, IRI predicate, Value object, Resource context) {
        return this.delegate.createStatement(RDFStarUtil.fromRDFEncodedValue(subject), predicate, RDFStarUtil.fromRDFEncodedValue(object), context);
    }

    public Triple createTriple(Resource subject, IRI predicate, Value object) {
        return this.delegate.createTriple(subject, predicate, object);
    }
}

