/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.Arrays;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;

public class ExternalTypeFilterNode
implements PlanNode {
    private SailConnection connection;
    private Resource filterOnType;
    PlanNode parent;
    int index = 0;
    private final boolean returnMatching;
    private boolean printed = false;

    public ExternalTypeFilterNode(SailConnection connection, Resource filterOnType, PlanNode parent, int index, boolean returnMatching) {
        this.connection = connection;
        this.filterOnType = filterOnType;
        this.parent = parent;
        this.index = index;
        this.returnMatching = returnMatching;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new CloseableIteration<Tuple, SailException>(){
            Tuple next = null;
            CloseableIteration<Tuple, SailException> parentIterator;
            {
                this.parentIterator = ExternalTypeFilterNode.this.parent.iterator();
            }

            void calculateNext() {
                while (this.next == null && this.parentIterator.hasNext()) {
                    Tuple temp = (Tuple)this.parentIterator.next();
                    Value subject = temp.line.get(ExternalTypeFilterNode.this.index);
                    if (ExternalTypeFilterNode.this.returnMatching) {
                        if (!this.isType(subject)) continue;
                        this.next = temp;
                        this.next.addHistory(new Tuple(Arrays.asList(subject, RDF.TYPE, ExternalTypeFilterNode.this.filterOnType)));
                        continue;
                    }
                    if (this.isType(subject)) continue;
                    this.next = temp;
                    this.next.addHistory(new Tuple(Arrays.asList(subject, RDF.TYPE, ExternalTypeFilterNode.this.filterOnType)));
                }
            }

            private boolean isType(Value subject) {
                if (subject instanceof Resource) {
                    return ExternalTypeFilterNode.this.connection.hasStatement((Resource)subject, RDF.TYPE, ExternalTypeFilterNode.this.filterOnType, true, new Resource[0]);
                }
                return false;
            }

            @Override
            public void close() throws SailException {
                this.parentIterator.close();
            }

            @Override
            public boolean hasNext() throws SailException {
                this.calculateNext();
                return this.next != null;
            }

            @Override
            public Tuple next() throws SailException {
                this.calculateNext();
                Tuple temp = this.next;
                this.next = null;
                return temp;
            }

            @Override
            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        if (this.connection instanceof MemoryStoreConnection) {
            stringBuilder.append(System.identityHashCode(((MemoryStoreConnection)this.connection).getSail()) + " -> " + this.getId() + " [label=\"filter source\"]").append("\n");
        } else {
            stringBuilder.append(System.identityHashCode(this.connection) + " -> " + this.getId() + " [label=\"filter source\"]").append("\n");
        }
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    public String toString() {
        return "ExternalTypeFilterNode{filterOnType=" + this.filterOnType + '}';
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public IteratorData getIteratorDataType() {
        return this.parent.getIteratorDataType();
    }
}

