/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.inferencer.fc;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.text.ASCIIUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.TreeModel;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.inferencer.InferencerConnection;
import org.eclipse.rdf4j.sail.inferencer.fc.AbstractForwardChainingInferencerConnection;
import org.eclipse.rdf4j.sail.inferencer.fc.RDFSRules;

@Deprecated
class ForwardChainingRDFSInferencerConnection
extends AbstractForwardChainingInferencerConnection {
    private Model newThisIteration;
    private boolean[] checkRule = new boolean[21];
    private boolean[] checkRuleNextIter = new boolean[21];
    private int[] ruleCount = new int[21];

    public ForwardChainingRDFSInferencerConnection(Sail sail, InferencerConnection con) {
        super(sail, con);
    }

    @Override
    protected Model createModel() {
        return new TreeModel();
    }

    @Override
    protected void addAxiomStatements() throws SailException {
        this.logger.debug("Inserting axiom statements");
        this.addInferredStatement(RDF.TYPE, RDF.TYPE, RDF.PROPERTY, new Resource[0]);
        this.addInferredStatement(RDF.SUBJECT, RDF.TYPE, RDF.PROPERTY, new Resource[0]);
        this.addInferredStatement(RDF.PREDICATE, RDF.TYPE, RDF.PROPERTY, new Resource[0]);
        this.addInferredStatement(RDF.OBJECT, RDF.TYPE, RDF.PROPERTY, new Resource[0]);
        this.addInferredStatement(RDF.FIRST, RDF.TYPE, RDF.PROPERTY, new Resource[0]);
        this.addInferredStatement(RDF.REST, RDF.TYPE, RDF.PROPERTY, new Resource[0]);
        this.addInferredStatement(RDF.VALUE, RDF.TYPE, RDF.PROPERTY, new Resource[0]);
        this.addInferredStatement(RDF.NIL, RDF.TYPE, RDF.LIST, new Resource[0]);
        this.addInferredStatement(RDF.TYPE, RDFS.DOMAIN, RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement(RDFS.DOMAIN, RDFS.DOMAIN, RDF.PROPERTY, new Resource[0]);
        this.addInferredStatement(RDFS.RANGE, RDFS.DOMAIN, RDF.PROPERTY, new Resource[0]);
        this.addInferredStatement(RDFS.SUBPROPERTYOF, RDFS.DOMAIN, RDF.PROPERTY, new Resource[0]);
        this.addInferredStatement(RDFS.SUBCLASSOF, RDFS.DOMAIN, RDFS.CLASS, new Resource[0]);
        this.addInferredStatement(RDF.SUBJECT, RDFS.DOMAIN, RDF.STATEMENT, new Resource[0]);
        this.addInferredStatement(RDF.PREDICATE, RDFS.DOMAIN, RDF.STATEMENT, new Resource[0]);
        this.addInferredStatement(RDF.OBJECT, RDFS.DOMAIN, RDF.STATEMENT, new Resource[0]);
        this.addInferredStatement(RDFS.MEMBER, RDFS.DOMAIN, RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement(RDF.FIRST, RDFS.DOMAIN, RDF.LIST, new Resource[0]);
        this.addInferredStatement(RDF.REST, RDFS.DOMAIN, RDF.LIST, new Resource[0]);
        this.addInferredStatement(RDFS.SEEALSO, RDFS.DOMAIN, RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement(RDFS.ISDEFINEDBY, RDFS.DOMAIN, RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement(RDFS.COMMENT, RDFS.DOMAIN, RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement(RDFS.LABEL, RDFS.DOMAIN, RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement(RDF.VALUE, RDFS.DOMAIN, RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement(RDF.TYPE, RDFS.RANGE, RDFS.CLASS, new Resource[0]);
        this.addInferredStatement(RDFS.DOMAIN, RDFS.RANGE, RDFS.CLASS, new Resource[0]);
        this.addInferredStatement(RDFS.RANGE, RDFS.RANGE, RDFS.CLASS, new Resource[0]);
        this.addInferredStatement(RDFS.SUBPROPERTYOF, RDFS.RANGE, RDF.PROPERTY, new Resource[0]);
        this.addInferredStatement(RDFS.SUBCLASSOF, RDFS.RANGE, RDFS.CLASS, new Resource[0]);
        this.addInferredStatement(RDF.SUBJECT, RDFS.RANGE, RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement(RDF.PREDICATE, RDFS.RANGE, RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement(RDF.OBJECT, RDFS.RANGE, RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement(RDFS.MEMBER, RDFS.RANGE, RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement(RDF.FIRST, RDFS.RANGE, RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement(RDF.REST, RDFS.RANGE, RDF.LIST, new Resource[0]);
        this.addInferredStatement(RDFS.SEEALSO, RDFS.RANGE, RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement(RDFS.ISDEFINEDBY, RDFS.RANGE, RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement(RDFS.COMMENT, RDFS.RANGE, RDFS.LITERAL, new Resource[0]);
        this.addInferredStatement(RDFS.LABEL, RDFS.RANGE, RDFS.LITERAL, new Resource[0]);
        this.addInferredStatement(RDF.VALUE, RDFS.RANGE, RDFS.RESOURCE, new Resource[0]);
        this.addInferredStatement(RDF.ALT, RDFS.SUBCLASSOF, RDFS.CONTAINER, new Resource[0]);
        this.addInferredStatement(RDF.BAG, RDFS.SUBCLASSOF, RDFS.CONTAINER, new Resource[0]);
        this.addInferredStatement(RDF.SEQ, RDFS.SUBCLASSOF, RDFS.CONTAINER, new Resource[0]);
        this.addInferredStatement(RDFS.CONTAINERMEMBERSHIPPROPERTY, RDFS.SUBCLASSOF, RDF.PROPERTY, new Resource[0]);
        this.addInferredStatement(RDFS.ISDEFINEDBY, RDFS.SUBPROPERTYOF, RDFS.SEEALSO, new Resource[0]);
        this.addInferredStatement(RDF.XMLLITERAL, RDF.TYPE, RDFS.DATATYPE, new Resource[0]);
        this.addInferredStatement(RDF.XMLLITERAL, RDFS.SUBCLASSOF, RDFS.LITERAL, new Resource[0]);
        this.addInferredStatement(RDFS.DATATYPE, RDFS.SUBCLASSOF, RDFS.CLASS, new Resource[0]);
    }

    @Override
    protected void doInferencing() throws SailException {
        int i;
        for (i = 0; i < 21; ++i) {
            this.ruleCount[i] = 0;
            this.checkRuleNextIter[i] = true;
        }
        super.doInferencing();
        this.logger.debug("---RdfMTInferencer statistics:---");
        this.logger.debug("total statements inferred = " + this.totalInferred);
        for (i = 0; i < 21; ++i) {
            this.logger.debug("rule " + RDFSRules.RULENAMES[i] + ":\t#inferred=" + this.ruleCount[i]);
        }
        this.logger.debug("---end of statistics:---");
    }

    @Override
    protected int applyRules(Model iteration) throws SailException {
        this.newThisIteration = iteration;
        int nofInferred = 0;
        nofInferred += this.applyRule(0);
        nofInferred += this.applyRule(1);
        nofInferred += this.applyRule(2);
        nofInferred += this.applyRule(3);
        nofInferred += this.applyRule(4);
        nofInferred += this.applyRule(5);
        nofInferred += this.applyRule(6);
        nofInferred += this.applyRule(7);
        nofInferred += this.applyRule(8);
        nofInferred += this.applyRule(9);
        nofInferred += this.applyRule(10);
        nofInferred += this.applyRule(11);
        nofInferred += this.applyRule(12);
        nofInferred += this.applyRule(13);
        nofInferred += this.applyRule(14);
        nofInferred += this.applyRule(15);
        nofInferred += this.applyRule(16);
        nofInferred += this.applyRule(17);
        nofInferred += this.applyRule(18);
        nofInferred += this.applyRule(19);
        this.newThisIteration = null;
        return nofInferred += this.applyRule(20);
    }

    @Override
    protected Model prepareIteration() {
        for (int i = 0; i < 21; ++i) {
            this.checkRule[i] = this.checkRuleNextIter[i];
            this.checkRuleNextIter[i] = false;
        }
        return super.prepareIteration();
    }

    protected void updateTriggers(int ruleNo, int nofInferred) {
        if (nofInferred > 0) {
            int n = ruleNo;
            this.ruleCount[n] = this.ruleCount[n] + nofInferred;
            boolean[] triggers = RDFSRules.TRIGGERS[ruleNo];
            for (int i = 0; i < 21; ++i) {
                if (!triggers[i]) continue;
                this.checkRuleNextIter[i] = true;
            }
        }
    }

    protected int applyRule(int rule) throws SailException {
        if (!this.checkRule[rule]) {
            return 0;
        }
        int nofInferred = 0;
        nofInferred = this.applyRuleInternal(rule);
        this.updateTriggers(rule, nofInferred);
        return nofInferred;
    }

    protected int applyRuleInternal(int rule) throws SailException {
        int result = 0;
        switch (rule) {
            case 0: {
                result = this.applyRuleRdf1();
                break;
            }
            case 1: {
                result = this.applyRuleRdfs2_1();
                break;
            }
            case 2: {
                result = this.applyRuleRdfs2_2();
                break;
            }
            case 3: {
                result = this.applyRuleRdfs3_1();
                break;
            }
            case 4: {
                result = this.applyRuleRdfs3_2();
                break;
            }
            case 5: {
                result = this.applyRuleRdfs4a();
                break;
            }
            case 6: {
                result = this.applyRuleRdfs4b();
                break;
            }
            case 7: {
                result = this.applyRuleRdfs5_1();
                break;
            }
            case 8: {
                result = this.applyRuleRdfs5_2();
                break;
            }
            case 9: {
                result = this.applyRuleRdfs6();
                break;
            }
            case 10: {
                result = this.applyRuleRdfs7_1();
                break;
            }
            case 11: {
                result = this.applyRuleRdfs7_2();
                break;
            }
            case 12: {
                result = this.applyRuleRdfs8();
                break;
            }
            case 13: {
                result = this.applyRuleRdfs9_1();
                break;
            }
            case 14: {
                result = this.applyRuleRdfs9_2();
                break;
            }
            case 15: {
                result = this.applyRuleRdfs10();
                break;
            }
            case 16: {
                result = this.applyRuleRdfs11_1();
                break;
            }
            case 17: {
                result = this.applyRuleRdfs11_2();
                break;
            }
            case 18: {
                result = this.applyRuleRdfs12();
                break;
            }
            case 19: {
                result = this.applyRuleRdfs13();
                break;
            }
            case 20: {
                result = this.applyRuleX1();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected rule: " + rule));
            }
        }
        return result;
    }

    private int applyRuleRdf1() throws SailException {
        int nofInferred = 0;
        Model iter = this.newThisIteration.filter(null, null, null, new Resource[0]);
        for (Statement st : iter) {
            boolean added = this.addInferredStatement(st.getPredicate(), RDF.TYPE, RDF.PROPERTY, new Resource[0]);
            if (!added) continue;
            ++nofInferred;
        }
        return nofInferred;
    }

    private int applyRuleRdfs2_1() throws SailException {
        int nofInferred = 0;
        Model ntIter = this.newThisIteration.filter(null, null, null, new Resource[0]);
        for (Statement nt : ntIter) {
            Resource xxx = nt.getSubject();
            IRI aaa = nt.getPredicate();
            CloseableIteration<? extends Statement, SailException> t1Iter = this.getWrappedConnection().getStatements((Resource)aaa, RDFS.DOMAIN, null, true, new Resource[0]);
            while (t1Iter.hasNext()) {
                boolean added;
                Statement t1 = (Statement)t1Iter.next();
                Value zzz = t1.getObject();
                if (!(zzz instanceof Resource) || !(added = this.addInferredStatement(xxx, RDF.TYPE, zzz, new Resource[0]))) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        return nofInferred;
    }

    private int applyRuleRdfs2_2() throws SailException {
        int nofInferred = 0;
        Model ntIter = this.newThisIteration.filter(null, RDFS.DOMAIN, null, new Resource[0]);
        for (Statement nt : ntIter) {
            Resource aaa = nt.getSubject();
            Value zzz = nt.getObject();
            if (!(aaa instanceof IRI) || !(zzz instanceof Resource)) continue;
            CloseableIteration<? extends Statement, SailException> t1Iter = this.getWrappedConnection().getStatements(null, (IRI)aaa, null, true, new Resource[0]);
            while (t1Iter.hasNext()) {
                Statement t1 = (Statement)t1Iter.next();
                Resource xxx = t1.getSubject();
                boolean added = this.addInferredStatement(xxx, RDF.TYPE, zzz, new Resource[0]);
                if (!added) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        return nofInferred;
    }

    private int applyRuleRdfs3_1() throws SailException {
        int nofInferred = 0;
        Model ntIter = this.newThisIteration.filter(null, null, null, new Resource[0]);
        for (Statement nt : ntIter) {
            IRI aaa = nt.getPredicate();
            Value uuu = nt.getObject();
            if (!(uuu instanceof Resource)) continue;
            CloseableIteration<? extends Statement, SailException> t1Iter = this.getWrappedConnection().getStatements((Resource)aaa, RDFS.RANGE, null, true, new Resource[0]);
            while (t1Iter.hasNext()) {
                boolean added;
                Statement t1 = (Statement)t1Iter.next();
                Value zzz = t1.getObject();
                if (!(zzz instanceof Resource) || !(added = this.addInferredStatement((Resource)uuu, RDF.TYPE, zzz, new Resource[0]))) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        return nofInferred;
    }

    private int applyRuleRdfs3_2() throws SailException {
        int nofInferred = 0;
        Model ntIter = this.newThisIteration.filter(null, RDFS.RANGE, null, new Resource[0]);
        for (Statement nt : ntIter) {
            Resource aaa = nt.getSubject();
            Value zzz = nt.getObject();
            if (!(aaa instanceof IRI) || !(zzz instanceof Resource)) continue;
            CloseableIteration<? extends Statement, SailException> t1Iter = this.getWrappedConnection().getStatements(null, (IRI)aaa, null, true, new Resource[0]);
            while (t1Iter.hasNext()) {
                boolean added;
                Statement t1 = (Statement)t1Iter.next();
                Value uuu = t1.getObject();
                if (!(uuu instanceof Resource) || !(added = this.addInferredStatement((Resource)uuu, RDF.TYPE, zzz, new Resource[0]))) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        return nofInferred;
    }

    private int applyRuleRdfs4a() throws SailException {
        int nofInferred = 0;
        Model iter = this.newThisIteration.filter(null, null, null, new Resource[0]);
        for (Statement st : iter) {
            boolean added = this.addInferredStatement(st.getSubject(), RDF.TYPE, RDFS.RESOURCE, new Resource[0]);
            if (!added) continue;
            ++nofInferred;
        }
        return nofInferred;
    }

    private int applyRuleRdfs4b() throws SailException {
        int nofInferred = 0;
        Model iter = this.newThisIteration.filter(null, null, null, new Resource[0]);
        for (Statement st : iter) {
            boolean added;
            Value uuu = st.getObject();
            if (!(uuu instanceof Resource) || !(added = this.addInferredStatement((Resource)uuu, RDF.TYPE, RDFS.RESOURCE, new Resource[0]))) continue;
            ++nofInferred;
        }
        return nofInferred;
    }

    private int applyRuleRdfs5_1() throws SailException {
        int nofInferred = 0;
        Model ntIter = this.newThisIteration.filter(null, RDFS.SUBPROPERTYOF, null, new Resource[0]);
        for (Statement nt : ntIter) {
            Resource aaa = nt.getSubject();
            Value bbb = nt.getObject();
            if (!(bbb instanceof Resource)) continue;
            CloseableIteration<? extends Statement, SailException> t1Iter = this.getWrappedConnection().getStatements((Resource)bbb, RDFS.SUBPROPERTYOF, null, true, new Resource[0]);
            while (t1Iter.hasNext()) {
                boolean added;
                Statement t1 = (Statement)t1Iter.next();
                Value ccc = t1.getObject();
                if (!(ccc instanceof Resource) || !(added = this.addInferredStatement(aaa, RDFS.SUBPROPERTYOF, ccc, new Resource[0]))) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        return nofInferred;
    }

    private int applyRuleRdfs5_2() throws SailException {
        int nofInferred = 0;
        Model ntIter = this.newThisIteration.filter(null, RDFS.SUBPROPERTYOF, null, new Resource[0]);
        for (Statement nt : ntIter) {
            Resource bbb = nt.getSubject();
            Value ccc = nt.getObject();
            if (!(ccc instanceof Resource)) continue;
            CloseableIteration<? extends Statement, SailException> t1Iter = this.getWrappedConnection().getStatements(null, RDFS.SUBPROPERTYOF, (Value)bbb, true, new Resource[0]);
            while (t1Iter.hasNext()) {
                Statement t1 = (Statement)t1Iter.next();
                Resource aaa = t1.getSubject();
                boolean added = this.addInferredStatement(aaa, RDFS.SUBPROPERTYOF, ccc, new Resource[0]);
                if (!added) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        return nofInferred;
    }

    private int applyRuleRdfs6() throws SailException {
        int nofInferred = 0;
        Model iter = this.newThisIteration.filter(null, RDF.TYPE, (Value)RDF.PROPERTY, new Resource[0]);
        for (Statement st : iter) {
            Resource xxx = st.getSubject();
            boolean added = this.addInferredStatement(xxx, RDFS.SUBPROPERTYOF, xxx, new Resource[0]);
            if (!added) continue;
            ++nofInferred;
        }
        return nofInferred;
    }

    private int applyRuleRdfs7_1() throws SailException {
        int nofInferred = 0;
        Model ntIter = this.newThisIteration.filter(null, null, null, new Resource[0]);
        for (Statement nt : ntIter) {
            Resource xxx = nt.getSubject();
            IRI aaa = nt.getPredicate();
            Value yyy = nt.getObject();
            CloseableIteration<? extends Statement, SailException> t1Iter = this.getWrappedConnection().getStatements((Resource)aaa, RDFS.SUBPROPERTYOF, null, true, new Resource[0]);
            while (t1Iter.hasNext()) {
                boolean added;
                Statement t1 = (Statement)t1Iter.next();
                Value bbb = t1.getObject();
                if (!(bbb instanceof IRI) || !(added = this.addInferredStatement(xxx, (IRI)bbb, yyy, new Resource[0]))) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        return nofInferred;
    }

    private int applyRuleRdfs7_2() throws SailException {
        int nofInferred = 0;
        Model ntIter = this.newThisIteration.filter(null, RDFS.SUBPROPERTYOF, null, new Resource[0]);
        for (Statement nt : ntIter) {
            Resource aaa = nt.getSubject();
            Value bbb = nt.getObject();
            if (!(aaa instanceof IRI) || !(bbb instanceof IRI)) continue;
            CloseableIteration<? extends Statement, SailException> t1Iter = this.getWrappedConnection().getStatements(null, (IRI)aaa, null, true, new Resource[0]);
            while (t1Iter.hasNext()) {
                Value yyy;
                Statement t1 = (Statement)t1Iter.next();
                Resource xxx = t1.getSubject();
                boolean added = this.addInferredStatement(xxx, (IRI)bbb, yyy = t1.getObject(), new Resource[0]);
                if (!added) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        return nofInferred;
    }

    private int applyRuleRdfs8() throws SailException {
        int nofInferred = 0;
        Model iter = this.newThisIteration.filter(null, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        for (Statement st : iter) {
            Resource xxx = st.getSubject();
            boolean added = this.addInferredStatement(xxx, RDFS.SUBCLASSOF, RDFS.RESOURCE, new Resource[0]);
            if (!added) continue;
            ++nofInferred;
        }
        return nofInferred;
    }

    private int applyRuleRdfs9_1() throws SailException {
        int nofInferred = 0;
        Model ntIter = this.newThisIteration.filter(null, RDFS.SUBCLASSOF, null, new Resource[0]);
        for (Statement nt : ntIter) {
            Resource xxx = nt.getSubject();
            Value yyy = nt.getObject();
            if (!(yyy instanceof Resource)) continue;
            CloseableIteration<? extends Statement, SailException> t1Iter = this.getWrappedConnection().getStatements(null, RDF.TYPE, (Value)xxx, true, new Resource[0]);
            while (t1Iter.hasNext()) {
                Statement t1 = (Statement)t1Iter.next();
                Resource aaa = t1.getSubject();
                boolean added = this.addInferredStatement(aaa, RDF.TYPE, yyy, new Resource[0]);
                if (!added) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        return nofInferred;
    }

    private int applyRuleRdfs9_2() throws SailException {
        int nofInferred = 0;
        Model ntIter = this.newThisIteration.filter(null, RDF.TYPE, null, new Resource[0]);
        for (Statement nt : ntIter) {
            Resource aaa = nt.getSubject();
            Value xxx = nt.getObject();
            if (!(xxx instanceof Resource)) continue;
            CloseableIteration<? extends Statement, SailException> t1Iter = this.getWrappedConnection().getStatements((Resource)xxx, RDFS.SUBCLASSOF, null, true, new Resource[0]);
            while (t1Iter.hasNext()) {
                boolean added;
                Statement t1 = (Statement)t1Iter.next();
                Value yyy = t1.getObject();
                if (!(yyy instanceof Resource) || !(added = this.addInferredStatement(aaa, RDF.TYPE, yyy, new Resource[0]))) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        return nofInferred;
    }

    private int applyRuleRdfs10() throws SailException {
        int nofInferred = 0;
        Model iter = this.newThisIteration.filter(null, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        for (Statement st : iter) {
            Resource xxx = st.getSubject();
            boolean added = this.addInferredStatement(xxx, RDFS.SUBCLASSOF, xxx, new Resource[0]);
            if (!added) continue;
            ++nofInferred;
        }
        return nofInferred;
    }

    private int applyRuleRdfs11_1() throws SailException {
        int nofInferred = 0;
        Model ntIter = this.newThisIteration.filter(null, RDFS.SUBCLASSOF, null, new Resource[0]);
        for (Statement nt : ntIter) {
            Resource xxx = nt.getSubject();
            Value yyy = nt.getObject();
            if (!(yyy instanceof Resource)) continue;
            CloseableIteration<? extends Statement, SailException> t1Iter = this.getWrappedConnection().getStatements((Resource)yyy, RDFS.SUBCLASSOF, null, true, new Resource[0]);
            while (t1Iter.hasNext()) {
                boolean added;
                Statement t1 = (Statement)t1Iter.next();
                Value zzz = t1.getObject();
                if (!(zzz instanceof Resource) || !(added = this.addInferredStatement(xxx, RDFS.SUBCLASSOF, zzz, new Resource[0]))) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        return nofInferred;
    }

    private int applyRuleRdfs11_2() throws SailException {
        int nofInferred = 0;
        Model ntIter = this.newThisIteration.filter(null, RDFS.SUBCLASSOF, null, new Resource[0]);
        for (Statement nt : ntIter) {
            Resource yyy = nt.getSubject();
            Value zzz = nt.getObject();
            if (!(zzz instanceof Resource)) continue;
            CloseableIteration<? extends Statement, SailException> t1Iter = this.getWrappedConnection().getStatements(null, RDFS.SUBCLASSOF, (Value)yyy, true, new Resource[0]);
            while (t1Iter.hasNext()) {
                Statement t1 = (Statement)t1Iter.next();
                Resource xxx = t1.getSubject();
                boolean added = this.addInferredStatement(xxx, RDFS.SUBCLASSOF, zzz, new Resource[0]);
                if (!added) continue;
                ++nofInferred;
            }
            t1Iter.close();
        }
        return nofInferred;
    }

    private int applyRuleRdfs12() throws SailException {
        int nofInferred = 0;
        Model iter = this.newThisIteration.filter(null, RDF.TYPE, (Value)RDFS.CONTAINERMEMBERSHIPPROPERTY, new Resource[0]);
        for (Statement st : iter) {
            Resource xxx = st.getSubject();
            boolean added = this.addInferredStatement(xxx, RDFS.SUBPROPERTYOF, RDFS.MEMBER, new Resource[0]);
            if (!added) continue;
            ++nofInferred;
        }
        return nofInferred;
    }

    private int applyRuleRdfs13() throws SailException {
        int nofInferred = 0;
        Model iter = this.newThisIteration.filter(null, RDF.TYPE, (Value)RDFS.DATATYPE, new Resource[0]);
        for (Statement st : iter) {
            Resource xxx = st.getSubject();
            boolean added = this.addInferredStatement(xxx, RDFS.SUBCLASSOF, RDFS.LITERAL, new Resource[0]);
            if (!added) continue;
            ++nofInferred;
        }
        return nofInferred;
    }

    private int applyRuleX1() throws SailException {
        int nofInferred = 0;
        String prefix = "http://www.w3.org/1999/02/22-rdf-syntax-ns#_";
        Model iter = this.newThisIteration.filter(null, null, null, new Resource[0]);
        for (Statement st : iter) {
            boolean added;
            IRI predNode = st.getPredicate();
            String predURI = predNode.toString();
            if (!predURI.startsWith(prefix) || !this.isValidPredicateNumber(predURI.substring(prefix.length())) || !(added = this.addInferredStatement(predNode, RDF.TYPE, RDFS.CONTAINERMEMBERSHIPPROPERTY, new Resource[0]))) continue;
            ++nofInferred;
        }
        return nofInferred;
    }

    private boolean isValidPredicateNumber(String str) {
        int strLength = str.length();
        if (strLength == 0) {
            return false;
        }
        for (int i = 0; i < strLength; ++i) {
            if (ASCIIUtil.isNumber(str.charAt(i))) continue;
            return false;
        }
        return str.charAt(0) != '0';
    }
}

