/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.xml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DocumentUtil {
    public static Document getDocument(URL location) throws IOException {
        return DocumentUtil.getDocument(location, false, false, null);
    }

    public static Document getDocument(URL location, boolean validating, boolean namespaceAware) throws IOException {
        return DocumentUtil.getDocument(location, validating, namespaceAware, null);
    }

    public static Document getDocument(URL location, Schema schema) throws IOException {
        return DocumentUtil.getDocument(location, false, true, schema);
    }

    private static Document getDocument(URL location, boolean validating, boolean namespaceAware, Schema schema) throws IOException {
        Document result = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(validating);
        factory.setNamespaceAware(namespaceAware);
        factory.setSchema(schema);
        try (BufferedInputStream in = new BufferedInputStream(location.openConnection().getInputStream());){
            DocumentBuilder builder = factory.newDocumentBuilder();
            result = builder.parse(in);
        }
        catch (SAXParseException e) {
            String message = "Parsing error, line " + e.getLineNumber() + ", uri " + e.getSystemId() + ", " + e.getMessage();
            throw DocumentUtil.toIOE(message, e);
        }
        catch (SAXException e) {
            throw DocumentUtil.toIOE(e);
        }
        catch (ParserConfigurationException e) {
            throw DocumentUtil.toIOE(e);
        }
        return result;
    }

    private static IOException toIOE(Exception e) {
        return DocumentUtil.toIOE(e.getMessage(), e);
    }

    private static IOException toIOE(String message, Exception e) {
        IOException result = new IOException(message);
        result.initCause(e);
        return result;
    }
}

