/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.properties.general;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomaly;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EUserRole;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIParticipant;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.general.ModelElementProperties;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ParticipantProperties
extends ModelElementProperties {
    private static final String AUTHOR = "AUTHOR";
    private static final String LEAD = "LEAD";
    private static final String ORGANIZER = "ORGANIZER";
    private static final String REVIEWER = "REVIEWER";
    protected static final String PARTICIPANT_ID_ID = "participantElement.id";
    protected static final PropertyDescriptor PARTICIPANT_ID_PROPERTY_DESCRIPTOR = new PropertyDescriptor((Object)"participantElement.id", "Id: ");
    protected static final String PARTICIPANT_EMAIL_ID = "participantElement.email";
    protected static final PropertyDescriptor PARTICIPANT_EMAIL_PROPERTY_DESCRIPTOR = new PropertyDescriptor((Object)"participantElement.email", "Email: ");
    protected static final String PARTICIPANT_NUM_ITEMS_ID = "participantElement.numItems";
    protected static final PropertyDescriptor PARTICIPANT_NUM_ITEMS_PROPERTY_DESCRIPTOR = new PropertyDescriptor((Object)"participantElement.numItems", "Review Items Added: ");
    protected static final String PARTICIPANT_NUM_ANOMALIES_ID = "participantElement.numAnomalies";
    protected static final PropertyDescriptor PARTICIPANT_NUM_ANOMALIES_PROPERTY_DESCR = new PropertyDescriptor((Object)"participantElement.numAnomalies", "Anomalies Added: ");
    protected static final String PARTICIPANT_NUM_COMMENTS_ID = "participantElement.numComments";
    protected static final PropertyDescriptor PARTICIPANT_NUM_COMMENTS_PROPERTY_DESCRIPTOR = new PropertyDescriptor((Object)"participantElement.numComments", "Comments Added: ");
    protected static final String PARTICIPANT_DETAILS_ID = "participantElement.details";
    protected static final PropertyDescriptor PARTICIPANT_DETAILS_PROPERTY_DESCRIPTOR = new PropertyDescriptor((Object)"participantElement.details", "User Details: ");
    protected static final String PARTICIPANT_TIME_SPENT_ID = "participantElement.timeSpent";
    protected static final PropertyDescriptor PARTICIPANT_TIME_SPENT_PROPERTY_DESCRIPTOR = new PropertyDescriptor((Object)"participantElement.timeSpent", "Time Spent (total): ");
    private static final String PARTICIPANT_ROLES_ID = "participantElement.roles";
    private static final PropertyDescriptor PARTICIPANT_ROLES_PROPERTY_DESCRIPTOR = new PropertyDescriptor((Object)"participantElement.roles", "Roles: ");
    private static final String PARTICIPANT_FOCUS_AREA_ID = "participantElement.focusArea";
    private static final PropertyDescriptor PARTICIPANT_FOCUS_AREA_PROPERTY_DESCRIPTOR = new PropertyDescriptor((Object)"participantElement.focusArea", "Focus Area: ");
    private static final IPropertyDescriptor[] DESCRIPTORS = new IPropertyDescriptor[]{PARTICIPANT_ID_PROPERTY_DESCRIPTOR, PARTICIPANT_EMAIL_PROPERTY_DESCRIPTOR, PARTICIPANT_NUM_ITEMS_PROPERTY_DESCRIPTOR, PARTICIPANT_NUM_ANOMALIES_PROPERTY_DESCR, PARTICIPANT_NUM_COMMENTS_PROPERTY_DESCRIPTOR, PARTICIPANT_DETAILS_PROPERTY_DESCRIPTOR, PARTICIPANT_TIME_SPENT_PROPERTY_DESCRIPTOR, PARTICIPANT_ROLES_PROPERTY_DESCRIPTOR, PARTICIPANT_FOCUS_AREA_PROPERTY_DESCRIPTOR};

    public ParticipantProperties(R4EUIModelElement aElement) {
        super(aElement);
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return DESCRIPTORS;
    }

    private String mapUserRole(R4EUserRole aRole) {
        if (aRole.equals((Object)R4EUserRole.R4E_ROLE_AUTHOR)) {
            return AUTHOR;
        }
        if (aRole.equals((Object)R4EUserRole.R4E_ROLE_LEAD)) {
            return LEAD;
        }
        if (aRole.equals((Object)R4EUserRole.R4E_ROLE_ORGANIZER)) {
            return ORGANIZER;
        }
        if (aRole.equals((Object)R4EUserRole.R4E_ROLE_REVIEWER)) {
            return REVIEWER;
        }
        return "";
    }

    public Object getPropertyValue(Object aId) {
        if (PARTICIPANT_ID_ID.equals(aId)) {
            return ((R4EUIParticipant)this.getElement()).getParticipant().getId();
        }
        if (PARTICIPANT_EMAIL_ID.equals(aId)) {
            return ((R4EUIParticipant)this.getElement()).getParticipant().getEmail();
        }
        if (PARTICIPANT_NUM_ITEMS_ID.equals(aId)) {
            return ((R4EUIParticipant)this.getElement()).getParticipant().getAddedItems().size();
        }
        if (PARTICIPANT_NUM_ANOMALIES_ID.equals(aId)) {
            int numAnomalies = 0;
            EList comments = ((R4EUIParticipant)this.getElement()).getParticipant().getAddedComments();
            int commentsSize = comments.size();
            int i = 0;
            while (i < commentsSize) {
                if (comments.get(i) instanceof R4EAnomaly) {
                    ++numAnomalies;
                }
                ++i;
            }
            return numAnomalies;
        }
        if (PARTICIPANT_NUM_COMMENTS_ID.equals(aId)) {
            int numComments = 0;
            EList comments = ((R4EUIParticipant)this.getElement()).getParticipant().getAddedComments();
            int commentsSize = comments.size();
            int i = 0;
            while (i < commentsSize) {
                if (!(comments.get(i) instanceof R4EAnomaly)) {
                    ++numComments;
                }
                ++i;
            }
            return numComments;
        }
        if (PARTICIPANT_DETAILS_ID.equals(aId)) {
            return ((R4EUIParticipant)this.getElement()).getParticipantDetails();
        }
        if (PARTICIPANT_TIME_SPENT_ID.equals(aId)) {
            R4EParticipant modelUser = ((R4EUIParticipant)this.getElement()).getParticipant();
            int numTimeEntries = modelUser.getTimeLog().size();
            int totalTimeSpent = 0;
            Map.Entry timeEntry = null;
            int i = 0;
            while (i < numTimeEntries) {
                timeEntry = (Map.Entry)modelUser.getTimeLog().get(i);
                totalTimeSpent += ((Integer)timeEntry.getValue()).intValue();
                ++i;
            }
            return Integer.toString(totalTimeSpent);
        }
        if (PARTICIPANT_ROLES_ID.equals(aId)) {
            EList roles = ((R4EUIParticipant)this.getElement()).getParticipant().getRoles();
            StringBuilder rolesStr = new StringBuilder();
            for (R4EUserRole role : roles) {
                rolesStr.append(String.valueOf(this.mapUserRole(role)) + ", ");
            }
            return rolesStr.toString().substring(0, rolesStr.length() - 2);
        }
        if (PARTICIPANT_FOCUS_AREA_ID.equals(aId)) {
            if (((R4EUIParticipant)this.getElement()).getParticipant().getFocusArea() != null) {
                return ((R4EUIParticipant)this.getElement()).getParticipant().getFocusArea();
            }
            return "";
        }
        return null;
    }
}

