/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.editors;

import java.text.MessageFormat;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ICompareNavigator;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.CompareContentViewerSwitchingPane;
import org.eclipse.compare.internal.CompareEditorInputNavigator;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.reviews.frame.ui.annotation.IReviewAnnotationModel;
import org.eclipse.mylyn.reviews.r4e.ui.internal.annotation.content.R4EAnnotation;
import org.eclipse.mylyn.reviews.r4e.ui.internal.annotation.content.R4EAnnotationModel;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EDiffNode;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIPosition;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class R4ECompareEditorInput
extends SaveableCompareEditorInput {
    protected R4EDiffNode fCurrentDiffNode;

    public R4ECompareEditorInput() {
        super(new CompareConfiguration(), null);
    }

    protected void initConfiguration() {
        this.getCompareConfiguration().setLeftEditable(false);
        this.getCompareConfiguration().setRightEditable(false);
        this.getCompareConfiguration().setProperty("IGNORE_WHITESPACE", (Object)true);
    }

    public ITypedElement getAncestorElement() {
        return null;
    }

    public R4EDiffNode getCurrentDiffNode() {
        return this.fCurrentDiffNode;
    }

    public String getToolTipText() {
        String targetTooltip = this.fCurrentDiffNode.getTargetLabel();
        String baseTooltip = this.fCurrentDiffNode.getBaseLabel();
        String format = CompareUI.getResourceBundle().getString("ResourceCompare.twoWay.tooltip");
        return MessageFormat.format(format, targetTooltip, baseTooltip);
    }

    protected void fireInputChange() {
    }

    protected ICompareInput prepareCompareInput(IProgressMonitor aMonitor) {
        if (aMonitor != null) {
            aMonitor.beginTask("R4E File Context Compare", -1);
        }
        return this.fCurrentDiffNode;
    }

    public Control createContents(Composite aParent) {
        Control control = super.createContents(aParent);
        UIUtils.selectElementInEditor(this);
        if (this.fCurrentDiffNode != null) {
            this.fCurrentDiffNode.refreshAnnotations();
        }
        return control;
    }

    public Viewer getContentViewer() {
        ICompareNavigator navigator = this.getNavigator();
        if (navigator instanceof CompareEditorInputNavigator) {
            Object[] panes;
            Object[] objectArray = panes = ((CompareEditorInputNavigator)navigator).getPanes();
            int n = panes.length;
            int n2 = 0;
            while (n2 < n) {
                Object pane = objectArray[n2];
                if (pane instanceof CompareContentViewerSwitchingPane) {
                    return ((CompareContentViewerSwitchingPane)pane).getViewer();
                }
                ++n2;
            }
        }
        return null;
    }

    public boolean isAnnotationsAvailable(String aType) {
        IReviewAnnotationModel model;
        return this.fCurrentDiffNode.getAnnotationSupport() != null && (model = this.fCurrentDiffNode.getAnnotationSupport().getAnnotationModel()) != null && model.isAnnotationsAvailable(aType);
    }

    public R4EAnnotation gotoNextAnnotation(String aType) {
        IReviewAnnotationModel model;
        ITextEditor editor;
        R4EAnnotation originalAnnotation = null;
        R4EAnnotation foundAnnotation = null;
        if (this.fCurrentDiffNode.getAnnotationSupport() != null && (editor = this.fCurrentDiffNode.getAnnotationSupport().getEditor()) != null && (model = this.fCurrentDiffNode.getAnnotationSupport().getAnnotationModel()) != null) {
            ICompareNavigator navigator = ((R4ECompareEditorInput)editor.getEditorInput()).getNavigator();
            originalAnnotation = (R4EAnnotation)model.getNextAnnotation(aType);
            if (originalAnnotation != null) {
                R4EAnnotation annotation = originalAnnotation;
                do {
                    IR4EUIPosition annotationPositon;
                    if (UIUtils.selectElementInEditorPane(navigator, annotationPositon = annotation.getR4EPosition(), true)) {
                        foundAnnotation = annotation;
                        break;
                    }
                    annotation = (R4EAnnotation)model.getNextAnnotation(aType);
                } while (!originalAnnotation.getR4EPosition().isSameAs(annotation.getR4EPosition()));
            }
        }
        return foundAnnotation;
    }

    public R4EAnnotation gotoPreviousAnnotation(String aType) {
        IReviewAnnotationModel model;
        ITextEditor editor;
        R4EAnnotation originalAnnotation = null;
        R4EAnnotation foundAnnotation = null;
        if (this.fCurrentDiffNode.getAnnotationSupport() != null && (editor = this.fCurrentDiffNode.getAnnotationSupport().getEditor()) != null && (model = this.fCurrentDiffNode.getAnnotationSupport().getAnnotationModel()) != null) {
            ICompareNavigator navigator = ((R4ECompareEditorInput)editor.getEditorInput()).getNavigator();
            originalAnnotation = (R4EAnnotation)model.getPreviousAnnotation(aType);
            if (originalAnnotation != null) {
                R4EAnnotation annotation = originalAnnotation;
                do {
                    IR4EUIPosition annotationPositon;
                    if (UIUtils.selectElementInEditorPane(navigator, annotationPositon = annotation.getR4EPosition(), true)) {
                        foundAnnotation = annotation;
                        break;
                    }
                    annotation = (R4EAnnotation)model.getPreviousAnnotation(aType);
                } while (!originalAnnotation.getR4EPosition().isSameAs(annotation.getR4EPosition()));
            }
        }
        return foundAnnotation;
    }

    public R4EAnnotationModel getAnnotationModel() {
        if (this.fCurrentDiffNode.getAnnotationSupport() == null) {
            return null;
        }
        return (R4EAnnotationModel)this.fCurrentDiffNode.getAnnotationSupport().getAnnotationModel();
    }
}

