/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.core.model.serial.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.IModelWriter;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.IRWUserBasedRes;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.Persistence;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.RWCommon;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.core.utils.ResourceUtils;
import org.eclipse.mylyn.reviews.r4e.core.utils.filePermission.FileSupportCommandFactory;
import org.eclipse.mylyn.reviews.r4e.core.utils.filePermission.IFileSupportCommand;

public class R4EWriter
extends RWCommon
implements IModelWriter {
    protected final Map<IRWUserBasedRes.ResourceType, String> fresTypeToTag = new HashMap<IRWUserBasedRes.ResourceType, String>();
    private final Persistence.IResSerializationState fResState;

    public R4EWriter(Persistence.IResSerializationState aResState) {
        this.fResState = aResState;
        this.fresTypeToTag.put(IRWUserBasedRes.ResourceType.USER_COMMENT, "_comments");
        this.fresTypeToTag.put(IRWUserBasedRes.ResourceType.USER_ITEM, "_items");
        this.fresTypeToTag.put(IRWUserBasedRes.ResourceType.REVIEW, "_review");
        this.fresTypeToTag.put(IRWUserBasedRes.ResourceType.USER_GROUP, "_group_reviews");
        this.fresTypeToTag.put(IRWUserBasedRes.ResourceType.GROUP, "_group_root");
        this.fresTypeToTag.put(IRWUserBasedRes.ResourceType.DRULE_SET, "_rule_set");
        if (this.fOptions == null) {
            this.fOptions = new HashMap();
        }
        this.fOptions.put("ENCODING", "UTF-8");
    }

    public void saveResources(ResourceSet resourceSet) throws ResourceHandlingException {
        EList resources = resourceSet.getResources();
        if (resources != null) {
            for (Resource resource : resources) {
                this.saveResource(resource);
            }
        }
    }

    public void saveResource(Resource resource) throws ResourceHandlingException {
        if (this.fResState.isSerializationInactive(resource)) {
            return;
        }
        StringBuilder message = new StringBuilder();
        URI resUri = resource.getURI();
        if (resUri == null) {
            message.append("Not possible to save a Resource with URI= null");
            throw new ResourceHandlingException(message.toString());
        }
        URI folderUri = ResourceUtils.getFolderPath(resUri);
        File folder = new File(URI.decode((String)folderUri.devicePath()));
        boolean newFolder = !folder.exists();
        File file = new File(URI.decode((String)resUri.devicePath()));
        boolean newFile = !file.exists();
        try {
            resource.save(this.fOptions);
        }
        catch (IOException e) {
            message.setLength(0);
            message.append("IOException while saving resource with URI: " + resource.getURI().toString());
            throw new ResourceHandlingException(message.toString(), e);
        }
        IFileSupportCommand permitionsUpdater = FileSupportCommandFactory.getInstance();
        if (newFolder && folder.exists()) {
            String absFolderStr = folder.getAbsolutePath();
            try {
                permitionsUpdater.grantWritePermission(absFolderStr);
            }
            catch (IOException e) {
                message.setLength(0);
                message.append("IOException while changing permissions to : " + absFolderStr);
                throw new ResourceHandlingException(message.toString(), e);
            }
        }
        if (newFile && file.exists()) {
            String absFileStr = file.getAbsolutePath();
            try {
                permitionsUpdater.grantWritePermission(absFileStr);
            }
            catch (IOException e) {
                message.setLength(0);
                message.append("IOException while changing permissions to : " + absFileStr);
                throw new ResourceHandlingException(message.toString(), e);
            }
        }
    }

    public URI createResourceURI(String name, URI containerPath, IRWUserBasedRes.ResourceType resourceType) {
        URI resURI = null;
        String reviewFolderSegment = null;
        String fileName = null;
        if (name != null) {
            reviewFolderSegment = this.toValidFileName(name);
            fileName = String.valueOf(reviewFolderSegment) + this.fresTypeToTag.get((Object)resourceType);
            resURI = resourceType == IRWUserBasedRes.ResourceType.REVIEW ? containerPath.appendSegment(reviewFolderSegment).appendSegment(fileName) : containerPath.appendSegment(fileName);
            resURI = resURI.appendFileExtension("xrer");
        }
        return resURI;
    }

    public String toValidFileName(String stValue) {
        String result = null;
        StringBuilder sb = new StringBuilder();
        if (stValue != null) {
            int size = stValue.length();
            int i = 0;
            while (i < size) {
                char c = stValue.charAt(i);
                if (!Character.isLetterOrDigit(c) && c != '-' && c != '_') {
                    sb.append('_');
                } else {
                    sb.append(c);
                }
                ++i;
            }
            result = sb.toString();
        }
        return result;
    }
}

