/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.jmsclient.Consumer;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.FlowControl;
import com.sun.messaging.jmq.jmsclient.FlowControlEntry;
import com.sun.messaging.jmq.jmsclient.ProtocolHandler;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

class ConsumerFlowControlEntry
extends FlowControlEntry {
    public static final String CONSUMER_FLOWCONTROL_LOGGER_NAME = "jakarta.jms.consumer.flowcontrol";
    private static final Logger cfcLogger = Logger.getLogger("jakarta.jms.consumer.flowcontrol", "com.sun.messaging.jmq.jmsclient.resources.ClientResources");
    protected Consumer consumer;
    protected int maxMsgCount;
    protected int thresholdCount;
    protected boolean resumeRequested = false;
    protected int inQueueCounter = 0;
    protected int TEST_peakCount = 0;
    protected int TEST_pauseCount = 0;
    protected int TEST_resumeCount = 0;
    protected int TEST_minResumeCount = Integer.MAX_VALUE;
    protected int TEST_lastResumeCount = -1;
    protected long totalCount = 0L;
    private static boolean sendResumeOnRecover = true;

    ConsumerFlowControlEntry(FlowControl fc, ProtocolHandler protocolHandler, Consumer consumer) {
        super(fc, protocolHandler);
        this.consumer = consumer;
        int prefetchMaxMsgCount = consumer.getPrefetchMaxMsgCount();
        int prefetchThresholdPercent = consumer.getPrefetchThresholdPercent();
        this.maxMsgCount = prefetchMaxMsgCount;
        if (cfcLogger.isLoggable(Level.FINE)) {
            cfcLogger.log(Level.FINE, "ConsumerFlowControl[" + consumer + "]maxMsgCount=" + this.maxMsgCount);
        }
        if (prefetchThresholdPercent < 0) {
            prefetchThresholdPercent = 0;
        }
        if (prefetchThresholdPercent > 100) {
            prefetchThresholdPercent = 100;
        }
        this.thresholdCount = (int)((double)((float)this.maxMsgCount * (float)prefetchThresholdPercent) / 100.0);
        if (this.thresholdCount >= this.maxMsgCount) {
            this.thresholdCount = this.maxMsgCount - 1;
        }
    }

    @Override
    public synchronized void messageReceived() {
        ++this.inQueueCounter;
        if (this.inQueueCounter > this.TEST_peakCount) {
            this.TEST_peakCount = this.inQueueCounter;
        }
    }

    @Override
    public synchronized void messageDelivered() {
        --this.inQueueCounter;
        this.checkAndResumeFlow();
    }

    @Override
    public synchronized void resetFlowControl(int count) {
        this.inQueueCounter = 0;
        if (sendResumeOnRecover) {
            this.checkAndResumeFlow();
        }
    }

    @Override
    public synchronized void setResumeRequested(boolean resumeRequested) {
        if (this.debug) {
            Debug.println("setResumeRequsted[" + this + "] : " + resumeRequested);
        }
        this.resumeRequested = resumeRequested;
        if (resumeRequested) {
            ++this.TEST_pauseCount;
            this.checkAndResumeFlow();
        }
    }

    @Override
    protected synchronized void sendResumeFlow() throws Exception {
        int count = -1;
        if (this.maxMsgCount > 0) {
            count = this.maxMsgCount - this.inQueueCounter;
        }
        if (this.maxMsgCount > 0 && count <= 0) {
            this.fc.removeFromReadyQueue(this);
            return;
        }
        this.setResumeRequested(false);
        if (cfcLogger.isLoggable(Level.FINEST)) {
            cfcLogger.log(Level.FINEST, "ConsumerFlowControl[" + this.consumer + "]sendResumeFlow(" + count + ")total=" + (this.totalCount += (long)count));
        }
        this.protocolHandler.resumeConsumerFlow(this.consumer, count);
        this.fc.removeFromReadyQueue(this);
        if (count < this.TEST_minResumeCount) {
            this.TEST_minResumeCount = count;
        }
        this.TEST_lastResumeCount = count;
        ++this.TEST_resumeCount;
    }

    private void checkAndResumeFlow() {
        if (this.debug) {
            Debug.println("In checkAndResumeFlow : " + this + "\n\tresumeRequested = " + this.resumeRequested + ", maxMsgCount = " + this.maxMsgCount + ", inQueueCounter = " + this.inQueueCounter + ", thresholdCount = " + this.thresholdCount);
        }
        if (this.resumeRequested && (this.maxMsgCount <= 0 || this.inQueueCounter <= this.thresholdCount)) {
            this.fc.addToReadyQueue(this);
        }
    }

    @Override
    protected Hashtable getDebugState() {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("maxMsgCount", String.valueOf(this.maxMsgCount));
        ht.put("thresholdCount", String.valueOf(this.thresholdCount));
        ht.put("inQueueCounter", String.valueOf(this.inQueueCounter));
        ht.put("peakCount", String.valueOf(this.TEST_peakCount));
        ht.put("isFlowPaused", String.valueOf(this.resumeRequested));
        ht.put("pauseCount", String.valueOf(this.TEST_pauseCount));
        ht.put("resumeCount", String.valueOf(this.TEST_resumeCount));
        ht.put("lastResumeCount", String.valueOf(this.TEST_minResumeCount));
        ht.put("minResumeCount", this.TEST_lastResumeCount == -1 ? "---" : Integer.toString(this.TEST_lastResumeCount));
        return ht;
    }

    @Override
    protected Object TEST_GetAttribute(String name) {
        if (name.equals("FlowControl.Count")) {
            return this.inQueueCounter;
        }
        if (name.equals("FlowControl.PeakCount")) {
            return this.TEST_peakCount;
        }
        if (name.equals("FlowControl.IsFlowPaused")) {
            return this.resumeRequested;
        }
        if (name.equals("FlowControl.PauseCount")) {
            return this.TEST_pauseCount;
        }
        if (name.equals("FlowControl.MinResumeCount")) {
            return this.TEST_minResumeCount;
        }
        return null;
    }

    public String toString() {
        return "ConsumerFlowControlEntry[" + this.consumer + "]";
    }

    @Override
    protected void status_report(PrintStream dbg) {
        dbg.println("FlowControlState for : " + this);
        dbg.println("\t# pending messages : " + this.inQueueCounter);
        dbg.println("\t# resumeRequested : " + this.resumeRequested);
        dbg.println("\t# threshodCount : " + this.thresholdCount);
        dbg.println("\t# lastResumeCount : " + (this.TEST_lastResumeCount == -1 ? "---" : Integer.toString(this.TEST_lastResumeCount)));
    }

    static {
        if (System.getProperty("imq.resume_on_recover") != null) {
            sendResumeOnRecover = Boolean.getBoolean("imq.resume_on_recover");
        }
    }
}

