/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.gogo.runtime.Closure;
import org.apache.felix.gogo.runtime.CommandSessionImpl;
import org.apache.felix.gogo.runtime.Expander;
import org.apache.felix.gogo.runtime.Parser;
import org.apache.felix.gogo.runtime.Token;
import org.apache.felix.service.command.Job;
import org.apache.felix.service.command.Process;
import org.apache.felix.service.threadio.ThreadIO;

public class Pipe
implements Callable<Result>,
Process {
    private static final ThreadLocal<Pipe> CURRENT = new ThreadLocal();
    final Closure closure;
    final Job job;
    final Parser.Statement statement;
    final Channel[] streams;
    final boolean[] toclose;
    final boolean endOfPipe;
    int error;
    InputStream in;
    PrintStream out;
    PrintStream err;
    private static final int READ = 1;
    private static final int WRITE = 2;

    public static Pipe getCurrentPipe() {
        return CURRENT.get();
    }

    private static Pipe setCurrentPipe(Pipe pipe) {
        Pipe previous = CURRENT.get();
        CURRENT.set(pipe);
        return previous;
    }

    public Pipe(Closure closure, CommandSessionImpl.JobImpl job, Parser.Statement statement, Channel[] streams, boolean[] toclose, boolean endOfPipe) {
        this.closure = closure;
        this.job = job;
        this.statement = statement;
        this.streams = streams;
        this.toclose = toclose;
        this.endOfPipe = endOfPipe;
    }

    public String toString() {
        return "pipe<" + this.statement + "> out=" + this.streams[1];
    }

    private void setStream(Channel ch, int fd, int readWrite) {
        if ((readWrite & 3) == 0) {
            throw new IllegalArgumentException("Should specify READ and/or WRITE");
        }
        if ((readWrite & 1) != 0 && !(ch instanceof ReadableByteChannel)) {
            throw new IllegalArgumentException("Channel is not readable");
        }
        if ((readWrite & 2) != 0 && !(ch instanceof WritableByteChannel)) {
            throw new IllegalArgumentException("Channel is not writable");
        }
        if (fd == 0 && (readWrite & 1) == 0) {
            throw new IllegalArgumentException("Stdin is not readable");
        }
        if (fd == 1 && (readWrite & 2) == 0) {
            throw new IllegalArgumentException("Stdout is not writable");
        }
        if (fd == 2 && (readWrite & 2) == 0) {
            throw new IllegalArgumentException("Stderr is not writable");
        }
        if (this.streams[fd] != null && (readWrite & 1) != 0 && (readWrite & 2) != 0) {
            throw new IllegalArgumentException("Can not do multios with read/write streams");
        }
        if (this.streams[fd] != null && !this.toclose[fd]) {
            this.streams[fd] = ch;
            this.toclose[fd] = true;
        } else {
            MultiChannel mrbc;
            if (this.streams[fd] instanceof MultiChannel) {
                mrbc = (MultiChannel)this.streams[fd];
            } else {
                mrbc = new MultiChannel();
                mrbc.addChannel(this.streams[fd], this.toclose[fd]);
                this.streams[fd] = mrbc;
                this.toclose[fd] = true;
            }
            mrbc.addChannel(ch, true);
        }
    }

    @Override
    public InputStream in() {
        return this.in;
    }

    @Override
    public PrintStream out() {
        return this.out;
    }

    @Override
    public PrintStream err() {
        return this.err;
    }

    @Override
    public Job job() {
        return this.job;
    }

    @Override
    public boolean isTty(int fd) {
        if (fd < 0 || fd > this.streams.length) {
            return false;
        }
        return this.streams[fd] != null && !this.toclose[fd];
    }

    @Override
    public void error(int error) {
        this.error = error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result call() {
        Thread thread = Thread.currentThread();
        String name = thread.getName();
        try {
            thread.setName("pipe-" + this.statement);
            Result result = this.doCall();
            return result;
        }
        finally {
            thread.setName(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result doCall() {
        WritableByteChannel errChannel = (WritableByteChannel)this.streams[2];
        ThreadIO threadIo = this.closure.session().threadIO();
        try {
            Result result;
            Object result2;
            Pipe previous;
            block44: {
                int i;
                List<Token> tokens = this.statement.redirections();
                for (i = 0; i < tokens.size(); ++i) {
                    ReadableByteChannel ch;
                    SeekableByteChannel ch2;
                    Object val;
                    Token tok;
                    HashSet<StandardOpenOption> options;
                    Token t = tokens.get(i);
                    Matcher m = Pattern.compile("(?:([0-9])?|(&)?)>(>)?").matcher(t);
                    if (m.matches()) {
                        int fd = m.group(1) != null ? Integer.parseInt(m.group(1)) : (m.group(2) != null ? -1 : 1);
                        boolean append = m.group(3) != null;
                        options = new HashSet<StandardOpenOption>();
                        options.add(StandardOpenOption.WRITE);
                        options.add(StandardOpenOption.CREATE);
                        options.add(append ? StandardOpenOption.APPEND : StandardOpenOption.TRUNCATE_EXISTING);
                        tok = tokens.get(++i);
                        val = Expander.expand(tok, this.closure);
                        for (Path p : this.toPaths(val)) {
                            p = this.closure.session().redirect(p, 2);
                            ch2 = Files.newByteChannel(p, options, new FileAttribute[0]);
                            if (fd >= 0) {
                                this.setStream(ch2, fd, 2);
                                continue;
                            }
                            this.setStream(ch2, 1, 2);
                            this.setStream(ch2, 2, 2);
                        }
                        continue;
                    }
                    m = Pattern.compile("([0-9])?>&([0-9])").matcher(t);
                    if (m.matches()) {
                        int fd0 = 1;
                        if (m.group(1) != null) {
                            fd0 = Integer.parseInt(m.group(1));
                        }
                        int fd1 = Integer.parseInt(m.group(2));
                        if (this.streams[fd0] != null && this.toclose[fd0]) {
                            this.streams[fd0].close();
                        }
                        if (this.toclose[fd1]) {
                            Channel channel = this.streams[fd1];
                            AtomicInteger references = new AtomicInteger();
                            this.streams[fd0] = new RefByteChannel(channel, references);
                            this.streams[fd1] = new RefByteChannel(channel, references);
                            this.toclose[fd0] = true;
                            continue;
                        }
                        this.streams[fd0] = this.streams[fd1];
                        this.toclose[fd0] = false;
                        continue;
                    }
                    m = Pattern.compile("([0-9])?<(>)?").matcher(t);
                    if (m.matches()) {
                        int fd = 0;
                        if (m.group(1) != null) {
                            fd = Integer.parseInt(m.group(1));
                        }
                        boolean output = m.group(2) != null;
                        options = new HashSet();
                        options.add(StandardOpenOption.READ);
                        if (output) {
                            options.add(StandardOpenOption.WRITE);
                            options.add(StandardOpenOption.CREATE);
                        }
                        tok = tokens.get(++i);
                        val = Expander.expand(tok, this.closure);
                        for (Path p : this.toPaths(val)) {
                            p = this.closure.session().redirect(p, 1 + (output ? 2 : 0));
                            ch2 = Files.newByteChannel(p, options, new FileAttribute[0]);
                            this.setStream(ch2, fd, 1 + (output ? 2 : 0));
                        }
                        continue;
                    }
                    m = Pattern.compile("<<-?").matcher(t);
                    if (m.matches()) {
                        final Token hereDoc = tokens.get(++i);
                        final boolean stripLeadingTabs = t.charAt(t.length() - 1) == '-';
                        InputStream doc = new InputStream(){
                            final byte[] bytes;
                            int index;
                            boolean nl;
                            {
                                this.bytes = hereDoc.toString().getBytes();
                                this.index = 0;
                                this.nl = true;
                            }

                            @Override
                            public int read() {
                                if (this.nl && stripLeadingTabs) {
                                    while (this.index < this.bytes.length && this.bytes[this.index] == 9) {
                                        ++this.index;
                                    }
                                }
                                if (this.index < this.bytes.length) {
                                    byte ch;
                                    this.nl = (ch = this.bytes[this.index++]) == 10;
                                    return ch;
                                }
                                return -1;
                            }
                        };
                        ch = Channels.newChannel(doc);
                        this.setStream(ch, 0, 1);
                        continue;
                    }
                    if (!Token.eq("<<<", t)) continue;
                    Token word = tokens.get(++i);
                    Object val2 = Expander.expand("\"" + word + "\"", this.closure);
                    String str = val2 != null ? String.valueOf(val2) : "";
                    ch = Channels.newChannel(new ByteArrayInputStream(str.getBytes()));
                    this.setStream(ch, 0, 1);
                }
                for (i = 0; i < this.streams.length; ++i) {
                    this.streams[i] = this.wrap(this.streams[i]);
                }
                this.in = Channels.newInputStream((ReadableByteChannel)this.streams[0]);
                this.out = new PrintStream(Channels.newOutputStream((WritableByteChannel)this.streams[1]), true);
                this.err = new PrintStream(Channels.newOutputStream((WritableByteChannel)this.streams[2]), true);
                errChannel = (WritableByteChannel)this.streams[2];
                if (threadIo != null) {
                    threadIo.setStreams(this.in, this.out, this.err);
                }
                previous = Pipe.setCurrentPipe(this);
                try {
                    if (this.statement.tokens().isEmpty() && this.toclose[0]) {
                        ByteBuffer bb = ByteBuffer.allocate(1024);
                        while (((ReadableByteChannel)this.streams[0]).read(bb) >= 0 || bb.position() != 0) {
                            bb.flip();
                            ((WritableByteChannel)this.streams[1]).write(bb);
                            bb.compact();
                        }
                        result2 = null;
                    } else {
                        result2 = this.closure.execute(this.statement);
                    }
                    if (this.error == 0) break block44;
                    result = new Result(this.error);
                }
                catch (Throwable throwable) {
                    try {
                        Pipe.setCurrentPipe(previous);
                        throw throwable;
                    }
                    catch (Exception e) {
                        if (!this.endOfPipe) {
                            String msg = "gogo: " + e.getClass().getSimpleName() + ": " + e.getMessage() + "\n";
                            try {
                                errChannel.write(ByteBuffer.wrap(msg.getBytes()));
                            }
                            catch (IOException ioe) {
                                e.addSuppressed(ioe);
                            }
                        }
                        Result result3 = new Result(e);
                        return result3;
                    }
                }
                Pipe.setCurrentPipe(previous);
                return result;
            }
            if (result2 != null && !this.endOfPipe && !Boolean.FALSE.equals(this.closure.session().get(".FormatPipe"))) {
                this.out.println(this.closure.session().format(result2, 0));
            }
            result = new Result(result2);
            Pipe.setCurrentPipe(previous);
            return result;
        }
        finally {
            if (this.out != null) {
                this.out.flush();
            }
            if (this.err != null) {
                this.err.flush();
            }
            if (threadIo != null) {
                threadIo.close();
            }
            try {
                for (int i = 0; i < 10; ++i) {
                    if (!this.toclose[i] || this.streams[i] == null) continue;
                    this.streams[i].close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private List<Path> toPaths(Object val) throws IOException {
        Path p;
        ArrayList<Path> paths = new ArrayList<Path>();
        if (val instanceof Collection) {
            for (Object o : (Collection)val) {
                Path p2 = this.toPath(o);
                if (p2 == null) continue;
                paths.add(p2);
            }
        } else if (val != null && (p = this.toPath(val)) != null) {
            paths.add(p);
        }
        if (paths.isEmpty()) {
            throw new IOException("no such file or directory");
        }
        return paths;
    }

    private Path toPath(Object o) {
        String s;
        if (o instanceof Path) {
            return (Path)o;
        }
        if (o instanceof File) {
            return ((File)o).toPath();
        }
        if (o instanceof URI) {
            return Paths.get((URI)o);
        }
        if (o != null && !(s = String.valueOf(o)).isEmpty()) {
            return Paths.get(String.valueOf(o), new String[0]);
        }
        return null;
    }

    private Channel wrap(Channel channel) {
        if (channel == null) {
            return null;
        }
        if (channel instanceof MultiChannel) {
            return channel;
        }
        MultiChannel mch = new MultiChannel();
        mch.addChannel(channel, true);
        return mch;
    }

    private class MultiChannel
    implements ByteChannel {
        protected final List<Channel> channels = new ArrayList<Channel>();
        protected final List<Channel> toClose = new ArrayList<Channel>();
        protected final AtomicBoolean opened = new AtomicBoolean(true);
        int index = 0;

        private MultiChannel() {
        }

        public void addChannel(Channel channel, boolean toclose) {
            this.channels.add(channel);
            if (toclose) {
                this.toClose.add(channel);
            }
        }

        @Override
        public boolean isOpen() {
            return this.opened.get();
        }

        @Override
        public void close() throws IOException {
            if (this.opened.compareAndSet(true, false)) {
                for (Channel channel : this.toClose) {
                    channel.close();
                }
            }
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            int nbRead = -1;
            while (nbRead < 0 && this.index < this.channels.size()) {
                Channel ch = this.channels.get(this.index);
                this.checkSuspend(ch);
                nbRead = ((ReadableByteChannel)ch).read(dst);
                if (nbRead >= 0) break;
                ++this.index;
            }
            return nbRead;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            int pos = src.position();
            for (Channel ch : this.channels) {
                this.checkSuspend(ch);
                src.position(pos);
                while (src.hasRemaining()) {
                    ((WritableByteChannel)ch).write(src);
                }
            }
            return src.position() - pos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkSuspend(Channel ch) throws IOException {
            Job job;
            Channel[] sch = Pipe.this.closure.session().channels;
            if (ch == sch[0] || ch == sch[1] || ch == sch[2]) {
                job = Pipe.this.job;
                synchronized (job) {
                    if (Pipe.this.job.status() == Job.Status.Background) {
                        Pipe.this.job.suspend();
                    }
                }
            }
            job = Pipe.this.job;
            synchronized (job) {
                while (Pipe.this.job.status() == Job.Status.Suspended) {
                    try {
                        Pipe.this.job.wait();
                    }
                    catch (InterruptedException e) {
                        throw (IOException)new InterruptedIOException().initCause(e);
                    }
                }
            }
        }
    }

    private class RefByteChannel
    implements ByteChannel {
        private final Channel channel;
        private final AtomicInteger references;
        private final AtomicBoolean closed = new AtomicBoolean(false);

        public RefByteChannel(Channel channel, AtomicInteger references) {
            this.channel = channel;
            this.references = references;
            references.incrementAndGet();
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            this.ensureOpen();
            return ((ReadableByteChannel)this.channel).read(dst);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            this.ensureOpen();
            return ((WritableByteChannel)this.channel).write(src);
        }

        @Override
        public boolean isOpen() {
            return !this.closed.get();
        }

        private void ensureOpen() throws ClosedChannelException {
            if (this.closed.get()) {
                throw new ClosedChannelException();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed.compareAndSet(false, true) && this.references.decrementAndGet() == 0) {
                this.channel.close();
            }
        }
    }

    public static class Result
    implements org.apache.felix.service.command.Result {
        public final Object result;
        public final Exception exception;
        public final int error;

        public Result(Object result) {
            this.result = result;
            this.exception = null;
            this.error = 0;
        }

        public Result(Exception exception) {
            this.result = null;
            this.exception = exception;
            this.error = 1;
        }

        public Result(int error) {
            this.result = null;
            this.exception = null;
            this.error = error;
        }

        @Override
        public boolean isSuccess() {
            return this.exception == null && this.error == 0;
        }

        @Override
        public Object result() {
            return this.result;
        }

        @Override
        public Exception exception() {
            return this.exception;
        }

        @Override
        public int error() {
            return this.error;
        }
    }
}

