/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.model;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.ui.model.AvailableIUElement;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.Update;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;

public class AvailableUpdateElement
extends AvailableIUElement {
    IInstallableUnit iuToBeUpdated;
    boolean isLockedForUpdate = false;

    public AvailableUpdateElement(Object parent, IInstallableUnit iu, IInstallableUnit iuToBeUpdated, String profileID, boolean shouldShowChildren) {
        super(parent, iu, profileID, shouldShowChildren);
        this.setIsInstalled(false);
        this.iuToBeUpdated = iuToBeUpdated;
        this.init();
    }

    private void init() {
        IProfileRegistry profileRegistry = (IProfileRegistry)this.getProvisioningUI().getSession().getProvisioningAgent().getService(IProfileRegistry.class);
        IProfile profile = profileRegistry.getProfile(this.profileID);
        String property = profile.getInstallableUnitProperty(this.iuToBeUpdated, "org.eclipse.equinox.p2.type.lock");
        try {
            this.isLockedForUpdate = property == null ? false : (Integer.parseInt(property) & 2) > 0;
        }
        catch (NumberFormatException numberFormatException) {
            this.isLockedForUpdate = false;
        }
    }

    public boolean isLockedForUpdate() {
        return this.isLockedForUpdate;
    }

    public IInstallableUnit getIUToBeUpdated() {
        return this.iuToBeUpdated;
    }

    @Override
    protected IProvisioningPlan getSizingPlan(IProgressMonitor monitor) {
        IPlanner planner = this.getPlanner();
        ProfileChangeRequest request = ProfileChangeRequest.createByProfileId((IProvisioningAgent)this.getProvisioningUI().getSession().getProvisioningAgent(), (String)this.profileID);
        if (this.iuToBeUpdated.getId().equals(this.getIU().getId())) {
            request.remove(this.iuToBeUpdated);
        }
        request.add(this.getIU());
        return planner.getProvisioningPlan((IProfileChangeRequest)request, new ProvisioningContext(this.getProvisioningUI().getSession().getProvisioningAgent()), monitor);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailableUpdateElement)) {
            return false;
        }
        if (this.iu == null) {
            return false;
        }
        if (this.iuToBeUpdated == null) {
            return false;
        }
        AvailableUpdateElement other = (AvailableUpdateElement)obj;
        return this.iu.equals((Object)other.getIU()) && this.iuToBeUpdated.equals((Object)other.getIUToBeUpdated());
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.iu == null ? 0 : this.iu.hashCode());
        result = 31 * result + (this.iuToBeUpdated == null ? 0 : this.iuToBeUpdated.hashCode());
        return result;
    }

    public Update getUpdate() {
        return new Update(this.iuToBeUpdated, this.getIU());
    }

    @Override
    protected String getImageId(Object obj) {
        String imageId = super.getImageId(obj);
        if ("obj/iu_obj.png".equals(imageId) && this.isLockedForUpdate()) {
            return "obj/iu_disabled_obj.png";
        }
        return imageId;
    }
}

