/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.equinox.internal.security.storage.SlashEncode;
import org.eclipse.oomph.preferences.util.PreferencesUtil;
import org.eclipse.oomph.setup.internal.core.Messages;
import org.eclipse.oomph.setup.internal.core.ParameterizedStringFilter;
import org.eclipse.oomph.setup.internal.core.SetupCorePlugin;
import org.eclipse.oomph.setup.internal.core.StringFilter;
import org.eclipse.oomph.setup.internal.core.StringFilterDocumentation;
import org.eclipse.oomph.setup.util.StringExpander;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.StringUtil;

public class StringFilterRegistry {
    public static final StringFilterRegistry INSTANCE = new StringFilterRegistry();
    private static final Pattern CAMEL_PATTERN = Pattern.compile("(?:[^\\p{Alnum}]+|^)(\\p{Lower})?");
    private final Map<String, StringFilter> filters = new HashMap<String, StringFilter>();

    private StringFilterRegistry() {
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "file";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_File_description;
            }

            @Override
            public String filter(String value) {
                return URI.createURI((String)value).toFileString();
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "uri";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_URI_description;
            }

            @Override
            public String filter(String value) {
                return URI.createFileURI((String)value).toString();
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "uriLastSegment";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_URILastSegment_description;
            }

            @Override
            public String filter(String value) {
                URI uri = URI.createURI((String)value);
                if (!uri.isHierarchical()) {
                    uri = URI.createURI((String)uri.opaquePart());
                }
                return URI.decode((String)uri.lastSegment());
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "gitRepository";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_GitRepository_description;
            }

            @Override
            public String filter(String value) {
                String result;
                URI uri = URI.createURI((String)value);
                if (!uri.isHierarchical()) {
                    uri = URI.createURI((String)uri.opaquePart());
                }
                if ((result = URI.decode((String)uri.lastSegment())) != null && result.endsWith(".git")) {
                    result = result.substring(0, result.length() - 4);
                }
                return result;
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "username";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_Username_description;
            }

            @Override
            public String filter(String value) {
                return URI.encodeSegment((String)value, (boolean)false).replace(":", "%3A").replace("@", "%40");
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "canonical";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_Canonical_description;
            }

            @Override
            public String filter(String value) {
                if (StringExpander.STRING_EXPANSION_PATTERN.matcher(value).find()) {
                    return value;
                }
                File file = new File(value).getAbsoluteFile();
                try {
                    return file.getCanonicalPath();
                }
                catch (IOException ex) {
                    return file.getAbsolutePath();
                }
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "preferenceNode";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_PreferenceNode_description;
            }

            @Override
            public String filter(String value) {
                return value.replaceAll("/", "\\\\2f");
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "length";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_Length_description;
            }

            @Override
            public String filter(String value) {
                return Integer.toString(value.length());
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "trim";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_Trim_description;
            }

            @Override
            public String filter(String value) {
                return value.trim();
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "trimLeft";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_TrimLeft_description;
            }

            @Override
            public String filter(String value) {
                return StringUtil.trimLeft((String)value);
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "trimRight";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_TrimRight_description;
            }

            @Override
            public String filter(String value) {
                return StringUtil.trimRight((String)value);
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "trimTrailingSlashes";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_TrimTrailingSlashes_description;
            }

            @Override
            public String filter(String value) {
                return StringUtil.trimTrailingSlashes((String)value);
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "upper";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_Upper_description;
            }

            @Override
            public String filter(String value) {
                return value.toUpperCase();
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "lower";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_Lower_description;
            }

            @Override
            public String filter(String value) {
                return value.toLowerCase();
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "cap";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_Cap_description;
            }

            @Override
            public String filter(String value) {
                return StringUtil.cap((String)value);
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "capAll";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_CapAll_description;
            }

            @Override
            public String[] getDeprecations() {
                return new String[]{"allCap"};
            }

            @Override
            public String filter(String value) {
                return StringUtil.capAll((String)value);
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "qualifiedName";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_QualifiedName_description;
            }

            @Override
            public String filter(String value) {
                return value.trim().replaceAll("[^\\p{Alnum}]+", ".").toLowerCase();
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "camel";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_Camel_description;
            }

            @Override
            public String filter(String value) {
                Matcher matcher = CAMEL_PATTERN.matcher(value);
                StringBuffer result = new StringBuffer();
                while (matcher.find()) {
                    String group = matcher.group(1);
                    matcher.appendReplacement(result, group == null ? "" : group.toUpperCase());
                }
                matcher.appendTail(result);
                return result.toString();
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "property";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_Property_description;
            }

            @Override
            public String filter(String value) {
                return value.replaceAll("\\\\", "\\\\\\\\");
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "path";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_Path_description;
            }

            @Override
            public String filter(String value) {
                return value.replaceAll("\\\\", "/");
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "basePath";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_BasePath_description;
            }

            @Override
            public String filter(String value) {
                int pos = (value = value.replaceAll("\\\\", "/")).lastIndexOf(47);
                if (pos == -1) {
                    return "";
                }
                return value.substring(0, pos);
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "lastSegment";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_LastSegment_description;
            }

            @Override
            public String filter(String value) {
                int pos = Math.max(value.lastIndexOf(47), value.lastIndexOf(92));
                if (pos == -1) {
                    return value;
                }
                return value.substring(pos + 1);
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "fileExtension";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_FileExtension_description;
            }

            @Override
            public String filter(String value) {
                int pos = value.lastIndexOf(46);
                if (pos == -1) {
                    return "";
                }
                return value.substring(pos + 1);
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "pathEncode";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_PathEncode_description;
            }

            @Override
            public String filter(String value) {
                return IOUtil.encodeFileName((String)value);
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "urlEncode";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_URLEncode_description;
            }

            @Override
            public String filter(String value) {
                try {
                    return URLEncoder.encode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    return value;
                }
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "urlDecode";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_URLDecode_description;
            }

            @Override
            public String filter(String value) {
                try {
                    return URLDecoder.decode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    return value;
                }
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "slashEncode";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_SlashEncode_description;
            }

            @Override
            public String filter(String value) {
                try {
                    return SlashEncode.encode((String)value);
                }
                catch (Throwable ex) {
                    return value;
                }
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "slashDecode";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_SlashDecode_description;
            }

            @Override
            public String filter(String value) {
                try {
                    return SlashEncode.decode((String)value);
                }
                catch (Throwable ex) {
                    return value;
                }
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "propertyValue";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_PropertyValue_description;
            }

            @Override
            public String filter(String value) {
                PreferencesUtil.PreferenceProperty preferenceProperty = new PreferencesUtil.PreferenceProperty(value);
                String result = preferenceProperty.get(null);
                return result == null ? "" : result;
            }
        });
        this.registerFilter(new DocumentedParameterizedStringFilter(){

            @Override
            public String getName() {
                return "base64";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_Base64_description;
            }

            @Override
            public String filter(String value) {
                return this.filter(value, null);
            }

            @Override
            public String filter(String value, String argument) {
                try {
                    String xmlEncoding;
                    Charset charset = value.startsWith("<?xml") ? Charset.forName((xmlEncoding = URIConverter.ReadableInputStream.getEncoding((String)value)) == null ? "UTF-8" : xmlEncoding) : (argument != null ? Charset.forName(argument.toUpperCase()) : Charset.defaultCharset());
                    return XMLTypeFactory.eINSTANCE.convertBase64Binary(value.getBytes(charset));
                }
                catch (Exception ex) {
                    return value;
                }
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "not";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_Not_description;
            }

            @Override
            public String filter(String value) {
                return "true".equalsIgnoreCase(value) ? "false" : "true";
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            @Override
            public String getName() {
                return "patternQuote";
            }

            @Override
            public String getDescription() {
                return Messages.StringFilterRegistry_PatternQuote_description;
            }

            @Override
            public String filter(String value) {
                return Pattern.quote(value);
            }
        });
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        ArrayList<Map.Entry<String, StringFilter>> entries = new ArrayList<Map.Entry<String, StringFilter>>(StringFilterRegistry.INSTANCE.filters.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<String, StringFilter>>(){

            @Override
            public int compare(Map.Entry<String, StringFilter> e1, Map.Entry<String, StringFilter> e2) {
                return e1.getKey().compareTo(e2.getKey());
            }
        });
        System.out.println("{| class=\"wikitable\"");
        boolean first = true;
        for (Map.Entry entry : entries) {
            String description;
            String name;
            StringFilter filter = (StringFilter)entry.getValue();
            if (filter instanceof StringFilterDocumentation) {
                boolean deprecated;
                name = ((StringFilterDocumentation)((Object)filter)).getName();
                description = ((StringFilterDocumentation)((Object)filter)).getDescription();
                boolean bl = deprecated = !name.toLowerCase().equals(((String)entry.getKey()).toLowerCase());
                if (deprecated) {
                    continue;
                }
            } else {
                name = (String)entry.getKey();
                description = "";
            }
            if (first) {
                first = false;
            } else {
                System.out.println("|-");
            }
            System.out.println("| '''" + name + "''' || " + description);
        }
        System.out.println("|}");
    }

    public String filter(String value, String filterName) {
        StringFilter filter = this.filters.get(filterName.toLowerCase());
        if (filter == null) {
            int argumentIndex = filterName.indexOf(46);
            if (argumentIndex != -1 && (filter = this.filters.get(filterName.substring(0, argumentIndex).toLowerCase())) instanceof ParameterizedStringFilter) {
                ParameterizedStringFilter parameterizedStringFilter = (ParameterizedStringFilter)filter;
                return parameterizedStringFilter.filter(value, filterName.substring(argumentIndex + 1));
            }
            return value;
        }
        return filter.filter(value);
    }

    void initContributions() {
        if (SetupCorePlugin.INSTANCE.isOSGiRunning()) {
            try {
                IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
                IConfigurationElement[] iConfigurationElementArray = extensionRegistry.getConfigurationElementsFor("org.eclipse.oomph.setup.core.stringFilters");
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                    String filterName = configurationElement.getAttribute("name");
                    if (!this.filters.containsKey(filterName)) {
                        try {
                            StringFilter filter = (StringFilter)configurationElement.createExecutableExtension("class");
                            this.registerFilter(filterName, filter);
                        }
                        catch (Exception ex) {
                            SetupCorePlugin.INSTANCE.log(ex);
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception ex) {
                SetupCorePlugin.INSTANCE.log(ex);
            }
        }
    }

    private void registerFilter(String filterName, StringFilter filter) {
        this.filters.put(filterName.toLowerCase(), filter);
    }

    private void registerFilter(StringFilterDocumentation filter) {
        String name = filter.getName().toLowerCase();
        this.filters.put(name, (StringFilter)((Object)filter));
        String[] deprecations = filter.getDeprecations();
        if (deprecations != null) {
            String[] stringArray = deprecations;
            int n = deprecations.length;
            int n2 = 0;
            while (n2 < n) {
                String deprecatedName = stringArray[n2];
                this.filters.put(deprecatedName.toLowerCase(), (StringFilter)((Object)filter));
                ++n2;
            }
        }
    }

    public static abstract class DocumentedParameterizedStringFilter
    implements ParameterizedStringFilter,
    StringFilterDocumentation {
        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public String[] getDeprecations() {
            return null;
        }
    }

    public static abstract class DocumentedStringFilter
    implements StringFilter,
    StringFilterDocumentation {
        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public String[] getDeprecations() {
            return null;
        }
    }
}

