/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.crystals.kyber;

import org.bouncycastle.pqc.crypto.crystals.kyber.KyberKeyParameters;
import org.bouncycastle.pqc.crypto.crystals.kyber.KyberParameters;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class KyberPrivateKeyParameters
extends KyberKeyParameters {
    final byte[] s;
    final byte[] hpk;
    final byte[] nonce;
    final byte[] t;
    final byte[] rho;

    public KyberPrivateKeyParameters(KyberParameters kyberParameters, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        super(true, kyberParameters);
        this.s = Arrays.clone(byArray);
        this.hpk = Arrays.clone(byArray2);
        this.nonce = Arrays.clone(byArray3);
        this.t = Arrays.clone(byArray4);
        this.rho = Arrays.clone(byArray5);
    }

    public byte[] getT() {
        return Arrays.clone(this.t);
    }

    public byte[] getRho() {
        return Arrays.clone(this.rho);
    }

    public byte[] getPrivateKey() {
        return Arrays.concatenate(this.s, this.getPublicKey(), this.hpk, this.nonce);
    }

    public byte[] getEncoded() {
        return this.getPrivateKey();
    }

    public byte[] getPublicKey() {
        return Arrays.concatenate(this.t, this.rho);
    }

    public byte[] getS() {
        return Arrays.clone(this.s);
    }

    public byte[] getHPK() {
        return Arrays.clone(this.hpk);
    }

    public byte[] getNonce() {
        return Arrays.clone(this.nonce);
    }
}

