/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.oomph.internal.util.UtilPlugin;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;

public abstract class OS {
    public static final OS INSTANCE = OS.create();
    private final String osgiOS;
    private final String osgiWS;
    private final String osgiArch;

    protected OS(String osgiOS, String osgiWS, String osgiArch) {
        this.osgiOS = osgiOS;
        this.osgiWS = osgiWS;
        this.osgiArch = osgiArch;
    }

    public String getOsgiOS() {
        return this.osgiOS;
    }

    public String getOsgiWS() {
        return this.osgiWS;
    }

    public String getOsgiArch() {
        return this.osgiArch;
    }

    public boolean isWin() {
        return false;
    }

    public boolean isMac() {
        return false;
    }

    public boolean isLinux() {
        return false;
    }

    public boolean isCurrent() {
        return Platform.getOS().equals(this.osgiOS) && Platform.getWS().equals(this.osgiWS) && Platform.getOSArch().equals(this.osgiArch);
    }

    public boolean isCurrentOS() {
        return Platform.getOS().equals(this.osgiOS);
    }

    public boolean is32BitAvailable() {
        return true;
    }

    public boolean isLineEndingConversionNeeded() {
        return false;
    }

    protected String getEncoding() {
        return "ISO-8859-1";
    }

    protected abstract String[] getOpenCommands();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean openSystemBrowser(String url) {
        try {
            String[] stringArray = this.getOpenCommands();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String command = stringArray[n2];
                if (this.openSystemBrowser(command, url)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {}
        try {
            Class desktopClass = CommonPlugin.loadClass((String)UtilPlugin.INSTANCE.getSymbolicName(), (String)"java.awt.Desktop");
            Method getDesktopMethod = ReflectUtil.getMethod(desktopClass, "getDesktop", new Class[0]);
            Method browseMethod = ReflectUtil.getMethod(desktopClass, "browse", URI.class);
            Object desktop = getDesktopMethod.invoke(null, new Object[0]);
            browseMethod.invoke(desktop, new URI(url));
            return true;
        }
        catch (Throwable ex) {
            UtilPlugin.INSTANCE.log(ex, 2);
            return false;
        }
    }

    private boolean openSystemBrowser(String command, String url) {
        if (IOUtil.getFromPath(command) != null) {
            String[] cmdarray = new String[]{command, url};
            try {
                Process process = Runtime.getRuntime().exec(cmdarray);
                if (process != null) {
                    return true;
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    public String getRelativeProductFolder(String folderName) {
        if (StringUtil.isEmpty(folderName)) {
            return "eclipse";
        }
        return folderName;
    }

    public abstract String getRelativeExecutableFolder();

    public String getExecutableName(String launcherName) {
        return launcherName;
    }

    public abstract String getGitPrefix();

    public abstract String getJREsRoot();

    public abstract OS getForBitness(int var1);

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static OS create() {
        String os = Platform.getOS();
        String ws = Platform.getWS();
        String arch = Platform.getOSArch();
        if ("win32".equals(os)) {
            if ("x86_64".equals(arch)) {
                return new Win64(ws);
            }
            return new Win32(ws, arch);
        }
        if ("macosx".equals(os)) {
            return new Mac(ws, arch);
        }
        if ("linux".equals(os)) {
            return new Linux(ws, arch);
        }
        throw new IllegalStateException("Operating system not supported: " + os);
    }

    private static final class Linux
    extends OS {
        private static final String[] OPEN_COMMANDS = new String[]{"kde-open", "gnome-open", "xdg-open", "sensible-browser"};

        public Linux(String osgiWS, String osgiArch) {
            super("linux", osgiWS, osgiArch);
        }

        public boolean isLinux() {
            return true;
        }

        public String getRelativeExecutableFolder() {
            return "";
        }

        public String getGitPrefix() {
            return "";
        }

        public String getJREsRoot() {
            return "";
        }

        public OS getForBitness(int bitness) {
            String osgiArch = this.getOsgiArch();
            if (bitness == 32) {
                if ("x86_64".equals(osgiArch)) {
                    return this.createLinux("x86");
                }
                if ("ia64".equals(osgiArch)) {
                    return this.createLinux("ia64_32");
                }
            } else {
                if ("x86".equals(osgiArch)) {
                    return this.createLinux("x86_64");
                }
                if ("ia64_32".equals(osgiArch)) {
                    return this.createLinux("ia64");
                }
            }
            return this;
        }

        private Linux createLinux(String arch) {
            return new Linux(this.getOsgiWS(), arch);
        }

        protected String[] getOpenCommands() {
            return OPEN_COMMANDS;
        }
    }

    private static final class Mac
    extends OS {
        private static final String[] OPEN_COMMANDS = new String[]{"open"};

        public Mac(String osgiWS, String osgiArch) {
            super("macosx", osgiWS, osgiArch);
        }

        public boolean isMac() {
            return true;
        }

        public String getRelativeProductFolder(String folderName) {
            if (StringUtil.isEmpty(folderName)) {
                folderName = "Eclipse.app";
            } else if (!folderName.endsWith(".app")) {
                folderName = String.valueOf(folderName) + ".app";
            }
            return String.valueOf(folderName) + "/Contents/Eclipse";
        }

        public String getRelativeExecutableFolder() {
            return "../MacOS";
        }

        public String getGitPrefix() {
            return "/";
        }

        public String getJREsRoot() {
            return "/";
        }

        public boolean is32BitAvailable() {
            return false;
        }

        public OS getForBitness(int bitness) {
            return this;
        }

        protected String[] getOpenCommands() {
            return OPEN_COMMANDS;
        }
    }

    private static class Win32
    extends OS {
        private static final Win32 INSTANCE = new Win32("win32", "x86");
        private static final String[] OPEN_COMMANDS = new String[0];

        public Win32(String osgiWS, String osgiArch) {
            super("win32", osgiWS, osgiArch);
        }

        public boolean isWin() {
            return true;
        }

        public boolean isLineEndingConversionNeeded() {
            return true;
        }

        public String getRelativeExecutableFolder() {
            return "";
        }

        public String getExecutableName(String launcherName) {
            return String.valueOf(super.getExecutableName(launcherName)) + ".exe";
        }

        public String getGitPrefix() {
            return "C:\\Program Files (x86)\\Git";
        }

        public String getJREsRoot() {
            return "C:\\Program Files (x86)\\Java";
        }

        public OS getForBitness(int bitness) {
            if (bitness == 64) {
                return Win64.INSTANCE;
            }
            return this;
        }

        protected String[] getOpenCommands() {
            return OPEN_COMMANDS;
        }
    }

    private static class Win64
    extends Win32 {
        private static final Win64 INSTANCE = new Win64("win32");

        public Win64(String osgiWS) {
            super(osgiWS, "x86_64");
        }

        public String getJREsRoot() {
            return "C:\\Program Files\\Java";
        }

        public OS getForBitness(int bitness) {
            if (bitness == 32) {
                return Win32.INSTANCE;
            }
            return this;
        }
    }
}

