/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public final class SetupEditorSupport {
    public static final Object FAMILY_MODEL_LOAD = new Object();
    public static final String EDITOR_ID = "org.eclipse.oomph.setup.presentation.SetupEditorID";
    public static final String TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    public static final String PREF_TEXT_EDITOR_ID = "preferred.text.editor";

    public static IEditorPart getEditor(IWorkbenchPage page, URI uri, boolean force, LoadHandler ... loadHandlers) {
        URIConverter uriConverter = SetupCoreUtil.createResourceSet().getURIConverter();
        URI trimmedURI = uri.trimFragment();
        URI normalizedURI = uriConverter.normalize(trimmedURI);
        IEditorInput editorInput = SetupEditorSupport.getEditorInput(normalizedURI, trimmedURI);
        return SetupEditorSupport.getEditor(page, editorInput, uri, uriConverter, force, loadHandlers);
    }

    public static IEditorPart getEditor(IWorkbenchPage page, IEditorInput editorInput, URI uri, boolean force, LoadHandler ... loadHandlers) {
        URIConverter uriConverter = SetupCoreUtil.createResourceSet().getURIConverter();
        return SetupEditorSupport.getEditor(page, editorInput, uri, uriConverter, force, loadHandlers);
    }

    private static IEditorPart getEditor(final IWorkbenchPage page, final IEditorInput editorInput, URI uri, URIConverter uriConverter, boolean force, LoadHandler ... loadHandlers) {
        try {
            final String fragment = uri.fragment();
            IEditorPart editor = SetupEditorSupport.findEditor(EDITOR_ID, page, uriConverter, editorInput);
            if (editor != null) {
                page.activate((IWorkbenchPart)editor);
            } else if (force) {
                editor = page.openEditor(editorInput, EDITOR_ID, true, 3);
            }
            if (editor != null) {
                final ArrayList<LoadHandler> handlers = new ArrayList<LoadHandler>(Arrays.asList(loadHandlers));
                if (fragment != null) {
                    handlers.add(0, new LoadHandler(){

                        protected void loaded(IEditorPart editor, EditingDomain domain, Resource resource) {
                            EObject eObject = resource.getEObject(fragment);
                            if (eObject != null) {
                                ((IViewerProvider)editor).getViewer().setSelection((ISelection)new StructuredSelection((Object)eObject), true);
                            }
                        }
                    });
                }
                if (!handlers.isEmpty()) {
                    final IEditorPart finalEditor = editor;
                    Job job = new Job("Loading Setup Editor"){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                Job.getJobManager().join(FAMILY_MODEL_LOAD, monitor);
                                Shell shell = page.getWorkbenchWindow().getShell();
                                if (!shell.isDisposed()) {
                                    shell.getDisplay().asyncExec(new Runnable(){

                                        public void run() {
                                            URI uri = EditUIUtil.getURI((IEditorInput)editorInput);
                                            for (LoadHandler handler : handlers) {
                                                handler.loaded(finalEditor, uri);
                                            }
                                        }
                                    });
                                }
                                return Status.OK_STATUS;
                            }
                            catch (Exception ex) {
                                return SetupUIPlugin.INSTANCE.getStatus(ex);
                            }
                        }
                    };
                    job.setSystem(true);
                    job.schedule();
                }
                return editor;
            }
        }
        catch (Exception ex) {
            SetupUIPlugin.INSTANCE.log(ex);
        }
        return null;
    }

    private static String getTextEditorID() {
        try {
            IEditorDescriptor descriptor;
            String editorID = SetupUIPlugin.INSTANCE.getPreferenceStore().getString(PREF_TEXT_EDITOR_ID);
            if (!StringUtil.isEmpty((String)editorID) && (descriptor = PlatformUI.getWorkbench().getEditorRegistry().findEditor(editorID)) != null) {
                return editorID;
            }
        }
        catch (Exception ex) {
            SetupUIPlugin.INSTANCE.log(ex);
        }
        return TEXT_EDITOR_ID;
    }

    public static IEditorPart getTextEditor(IWorkbenchPage page, URI uri) {
        URIConverter uriConverter = SetupCoreUtil.createResourceSet().getURIConverter();
        URI trimmedURI = uri.trimFragment();
        URI normalizedURI = uriConverter.normalize(trimmedURI);
        IEditorInput editorInput = SetupEditorSupport.getTextEditorInput(normalizedURI, trimmedURI);
        return SetupEditorSupport.getTextEditor(page, uriConverter, editorInput);
    }

    public static IEditorPart getTextEditor(IWorkbenchPage page, IEditorInput editorInput) {
        URIConverter uriConverter = SetupCoreUtil.createResourceSet().getURIConverter();
        return SetupEditorSupport.getTextEditor(page, uriConverter, editorInput);
    }

    public static IEditorPart getTextEditor(IWorkbenchPage page, URIConverter uriConverter, IEditorInput editorInput) {
        try {
            String editorID = SetupEditorSupport.getTextEditorID();
            IEditorPart editor = SetupEditorSupport.findEditor(editorID, page, uriConverter, editorInput);
            if (editor != null) {
                page.activate((IWorkbenchPart)editor);
            } else {
                editor = page.openEditor(editorInput, editorID, true, 3);
            }
            return editor;
        }
        catch (Exception ex) {
            SetupUIPlugin.INSTANCE.log(ex);
            return null;
        }
    }

    private static IEditorPart findEditor(String editorID, IWorkbenchPage page, URIConverter uriConverter, IEditorInput input) {
        URI resourceURI = EditUIUtil.getURI((IEditorInput)input);
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorReference = iEditorReferenceArray[n2];
            if (editorReference.getId().equals(editorID)) {
                try {
                    IEditorInput editorInput = editorReference.getEditorInput();
                    URI editorResourceURI = SetupEditorSupport.getURI(editorInput, uriConverter);
                    if (editorResourceURI != null && (editorResourceURI = uriConverter.normalize(editorResourceURI).trimFragment()).equals(uriConverter.normalize(resourceURI))) {
                        return editorReference.getEditor(true);
                    }
                }
                catch (PartInitException ex) {
                    SetupUIPlugin.INSTANCE.log(ex);
                }
            }
            ++n2;
        }
        return null;
    }

    private static IEditorInput getTextEditorInput(URI normalizedURI, URI originalURI) {
        IEditorInput editorInput = SetupEditorSupport.getEditorInput(normalizedURI, originalURI);
        if (editorInput instanceof URIEditorInput) {
            URIEditorInput uriEditorInput = (URIEditorInput)editorInput;
            final URI uri = SetupContext.resolve((URI)uriEditorInput.getURI());
            if (uri.isFile()) {
                IFileStore store = EFS.getLocalFileSystem().getStore((IPath)new Path(uri.toFileString()));
                return new FileStoreEditorInput(store);
            }
            return new IStorageEditorInput(){

                public Object getAdapter(Class adapter) {
                    return null;
                }

                public String getToolTipText() {
                    return uri.toString();
                }

                public IPersistableElement getPersistable() {
                    return null;
                }

                public String getName() {
                    return uri.lastSegment();
                }

                public ImageDescriptor getImageDescriptor() {
                    return null;
                }

                public boolean exists() {
                    return true;
                }

                public IStorage getStorage() throws CoreException {
                    return new IStorage(){

                        public Object getAdapter(Class adapter) {
                            return null;
                        }

                        public boolean isReadOnly() {
                            return true;
                        }

                        public String getName() {
                            return uri.lastSegment();
                        }

                        public IPath getFullPath() {
                            return new Path(uri.toString());
                        }

                        public InputStream getContents() throws CoreException {
                            URIConverter uriConverter = SetupCoreUtil.createResourceSet().getURIConverter();
                            try {
                                return uriConverter.createInputStream(uri);
                            }
                            catch (IOException ex) {
                                SetupUIPlugin.INSTANCE.coreException(ex);
                                return null;
                            }
                        }
                    };
                }
            };
        }
        return editorInput;
    }

    private static IEditorInput getEditorInput(URI normalizedURI, URI originalURI) {
        IFile file;
        FileEditorInput editorInput;
        if ((normalizedURI = SetupContext.resolve((URI)normalizedURI)).isFile() && !normalizedURI.isRelative() && (editorInput = SetupEditorSupport.getFileEditorInput(normalizedURI)) != null) {
            return editorInput;
        }
        if (normalizedURI.isPlatformResource() && (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(normalizedURI.toPlatformString(true)))).isAccessible()) {
            return new FileEditorInput(file);
        }
        return new URIEditorInput(originalURI, originalURI.lastSegment());
    }

    private static FileEditorInput getFileEditorInput(URI uri) {
        if (uri.isFile() && !uri.isRelative()) {
            try {
                IFile[] files;
                IFile[] iFileArray = files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(new java.net.URI(uri.toString()));
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    IFile file = iFileArray[n2];
                    if (file.isAccessible()) {
                        return new FileEditorInput(file);
                    }
                    ++n2;
                }
            }
            catch (URISyntaxException ex) {
                SetupUIPlugin.INSTANCE.log(ex);
            }
        }
        return null;
    }

    private SetupEditorSupport() {
    }

    public static URI getURI(IEditorInput editorInput, URIConverter uriConverter) {
        try {
            return (URI)ReflectUtil.invokeMethod((Method)EditUIUtil.class.getMethod("getURI", IEditorInput.class, URIConverter.class), null, (Object[])new Object[]{editorInput, uriConverter});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return EditUIUtil.getURI((IEditorInput)editorInput);
        }
    }

    public static class LoadHandler {
        public void loaded(IEditorPart editor, URI uri) {
            this.loaded(editor, ((IEditingDomainProvider)editor).getEditingDomain(), uri);
        }

        protected void loaded(IEditorPart editorPart, EditingDomain domain, URI uri) {
            Resource resource = domain.getResourceSet().getResource(uri, false);
            if (resource != null) {
                this.loaded(editorPart, domain, resource);
            }
        }

        protected void loaded(IEditorPart editor, EditingDomain domain, Resource resource) {
        }
    }
}

