/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.repository.helpers.LocationProperties;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.ProfileDefinition;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.AgentManager;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.p2.core.ProfileCreator;
import org.eclipse.oomph.p2.core.ProfileTransaction;
import org.eclipse.oomph.p2.internal.core.AgentManagerImpl;
import org.eclipse.oomph.p2.internal.core.CachingRepositoryManager;
import org.eclipse.oomph.p2.internal.core.ProfileImpl;
import org.eclipse.oomph.p2.tests.AbstractP2Test;
import org.eclipse.oomph.util.IOUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.JVM)
public class AgentTests
extends AbstractP2Test {
    @Test
    public void testDefaultAgent() throws Exception {
        AgentManager agentManager = P2Util.getAgentManager();
        MatcherAssert.assertThat((Object)agentManager.getAgents().size(), (Matcher)AgentTests.is((Object)1));
        Agent agent = (Agent)agentManager.getAgents().iterator().next();
        MatcherAssert.assertThat((Object)agent.getBundlePools().size(), (Matcher)AgentTests.is((Object)1));
        MatcherAssert.assertThat((Object)agent.getProfiles().size(), (Matcher)AgentTests.is((Object)0));
        AgentManagerImpl.instance = new AgentManagerImpl(this.getUserHome());
        agentManager = P2Util.getAgentManager();
        MatcherAssert.assertThat((Object)agentManager.getAgents().size(), (Matcher)AgentTests.is((Object)1));
        agent = (Agent)agentManager.getAgents().iterator().next();
        MatcherAssert.assertThat((Object)agent.getBundlePools().size(), (Matcher)AgentTests.is((Object)1));
        MatcherAssert.assertThat((Object)agent.getProfiles().size(), (Matcher)AgentTests.is((Object)0));
    }

    @Test
    public void testCreateProfile() throws Exception {
        Profile profile;
        String id;
        Agent agent = this.getAgent();
        int i = 1;
        while (i <= 10) {
            id = "profile" + i;
            profile = agent.addProfile(id, "Test").create();
            MatcherAssert.assertThat((Object)profile.getProfileId(), (Matcher)AgentTests.is((Object)id));
            MatcherAssert.assertThat((Object)profile.getType(), (Matcher)AgentTests.is((Object)"Test"));
            MatcherAssert.assertThat((Object)agent.getProfiles().size(), (Matcher)AgentTests.is((Object)i));
            MatcherAssert.assertThat((Object)agent.getProfileRegistry().getProfiles().length, (Matcher)AgentTests.is((Object)i));
            ++i;
        }
        agent = this.getFreshAgent();
        MatcherAssert.assertThat((Object)agent.getProfiles().size(), (Matcher)AgentTests.is((Object)10));
        i = 1;
        while (i <= 10) {
            id = "profile" + i;
            profile = (ProfileImpl)agent.getProfile(id);
            MatcherAssert.assertThat((Object)profile.getProfileId(), (Matcher)AgentTests.is((Object)id));
            MatcherAssert.assertThat((Object)profile.getType(), (Matcher)AgentTests.is((Object)"Test"));
            MatcherAssert.assertThat((Object)profile.getDelegate(false), (Matcher)AgentTests.nullValue());
            ++i;
        }
        ProfileImpl profileNEW = (ProfileImpl)agent.addProfile("profileNEW", "Test").create();
        MatcherAssert.assertThat((Object)profileNEW.getDelegate(false), (Matcher)AgentTests.not((Matcher)AgentTests.nullValue()));
        int i2 = 1;
        while (i2 <= 10) {
            String id2 = "profile" + i2;
            ProfileImpl profile2 = (ProfileImpl)agent.getProfile(id2);
            MatcherAssert.assertThat((Object)profile2.getDelegate(false), (Matcher)AgentTests.nullValue());
            ++i2;
        }
    }

    @Test
    public void testImmutableProfileProperties() throws Exception {
        Agent agent = this.getAgent();
        Profile profile = agent.addProfile("profile1", "Test").create();
        for (String key : Arrays.asList("org.eclipse.update.install.features", "org.eclipse.equinox.p2.installFolder", "org.eclipse.equinox.p2.cache", "org.eclipse.oomph.p2.profile.type", "org.eclipse.oomph.p2.profile.definition")) {
            try {
                this.commitProfileTransaction(profile.change().setProfileProperty(key, "some value"), false);
                Assert.fail((String)"IllegalArgumentException expected");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @Test
    public void testChangeProfileProperties() throws Exception {
        Agent agent = this.getAgent();
        Profile profile = agent.addProfile("profile1", "Test").set("test", "Test Value").create();
        IProfile delegate = ((ProfileImpl)profile).getDelegate(false);
        MatcherAssert.assertThat((Object)profile.getProperties().size(), (Matcher)AgentTests.is((Object)4));
        MatcherAssert.assertThat((Object)profile.getProperty("test"), (Matcher)AgentTests.is((Object)"Test Value"));
        this.commitProfileTransaction(profile.change().setProfileProperty("test", "Changed Value"), true);
        MatcherAssert.assertThat((Object)profile.getProperties().size(), (Matcher)AgentTests.is((Object)4));
        MatcherAssert.assertThat((Object)profile.getProperty("test"), (Matcher)AgentTests.is((Object)"Changed Value"));
        Profile p = agent.getProfile("profile1");
        MatcherAssert.assertThat((Object)p, (Matcher)AgentTests.is((Object)profile));
        MatcherAssert.assertThat((Object)((ProfileImpl)p).getDelegate(false), (Matcher)AgentTests.sameInstance((Object)delegate));
        this.commitProfileTransaction(profile.change().setProfileProperty("test2", "New Property"), true);
        MatcherAssert.assertThat((Object)profile.getProperties().size(), (Matcher)AgentTests.is((Object)5));
        MatcherAssert.assertThat((Object)profile.getProperty("test2"), (Matcher)AgentTests.is((Object)"New Property"));
        this.commitProfileTransaction(profile.change().removeProfileProperty("test2"), true);
        MatcherAssert.assertThat((Object)profile.getProperties().size(), (Matcher)AgentTests.is((Object)4));
        MatcherAssert.assertThat((Object)profile.getProperty("test2"), (Matcher)AgentTests.nullValue());
    }

    @Test
    public void testDeleteProfile() throws Exception {
        Agent agent = this.getAgent();
        Profile profile = agent.addProfile("profile1", "Test").create();
        MatcherAssert.assertThat((Object)agent.getProfile("profile1"), (Matcher)AgentTests.sameInstance((Object)profile));
        MatcherAssert.assertThat((Object)profile.getLocation().isDirectory(), (Matcher)AgentTests.is((Object)true));
        profile.delete(true);
        MatcherAssert.assertThat((Object)agent.getProfile("profile1"), (Matcher)AgentTests.nullValue());
        MatcherAssert.assertThat((Object)profile.getLocation().exists(), (Matcher)AgentTests.is((Object)false));
    }

    @Test
    public void testUseDeletedProfile() throws Exception {
        Agent agent = this.getAgent();
        Profile profile = agent.addProfile("profile1", "Test1").create();
        File location = profile.getLocation();
        boolean deleted = IOUtil.deleteBestEffort((File)location);
        MatcherAssert.assertThat((Object)deleted, (Matcher)AgentTests.is((Object)true));
        MatcherAssert.assertThat((Object)location.exists(), (Matcher)AgentTests.is((Object)false));
        profile = agent.getProfile("profile1");
        MatcherAssert.assertThat((Object)profile, (Matcher)AgentTests.nullValue());
        MatcherAssert.assertThat((Object)agent.getProfiles().size(), (Matcher)AgentTests.is((Object)0));
        MatcherAssert.assertThat((Object)agent.getProfileRegistry().getProfiles().length, (Matcher)AgentTests.is((Object)0));
        profile = agent.addProfile("profile1", "Test2").create();
        MatcherAssert.assertThat((Object)profile.getProfileId(), (Matcher)AgentTests.is((Object)"profile1"));
        MatcherAssert.assertThat((Object)profile.getType(), (Matcher)AgentTests.is((Object)"Test2"));
        MatcherAssert.assertThat((Object)agent.getProfiles().size(), (Matcher)AgentTests.is((Object)1));
        MatcherAssert.assertThat((Object)agent.getProfileRegistry().getProfiles().length, (Matcher)AgentTests.is((Object)1));
        MatcherAssert.assertThat((Object)location.isDirectory(), (Matcher)AgentTests.is((Object)true));
    }

    @Test
    public void testInstallExceptions() throws Exception {
        Agent agent = this.getAgent();
        Profile profile = agent.addProfile("profile-app1", "Installation").create();
        ProfileTransaction transaction = profile.change();
        transaction.getProfileDefinition().getRequirements().add((Object)P2Factory.eINSTANCE.createRequirement("com.jcraft.jsch"));
        try {
            this.commitProfileTransaction(transaction, false);
            Assert.fail((String)"CoreException expected");
        }
        catch (CoreException coreException) {}
    }

    @Test
    public void testInstallAndUpdateFeature() throws Exception {
        Agent agent = this.getAgent();
        File installFolder = new File(this.getUserHome(), "app1");
        String oldVersion = "org.eclipse.net4j.util_4.2.0.v20130601-1611";
        String newVersion = "org.eclipse.net4j.util_4.2.1.v20140218-1709";
        ProfileCreator creator = agent.addProfile("profile-app1", "Installation");
        Profile profile = creator.setCacheFolder(installFolder).setInstallFolder(installFolder).setInstallFeatures(true).create();
        ProfileTransaction transaction1 = profile.change();
        ProfileDefinition profileDefinition = transaction1.getProfileDefinition();
        profileDefinition.getRequirements().add((Object)P2Factory.eINSTANCE.createRequirement("org.eclipse.net4j.util.feature.group"));
        profileDefinition.getRepositories().add((Object)P2Factory.eINSTANCE.createRepository(CDO_OLD.toURI().toString()));
        this.commitProfileTransaction(transaction1, true);
        MatcherAssert.assertThat((Object)installFolder.isDirectory(), (Matcher)AgentTests.is((Object)true));
        MatcherAssert.assertThat((Object)new File(installFolder, "artifacts.xml").isFile(), (Matcher)AgentTests.is((Object)true));
        MatcherAssert.assertThat((Object)new File(installFolder, "p2").exists(), (Matcher)AgentTests.is((Object)false));
        File features = new File(installFolder, "features");
        MatcherAssert.assertThat((Object)features.isDirectory(), (Matcher)AgentTests.is((Object)true));
        MatcherAssert.assertThat((Object)features.list().length, (Matcher)AgentTests.is((Object)1));
        MatcherAssert.assertThat((Object)new File(features, oldVersion).isDirectory(), (Matcher)AgentTests.is((Object)true));
        ProfileTransaction transaction2 = profile.change();
        transaction2.getProfileDefinition().getRepositories().add((Object)P2Factory.eINSTANCE.createRepository(CDO_NEW.toURI().toString()));
        this.commitProfileTransaction(transaction2, true);
        MatcherAssert.assertThat((Object)features.list().length, (Matcher)AgentTests.is((Object)1));
        MatcherAssert.assertThat((Object)new File(features, oldVersion).exists(), (Matcher)AgentTests.is((Object)false));
        MatcherAssert.assertThat((Object)new File(features, newVersion).isDirectory(), (Matcher)AgentTests.is((Object)true));
        ProfileTransaction transaction3 = profile.change().setRemoveExistingInstallableUnits(true);
        this.commitProfileTransaction(transaction3, false);
        MatcherAssert.assertThat((Object)features.list().length, (Matcher)AgentTests.is((Object)1));
        MatcherAssert.assertThat((Object)new File(features, newVersion).isDirectory(), (Matcher)AgentTests.is((Object)true));
    }

    @Test
    public void testInstallAndUpdateSingleton() throws Exception {
        Agent agent = this.getAgent();
        File installFolder = new File(this.getUserHome(), "app1");
        String oldVersion = "org.eclipse.net4j.util_3.3.0.v20130601-1611.jar";
        String newVersion = "org.eclipse.net4j.util_3.3.1.v20140218-1709.jar";
        ProfileCreator creator = agent.addProfile("profile-app1", "Installation");
        Profile profile = creator.setCacheFolder(installFolder).setInstallFolder(installFolder).create();
        ProfileTransaction transaction1 = profile.change();
        ProfileDefinition profileDefinition = transaction1.getProfileDefinition();
        profileDefinition.getRequirements().add((Object)P2Factory.eINSTANCE.createRequirement("org.eclipse.net4j.util"));
        profileDefinition.getRepositories().add((Object)P2Factory.eINSTANCE.createRepository(CDO_OLD.toURI().toString()));
        this.commitProfileTransaction(transaction1, true);
        MatcherAssert.assertThat((Object)installFolder.isDirectory(), (Matcher)AgentTests.is((Object)true));
        MatcherAssert.assertThat((Object)new File(installFolder, "artifacts.xml").isFile(), (Matcher)AgentTests.is((Object)true));
        MatcherAssert.assertThat((Object)new File(installFolder, "p2").exists(), (Matcher)AgentTests.is((Object)false));
        MatcherAssert.assertThat((Object)new File(installFolder, "features").isDirectory(), (Matcher)AgentTests.is((Object)false));
        File plugins = new File(installFolder, "plugins");
        MatcherAssert.assertThat((Object)plugins.isDirectory(), (Matcher)AgentTests.is((Object)true));
        MatcherAssert.assertThat((Object)plugins.list().length, (Matcher)AgentTests.is((Object)1));
        MatcherAssert.assertThat((Object)new File(plugins, oldVersion).isFile(), (Matcher)AgentTests.is((Object)true));
        ProfileTransaction transaction2 = profile.change();
        transaction2.getProfileDefinition().getRepositories().add((Object)P2Factory.eINSTANCE.createRepository(CDO_NEW.toURI().toString()));
        this.commitProfileTransaction(transaction2, true);
        MatcherAssert.assertThat((Object)plugins.list().length, (Matcher)AgentTests.is((Object)1));
        MatcherAssert.assertThat((Object)new File(plugins, oldVersion).isFile(), (Matcher)AgentTests.is((Object)false));
        MatcherAssert.assertThat((Object)new File(plugins, newVersion).isFile(), (Matcher)AgentTests.is((Object)true));
        ProfileTransaction transaction3 = profile.change().setRemoveExistingInstallableUnits(true);
        this.commitProfileTransaction(transaction3, false);
        MatcherAssert.assertThat((Object)plugins.list().length, (Matcher)AgentTests.is((Object)1));
        MatcherAssert.assertThat((Object)new File(plugins, newVersion).isFile(), (Matcher)AgentTests.is((Object)true));
    }

    @Test
    public void testInstallAndUpdateNonSingleton() throws Exception {
        Agent agent = this.getAgent();
        File installFolder = new File(this.getUserHome(), "app1");
        String oldVersion = "com.jcraft.jsch_0.1.46.v201205102330.jar";
        String newVersion = "com.jcraft.jsch_0.1.50.v201310081430.jar";
        ProfileCreator creator = agent.addProfile("profile-app1", "Installation");
        Profile profile = creator.setCacheFolder(installFolder).setInstallFolder(installFolder).create();
        ProfileTransaction transaction1 = profile.change();
        ProfileDefinition profileDefinition = transaction1.getProfileDefinition();
        profileDefinition.getRequirements().add((Object)P2Factory.eINSTANCE.createRequirement("com.jcraft.jsch", new VersionRange("[0.1.46.v201205102330,0.1.46.v201205102330]")));
        profileDefinition.getRepositories().add((Object)P2Factory.eINSTANCE.createRepository(PLATFORM_OLD.toURI().toString()));
        this.commitProfileTransaction(transaction1, true);
        MatcherAssert.assertThat((Object)installFolder.isDirectory(), (Matcher)AgentTests.is((Object)true));
        MatcherAssert.assertThat((Object)new File(installFolder, "artifacts.xml").isFile(), (Matcher)AgentTests.is((Object)true));
        MatcherAssert.assertThat((Object)new File(installFolder, "p2").exists(), (Matcher)AgentTests.is((Object)false));
        MatcherAssert.assertThat((Object)new File(installFolder, "features").isDirectory(), (Matcher)AgentTests.is((Object)false));
        File plugins = new File(installFolder, "plugins");
        MatcherAssert.assertThat((Object)plugins.list().length, (Matcher)AgentTests.is((Object)1));
        MatcherAssert.assertThat((Object)new File(plugins, oldVersion).isFile(), (Matcher)AgentTests.is((Object)true));
        MatcherAssert.assertThat((Object)new File(plugins, newVersion).isFile(), (Matcher)AgentTests.is((Object)false));
        ProfileTransaction transaction2 = profile.change();
        transaction2.getProfileDefinition().getRepositories().add((Object)P2Factory.eINSTANCE.createRepository(PLATFORM_NEW.toURI().toString()));
        this.commitProfileTransaction(transaction2, true);
        MatcherAssert.assertThat((Object)plugins.list().length, (Matcher)AgentTests.is((Object)1));
        MatcherAssert.assertThat((Object)new File(plugins, oldVersion).isFile(), (Matcher)AgentTests.is((Object)true));
        MatcherAssert.assertThat((Object)new File(plugins, newVersion).isFile(), (Matcher)AgentTests.is((Object)false));
        ProfileTransaction transaction3 = profile.change().setRemoveExistingInstallableUnits(true);
        transaction3.getProfileDefinition().getRequirements().add((Object)P2Factory.eINSTANCE.createRequirement("com.jcraft.jsch", new VersionRange("[0.1.50.v201310081430,0.1.50.v201310081430]")));
        this.commitProfileTransaction(transaction3, true);
        MatcherAssert.assertThat((Object)plugins.list().length, (Matcher)AgentTests.is((Object)2));
        MatcherAssert.assertThat((Object)new File(plugins, oldVersion).isFile(), (Matcher)AgentTests.is((Object)true));
        MatcherAssert.assertThat((Object)new File(plugins, newVersion).isFile(), (Matcher)AgentTests.is((Object)true));
    }

    @Test
    public void testInstallWithoutChange() throws Exception {
        Agent agent = this.getAgent();
        File installFolder = new File(this.getUserHome(), "app1");
        String oldVersion = "com.jcraft.jsch_0.1.46.v201205102330.jar";
        ProfileCreator creator = agent.addProfile("profile-app1", "Installation");
        Profile profile = creator.setCacheFolder(installFolder).setInstallFolder(installFolder).create();
        ProfileTransaction transaction1 = profile.change();
        ProfileDefinition profileDefinition = transaction1.getProfileDefinition();
        profileDefinition.getRequirements().add((Object)P2Factory.eINSTANCE.createRequirement("com.jcraft.jsch"));
        profileDefinition.getRepositories().add((Object)P2Factory.eINSTANCE.createRepository(PLATFORM_OLD.toURI().toString()));
        this.commitProfileTransaction(transaction1, true);
        MatcherAssert.assertThat((Object)installFolder.isDirectory(), (Matcher)AgentTests.is((Object)true));
        MatcherAssert.assertThat((Object)new File(installFolder, "artifacts.xml").isFile(), (Matcher)AgentTests.is((Object)true));
        MatcherAssert.assertThat((Object)new File(installFolder, "p2").exists(), (Matcher)AgentTests.is((Object)false));
        MatcherAssert.assertThat((Object)new File(installFolder, "features").isDirectory(), (Matcher)AgentTests.is((Object)false));
        File plugins = new File(installFolder, "plugins");
        MatcherAssert.assertThat((Object)plugins.list().length, (Matcher)AgentTests.is((Object)1));
        MatcherAssert.assertThat((Object)new File(plugins, oldVersion).isFile(), (Matcher)AgentTests.is((Object)true));
        ProfileTransaction transaction2 = profile.change();
        this.commitProfileTransaction(transaction2, false);
        MatcherAssert.assertThat((Object)plugins.list().length, (Matcher)AgentTests.is((Object)1));
        MatcherAssert.assertThat((Object)new File(plugins, oldVersion).isFile(), (Matcher)AgentTests.is((Object)true));
    }

    @Test
    public void testDetectProfileDefinitionCreation() throws Exception {
        Agent agent = this.getAgent();
        IProfileRegistry profileRegistry = agent.getProfileRegistry();
        profileRegistry.addProfile("profile1");
        agent.refreshProfiles(LOGGER);
        Profile profile = agent.getProfile("profile1");
        ProfileTransaction transaction = profile.change();
        ProfileTransaction.Resolution resolution = transaction.resolve(null, LOGGER);
        MatcherAssert.assertThat((Object)resolution, (Matcher)AgentTests.nullValue());
    }

    public void testInstallStandalone() throws Exception {
        Agent agent = this.getAgent();
        File installFolder = new File(this.getUserHome(), "app1");
        ProfileCreator creator = agent.addProfile("profile-app1", "Installation");
        Profile profile = creator.setCacheFolder(installFolder).setInstallFolder(installFolder).setInstallFeatures(true).create();
        ProfileTransaction transaction = profile.change();
        ProfileDefinition profileDefinition = transaction.getProfileDefinition();
        profileDefinition.getRequirements().add((Object)P2Factory.eINSTANCE.createRequirement("org.eclipse.sdk.ide"));
        profileDefinition.getRepositories().add((Object)P2Factory.eINSTANCE.createRepository(PLATFORM_NEW.toURI().toString()));
        this.commitProfileTransaction(transaction, true);
        MatcherAssert.assertThat((Object)installFolder.isDirectory(), (Matcher)AgentTests.is((Object)true));
        MatcherAssert.assertThat((Object)new File(installFolder, "p2").exists(), (Matcher)AgentTests.is((Object)false));
        File features = new File(installFolder, "features");
        MatcherAssert.assertThat((Object)features.isDirectory(), (Matcher)AgentTests.is((Object)true));
        MatcherAssert.assertThat((Object)features.list().length, (Matcher)AgentTests.is((Object)26));
        File plugins = new File(installFolder, "plugins");
        MatcherAssert.assertThat((Object)plugins.isDirectory(), (Matcher)AgentTests.is((Object)true));
        MatcherAssert.assertThat((Object)plugins.list().length, (Matcher)AgentTests.is((Object)436));
        File artifacts = new File(installFolder, "artifacts.xml");
        MatcherAssert.assertThat((Object)artifacts.isFile(), (Matcher)AgentTests.is((Object)true));
    }

    @Test
    public void testP2IndexSorting() throws Exception {
        Agent testAgent = this.getAgent();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class RepoMan
        extends CachingRepositoryManager.Metadata {
            private final String INDEX_FILE = "p2.index";

            public RepoMan(Agent agent) {
                super(agent.getProvisioningAgent(), null);
                this.INDEX_FILE = "p2.index";
            }

            public void test(String uri) throws Exception {
                URI location = new URI(uri);
                LocationProperties indexFile = this.loadIndexFile(location, (IProgressMonitor)new NullProgressMonitor());
                String[] allSuffixes = this.getAllSuffixes();
                System.out.println("allSuffixes: " + Arrays.asList(allSuffixes));
                String[] preferredOrder = this.getPreferredRepositorySearchOrder(indexFile);
                System.out.println("preferredOrder: " + Arrays.asList(preferredOrder));
                String[] suffixes = this.sortSuffixes(allSuffixes, location, preferredOrder);
                System.out.println("suffixes: " + Arrays.asList(suffixes));
            }

            private LocationProperties loadIndexFile(URI location, IProgressMonitor monitor) {
                LocationProperties locationProperties = LocationProperties.createEmptyIndexFile();
                if (!this.isURL(location)) {
                    return locationProperties;
                }
                if ("file".equals(location.getScheme())) {
                    InputStream localStream = null;
                    try {
                        try {
                            File indexFile = URIUtil.toFile((URI)this.getIndexFileURI(location));
                            if (indexFile != null && indexFile.exists() && indexFile.canRead()) {
                                localStream = new FileInputStream(indexFile);
                                locationProperties = LocationProperties.create((InputStream)localStream);
                            }
                        }
                        finally {
                            if (localStream != null) {
                                localStream.close();
                            }
                        }
                    }
                    catch (IOException iOException) {}
                    return locationProperties;
                }
                ByteArrayOutputStream index = new ByteArrayOutputStream();
                IStatus indexFileStatus = null;
                indexFileStatus = this.getTransport().download(this.getIndexFileURI(location), (OutputStream)index, monitor);
                if (indexFileStatus != null && indexFileStatus.isOK()) {
                    locationProperties = LocationProperties.create((InputStream)new ByteArrayInputStream(index.toByteArray()));
                }
                return locationProperties;
            }

            private boolean isURL(URI location) {
                try {
                    new URL(location.toASCIIString());
                }
                catch (MalformedURLException malformedURLException) {
                    return false;
                }
                return true;
            }

            private URI getIndexFileURI(URI base) {
                String spec = base.toString();
                if (spec.endsWith("p2.index")) {
                    return base;
                }
                return URIUtil.append((URI)base, (String)"p2.index");
            }
        }
        new RepoMan(testAgent).test("http://download.eclipse.org/releases/mars");
    }
}

