/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.oomph.internal.ui.UIPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class FlatButton
extends Canvas
implements Listener,
PaintListener {
    private static final int[] LISTENER_TYPES = new int[]{6, 7, 3, 4, 5, 1, 31, 15, 16};
    private static final Cursor CURSOR_HAND = UIUtil.getDisplay().getSystemCursor(21);
    private static final int DEFAULT_ICON_TEXT_GAP = 5;
    protected static final Color COLOR_DEFAULT_FOCUS_FOREGROUND = UIPlugin.getColor(180, 180, 180);
    protected static final Color COLOR_DEFAULT_DISABLED_BACKGROUND = UIPlugin.getColor(238, 238, 238);
    protected static final Color COLOR_DEFAULT_DISABLED_FOREGROUND = UIPlugin.getColor(170, 170, 170);
    private final List<SelectionListener> selectionListeners = new ArrayList<SelectionListener>();
    private final int buttonStyle;
    private boolean hover;
    private Color hoverColor = UIUtil.getEclipseThemeColor();
    private Color disabledBackgroundColor = COLOR_DEFAULT_DISABLED_BACKGROUND;
    private Color disabledForegroundColor = COLOR_DEFAULT_DISABLED_FOREGROUND;
    private Color internalBackgroundColor;
    private Image image;
    private String text;
    private int cornerWidth;
    private int iconTextGap = 5;
    private int alignment = 16384;
    private boolean listenersPaused;
    private boolean mouseDown;
    private boolean mouseLockedInBounds;
    private boolean showButtonDownState = true;

    public FlatButton(Composite parent, int buttonStyle) {
        super(parent, 0x20040000);
        this.buttonStyle = buttonStyle;
        this.setLayout((Layout)new GridLayout(1, false));
        this.setCursor(CURSOR_HAND);
        this.hookListeners();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setCursor((Cursor)(enabled ? CURSOR_HAND : null));
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (this.text != text) {
            this.text = text;
            this.redraw();
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        if (this.image != image) {
            this.image = image;
            this.redraw();
        }
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        switch (alignment) {
            case 16384: 
            case 131072: 
            case 0x1000000: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Alignment must be one of SWT.LEFT, SWT.CENTER, SWT.RIGHT");
            }
        }
        if (this.alignment != alignment) {
            this.alignment = alignment;
            this.redraw();
        }
    }

    public int getCornerWidth() {
        return this.cornerWidth;
    }

    public void setCornerWidth(int cornerWidth) {
        if (this.cornerWidth != cornerWidth) {
            this.cornerWidth = cornerWidth;
            this.redraw();
        }
    }

    public Color getBackground() {
        if (this.internalBackgroundColor == null) {
            return super.getBackground();
        }
        return this.internalBackgroundColor;
    }

    public void setBackground(Color color) {
        if (this.internalBackgroundColor != color) {
            this.internalBackgroundColor = color;
            this.redraw();
        }
    }

    public Color getHoverColor() {
        return this.hoverColor;
    }

    public void setHoverColor(Color hoverColor) {
        if (this.hoverColor != hoverColor) {
            this.hoverColor = hoverColor;
            this.redraw();
        }
    }

    public Color getDisabledForegroundColor() {
        return this.disabledForegroundColor;
    }

    public void setDisabledForegroundColor(Color color) {
        if (!ObjectUtil.equals((Object)this.disabledForegroundColor, (Object)color)) {
            this.disabledForegroundColor = color;
            this.redraw();
        }
    }

    protected void setDisabledBackgroundColor(Color color) {
        if (!ObjectUtil.equals((Object)this.disabledBackgroundColor, (Object)color)) {
            this.disabledBackgroundColor = color;
            this.redraw();
        }
    }

    protected Color getDisabledBackgroundColor() {
        return this.disabledBackgroundColor;
    }

    public boolean isShowButtonDownState() {
        return this.showButtonDownState;
    }

    public void setShowButtonDownState(boolean showButtonDownState) {
        if (this.showButtonDownState != showButtonDownState) {
            this.showButtonDownState = showButtonDownState;
            this.redraw();
        }
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    public void setIconTextGap(int iconTextGap) {
        if (this.iconTextGap != iconTextGap) {
            this.iconTextGap = iconTextGap;
            Composite parent = this.getParent();
            if (parent != null) {
                parent.layout();
            }
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.selectionListeners.remove(this.selectionListeners);
    }

    public boolean isHover() {
        return this.hover;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = null;
        size = wHint != -1 && hHint != -1 ? new Point(wHint, hHint) : this.getTotalSize();
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        ++size.x;
        ++size.y;
        return size;
    }

    protected Point getTotalSize() {
        int width = 0;
        int height = 0;
        if (this.text != null) {
            Point textSize;
            GC gc = new GC((Drawable)this);
            try {
                textSize = gc.textExtent(this.text);
            }
            finally {
                gc.dispose();
            }
            width += textSize.x;
            if (this.image != null) {
                width += this.iconTextGap;
            }
            height += textSize.y;
        }
        if (this.image != null) {
            Rectangle imgBounds = this.image.getBounds();
            width += imgBounds.width;
            int heightDiff = imgBounds.height - height;
            if (heightDiff > 0) {
                height += heightDiff;
            }
        }
        return new Point(width, height);
    }

    protected void hookListeners() {
        int[] nArray = LISTENER_TYPES;
        int n = LISTENER_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            int type = nArray[n2];
            this.addListener(type, this);
            ++n2;
        }
        this.addPaintListener(this);
    }

    protected void unhookListeners() {
        this.removePaintListener(this);
        int[] nArray = LISTENER_TYPES;
        int n = LISTENER_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            int type = nArray[n2];
            this.removeListener(type, this);
            ++n2;
        }
    }

    public void dispose() {
        this.unhookListeners();
        super.dispose();
    }

    protected void drawContent(PaintEvent e) {
        GC gc = e.gc;
        Point totalSize = this.getTotalSize();
        Rectangle clientArea = this.getClientArea();
        int startX = 0;
        switch (this.getAlignment()) {
            case 0x1000000: {
                startX = (clientArea.x + clientArea.width - totalSize.x) / 2;
                break;
            }
            case 131072: {
                startX = clientArea.x + clientArea.width - totalSize.x;
            }
        }
        if (this.showButtonDownState && this.mouseLockedInBounds) {
            ++startX;
        }
        if (this.image != null) {
            Rectangle imgBounds = this.image.getBounds();
            int imgY = (clientArea.y + clientArea.height - imgBounds.height) / 2;
            if (this.showButtonDownState && this.mouseLockedInBounds) {
                ++imgY;
            }
            this.drawImage(gc, startX, imgY);
            startX += imgBounds.width;
            if (this.text != null) {
                startX += this.iconTextGap;
            }
        }
        if (this.text != null) {
            Point textExtent = gc.textExtent(this.text);
            int textY = (clientArea.y + clientArea.height - textExtent.y) / 2;
            if (this.showButtonDownState && this.mouseLockedInBounds) {
                ++textY;
            }
            this.drawText(gc, startX, textY);
        }
    }

    protected void drawText(GC gc, int x, int y) {
        if (this.isEnabled()) {
            if (this.isHover() || this.isFocusControl() && !this.listenersPaused && this.hoverColor != null) {
                gc.setForeground(this.hoverColor);
            }
        } else if (this.disabledForegroundColor != null) {
            gc.setForeground(this.disabledForegroundColor);
        }
        gc.drawText(this.text, x, y, true);
    }

    protected void drawImage(GC gc, int x, int y) {
        gc.drawImage(this.image, x, y);
    }

    public int getStyle() {
        return this.buttonStyle;
    }

    protected void checkSubclass() {
    }

    public void handleEvent(final Event event) {
        switch (event.type) {
            case 6: {
                this.onMouseEnter(event);
                break;
            }
            case 4: {
                this.onMouseUp(event);
                break;
            }
            case 7: {
                this.onMouseExit(event);
                break;
            }
            case 3: {
                this.onMouseDown(event);
                break;
            }
            case 5: {
                this.mouseMoveInternal(event);
                break;
            }
            case 1: {
                if (event.character != '\r' && event.character != ' ') break;
                this.notifySelectionListeners(null);
                break;
            }
            case 31: {
                event.doit = true;
                break;
            }
            case 15: {
                this.onFocusIn(event);
                break;
            }
            case 16: {
                UIUtil.asyncExec((Control)this, new Runnable(){

                    public void run() {
                        FlatButton.this.onFocusOut(event);
                    }
                });
            }
        }
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    protected void onFocusOut(Event event) {
    }

    protected void onFocusIn(Event event) {
    }

    private void mouseMoveInternal(Event event) {
        if (this.mouseDown) {
            boolean inBounds;
            Rectangle bounds = this.getBounds();
            boolean bl = inBounds = event.x >= 0 && event.x <= bounds.width && event.y >= 0 && event.y <= bounds.height;
            if (inBounds != this.mouseLockedInBounds) {
                this.mouseLockedInBounds = inBounds;
                if (inBounds) {
                    this.onMouseEnter(event);
                } else {
                    this.onMouseExit(event);
                }
            }
        }
    }

    protected void onMouseDown(Event event) {
        this.mouseDown = true;
        this.mouseLockedInBounds = true;
    }

    protected void onMouseExit(Event event) {
        this.setHover(false);
    }

    protected void onMouseUp(Event event) {
        this.mouseLockedInBounds = false;
        this.mouseDown = false;
        this.setHover(true);
        this.notifySelectionListeners(new SelectionEvent(event));
    }

    protected void onHover() {
    }

    protected void onMouseEnter(Event event) {
        this.setHover(true);
    }

    private void setHover(boolean hover) {
        if (this.hover != hover) {
            this.hover = hover;
            this.onHover();
        }
    }

    private void notifySelectionListeners(SelectionEvent event) {
        if (!this.isEnabled() || this.listenersPaused) {
            return;
        }
        Rectangle r = this.getBounds();
        if (event == null || event.x >= 0 && event.x <= r.width && event.y >= 0 && event.y <= r.height && !this.selectionListeners.isEmpty()) {
            for (SelectionListener listener : this.selectionListeners) {
                try {
                    listener.widgetSelected(event);
                }
                catch (Exception ex) {
                    UIPlugin.INSTANCE.log(ex);
                }
            }
        }
    }

    protected boolean isListenersPaused() {
        return this.listenersPaused;
    }

    protected void setListenersPaused(boolean pause) {
        this.listenersPaused = pause;
    }

    public final void paintControl(PaintEvent e) {
        Rectangle clientBounds = this.getClientArea();
        GC gc = e.gc;
        gc.setAntialias(1);
        int clientX = clientBounds.x;
        int clientY = clientBounds.y;
        int clientWidth = clientBounds.width - 1;
        int clientHeight = clientBounds.height - 1;
        if (this.showButtonDownState && this.mouseLockedInBounds) {
            ++clientX;
            ++clientY;
        }
        this.clearBackground(gc, clientBounds);
        this.drawBackground(gc, clientX, clientY, clientWidth, clientHeight, 0, 0);
        this.drawContent(e);
        if (this.isHover()) {
            this.drawHoverState(gc, clientX, clientY, clientWidth, clientHeight);
        }
        if (this.isFocusControl()) {
            this.drawFocusState(gc, clientX, clientY, clientWidth, clientHeight);
        }
    }

    protected void drawFocusState(GC gc, int x, int y, int width, int height) {
        Color oldForeground = gc.getForeground();
        gc.setForeground(COLOR_DEFAULT_FOCUS_FOREGROUND);
        gc.drawRoundRectangle(x, y, width, height, this.cornerWidth, this.cornerWidth);
        gc.setForeground(oldForeground);
    }

    private void clearBackground(GC gc, Rectangle bounds) {
        Composite parent = this.getParent();
        Color parentBackground = null;
        do {
            parentBackground = parent.getBackground();
            parent = parent.getParent();
        } while (parentBackground == null && parent.getParent() != null);
        if (parentBackground != null) {
            Color oldBG = gc.getBackground();
            gc.setBackground(parentBackground);
            gc.fillRectangle(bounds);
            gc.setBackground(oldBG);
        }
    }

    protected void drawHoverState(GC gc, int x, int y, int width, int height) {
    }

    public void drawBackground(GC gc, int x, int y, int width, int height, int offsetX, int offsetY) {
        if (this.isEnabled()) {
            if (this.internalBackgroundColor != null) {
                gc.setBackground(this.internalBackgroundColor);
                gc.fillRoundRectangle(x, y, width, height, this.cornerWidth, this.cornerWidth);
            }
        } else if (this.disabledBackgroundColor != null) {
            gc.setBackground(this.disabledBackgroundColor);
            gc.fillRoundRectangle(x, y, width, height, this.cornerWidth, this.cornerWidth);
        }
    }
}

