/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.export.excel;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.export.IExportFormatter;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;

public class DefaultExportFormatter
implements IExportFormatter {
    private final IDisplayConverter fallbackConverter = new DefaultDisplayConverter();

    @Override
    public Object formatForExport(ILayerCell cell, IConfigRegistry configRegistry) {
        Object dataValue = cell.getDataValue();
        IDisplayConverter displayConverter = configRegistry.getConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, cell.getDisplayMode(), (List<String>)cell.getConfigLabels());
        if (displayConverter == null) {
            displayConverter = this.fallbackConverter;
        }
        return displayConverter.canonicalToDisplayValue(cell, configRegistry, dataValue);
    }
}

