/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

/**
 * This package contains interfaces for {@link org.eclipse.collections.api.partition.bag.sorted.PartitionSortedBag}.
 * <p>
 *     A PartitionSortedBag is the result of splitting a sorted bag into two sorted bags based on a Predicate.
 * <p>
 *      This package contains the following interfaces:
 * <ul>
 *     <li>
 *         {@link org.eclipse.collections.api.partition.bag.sorted.PartitionSortedBag} - a Read-only PartitionSortedSet API.
 *     </li>
 *     <li>
 *         {@link org.eclipse.collections.api.partition.bag.sorted.PartitionMutableSortedBag} - a modifiable PartitionSortedSet.
 *     </li>
 * </ul>
 */
package org.eclipse.collections.api.partition.bag.sorted;
