/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.tracwiki;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.AbstractMarkupLanguage;
import org.eclipse.mylyn.wikitext.parser.markup.Block;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.parser.markup.token.ImpliedHyperlinkReplacementToken;
import org.eclipse.mylyn.wikitext.tracwiki.internal.block.DefinitionListBlock;
import org.eclipse.mylyn.wikitext.tracwiki.internal.block.HeadingBlock;
import org.eclipse.mylyn.wikitext.tracwiki.internal.block.ListBlock;
import org.eclipse.mylyn.wikitext.tracwiki.internal.block.ParagraphBlock;
import org.eclipse.mylyn.wikitext.tracwiki.internal.block.PreformattedBlock;
import org.eclipse.mylyn.wikitext.tracwiki.internal.block.QuoteBlock;
import org.eclipse.mylyn.wikitext.tracwiki.internal.block.TableBlock;
import org.eclipse.mylyn.wikitext.tracwiki.internal.phrase.EscapePhraseModifier;
import org.eclipse.mylyn.wikitext.tracwiki.internal.phrase.MonospacePhraseModifier;
import org.eclipse.mylyn.wikitext.tracwiki.internal.phrase.SimplePhraseModifier;
import org.eclipse.mylyn.wikitext.tracwiki.internal.token.BangEscapeToken;
import org.eclipse.mylyn.wikitext.tracwiki.internal.token.ChangesetLinkReplacementToken;
import org.eclipse.mylyn.wikitext.tracwiki.internal.token.HyperlinkReplacementToken;
import org.eclipse.mylyn.wikitext.tracwiki.internal.token.LineBreakToken;
import org.eclipse.mylyn.wikitext.tracwiki.internal.token.MacroReplacementToken;
import org.eclipse.mylyn.wikitext.tracwiki.internal.token.MilestoneLinkReplacementToken;
import org.eclipse.mylyn.wikitext.tracwiki.internal.token.ReportLinkReplacementToken;
import org.eclipse.mylyn.wikitext.tracwiki.internal.token.RevisionLogReplacementToken;
import org.eclipse.mylyn.wikitext.tracwiki.internal.token.SourceLinkReplacementToken;
import org.eclipse.mylyn.wikitext.tracwiki.internal.token.TicketAttachmentLinkReplacementToken;
import org.eclipse.mylyn.wikitext.tracwiki.internal.token.TicketLinkReplacementToken;
import org.eclipse.mylyn.wikitext.tracwiki.internal.token.WikiLinkReplacementToken;
import org.eclipse.mylyn.wikitext.tracwiki.internal.token.WikiWordReplacementToken;

public class TracWikiLanguage
extends AbstractMarkupLanguage {
    private boolean autoLinking = true;
    private String serverUrl;

    public TracWikiLanguage() {
        this.setName("TracWiki");
    }

    public String toInternalHref(String pageName) {
        String pageId = pageName;
        if (pageId.startsWith("#")) {
            return pageId;
        }
        return MessageFormat.format(this.internalLinkPattern, pageId);
    }

    public String toTicketHref(String ticketId, String commentNumber) {
        String url = this.serverUrl + "ticket/" + ticketId;
        if (commentNumber != null) {
            url = url + "#comment:" + commentNumber;
        }
        return url;
    }

    public String toChangesetHref(String changesetId, String restriction) {
        String url = this.serverUrl + "changeset/" + changesetId;
        if (restriction != null) {
            url = url + "/" + restriction;
        }
        return url;
    }

    public String toRevisionLogHref(String revision1, String revision2, String restriction) {
        String url = this.serverUrl + "log/";
        if (restriction != null) {
            url = url + restriction;
        }
        url = url + "?revs=" + revision1 + "-" + revision2;
        return url;
    }

    public String toReportHref(String reportId) {
        String url = this.serverUrl + "report/" + reportId;
        return url;
    }

    public String toMilestoneHref(String milestoneId) {
        String url = this.serverUrl + "milestone/" + milestoneId;
        return url;
    }

    public String toTicketAttachmentHref(String ticketId, String attachment) {
        String url = this.serverUrl + "ticket/" + ticketId + "/" + attachment;
        return url;
    }

    public String toSourceBrowserHref(String source, String revision, String line) {
        String url = this.serverUrl + "browser";
        if (source.charAt(0) != '/') {
            url = url + "/";
        }
        url = url + source;
        if (revision != null) {
            url = url + "?rev=" + revision;
        }
        if (line != null) {
            url = url + "#L" + line;
        }
        return url;
    }

    public boolean computeInternalLinkExists(String link) {
        return true;
    }

    public boolean isAutoLinking() {
        return this.autoLinking;
    }

    public void setAutoLinking(boolean autoLinking) {
        this.autoLinking = autoLinking;
    }

    public void setServerUrl(String url) {
        if (url != null && !((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        this.serverUrl = url;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    protected void addStandardBlocks(List<Block> blocks, List<Block> paragraphBreakingBlocks) {
        ListBlock listBlock = new ListBlock();
        blocks.add(listBlock);
        paragraphBreakingBlocks.add(listBlock);
        DefinitionListBlock definitionListBlock = new DefinitionListBlock();
        blocks.add(definitionListBlock);
        paragraphBreakingBlocks.add(definitionListBlock);
        HeadingBlock headingBlock = new HeadingBlock();
        blocks.add(headingBlock);
        paragraphBreakingBlocks.add(headingBlock);
        PreformattedBlock preformattedBlock = new PreformattedBlock();
        blocks.add(preformattedBlock);
        paragraphBreakingBlocks.add(preformattedBlock);
        QuoteBlock quoteBlock = new QuoteBlock();
        blocks.add(quoteBlock);
        paragraphBreakingBlocks.add(quoteBlock);
        TableBlock tableBlock = new TableBlock();
        blocks.add(tableBlock);
        paragraphBreakingBlocks.add(tableBlock);
    }

    protected void addStandardPhraseModifiers(AbstractMarkupLanguage.PatternBasedSyntax phraseModifierSyntax) {
        phraseModifierSyntax.add((PatternBasedElement)new MonospacePhraseModifier());
        phraseModifierSyntax.beginGroup("(?:(?<=[\\s\\.\\\"'?!;:\\)\\(\\{\\}\\[\\]-])|^)(?:", 0);
        phraseModifierSyntax.add((PatternBasedElement)new EscapePhraseModifier());
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("'''''", new DocumentBuilder.SpanType[]{DocumentBuilder.SpanType.BOLD, DocumentBuilder.SpanType.ITALIC}, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("'''", DocumentBuilder.SpanType.BOLD, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("''", DocumentBuilder.SpanType.ITALIC, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("__", DocumentBuilder.SpanType.UNDERLINED, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("~~", DocumentBuilder.SpanType.DELETED, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("^", DocumentBuilder.SpanType.SUPERSCRIPT, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier(",,", DocumentBuilder.SpanType.SUBSCRIPT, true));
        phraseModifierSyntax.endGroup(")(?=\\W|$)", 0);
    }

    protected void addStandardTokens(AbstractMarkupLanguage.PatternBasedSyntax tokenSyntax) {
        tokenSyntax.add((PatternBasedElement)new BangEscapeToken());
        tokenSyntax.add((PatternBasedElement)new LineBreakToken());
        tokenSyntax.beginGroup("(?:(?<=[\\s\\.\\\"'?!;:\\)\\(\\{\\}\\[\\]-])|^)(?:", 0);
        tokenSyntax.add((PatternBasedElement)new MacroReplacementToken());
        tokenSyntax.add((PatternBasedElement)new RevisionLogReplacementToken());
        tokenSyntax.add((PatternBasedElement)new ChangesetLinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new HyperlinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new ImpliedHyperlinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new TicketAttachmentLinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new TicketLinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new ReportLinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new MilestoneLinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new SourceLinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new WikiLinkReplacementToken());
        if (this.configuration == null || this.configuration.isWikiWordLinking() == null || this.configuration.isWikiWordLinking().booleanValue()) {
            tokenSyntax.add((PatternBasedElement)new WikiWordReplacementToken());
        }
        tokenSyntax.endGroup(")(?=\\W|$)", 0);
    }

    protected Block createParagraphBlock() {
        return new ParagraphBlock();
    }
}

