/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.inlines;

import com.google.common.base.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Characters;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Cursor;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Inline;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.SourceSpan;

public class StringCharactersSpan
extends SourceSpan {
    private final Pattern pattern = Pattern.compile("((?: *[^\n `\\[\\]\\\\!<&*_h]+)+).*", 32);

    @Override
    public Optional<? extends Inline> createInline(Cursor cursor) {
        Matcher matcher = cursor.matcher(this.pattern);
        if (matcher.matches()) {
            String group = matcher.group(1);
            int length = cursor.getOffset(matcher.end(1)) - cursor.getOffset();
            return Optional.of((Object)new Characters(cursor.getLineAtOffset(), cursor.getOffset(), length, group));
        }
        return Optional.absent();
    }
}

