/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.eclipse.mylyn.wikitext.internal.parser.html.AbstractSaxHtmlParser;
import org.eclipse.mylyn.wikitext.internal.parser.html.HtmlCleaner;
import org.eclipse.mylyn.wikitext.internal.parser.html.XHtmlParser;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HtmlParser {
    private final AbstractSaxHtmlParser delegate;

    private HtmlParser(AbstractSaxHtmlParser parser) {
        this.delegate = (AbstractSaxHtmlParser)Preconditions.checkNotNull((Object)parser);
    }

    public HtmlParser() {
        AbstractSaxHtmlParser parser = this.isJsoupAvailable() ? new org.eclipse.mylyn.wikitext.internal.parser.html.HtmlParser() : new XHtmlParser();
        this.delegate = parser;
    }

    public static HtmlParser instanceWithHtmlCleanupRules() {
        org.eclipse.mylyn.wikitext.internal.parser.html.HtmlParser parser = new org.eclipse.mylyn.wikitext.internal.parser.html.HtmlParser();
        HtmlCleaner htmlCleaner = new HtmlCleaner();
        htmlCleaner.configure(parser);
        return new HtmlParser(parser);
    }

    public static HtmlParser instance() {
        return new HtmlParser();
    }

    AbstractSaxHtmlParser getDelegate() {
        return this.delegate;
    }

    public void parse(InputSource input, DocumentBuilder builder) throws IOException, SAXException {
        this.parse(input, builder, true);
    }

    public void parse(InputSource input, DocumentBuilder builder, boolean asDocument) throws IOException, SAXException {
        Preconditions.checkNotNull((Object)input);
        Preconditions.checkNotNull((Object)builder);
        this.delegate.parse(input, builder, asDocument);
    }

    boolean isJsoupAvailable() {
        try {
            Class.forName("org.jsoup.Jsoup", true, HtmlParser.class.getClassLoader());
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }
}

