/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.epub.core;

import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.mylyn.docs.epub.core.Publication;
import org.eclipse.mylyn.docs.epub.dc.Creator;
import org.eclipse.mylyn.docs.epub.dc.Date;
import org.eclipse.mylyn.docs.epub.dc.Identifier;
import org.eclipse.mylyn.docs.epub.dc.Language;
import org.eclipse.mylyn.docs.epub.dc.Rights;
import org.eclipse.mylyn.docs.epub.dc.Subject;
import org.eclipse.mylyn.docs.epub.dc.Title;
import org.eclipse.mylyn.docs.epub.opf.Item;

public class PublicationProxy {
    private static final String EMPTY_STRING = "";
    private static final String ID = "epub-id";
    private static final String STYLING_ID = "styling";
    private static final EStructuralFeature TEXT = XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_Text();
    private final Publication publication;
    private final File markupFile;
    TreeMap<String, String> sorted_locales;

    public PublicationProxy() {
        this.publication = Publication.getVersion2Instance();
        this.markupFile = null;
    }

    public PublicationProxy(Publication publication, File markupFile) {
        String[] iso639s;
        this.publication = publication;
        this.markupFile = markupFile;
        String id = publication.getPackage().getUniqueIdentifier();
        if (id == null || id.trim().length() == 0) {
            publication.getPackage().setUniqueIdentifier(ID);
            publication.addIdentifier(ID, "UUID", UUID.randomUUID().toString());
        }
        publication.getPackage().getManifest().getItems().clear();
        publication.getPackage().getGuide().getGuideItems().clear();
        publication.getPackage().getSpine().getSpineItems().clear();
        this.sorted_locales = new TreeMap();
        for (String iso639 : iso639s = Locale.getISOLanguages()) {
            Locale locale = new Locale(iso639);
            this.sorted_locales.put(locale.getDisplayLanguage(), locale.getLanguage());
        }
    }

    public String getCover() {
        Item item = this.publication.getItemById("cover-image");
        if (item == null) {
            return EMPTY_STRING;
        }
        return item.getFile();
    }

    public String getCreator() {
        FeatureMap fm;
        Object o;
        EList<Creator> creators = this.publication.getPackage().getMetadata().getCreators();
        if (creators.size() > 0 && (o = (fm = ((Creator)creators.get(0)).getMixed()).get(TEXT, false)) instanceof FeatureMapUtil.FeatureEList && ((FeatureMapUtil.FeatureEList)o).size() > 0) {
            return ((FeatureMapUtil.FeatureEList)o).get(0).toString();
        }
        return EMPTY_STRING;
    }

    public String getIdentifier() {
        FeatureMap fm;
        Object o;
        EList<Identifier> identifiers = this.publication.getPackage().getMetadata().getIdentifiers();
        if (identifiers.size() > 0 && (o = (fm = ((Identifier)identifiers.get(0)).getMixed()).get(TEXT, false)) instanceof FeatureMapUtil.FeatureEList && ((FeatureMapUtil.FeatureEList)o).size() > 0) {
            return ((FeatureMapUtil.FeatureEList)o).get(0).toString();
        }
        return EMPTY_STRING;
    }

    public String getLanguage() {
        FeatureMap fm;
        Object o;
        EList<Language> languages = this.publication.getPackage().getMetadata().getLanguages();
        if (languages.size() > 0 && (o = (fm = ((Language)languages.get(0)).getMixed()).get(TEXT, false)) instanceof FeatureMapUtil.FeatureEList && ((FeatureMapUtil.FeatureEList)o).size() > 0) {
            String iso639 = ((FeatureMapUtil.FeatureEList)o).get(0).toString();
            Locale l = new Locale(iso639);
            return l.getDisplayLanguage();
        }
        return EMPTY_STRING;
    }

    public Map<String, String> getLocales() {
        return this.sorted_locales;
    }

    public File getMarkupFile() {
        return this.markupFile;
    }

    public Publication getOPSPublication() {
        return this.publication;
    }

    public String getPublicationDate() {
        EList<Date> dates = this.publication.getPackage().getMetadata().getDates();
        if (dates.size() > 0) {
            for (Date date : dates) {
                FeatureMap fm;
                Object o;
                if (!date.getEvent().equals("publication") || !((o = (fm = date.getMixed()).get(TEXT, false)) instanceof FeatureMapUtil.FeatureEList) || ((FeatureMapUtil.FeatureEList)o).size() <= 0) continue;
                return ((FeatureMapUtil.FeatureEList)o).get(0).toString();
            }
        }
        return EMPTY_STRING;
    }

    public String getRights() {
        FeatureMap fm;
        Object o;
        EList<Rights> rights = this.publication.getPackage().getMetadata().getRights();
        if (rights.size() > 0 && (o = (fm = ((Rights)rights.get(0)).getMixed()).get(TEXT, false)) instanceof FeatureMapUtil.FeatureEList && ((FeatureMapUtil.FeatureEList)o).size() > 0) {
            return ((FeatureMapUtil.FeatureEList)o).get(0).toString();
        }
        return EMPTY_STRING;
    }

    public String getScheme() {
        Identifier ident = (Identifier)this.publication.getPackage().getMetadata().getIdentifiers().get(0);
        return ident.getScheme();
    }

    public String getStyleSheet() {
        List<Item> stylesheets = this.publication.getItemsByMIMEType("text/css");
        if (stylesheets.isEmpty()) {
            return EMPTY_STRING;
        }
        return stylesheets.get(0).getHref();
    }

    public String getSubject() {
        FeatureMap fm;
        Object o;
        EList<Subject> subjects = this.publication.getPackage().getMetadata().getSubjects();
        if (subjects.size() > 0 && (o = (fm = ((Subject)subjects.get(0)).getMixed()).get(TEXT, false)) instanceof FeatureMapUtil.FeatureEList && ((FeatureMapUtil.FeatureEList)o).size() > 0) {
            return ((FeatureMapUtil.FeatureEList)o).get(0).toString();
        }
        return EMPTY_STRING;
    }

    public String getTitle() {
        FeatureMap fm;
        Object o;
        EList<Title> titles = this.publication.getPackage().getMetadata().getTitles();
        if (titles.size() > 0 && (o = (fm = ((Title)titles.get(0)).getMixed()).get(TEXT, false)) instanceof FeatureMapUtil.FeatureEList && ((FeatureMapUtil.FeatureEList)o).size() > 0) {
            return ((FeatureMapUtil.FeatureEList)o).get(0).toString();
        }
        return EMPTY_STRING;
    }

    public void setCover(String cover) {
        if (cover.length() > 0) {
            this.publication.setCover(new File(cover), "Cover page");
        }
    }

    public void setCreator(String creator) {
        this.publication.getPackage().getMetadata().getCreators().clear();
        this.publication.addCreator(creator);
    }

    public void setIdentifier(String identifier) {
        String scheme = this.getScheme();
        this.publication.getPackage().getMetadata().getIdentifiers().clear();
        this.publication.addIdentifier(ID, scheme, identifier);
        this.publication.getPackage().setUniqueIdentifier(ID);
    }

    public void setLanguage(String language) {
        this.publication.getPackage().getMetadata().getLanguages().clear();
        this.publication.addLanguage(this.sorted_locales.get(language));
    }

    public void setPublicationDate(String date) {
        this.publication.getPackage().getMetadata().getDates().clear();
        this.publication.addDate(null, date, "publication");
    }

    public void setRights(String rights) {
        this.publication.getPackage().getMetadata().getRights().clear();
        this.publication.addRights(rights);
    }

    public void setScheme(String schemeName) {
        String identifier = this.getIdentifier();
        this.publication.getPackage().getMetadata().getIdentifiers().clear();
        this.publication.getPackage().setUniqueIdentifier(ID);
        this.publication.addIdentifier(ID, schemeName, identifier);
    }

    public void setStyleSheet(String css) {
        if (css.length() > 0) {
            this.publication.getPackage().getManifest().getItems().remove((Object)this.publication.getItemById(STYLING_ID));
            this.publication.addItem(STYLING_ID, null, new File(css), null, null, false, false, true);
        }
    }

    public void setSubject(String subject) {
        this.publication.getPackage().getMetadata().getSubjects().clear();
        this.publication.addSubject(subject);
    }

    public void setTitle(String title) {
        this.publication.getPackage().getMetadata().getTitles().clear();
        this.publication.addTitle(title);
    }

    class ValueComparator
    implements Comparator<String> {
        Map<String, String> base;

        public ValueComparator(Map<String, String> base) {
            this.base = base;
        }

        @Override
        public int compare(String a, String b) {
            String key_a = a;
            String key_b = b;
            return key_a.compareTo(key_b);
        }
    }
}

