/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.epub.ncx;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DirType implements Enumerator
{
    LTR(0, "ltr", "ltr"),
    RTL(1, "rtl", "rtl");

    public static final int LTR_VALUE = 0;
    public static final int RTL_VALUE = 1;
    private static final DirType[] VALUES_ARRAY;
    public static final List<DirType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static DirType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            DirType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static DirType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            DirType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static DirType get(int value) {
        switch (value) {
            case 0: {
                return LTR;
            }
            case 1: {
                return RTL;
            }
        }
        return null;
    }

    private DirType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new DirType[]{LTR, RTL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

